<?xml version="1.0" ?>
<!-- 
NAME
    cmsyn.xsl
DESCRIPTION
    Convert mdapi SYNONYM_T document to CM SYNONYM document
    Remove elements that do not need comparing	

MODIFIED	MM/DD/YY
    pkalire 05/15/08 - Merge 11GC functionality
    xshen   03/08/05 - fix schema mapping 
    xshen   07/12/04 - only map schema object schema name 
    xshen   07/10/04 - xshen_changemgr_differ
    xshen   07/04/04 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
 <xsl:for-each select="ROW">
  <xsl:apply-templates/>
 </xsl:for-each>
</xsl:template>

<xsl:template match="SYNONYM_T">
  <SYNONYM>
   <xsl:call-template name="DoSchemaWithMapping">
     <xsl:with-param name="CurrentSchema" select="SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:call-template>
   <NAME>
    <xsl:choose>
     <xsl:when test="SYN_LONG_NAME">
      <xsl:value-of select="SYN_LONG_NAME"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     </xsl:otherwise>
   </xsl:choose>
   </NAME>
   <OBJECT_SCHEMA>
     <xsl:choose>
       <xsl:when test="$SCHEMA_MAP=1 and (OWNER_NAME=$R_SCHEMA)">
         <xsl:value-of select="$L_SCHEMA"/>
       </xsl:when>
       <xsl:otherwise>
         <xsl:value-of select="OWNER_NAME"/>
       </xsl:otherwise>
     </xsl:choose>
   </OBJECT_SCHEMA>
   <OBJECT_NAME>
     <xsl:choose>
       <xsl:when test="OBJ_LONG_NAME">
         <xsl:value-of select="OBJ_LONG_NAME"/>
       </xsl:when>
       <xsl:otherwise>
         <xsl:value-of select="NAME"/>
       </xsl:otherwise>
     </xsl:choose>
   </OBJECT_NAME>
   <xsl:choose>
     <xsl:when test="DB_LINK">
       <DB_LINK>
         <xsl:value-of select="DB_LINK"/>
       </DB_LINK>
     </xsl:when>
   </xsl:choose>
  </SYNONYM>
</xsl:template>

</xsl:stylesheet>
