-- Generated by Oracle SQL Developer Data Modeler Version: 2.0.0 Build: 584
--   at:        2010-05-10 16:11:31
--   site:      Oracle Database 10g
--   type:      Oracle Database 10g



CREATE TABLE MD_APPLICATIONS
  (
    ID                NUMBER NOT NULL ,
    NAME              VARCHAR2 (4000 BYTE) ,
    DESCRIPTION       VARCHAR2 (4000 BYTE) ,
    BASE_DIR          VARCHAR2 (4000 BYTE) ,
    OUTPUT_DIR        VARCHAR2 (4000 BYTE) ,
    BACKUP_DIR        VARCHAR2 (4000 BYTE) ,
    INPLACE			NUMBER,
    CONNECTION_ID_FK     NUMBER NOT NULL ,
    SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
    CREATED_ON DATE DEFAULT sysdate NOT NULL ,
    CREATED_BY VARCHAR2 (255 BYTE) ,
    LAST_UPDATED_ON DATE ,
    LAST_UPDATED_BY VARCHAR2 (255 BYTE)
  ) ;
COMMENT ON TABLE MD_APPLICATIONS
IS
  'This is the base table for application projects.  It holds the base information for applications associated with a database';
  COMMENT ON COLUMN MD_APPLICATIONS.ID
IS
  'Primary Key';
  COMMENT ON COLUMN MD_APPLICATIONS.NAME
IS
  'Name of the application suite  //OBJECTNAME';
  COMMENT ON COLUMN MD_APPLICATIONS.DESCRIPTION
IS
  'Overview of what the application does.';
  COMMENT ON COLUMN MD_APPLICATIONS.BASE_DIR
IS
  'This is the base src directory for the application.  It could be an svn checkout, a clearcase view or something similar' ;
  COMMENT ON COLUMN MD_APPLICATIONS.OUTPUT_DIR
IS
  'This is the output directory where the scanner will present the converted files, if there are converted or modified.' ;
  COMMENT ON COLUMN MD_APPLICATIONS.BACKUP_DIR
IS
  'This is the directory in which the application files are backed up if a backp is chosen' ;
  COMMENT ON COLUMN MD_APPLICATIONS.INPLACE
IS
  'Designates whether the changes have been made inplace, in the source directory or not' ;
  COMMENT ON COLUMN MD_APPLICATIONS.CONNECTION_ID_FK
IS
  'captured model of the database(s) this application relates to' ;
  ALTER TABLE MD_APPLICATIONS ADD CONSTRAINT MD_APPLICATIONS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_APPLICATIONFILES
    (
      ID                NUMBER NOT NULL ,
      APPLICATIONS_ID_FK    NUMBER NOT NULL ,
      NAME              VARCHAR2 (200 BYTE) NOT NULL,
      URI               VARCHAR2 (4000 BYTE) NOT NULL,
      TYPE              VARCHAR2 (100 BYTE)  NOT NULL,
      STATE             VARCHAR2 (100 BYTE) NOT NULL,
      LANGUAGE          VARCHAR2 (100 BYTE),
      LOC				NUMBER,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (4000 BYTE) ,
      UPDATED_ON DATE ,
      UPDATED_BY VARCHAR2 (4000 BYTE)
    );
  COMMENT ON TABLE MD_APPLICATIONFILES
IS
  'Holds a tuple for each file that is being processed whether it is changed or not.' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.NAME
IS
  'file name  //OBJECTNAME' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.URI
IS
  'The uri is the part of the file url after the base dir has been removed.  See MD_APPLICATION for base dir' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.TYPE
IS
  'This will denote the type of file we have, including DIR, FILE (text), BINARY, IGNORE (where we choose to ignore files)' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.STATE
IS
  'State will be how this file is operated on.  For example. it will be OPEN, NEW, FIXED, IGNORED, REVIEWED, COMPLETE' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.LANGUAGE
IS
  'Language of the file that has been processed.' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.SECURITY_GROUP_ID
IS
  'APEX' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.CREATED_ON
IS
  'APEX' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.CREATED_BY
IS
  'APEX' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.UPDATED_ON
IS
  'APEX' ;
  COMMENT ON COLUMN MD_APPLICATIONFILES.UPDATED_BY
IS
  'APEX' ;
  CREATE INDEX MD_APP_FILE_TYPE_IDX ON MD_APPLICATIONFILES
    (
      TYPE ASC ,
      ID ASC
    ) ;
  CREATE INDEX MD_STATE_TYPE__ID ON MD_APPLICATIONFILES
    (
      STATE ASC ,
      TYPE ASC ,
      ID ASC
    );
  ALTER TABLE MD_APPLICATIONFILES ADD CONSTRAINT MD_APPLICATIONFILES_PK PRIMARY KEY
  (
    ID
  )
  ;
  
  CREATE TABLE MD_FILE_ARTIFACTS
    (
      ID                NUMBER CONSTRAINT MD_APP_FILE_ART_NONULL NOT NULL ,
      APPLICATIONFILES_ID       NUMBER CONSTRAINT MD_APPL_FILE_FK_NONULL NOT NULL ,
      PATTERN           VARCHAR2 (4000 BYTE) ,
      STRING_FOUND      VARCHAR2 (4000 BYTE) ,
      STRING_REPLACED   VARCHAR2 (4000 BYTE) ,
      TYPE              VARCHAR2 (200 BYTE) ,
      STATUS            VARCHAR2 (4000 BYTE) ,
      LINE              NUMBER ,
      PATTERN_START     NUMBER,
      PATTERN_END       NUMBER,
      DUE_DATE			DATE,
      DB_TYPE			VARCHAR (100 BYTE),
      CODE_TYPE			VARCHAR (1000 BYTE),
      DESCRIPTION		VARCHAR2 (4000 BYTE),
      PRIORITY			INTEGER,
      SECURITY_GROUP_ID VARCHAR2 (20 BYTE) DEFAULT '0' NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (4000 BYTE) ,
      LAST_UPDATED DATE ,
      LAST_UPDATED_BY VARCHAR2 (4000 BYTE)
    ) ;
  ALTER TABLE md_file_artifacts ADD CONSTRAINT md_file_artifacts_PK PRIMARY KEY
  (
    ID
  )
  ;
  
   COMMENT ON TABLE MD_FILE_ARTIFACTS
IS
  'Holds a tuple for each interesting thing the scanner finds in a file' ;
  COMMENT ON COLUMN  MD_FILE_ARTIFACTS.PATTERN
IS
  'Pattern used to search source file for interesting artifiacts' ;
  COMMENT ON COLUMN  MD_FILE_ARTIFACTS.STRING_FOUND
IS
  'String found in source from the pattern supplied' ;
  COMMENT ON COLUMN  MD_FILE_ARTIFACTS.STRING_REPLACED
IS
  'This is the string which replace the string found if it was replaced.' ;
  COMMENT ON COLUMN  MD_FILE_ARTIFACTS.TYPE
IS
  'This is the type of the replacement.  It could be a straight replace from a replacement pattern, or we could have passed the string to a translator which would change the string depending on the database.' ;
  COMMENT ON COLUMN  MD_FILE_ARTIFACTS.STATUS
IS
  'Pattern used to search source file for interesting artifiacts' ;
  COMMENT ON COLUMN  MD_FILE_ARTIFACTS.PATTERN
IS
  'Pattern used to search source file for interesting artifiacts' ;
COMMENT ON COLUMN MD_FILE_ARTIFACTS.DUE_DATE
IS
  'Due date is used by the TODO mechanism to manage the validation and work to complete this change';
COMMENT ON COLUMN MD_FILE_ARTIFACTS.DB_TYPE IS 'Source database calls type';
COMMENT ON COLUMN MD_FILE_ARTIFACTS.CODE_TYPE IS 'Source code db api, like dblib, jdbc';

COMMENT ON COLUMN MD_FILE_ARTIFACTS.DESCRIPTION
IS
 'This is a description of the artifact which will have a default generated by the scanner and then can be modified by the user to be more appropriate for their use';
COMMENT ON COLUMN MD_FILE_ARTIFACTS.PRIORITY 
IS
  'The priority is set for the TODOs so they can be managed by the user';
  
  CREATE TABLE MD_TABLESPACES
    (
      ID              NUMBER NOT NULL ,
      SCHEMA_ID_FK    NUMBER NOT NULL ,
      TABLESPACE_NAME VARCHAR2 (4000 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_TABLESPACES
IS
  'For storing information about tablespaces.' ;
  COMMENT ON COLUMN MD_TABLESPACES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_TABLESPACES.SCHEMA_ID_FK
IS
  'Schema to which this tablespace belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_TABLESPACES.TABLESPACE_NAME
IS
  'Name of the table space //OBJECTNAME' ;
  COMMENT ON COLUMN MD_TABLESPACES.NATIVE_SQL
IS
  'The SQL used to create this tablespace' ;
  COMMENT ON COLUMN MD_TABLESPACES.NATIVE_KEY
IS
  'A unique identifier for this object at source' ;
  ALTER TABLE MD_TABLESPACES ADD CONSTRAINT MD_TABLESPACES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_USER_PRIVILEGES
    (
      ID                NUMBER NOT NULL ,
      USER_ID_FK        NUMBER NOT NULL ,
      PRIVILEGE_ID_FK   NUMBER ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UDPATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_USER_PRIVILEGES
IS
  'This table stores privileges granted to individual users' ;
  COMMENT ON COLUMN MD_USER_PRIVILEGES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_USER_PRIVILEGES.USER_ID_FK
IS
  'User' ;
  COMMENT ON COLUMN MD_USER_PRIVILEGES.PRIVILEGE_ID_FK
IS
  'Privilege' ;
  ALTER TABLE MD_USER_PRIVILEGES ADD CONSTRAINT MD_USER_PRIVILEGES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_REPOVERSIONS
    ( REVISION NUMBER NOT NULL
    ) ;
  COMMENT ON TABLE MD_REPOVERSIONS
IS
  'This table is used to version this schema for future requirements.' ;
  CREATE TABLE MD_USERS
    (
      ID           NUMBER NOT NULL ,
      SCHEMA_ID_FK NUMBER NOT NULL ,
      USERNAME     VARCHAR2 (4000 BYTE) NOT NULL ,
      PASSWORD     VARCHAR2 (4000 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_USERS
IS
  'User information.' ;
  COMMENT ON COLUMN MD_USERS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_USERS.SCHEMA_ID_FK
IS
  'Shema in which this object belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_USERS.USERNAME
IS
  'Username for login //OBJECTNAME' ;
  COMMENT ON COLUMN MD_USERS.PASSWORD
IS
  'Password for login' ;
  COMMENT ON COLUMN MD_USERS.NATIVE_SQL
IS
  'SQL Used to create this object at source' ;
  COMMENT ON COLUMN MD_USERS.NATIVE_KEY
IS
  'Unique identifier for this object at source.' ;
  ALTER TABLE MD_USERS ADD CONSTRAINT MD_USERS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_GROUP_MEMBERS
    (
      ID                 NUMBER NOT NULL ,
      GROUP_ID_FK        NUMBER NOT NULL ,
      USER_ID_FK         NUMBER ,
      GROUP_MEMBER_ID_FK NUMBER ,
      SECURITY_GROUP_ID  NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_GROUP_MEMBERS
IS
  'This table is used to store the members of a group.' ;
  COMMENT ON COLUMN MD_GROUP_MEMBERS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_GROUP_MEMBERS.USER_ID_FK
IS
  'Id of member' ;
  COMMENT ON COLUMN MD_GROUP_MEMBERS.GROUP_MEMBER_ID_FK
IS
  'groups can be members of groups' ;
  ALTER TABLE MD_GROUP_MEMBERS ADD CONSTRAINT MD_GROUP_MEMBERS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_CATALOGS
    (
      ID               NUMBER NOT NULL ,
      CONNECTION_ID_FK NUMBER NOT NULL ,
      CATALOG_NAME     VARCHAR2 (4000 BYTE) ,
      DUMMY_FLAG       CHAR (1 BYTE) DEFAULT 'N' ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_CATALOGS
IS
  'Store catalogs in this table.' ;
  COMMENT ON COLUMN MD_CATALOGS.CONNECTION_ID_FK
IS
  'Foreign key into the connections table - Shows what connection this catalog belongs to //PARENTFIELD' ;
  COMMENT ON COLUMN MD_CATALOGS.CATALOG_NAME
IS
  'Name of the catalog //OBJECTNAME' ;
  COMMENT ON COLUMN MD_CATALOGS.DUMMY_FLAG
IS
  'Flag to show if this catalog is a "dummy" catalog which is used as a placeholder for those platforms that do not support catalogs.  ''N'' signifies that this is NOT a dummy catalog, while ''Y'' signifies that it is.' ;
  COMMENT ON COLUMN MD_CATALOGS.NATIVE_SQL
IS
  'THe SQL used to create this catalog' ;
  COMMENT ON COLUMN MD_CATALOGS.NATIVE_KEY
IS
  'A unique identifier used to identify the catalog at source.' ;
  ALTER TABLE MD_CATALOGS ADD CONSTRAINT MD_CATALOGS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_SEQUENCES
    (
      ID           NUMBER NOT NULL ,
      SCHEMA_ID_FK NUMBER NOT NULL ,
      NAME         VARCHAR2 (4000 BYTE) NOT NULL ,
      SEQ_START    NUMBER NOT NULL ,
      INCR         NUMBER DEFAULT 1 NOT NULL ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) DEFAULT '0' NOT NULL ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_SEQUENCES
IS
  'For storing information on sequences.' ;
  COMMENT ON COLUMN MD_SEQUENCES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_SEQUENCES.SCHEMA_ID_FK
IS
  'The schema to which this object belongs. //PARENTFIELD' ;
  COMMENT ON COLUMN MD_SEQUENCES.NAME
IS
  'Name of this sequence //OBJECTNAME' ;
  COMMENT ON COLUMN MD_SEQUENCES.SEQ_START
IS
  'Starting point of the sequence' ;
  COMMENT ON COLUMN MD_SEQUENCES.INCR
IS
  'Increment value of the sequence' ;
  COMMENT ON COLUMN MD_SEQUENCES.NATIVE_SQL
IS
  'SQL used to create this object at source' ;
  COMMENT ON COLUMN MD_SEQUENCES.NATIVE_KEY
IS
  'Identifier for this object at source.' ;
  ALTER TABLE MD_SEQUENCES ADD CONSTRAINT MD_SEQUENCES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_COLUMNS
    (
      ID            NUMBER NOT NULL ,
      TABLE_ID_FK   NUMBER NOT NULL ,
      COLUMN_NAME   VARCHAR2 (4000 BYTE) NOT NULL ,
      COLUMN_ORDER  NUMBER NOT NULL ,
      COLUMN_TYPE   VARCHAR2 (4000 BYTE) ,
      PRECISION     NUMBER ,
      SCALE         NUMBER ,
      NULLABLE      CHAR (1 BYTE) ,
      DEFAULT_VALUE VARCHAR2 (4000 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY                VARCHAR2 (4000 BYTE) ,
      DATATYPE_TRANSFORMED_FLAG CHAR (1 BYTE) ,
      COMMENTS                  VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID         NUMBER DEFAULT 0 NOT NULL ,
      CREATED_BY                VARCHAR2 (255 BYTE) ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE
    ) ;
  COMMENT ON TABLE MD_COLUMNS
IS
  'Column information is stored in this table.' ;
  COMMENT ON COLUMN MD_COLUMNS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_COLUMNS.TABLE_ID_FK
IS
  'The table that this column is part of //PARENTFIELD' ;
  COMMENT ON COLUMN MD_COLUMNS.COLUMN_NAME
IS
  'The name of the column //OBJECTNAME' ;
  COMMENT ON COLUMN MD_COLUMNS.COLUMN_ORDER
IS
  'The order this appears in the table' ;
  COMMENT ON COLUMN MD_COLUMNS.COLUMN_TYPE
IS
  'The type of the column' ;
  COMMENT ON COLUMN MD_COLUMNS.PRECISION
IS
  'The precision on the column' ;
  COMMENT ON COLUMN MD_COLUMNS.SCALE
IS
  'The scale of the column' ;
  COMMENT ON COLUMN MD_COLUMNS.NULLABLE
IS
  'Yes or No.  Null signifies NO' ;
  COMMENT ON COLUMN MD_COLUMNS.DEFAULT_VALUE
IS
  'Default value on the column' ;
  COMMENT ON COLUMN MD_COLUMNS.NATIVE_SQL
IS
  'The SQL used to create this column at source' ;
  COMMENT ON COLUMN MD_COLUMNS.NATIVE_KEY
IS
  'Unique identifier for this object at source' ;
  COMMENT ON COLUMN MD_COLUMNS.DATATYPE_TRANSFORMED_FLAG
IS
  'This is set to ''Y'' to show if the data type was transformed.  This is useful so we don''t apply more than 1 datatype transformation to a column' ;
  ALTER TABLE MD_COLUMNS ADD CONSTRAINT MD_COLUMNS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_PARTITIONS
    (
      ID                            NUMBER NOT NULL ,
      TABLE_ID_FK                   NUMBER NOT NULL ,
      NATIVE_SQL                    CLOB ,
      PARTITION_EXPRESSION          VARCHAR2 (4000 BYTE) ,
      COMMENTS                      VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID             NUMBER DEFAULT 0 NOT NULL ,
      CREATED_BY                    VARCHAR2 (255 BYTE) ,
      CREATED_ON                    DATE DEFAULT sysdate NOT NULL ,
      LAST_UPDATED_BY               VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON               DATE
    ) ;
  COMMENT ON TABLE MD_PARTITIONS
IS
  'Partition information is stored in this table.' ;
  COMMENT ON COLUMN MD_PARTITIONS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_PARTITIONS.TABLE_ID_FK
IS
  'The table that this partition refers to //PARENTFIELD' ;
  COMMENT ON COLUMN MD_PARTITIONS.NATIVE_SQL
IS
  'The SQL used to create this partition at source' ;
  COMMENT ON COLUMN MD_PARTITIONS.PARTITION_EXPRESSION
IS
  'The partition expression' ;
  ALTER TABLE MD_PARTITIONS ADD CONSTRAINT MD_PARTITIONS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_CONNECTIONS
    (
      ID            NUMBER NOT NULL ,
      PROJECT_ID_FK NUMBER NOT NULL ,
      TYPE          VARCHAR2 (4000 BYTE) ,
      HOST          VARCHAR2 (4000 BYTE) ,
      PORT          NUMBER ,
      USERNAME      VARCHAR2 (4000 BYTE) ,
      PASSWORD      VARCHAR2 (4000 BYTE) ,
      DBURL         VARCHAR2 (4000 BYTE) ,
      NAME          VARCHAR2 (255 BYTE) ,
      NATIVE_SQL CLOB ,
      STATUS VARCHAR2(30 BYTE),
      NUM_CATALOGS                NUMBER ,
      NUM_COLUMNS                 NUMBER ,
      NUM_CONSTRAINTS             NUMBER ,
      NUM_GROUPS                  NUMBER ,
      NUM_ROLES                   NUMBER ,
      NUM_INDEXES                 NUMBER ,
      NUM_OTHER_OBJECTS           NUMBER ,
      NUM_PACKAGES                NUMBER ,
      NUM_PRIVILEGES              NUMBER ,
      NUM_SCHEMAS                 NUMBER ,
      NUM_SEQUENCES               NUMBER ,
      NUM_STORED_PROGRAMS         NUMBER ,
      NUM_SYNONYMS                NUMBER ,
      NUM_TABLES                  NUMBER ,
      NUM_TABLESPACES             NUMBER ,
      NUM_TRIGGERS                NUMBER ,
      NUM_USER_DEFINED_DATA_TYPES NUMBER ,
      NUM_USERS                   NUMBER ,
      NUM_VIEWS                   NUMBER ,
      COMMENTS                    VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID           NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_CONNECTIONS
IS
  'This table is used to store connection information.  For example, in migrations, we could be carrying out a consolidation which occurs across many connections.' ;
  COMMENT ON COLUMN MD_CONNECTIONS.ID
IS
  'Primary key' ;
  COMMENT ON COLUMN MD_CONNECTIONS.PROJECT_ID_FK
IS
  'The project to which this connection belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_CONNECTIONS.TYPE
IS
  'The type of the connection - For example it could be used to store "ORACLE" or "MYSQL"' ;
  COMMENT ON COLUMN MD_CONNECTIONS.HOST
IS
  'The host to which this connection connects.' ;
  COMMENT ON COLUMN MD_CONNECTIONS.PORT
IS
  'The port to which this connection connects' ;
  COMMENT ON COLUMN MD_CONNECTIONS.USERNAME
IS
  'The username used to make the connection' ;
  COMMENT ON COLUMN MD_CONNECTIONS.PASSWORD
IS
  'The password used to make this connection' ;
  COMMENT ON COLUMN MD_CONNECTIONS.DBURL
IS
  'The database url used to make this connection' ;
  COMMENT ON COLUMN MD_CONNECTIONS.NAME
IS
  '//OBJECTNAME' ;
  COMMENT ON COLUMN MD_CONNECTIONS.STATUS
IS
  'Status of Migration, = captured,converted,generated,datamoved' ;
  COMMENT ON COLUMN MD_CONNECTIONS.NATIVE_SQL
IS
  'The native sql used to create this connection' ;
  ALTER TABLE MD_CONNECTIONS ADD CONSTRAINT MD_CONNECTIONS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_PROJECTS
    (
      ID                NUMBER NOT NULL ,
      PROJECT_NAME      VARCHAR2 (4000 BYTE) NOT NULL ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_PROJECTS
IS
  'This is a top level container for a set of connections.' ;
  COMMENT ON COLUMN MD_PROJECTS.ID
IS
  'Primary key' ;
  COMMENT ON COLUMN MD_PROJECTS.PROJECT_NAME
IS
  'Name of the project //OBJECTNAME' ;
  ALTER TABLE MD_PROJECTS ADD CONSTRAINT MD_PROJECTS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_MIGR_PARAMETER
    (
      ID                NUMBER NOT NULL ,
      CONNECTION_ID_FK  NUMBER NOT NULL ,
      OBJECT_ID         NUMBER NOT NULL ,
      OBJECT_TYPE       VARCHAR2 (4000 BYTE) NOT NULL ,
      PARAM_EXISTING    NUMBER NOT NULL ,
      PARAM_ORDER       NUMBER NOT NULL ,
      PARAM_NAME        VARCHAR2 (4000 BYTE) NOT NULL ,
      PARAM_TYPE        VARCHAR2 (4000 BYTE) NOT NULL ,
      PARAM_DATA_TYPE   VARCHAR2 (4000 BYTE) NOT NULL ,
      PERCISION         NUMBER ,
      SCALE             NUMBER ,
      NULLABLE          CHAR (1 BYTE) NOT NULL ,
      DEFAULT_VALUE     VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON COLUMN MD_MIGR_PARAMETER.CONNECTION_ID_FK
IS
  'the connection in which this belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_MIGR_PARAMETER.PARAM_EXISTING
IS
  '1 represents a new parameter for PL/SQL that was not present in the origional. 0 represents a n existing parameter that was present in the origional' ;
  COMMENT ON COLUMN MD_MIGR_PARAMETER.PARAM_ORDER
IS
  'IF -1 THEN THIS PARAM IS A RETURN PARAMETER. 1 WILL BE THE FIRST PARAMETER IN THE PARAMETER LIST' ;
  ALTER TABLE MD_MIGR_PARAMETER ADD CONSTRAINT MIGR_PARAMETER_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_INDEX_DETAILS
    (
      ID                NUMBER NOT NULL ,
      INDEX_ID_FK       NUMBER NOT NULL ,
      COLUMN_ID_FK      NUMBER NOT NULL ,
      INDEX_PORTION     NUMBER ,
      DETAIL_ORDER      NUMBER NOT NULL ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_INDEX_DETAILS
IS
  'This table stores the details of an index.  It shows what columns are "part" of the index.' ;
  COMMENT ON COLUMN MD_INDEX_DETAILS.INDEX_ID_FK
IS
  'The index to which this detail belongs. //PARENTFIELD' ;
  COMMENT ON COLUMN MD_INDEX_DETAILS.INDEX_PORTION
IS
  'To support indexing on part of a field' ;
  ALTER TABLE MD_INDEX_DETAILS ADD CONSTRAINT MD_INDEX_DETAILS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_OTHER_OBJECTS
    (
      ID           NUMBER NOT NULL ,
      SCHEMA_ID_FK NUMBER NOT NULL ,
      NAME         VARCHAR2 (4000 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_OTHER_OBJECTS
IS
  'For storing objects that don''''t belong anywhere else' ;
  COMMENT ON COLUMN MD_OTHER_OBJECTS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_OTHER_OBJECTS.SCHEMA_ID_FK
IS
  'Schema to which this object blongs. //PARENTFIELD' ;
  COMMENT ON COLUMN MD_OTHER_OBJECTS.NAME
IS
  'Name of this object //OBJECTNAME' ;
  COMMENT ON COLUMN MD_OTHER_OBJECTS.NATIVE_SQL
IS
  'The native SQL used to create this object' ;
  COMMENT ON COLUMN MD_OTHER_OBJECTS.NATIVE_KEY
IS
  'A key that identifies this object at source.' ;
  ALTER TABLE MD_OTHER_OBJECTS ADD CONSTRAINT MD_OTHER_OBJECTS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_CONSTRAINTS
    (
      ID              NUMBER NOT NULL ,
      DELETE_CLAUSE   VARCHAR2 (4000 BYTE) ,
      NAME            VARCHAR2 (4000 BYTE) ,
      CONSTRAINT_TYPE VARCHAR2 (4000 BYTE) ,
      TABLE_ID_FK     NUMBER NOT NULL ,
      REFTABLE_ID_FK  NUMBER ,
      CONSTRAINT_TEXT CLOB ,
      LANGUAGE          VARCHAR2 (40 BYTE) NOT NULL ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_CONSTRAINTS
IS
  'Table for storing information about a constraint' ;
  COMMENT ON COLUMN MD_CONSTRAINTS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_CONSTRAINTS.DELETE_CLAUSE
IS
  'delete option , can be either CASCADE, RESTRICT or NULL' ;
  COMMENT ON COLUMN MD_CONSTRAINTS.NAME
IS
  'Name of the constraint //OBJECTNAME' ;
  COMMENT ON COLUMN MD_CONSTRAINTS.CONSTRAINT_TYPE
IS
  'Type of the constraint (e.g. CHECK)' ;
  COMMENT ON COLUMN MD_CONSTRAINTS.TABLE_ID_FK
IS
  'Table on which this constraint exists //PARENTFIELD' ;
  COMMENT ON COLUMN MD_CONSTRAINTS.REFTABLE_ID_FK
IS
  'Used in foreign keys - this gives the table that we refer to.' ;
  COMMENT ON COLUMN MD_CONSTRAINTS.CONSTRAINT_TEXT
IS
  'The text of the constraint' ;
  COMMENT ON COLUMN MD_CONSTRAINTS.LANGUAGE
IS
  '//PUBLIC' ;
  ALTER TABLE MD_CONSTRAINTS ADD CONSTRAINT MD_CONSTRAINTS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_USER_DEFINED_DATA_TYPES
    (
      ID             NUMBER NOT NULL ,
      SCHEMA_ID_FK   NUMBER NOT NULL ,
      DATA_TYPE_NAME VARCHAR2 (4000 BYTE) NOT NULL ,
      DEFINITION     VARCHAR2 (4000 BYTE) NOT NULL ,
      NATIVE_SQL CLOB NOT NULL ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_USER_DEFINED_DATA_TYPES
IS
  'For storing information on user defined data types.' ;
  COMMENT ON COLUMN MD_USER_DEFINED_DATA_TYPES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_USER_DEFINED_DATA_TYPES.SCHEMA_ID_FK
IS
  'Schema to which this object blongs. //PARENTFIELD' ;
  COMMENT ON COLUMN MD_USER_DEFINED_DATA_TYPES.DATA_TYPE_NAME
IS
  'The name of the data type //OBJECTNAME' ;
  COMMENT ON COLUMN MD_USER_DEFINED_DATA_TYPES.DEFINITION
IS
  'The definition of the data type' ;
  COMMENT ON COLUMN MD_USER_DEFINED_DATA_TYPES.NATIVE_SQL
IS
  'The native SQL used to create this object' ;
  COMMENT ON COLUMN MD_USER_DEFINED_DATA_TYPES.NATIVE_KEY
IS
  'An unique identifier for this object at source.' ;
  ALTER TABLE MD_USER_DEFINED_DATA_TYPES ADD CONSTRAINT MD_USER_DEFINED_DATA_TYPES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MIGR_DATATYPE_TRANSFORM_MAP
    (
      ID                NUMBER NOT NULL ,
      PROJECT_ID_FK     NUMBER NOT NULL ,
      MAP_NAME          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MIGR_DATATYPE_TRANSFORM_MAP
IS
  'Table for storing data type maps.  A map is simply a collection of rules' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_MAP.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_MAP.PROJECT_ID_FK
IS
  '//PARENTFIELD' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_MAP.MAP_NAME
IS
  'A name for the map' ;
  ALTER TABLE MIGR_DATATYPE_TRANSFORM_MAP ADD CONSTRAINT MIGR_DATATYPE_TRANSFORM_M_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_GROUPS
    (
      ID           NUMBER NOT NULL ,
      SCHEMA_ID_FK NUMBER NOT NULL ,
      GROUP_NAME   VARCHAR2 (4000 BYTE) ,
      GROUP_FLAG   CHAR (1 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_GROUPS
IS
  'Groups of users in a schema' ;
  COMMENT ON COLUMN MD_GROUPS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_GROUPS.SCHEMA_ID_FK
IS
  'Schema in which this object belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_GROUPS.GROUP_NAME
IS
  'Name of the group //OBJECTNAME' ;
  COMMENT ON COLUMN MD_GROUPS.GROUP_FLAG
IS
  'This is a flag to signify a group or a role.  If this is ''R'' it means the group is known as a Role.  Any other value means it is known as a group.' ;
  COMMENT ON COLUMN MD_GROUPS.NATIVE_SQL
IS
  'SQL Used to generate this object at source' ;
  COMMENT ON COLUMN MD_GROUPS.NATIVE_KEY
IS
  'Unique id for this object at source' ;
  ALTER TABLE MD_GROUPS ADD CONSTRAINT MD_GROUPS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_ADDITIONAL_PROPERTIES
    (
      ID                NUMBER NOT NULL ,
      CONNECTION_ID_FK  NUMBER NOT NULL ,
      REF_ID_FK         NUMBER NOT NULL ,
      REF_TYPE          VARCHAR2 (4000 BYTE) NOT NULL ,
      PROPERTY_ORDER    NUMBER ,
      PROP_KEY          VARCHAR2 (4000 BYTE) NOT NULL ,
      VALUE             VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_ADDITIONAL_PROPERTIES
IS
  'This table is used to store additional properties in key-value pairs.  It is designed to store "other information" that is not supported in the main database object table.' ;
  COMMENT ON COLUMN MD_ADDITIONAL_PROPERTIES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_ADDITIONAL_PROPERTIES.CONNECTION_ID_FK
IS
  'Connection to which this belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_ADDITIONAL_PROPERTIES.REF_ID_FK
IS
  'The object to which this property blongs' ;
  COMMENT ON COLUMN MD_ADDITIONAL_PROPERTIES.REF_TYPE
IS
  'Type of object that this property belongs to' ;
  COMMENT ON COLUMN MD_ADDITIONAL_PROPERTIES.PROPERTY_ORDER
IS
  'This is to handle a situation where multiple properties have a relevant order, or multiple properties have multiple values' ;
  COMMENT ON COLUMN MD_ADDITIONAL_PROPERTIES.PROP_KEY
IS
  'The keyname for this property' ;
  COMMENT ON COLUMN MD_ADDITIONAL_PROPERTIES.VALUE
IS
  'The value for this property' ;
  ALTER TABLE MD_ADDITIONAL_PROPERTIES ADD CONSTRAINT MD_ADDITIONAL_PROPERTIES_PK PRIMARY KEY
  (
    ID
  )
  ;
    
  CREATE TABLE MIGRLOG
    (
      ID            NUMBER NOT NULL ,
      PARENT_LOG_ID NUMBER ,
      LOG_DATE TIMESTAMP NOT NULL ,
      SEVERITY         NUMBER (4) NOT NULL ,
      LOGTEXT          VARCHAR2 (4000 BYTE) ,
      PHASE            VARCHAR2 (100 BYTE) ,
      REF_OBJECT_ID    NUMBER ,
      REF_OBJECT_TYPE  VARCHAR2 (4000 BYTE) ,
      CONNECTION_ID_FK NUMBER
    ) ;
  ALTER TABLE MIGRLOG ADD CONSTRAINT MIGRLOG_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_TABLES
    (
      ID           NUMBER NOT NULL ,
      SCHEMA_ID_FK NUMBER NOT NULL ,
      TABLE_NAME   VARCHAR2 (4000 BYTE) NOT NULL ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY            VARCHAR2 (4000 BYTE) ,
      QUALIFIED_NATIVE_NAME VARCHAR2 (4000 BYTE) NOT NULL ,
      COMMENTS              VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID     NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_TABLES
IS
  'Table used to store information about tables.' ;
  COMMENT ON COLUMN MD_TABLES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_TABLES.SCHEMA_ID_FK
IS
  'Schema in which this table resides //PARENTFIELD' ;
  COMMENT ON COLUMN MD_TABLES.TABLE_NAME
IS
  'Name of the table //OBJECTNAME' ;
  COMMENT ON COLUMN MD_TABLES.NATIVE_SQL
IS
  'SQL Used to create this table at soruce' ;
  COMMENT ON COLUMN MD_TABLES.NATIVE_KEY
IS
  'Unique identifier for this table at source' ;
  ALTER TABLE MD_TABLES ADD CONSTRAINT MD_TABLES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_PACKAGES
    (
      ID           NUMBER NOT NULL ,
      SCHEMA_ID_FK NUMBER NOT NULL ,
      NAME         VARCHAR2 (4000 BYTE) NOT NULL ,
      PACKAGE_HEADER CLOB ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      LANGUAGE          VARCHAR2 (40 BYTE) NOT NULL ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_PACKAGES
IS
  'For storing packages' ;
  COMMENT ON COLUMN MD_PACKAGES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_PACKAGES.SCHEMA_ID_FK
IS
  'the schema in which this package resides //PARENTFIELD' ;
  COMMENT ON COLUMN MD_PACKAGES.NAME
IS
  'Name of this package //OBJECTNAME' ;
  COMMENT ON COLUMN MD_PACKAGES.NATIVE_SQL
IS
  'The SQL used to create this package at source' ;
  COMMENT ON COLUMN MD_PACKAGES.NATIVE_KEY
IS
  'A unique identifer for this object at source.' ;
  COMMENT ON COLUMN MD_PACKAGES.LANGUAGE
IS
  '//PUBLIC' ;
  ALTER TABLE MD_PACKAGES ADD CONSTRAINT MD_PACKAGES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_GROUP_PRIVILEGES
    (
      ID                NUMBER NOT NULL ,
      GROUP_ID_FK       NUMBER NOT NULL ,
      PRIVILEGE_ID_FK   NUMBER NOT NULL ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_GROUP_PRIVILEGES
IS
  'This table stores the privileges granted to a group (or role)' ;
  ALTER TABLE MD_GROUP_PRIVILEGES ADD CONSTRAINT MD_GROUP_PRIVILEGES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_VIEWS
    (
      ID           NUMBER NOT NULL ,
      SCHEMA_ID_FK NUMBER NOT NULL ,
      VIEW_NAME    VARCHAR2 (4000 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      LANGUAGE          VARCHAR2 (40 BYTE) NOT NULL ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      LINECOUNT NUMBER NULL,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_VIEWS
IS
  'For storing information on views.' ;
  COMMENT ON COLUMN MD_VIEWS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_VIEWS.SCHEMA_ID_FK
IS
  'The schema to which this obect blongs. //PARENTFIELD' ;
  COMMENT ON COLUMN MD_VIEWS.VIEW_NAME
IS
  'The name of the view //OBJECTNAME' ;
  COMMENT ON COLUMN MD_VIEWS.NATIVE_SQL
IS
  'The SQL used to create this object at source' ;
  COMMENT ON COLUMN MD_VIEWS.NATIVE_KEY
IS
  'An identifier for this object at source.' ;
  COMMENT ON COLUMN MD_VIEWS.LANGUAGE
IS
  '//PUBLIC' ;
  ALTER TABLE MD_VIEWS ADD CONSTRAINT MD_VIEWS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_INDEXES
    (
      ID          NUMBER NOT NULL ,
      INDEX_TYPE  VARCHAR2 (4000 BYTE) ,
      TABLE_ID_FK NUMBER NOT NULL ,
      INDEX_NAME  VARCHAR2 (4000 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (4000 BYTE)
    ) ;
  COMMENT ON TABLE MD_INDEXES
IS
  'This table is used to store information about the indexes in a schema' ;
  COMMENT ON COLUMN MD_INDEXES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_INDEXES.INDEX_TYPE
IS
  'Type of the index e.g. PRIMARY' ;
  COMMENT ON COLUMN MD_INDEXES.TABLE_ID_FK
IS
  'Table that this index is on //PARENTFIELD' ;
  COMMENT ON COLUMN MD_INDEXES.INDEX_NAME
IS
  'Name of the index //OBJECTNAME' ;
  COMMENT ON COLUMN MD_INDEXES.NATIVE_SQL
IS
  'SQL used to create the index at source' ;
  COMMENT ON COLUMN MD_INDEXES.NATIVE_KEY
IS
  'A unique identifier for this object at the source' ;
  ALTER TABLE MD_INDEXES ADD CONSTRAINT MD_INDEXES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MIGR_DATATYPE_TRANSFORM_RULE
    (
      ID                    NUMBER NOT NULL ,
      MAP_ID_FK             NUMBER NOT NULL ,
      SOURCE_DATA_TYPE_NAME VARCHAR2 (4000 BYTE) NOT NULL ,
      SOURCE_PRECISION      NUMBER ,
      SOURCE_SCALE          NUMBER ,
      TARGET_DATA_TYPE_NAME VARCHAR2 (4000 BYTE) NOT NULL ,
      TARGET_PRECISION      NUMBER ,
      TARGET_SCALE          NUMBER ,
      SECURITY_GROUP_ID     NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_RULE.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_RULE.MAP_ID_FK
IS
  'The map to which this rule belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_RULE.SOURCE_DATA_TYPE_NAME
IS
  'Source data type' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_RULE.SOURCE_PRECISION
IS
  'Precison to match' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_RULE.SOURCE_SCALE
IS
  'scale to match' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_RULE.TARGET_DATA_TYPE_NAME
IS
  'data type name to transform to' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_RULE.TARGET_PRECISION
IS
  'precision to map to ' ;
  COMMENT ON COLUMN MIGR_DATATYPE_TRANSFORM_RULE.TARGET_SCALE
IS
  'scale to map to' ;
  ALTER TABLE MIGR_DATATYPE_TRANSFORM_RULE ADD CONSTRAINT MIGR_DATATYPE_TRANSFORM_R_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_SCHEMAS
    (
      ID            NUMBER NOT NULL ,
      CATALOG_ID_FK NUMBER NOT NULL ,
      NAME          VARCHAR2 (4000 BYTE) ,
      TYPE          CHAR (1 BYTE) ,
      CHARACTER_SET VARCHAR2 (4000 BYTE) ,
      VERSION_TAG   VARCHAR2 (40 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_SCHEMAS
IS
  'This is the holder for schemas' ;
  COMMENT ON COLUMN MD_SCHEMAS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_SCHEMAS.CATALOG_ID_FK
IS
  'Catalog to which this schema blongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_SCHEMAS.NAME
IS
  'Name of the schema //OBJECTNAME' ;
  COMMENT ON COLUMN MD_SCHEMAS.TYPE
IS
  'Type of this schema.  Eaxamples are ''CAPTURED'' OR ''CONVERTED''' ;
  COMMENT ON COLUMN MD_SCHEMAS.CHARACTER_SET
IS
  'The characterset of this schema' ;
  COMMENT ON COLUMN MD_SCHEMAS.VERSION_TAG
IS
  'A version string that can be used for tagging/baseling a schema' ;
  COMMENT ON COLUMN MD_SCHEMAS.NATIVE_SQL
IS
  'The native SQL used to create this schema' ;
  COMMENT ON COLUMN MD_SCHEMAS.NATIVE_KEY
IS
  'A unique identifier that this schema is known as in its source state.' ;
  ALTER TABLE MD_SCHEMAS ADD CONSTRAINT MD_SCHEMAS_PK PRIMARY KEY
  (
    ID
  )
  ;
  --  Table to store information on the MD_ repository.  This lists the objects
  --  to be dropped if you wish to remove the repository
  CREATE TABLE MD_REGISTRY
    (
      OBJECT_TYPE VARCHAR2 (30 BYTE) NOT NULL ,
      OBJECT_NAME VARCHAR2 (30 BYTE) NOT NULL,
      DESC_OBJECT_NAME VARCHAR2 (30 BYTE)
    ) ;
  COMMENT ON TABLE MD_REGISTRY
IS
  'Table to store information on the MD_ repository.  This lists the objects to be dropped if you wish to remove the repository' ;
  ALTER TABLE MD_REGISTRY ADD CONSTRAINT MD_REGISTRY_PK PRIMARY KEY
  (
    OBJECT_TYPE, OBJECT_NAME
  )
  ;
  CREATE TABLE MD_DERIVATIVES
    (
      ID                       NUMBER NOT NULL ,
      SRC_ID                   NUMBER NOT NULL ,
      SRC_TYPE                 VARCHAR2 (4000 BYTE) ,
      DERIVED_ID               NUMBER NOT NULL ,
      DERIVED_TYPE             VARCHAR2 (4000 BYTE) ,
      DERIVED_CONNECTION_ID_FK NUMBER NOT NULL ,
      TRANSFORMED              CHAR (1 BYTE) ,
      ORIGINAL_IDENTIFIER      VARCHAR2 (4000 BYTE) ,
      NEW_IDENTIFIER           VARCHAR2 (4000 BYTE) ,
      DERIVED_OBJECT_NAMESPACE VARCHAR2 (40 BYTE) ,
      DERIVATIVE_REASON        VARCHAR2 (10 BYTE) ,
      SECURITY_GROUP_ID        NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_DERIVATIVES
IS
  'This table is used to store objects that are derived from each other.  For example in a migration an auto-increment column in a source model could be mapped to a primary key, and a sequence, and a trigger.  The MD_DERIVATIVES table would store the fact that these 3 objects are derived from the auto-increment column.' ;
  COMMENT ON COLUMN MD_DERIVATIVES.TRANSFORMED
IS
  'Set this field to ''Y'' if we carry out any sort of transformation on teh derived object.' ;
  ALTER TABLE MD_DERIVATIVES ADD CONSTRAINT MIGRDREIVATIVES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_SYNONYMS
    (
      ID                 NUMBER NOT NULL ,
      SCHEMA_ID_FK       NUMBER NOT NULL ,
      NAME               VARCHAR2 (4000 BYTE) NOT NULL ,
      SYNONYM_FOR_ID     NUMBER NOT NULL ,
      FOR_OBJECT_TYPE    VARCHAR2 (4000 BYTE) NOT NULL ,
      PRIVATE_VISIBILITY CHAR (1 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_SYNONYMS
IS
  'For storing synonym information.' ;
  COMMENT ON COLUMN MD_SYNONYMS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_SYNONYMS.SCHEMA_ID_FK
IS
  'The schema to which this object belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_SYNONYMS.NAME
IS
  'Synonym name //OBJECTNAME' ;
  COMMENT ON COLUMN MD_SYNONYMS.SYNONYM_FOR_ID
IS
  'What object this is a synonym for' ;
  COMMENT ON COLUMN MD_SYNONYMS.FOR_OBJECT_TYPE
IS
  'The type this is a synonym for (e.g. INDEX)' ;
  COMMENT ON COLUMN MD_SYNONYMS.PRIVATE_VISIBILITY
IS
  'Visibility - Private or Public.  If Private_visibility = ''Y'' means this is a private synonym.  Anything else means it is a public synonym' ;
  COMMENT ON COLUMN MD_SYNONYMS.NATIVE_SQL
IS
  'The SQL used to create this object at source' ;
  COMMENT ON COLUMN MD_SYNONYMS.NATIVE_KEY
IS
  'An identifier for this object at source.' ;
  ALTER TABLE MD_SYNONYMS ADD CONSTRAINT MD_SYNONYMS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_TRIGGERS
    (
      ID                  NUMBER NOT NULL ,
      TABLE_OR_VIEW_ID_FK NUMBER NOT NULL ,
      TRIGGER_ON_FLAG     CHAR (1 BYTE) NOT NULL ,
      TRIGGER_NAME        VARCHAR2 (4000 BYTE) ,
      TRIGGER_TIMING      VARCHAR2 (4000 BYTE) ,
      TRIGGER_OPERATION   VARCHAR2 (4000 BYTE) ,
      TRIGGER_EVENT       VARCHAR2 (4000 BYTE) ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      LANGUAGE          VARCHAR2 (40 BYTE) NOT NULL ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      LINECOUNT NUMBER NULL,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_TRIGGERS
IS
  'For storing information about triggers.' ;
  COMMENT ON COLUMN MD_TRIGGERS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_TRIGGERS.TABLE_OR_VIEW_ID_FK
IS
  'Table on which this trigger fires' ;
  COMMENT ON COLUMN MD_TRIGGERS.TRIGGER_ON_FLAG
IS
  'Flag to show iif the trigger is on a table or a view.  If it is a table this should be ''T''. If it is on a view this should be ''V''' ;
  COMMENT ON COLUMN MD_TRIGGERS.TRIGGER_NAME
IS
  'Name of the trigger //OBJECTNAME' ;
  COMMENT ON COLUMN MD_TRIGGERS.TRIGGER_TIMING
IS
  'before, after ,etc.' ;
  COMMENT ON COLUMN MD_TRIGGERS.TRIGGER_OPERATION
IS
  'insert, delete, etc.' ;
  COMMENT ON COLUMN MD_TRIGGERS.TRIGGER_EVENT
IS
  'The actual trigger that gets fired ' ;
  COMMENT ON COLUMN MD_TRIGGERS.NATIVE_SQL
IS
  'The full definition ' ;
  COMMENT ON COLUMN MD_TRIGGERS.NATIVE_KEY
IS
  'UInique identifer for this object at source' ;
  COMMENT ON COLUMN MD_TRIGGERS.LANGUAGE
IS
  '//PUBLIC' ;
  ALTER TABLE MD_TRIGGERS ADD CONSTRAINT MD_TRIGGERS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_MIGR_DEPENDENCY
    (
      ID                 NUMBER NOT NULL ,
      CONNECTION_ID_FK   NUMBER NOT NULL ,
      PARENT_ID          NUMBER NOT NULL ,
      CHILD_ID           NUMBER NOT NULL ,
      PARENT_OBJECT_TYPE VARCHAR2 (4000 BYTE) NOT NULL ,
      CHILD_OBJECT_TYPE  VARCHAR2 (4000 BYTE) NOT NULL ,
      SECURITY_GROUP_ID  NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON COLUMN MD_MIGR_DEPENDENCY.CONNECTION_ID_FK
IS
  'The connection that this exists in //PARENTFIELD' ;
  ALTER TABLE MD_MIGR_DEPENDENCY ADD CONSTRAINT MIGR_DEPENDENCY_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_PRIVILEGES
    (
      ID                  NUMBER NOT NULL ,
      SCHEMA_ID_FK        NUMBER NOT NULL ,
      PRIVILEGE_NAME      VARCHAR2 (4000 BYTE) NOT NULL ,
      PRIVELEGE_OBJECT_ID NUMBER ,
      PRIVELEGEOBJECTTYPE VARCHAR2 (4000 BYTE) NOT NULL ,
      PRIVELEGE_TYPE      VARCHAR2 (4000 BYTE) NOT NULL ,
      ADMIN_OPTION        CHAR (1 BYTE) ,
      NATIVE_SQL CLOB NOT NULL ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_PRIVILEGES
IS
  'This table stores privilege information' ;
  COMMENT ON COLUMN MD_PRIVILEGES.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_PRIVILEGES.SCHEMA_ID_FK
IS
  'The schema to which this object belongs //PARENTFIELD' ;
  COMMENT ON COLUMN MD_PRIVILEGES.PRIVILEGE_NAME
IS
  'The name of the privilege //OBJECTNAME' ;
  COMMENT ON COLUMN MD_PRIVILEGES.PRIVELEGE_OBJECT_ID
IS
  'This references the table, view, etc on which the privelege exists.  This can be NULL for things like system wide privileges' ;
  COMMENT ON COLUMN MD_PRIVILEGES.PRIVELEGEOBJECTTYPE
IS
  'The type the privelege is on (e.g. INDEX)' ;
  COMMENT ON COLUMN MD_PRIVILEGES.PRIVELEGE_TYPE
IS
  'e.g.select' ;
  COMMENT ON COLUMN MD_PRIVILEGES.ADMIN_OPTION
IS
  'Flag to show if this was granted with admin option.  ''Y'' means it was granted with admin option ''N'' means it was NOT granted with admin option.  NULL means not applicable (e.g. not known, not supported by source platform, etc.)' ;
  COMMENT ON COLUMN MD_PRIVILEGES.NATIVE_SQL
IS
  'The SQL used to create this privilege at source' ;
  COMMENT ON COLUMN MD_PRIVILEGES.NATIVE_KEY
IS
  'An identifier for this object at source.' ;
  ALTER TABLE MD_PRIVILEGES ADD CONSTRAINT MD_PRIVILEGES_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MIGR_GENERATION_ORDER
    (
      ID               NUMBER NOT NULL ,
      CONNECTION_ID_FK NUMBER NOT NULL ,
      OBJECT_ID        NUMBER NOT NULL ,
      OBJECT_TYPE      VARCHAR2 (4000 BYTE) NOT NULL ,
      GENERATION_ORDER NUMBER NOT NULL
    ) ;
  COMMENT ON COLUMN MIGR_GENERATION_ORDER.CONNECTION_ID_FK
IS
  '//PARENTFIELD' ;
  ALTER TABLE MIGR_GENERATION_ORDER ADD CONSTRAINT MIGR_GENERATION_ORDER_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_MIGR_WEAKDEP
    (
      ID                NUMBER NOT NULL ,
      CONNECTION_ID_FK  NUMBER NOT NULL ,
      SCHEMA_ID_FK      NUMBER NOT NULL ,
      PARENT_ID         NUMBER NOT NULL ,
      CHILD_NAME        VARCHAR2 (4000 BYTE) NOT NULL ,
      PARENT_TYPE       VARCHAR2 (4000 BYTE) NOT NULL ,
      CHILD_TYPE        VARCHAR2 (4000 BYTE) NOT NULL ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON COLUMN MD_MIGR_WEAKDEP.CHILD_NAME
IS
  'name of the child,  as weak dependencies dont have reference to child id' ;
  COMMENT ON COLUMN MD_MIGR_WEAKDEP.PARENT_TYPE
IS
  'MD_<tablename>' ;
  COMMENT ON COLUMN MD_MIGR_WEAKDEP.CHILD_TYPE
IS
  'Generic Type (not MD_<tablename>)' ;
  ALTER TABLE MD_MIGR_WEAKDEP ADD CONSTRAINT MIGR_WEAKDEP_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_CONSTRAINT_DETAILS
    (
      ID               NUMBER NOT NULL ,
      REF_FLAG         CHAR (1 BYTE) DEFAULT 'N' ,
      CONSTRAINT_ID_FK NUMBER NOT NULL ,
      COLUMN_ID_FK     NUMBER ,
      COLUMN_PORTION   NUMBER ,
      CONSTRAINT_TEXT CLOB ,
      DETAIL_ORDER      NUMBER NOT NULL ,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_CONSTRAINT_DETAILS
IS
  'Constraint details show what columns are "involved" in a constraint.' ;
  COMMENT ON COLUMN MD_CONSTRAINT_DETAILS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_CONSTRAINT_DETAILS.REF_FLAG
IS
  '"N" or Null signify that this column is the colum that is used in the constraint.  A flag of Y signifies that the colum is a referenced column (i.e. part of a foreign key constraint)' ;
  COMMENT ON COLUMN MD_CONSTRAINT_DETAILS.CONSTRAINT_ID_FK
IS
  'Constraint that this detail belongs to //PARENTFIELD' ;
  COMMENT ON COLUMN MD_CONSTRAINT_DETAILS.COLUMN_PORTION
IS
  'The portion of a column this detail belongs (e.g. for constrints on substrings)' ;
  COMMENT ON COLUMN MD_CONSTRAINT_DETAILS.CONSTRAINT_TEXT
IS
  'The text of the constraint' ;
  ALTER TABLE MD_CONSTRAINT_DETAILS ADD CONSTRAINT MD_CONSTRAINT_DETAILS_PK PRIMARY KEY
  (
    ID
  )
  ;
  CREATE TABLE MD_STORED_PROGRAMS
    (
      ID            NUMBER NOT NULL ,
      SCHEMA_ID_FK  NUMBER NOT NULL ,
      PROGRAMTYPE   VARCHAR2 (20 BYTE) ,
      NAME          VARCHAR2 (4000 BYTE) ,
      PACKAGE_ID_FK NUMBER ,
      NATIVE_SQL CLOB ,
      NATIVE_KEY        VARCHAR2 (4000 BYTE) ,
      LANGUAGE          VARCHAR2 (40 BYTE) NOT NULL ,
      COMMENTS          VARCHAR2 (4000 BYTE) ,
      LINECOUNT NUMBER NULL,
      SECURITY_GROUP_ID NUMBER DEFAULT 0 NOT NULL ,
      CREATED_ON DATE DEFAULT sysdate NOT NULL ,
      CREATED_BY VARCHAR2 (255 BYTE) ,
      LAST_UPDATED_ON DATE ,
      LAST_UPDATED_BY VARCHAR2 (255 BYTE)
    ) ;
  COMMENT ON TABLE MD_STORED_PROGRAMS
IS
  'Container for stored programs.' ;
  COMMENT ON COLUMN MD_STORED_PROGRAMS.ID
IS
  'Primary Key' ;
  COMMENT ON COLUMN MD_STORED_PROGRAMS.SCHEMA_ID_FK
IS
  'Schema to which this object belongs.  Note that the PACKAGE_ID_FK (if present also leads us to the relevant schema), however a stored program may or may not belong in a package.  If it is in a package, then the SCHEMA_ID_FK and the SCHEME_ID_FK in the parent package should match //PARENTFIELD' ;
  COMMENT ON COLUMN MD_STORED_PROGRAMS.PROGRAMTYPE
IS
  'Java/TSQL/PLSQL, etc.' ;
  COMMENT ON COLUMN MD_STORED_PROGRAMS.NAME
IS
  'Name of the stored program //OBJECTNAME' ;
  COMMENT ON COLUMN MD_STORED_PROGRAMS.PACKAGE_ID_FK
IS
  'The package to which this object belongs' ;
  COMMENT ON COLUMN MD_STORED_PROGRAMS.NATIVE_SQL
IS
  'The SQL used to create this object at source' ;
  COMMENT ON COLUMN MD_STORED_PROGRAMS.NATIVE_KEY
IS
  'A unique indetifier for this object at source' ;
  COMMENT ON COLUMN MD_STORED_PROGRAMS.LANGUAGE
IS
  '//PUBLIC' ;
  ALTER TABLE MD_MIGR_WEAKDEP ADD CONSTRAINT MIGR_WEAKDEP_FK2 FOREIGN KEY
  (
    SCHEMA_ID_FK
  )
  REFERENCES MD_SCHEMAS
  (
    ID
  )
  ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_MIGR_DEPENDENCY ADD CONSTRAINT MIGR_DEPENDENCY_FK FOREIGN KEY ( CONNECTION_ID_FK ) REFERENCES MD_CONNECTIONS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_CONSTRAINT_DETAILS ADD CONSTRAINT MD_CONSTRAINT_DETAILS_MD__FK2 FOREIGN KEY ( COLUMN_ID_FK ) REFERENCES MD_COLUMNS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_GROUP_MEMBERS ADD CONSTRAINT MD_GROUPMEMBERS_MD_USERS_FK1 FOREIGN KEY ( USER_ID_FK ) REFERENCES MD_USERS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_INDEX_DETAILS ADD CONSTRAINT MD_INDEX_DETAILS_MD_COLUM_FK1 FOREIGN KEY ( COLUMN_ID_FK ) REFERENCES MD_COLUMNS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_USERS ADD CONSTRAINT MD_USERS_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_GROUPS ADD CONSTRAINT MD_GROUPS_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_VIEWS ADD CONSTRAINT MD_VIEWS_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_SCHEMAS ADD CONSTRAINT MD_SCHEMAS_MD_CATALOGS_FK1 FOREIGN KEY ( CATALOG_ID_FK ) REFERENCES MD_CATALOGS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MIGR_DATATYPE_TRANSFORM_RULE ADD CONSTRAINT MIGR_DATATYPE_TRANSFORM_R_FK1 FOREIGN KEY ( MAP_ID_FK ) REFERENCES MIGR_DATATYPE_TRANSFORM_MAP ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_PACKAGES ADD CONSTRAINT MD_PACKAGES_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_GROUP_MEMBERS ADD CONSTRAINT MD_GROUPMEMBERS_MD_GROUPS_FK2 FOREIGN KEY ( GROUP_MEMBER_ID_FK ) REFERENCES MD_GROUPS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_USER_DEFINED_DATA_TYPES ADD CONSTRAINT MD_USER_DEFINED_DATA_TYPE_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_STORED_PROGRAMS ADD CONSTRAINT MD_STORED_PROGRAMS_PK PRIMARY KEY ( ID ) ;
  ALTER TABLE MD_STORED_PROGRAMS ADD CONSTRAINT MD_STORED_PROGRAMS_MD_SCH_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_COLUMNS ADD CONSTRAINT MD_COLUMNS_MD_TABLES_FK1 FOREIGN KEY ( TABLE_ID_FK ) REFERENCES MD_TABLES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_PARTITIONS ADD CONSTRAINT MD_PARTITIONS_MD_TABLES_FK1 FOREIGN KEY ( TABLE_ID_FK ) REFERENCES MD_TABLES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  /* --Need a more complex delete/update system if this foreign key is present.
  * --For Example, Delete a Captured Connection. This foreign key will stop the delete from happening as when you try and delete the
  * --MD_CONNECTIONS.ID, this key will throw an exception. We would have to delete the rows from the migrlog first. But its simpler to remove this foreign key.
  * --This was enforcing the data integraty, but SQL Dev is the only tool to write to this table, so we enforce that rule ourselves.
  ALTER TABLE MIGRLOG
  ADD CONSTRAINT MIGRLOG_MD_CONNECTIONS_FK FOREIGN KEY
  (
  CONNECTION_ID_FK
  )
  REFERENCES MD_CONNECTIONS
  (
  ID
  )
  NOT DEFERRABLE
  ;
  */
  ALTER TABLE MD_GROUP_PRIVILEGES ADD CONSTRAINT MD_GROUP_PRIVILEGES_MD_GR_FK1 FOREIGN KEY ( GROUP_ID_FK ) REFERENCES MD_GROUPS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_GROUP_MEMBERS ADD CONSTRAINT MD_GROUPMEMBERS_MD_GROUPS_FK1 FOREIGN KEY ( GROUP_ID_FK ) REFERENCES MD_GROUPS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MIGR_GENERATION_ORDER ADD CONSTRAINT MIGR_GENERATION_ORDER_MD__FK1 FOREIGN KEY ( CONNECTION_ID_FK ) REFERENCES MD_CONNECTIONS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_MIGR_WEAKDEP ADD CONSTRAINT MIGR_WEAKDEP_FK1 FOREIGN KEY ( CONNECTION_ID_FK ) REFERENCES MD_CONNECTIONS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_OTHER_OBJECTS ADD CONSTRAINT MD_OTHER_OBJECTS_MD_SCHEM_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_USER_PRIVILEGES ADD CONSTRAINT MD_USER_PRIVILEGES_MD_PRI_FK1 FOREIGN KEY ( PRIVILEGE_ID_FK ) REFERENCES MD_PRIVILEGES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_CONSTRAINT_DETAILS ADD CONSTRAINT MD_CONSTRAINT_DETAILS_MD__FK1 FOREIGN KEY ( CONSTRAINT_ID_FK ) REFERENCES MD_CONSTRAINTS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_INDEX_DETAILS ADD CONSTRAINT MD_INDEX_DETAILS_MD_INDEX_FK1 FOREIGN KEY ( INDEX_ID_FK ) REFERENCES MD_INDEXES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_MIGR_PARAMETER ADD CONSTRAINT MIGR_PARAMETER_FK FOREIGN KEY ( CONNECTION_ID_FK ) REFERENCES MD_CONNECTIONS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_ADDITIONAL_PROPERTIES ADD CONSTRAINT MD_ADDITIONAL_PROPERTIES__FK1 FOREIGN KEY ( CONNECTION_ID_FK ) REFERENCES MD_CONNECTIONS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_INDEXES ADD CONSTRAINT MD_INDEXES_MD_TABLES_FK1 FOREIGN KEY ( TABLE_ID_FK ) REFERENCES MD_TABLES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_PRIVILEGES ADD CONSTRAINT MD_PRIVILEGES_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_SEQUENCES ADD CONSTRAINT MD_SEQUENCES_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_TABLESPACES ADD CONSTRAINT MD_TABLESPACES_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_STORED_PROGRAMS ADD CONSTRAINT MD_STORED_PROGRAMS_MD_PAC_FK1 FOREIGN KEY ( PACKAGE_ID_FK ) REFERENCES MD_PACKAGES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_SYNONYMS ADD CONSTRAINT MD_SYNONYMS_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_CATALOGS ADD CONSTRAINT MD_CATALOGS_MD_CONNECTION_FK1 FOREIGN KEY ( CONNECTION_ID_FK ) REFERENCES MD_CONNECTIONS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MIGRLOG ADD CONSTRAINT MIGR_MIGRLOG_FK FOREIGN KEY ( PARENT_LOG_ID ) REFERENCES MIGRLOG ( ID ) NOT DEFERRABLE ;
  ALTER TABLE MIGR_DATATYPE_TRANSFORM_MAP ADD CONSTRAINT MIGR_DATATYPE_TRANSFORM_M_FK1 FOREIGN KEY ( PROJECT_ID_FK ) REFERENCES MD_PROJECTS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_CONNECTIONS ADD CONSTRAINT MD_CONNECTIONS_MD_PROJECT_FK1 FOREIGN KEY ( PROJECT_ID_FK ) REFERENCES MD_PROJECTS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_USER_PRIVILEGES ADD CONSTRAINT MD_USER_PRIVILEGES_MD_USE_FK1 FOREIGN KEY ( USER_ID_FK ) REFERENCES MD_USERS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_GROUP_PRIVILEGES ADD CONSTRAINT MD_GROUP_PRIVILEGES_MD_PR_FK1 FOREIGN KEY ( PRIVILEGE_ID_FK ) REFERENCES MD_PRIVILEGES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_DERIVATIVES ADD CONSTRAINT MD_DERIVATIVES_MD_CONNECT_FK1 FOREIGN KEY ( DERIVED_CONNECTION_ID_FK ) REFERENCES MD_CONNECTIONS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_CONSTRAINTS ADD CONSTRAINT MD_CONSTRAINTS_MD_TABLES_FK1 FOREIGN KEY ( TABLE_ID_FK ) REFERENCES MD_TABLES ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  ALTER TABLE MD_TABLES ADD CONSTRAINT MD_TABLES_MD_SCHEMAS_FK1 FOREIGN KEY ( SCHEMA_ID_FK ) REFERENCES MD_SCHEMAS ( ID ) ON
  DELETE CASCADE NOT DEFERRABLE ;
  
  
  ALTER TABLE md_file_artifacts ADD CONSTRAINT MD_ARTIFACT_FILE_FK FOREIGN KEY(APPLICATIONFILES_ID) REFERENCES MD_APPLICATIONFILES(ID) ON
  DELETE CASCADE NOT DEFERRABLE;
  ALTER TABLE MD_APPLICATIONFILES ADD CONSTRAINT MD_FILE_APP_FK FOREIGN KEY(APPLICATIONS_ID_FK) REFERENCES MD_APPLICATIONS(ID) ON
  DELETE CASCADE NOT DEFERRABLE;
  ALTER TABLE MD_APPLICATIONS ADD CONSTRAINT MD_APP_CONN_FK FOREIGN KEY (CONNECTION_ID_FK) REFERENCES MD_CONNECTIONS(ID) ON
  DELETE CASCADE NOT DEFERRABLE;
  

CREATE TABLE MD_NUMROW$SOURCE
(
    NUMROWS NUMBER(10,0),
    NAME    VARCHAR2(4000 BYTE),
    OBJID NUMBER(10,0)
);

CREATE TABLE MD_NUMROW$TARGET
(
    NUMROWS NUMBER(10,0),
    NAME    VARCHAR2(4000 BYTE),
    OBJID NUMBER(10,0)
);

  CREATE OR REPLACE VIEW MGV_ALL_TABLE_TRIGGERS
AS
  SELECT md_projects.id project_id ,
    md_projects.project_name project_name,
    md_connections.id connection_id ,
    md_connections.host host ,
    md_connections.port port ,
    md_connections.username username ,
    md_catalogs.id catalog_id ,
    md_catalogs.catalog_name catalog_name,
    md_catalogs.dummy_flag dummy_flag ,
    md_schemas.id schema_id ,
    md_schemas.name schema_name ,
    md_tables.id table_id ,
    md_tables.TABLE_NAME TABLE_NAME ,
    md_triggers.id trigger_id ,
    md_triggers.trigger_name trigger_name
  FROM md_projects ,
    md_connections,
    md_catalogs ,
    md_schemas ,
    md_tables ,
    md_triggers
  WHERE md_triggers.table_or_view_id_fk = md_tables.id
  AND md_tables.schema_id_fk            = md_schemas.id
  AND md_schemas.catalog_id_fk          = md_catalogs.id
  AND md_catalogs.connection_id_fk      = md_connections.id
  AND md_connections.project_id_fk      = md_projects.id ;
CREATE OR REPLACE VIEW MGV_ALL_SCHEMA
AS
  SELECT md_projects.id project_id ,
    md_projects.project_name project_name,
    md_connections.id connection_id ,
    md_connections.host host ,
    md_connections.port port ,
    md_connections.username username ,
    md_catalogs.id catalog_id ,
    md_catalogs.catalog_name catalog_name,
    md_schemas.id schema_id ,
    md_schemas.name schema_name
  FROM md_connections,
    md_catalogs ,
    md_schemas ,
    md_projects
  WHERE md_schemas.catalog_id_fk   = md_catalogs.id
  AND md_catalogs.connection_id_fk = md_connections.id
  AND md_connections.project_id_fk = md_projects.id
WITH READ ONLY ;
CREATE OR REPLACE VIEW MGV_ALL_TABLES
AS
  SELECT md_projects.id project_id ,
    md_projects.project_name project_name,
    md_connections.id connection_id ,
    md_connections.host host ,
    md_connections.port port ,
    md_connections.username username ,
    md_connections.dburl dburl ,
    md_catalogs.id catalog_id ,
    md_catalogs.catalog_name catalog_name,
    md_schemas.id schema_id ,
    md_schemas.name schema_name ,
    md_tables.id table_id ,
    md_tables.TABLE_NAME TABLE_NAME
  FROM md_connections,
    md_catalogs ,
    md_schemas ,
    md_tables ,
    md_projects
  WHERE md_tables.schema_id_fk     = md_schemas.id
  AND md_schemas.catalog_id_fk     = md_catalogs.id
  AND md_catalogs.connection_id_fk = md_connections.id
  AND md_connections.project_id_fk = md_projects.id
WITH READ ONLY ;
CREATE OR REPLACE VIEW MGV_ALL_CATALOGS
AS
  SELECT md_projects.id project_id ,
    md_projects.project_name project_name,
    md_connections.id connection_id ,
    md_connections.host host ,
    md_connections.port port ,
    md_connections.username username ,
    md_connections.dburl dburl ,
    md_catalogs.id catalog_id ,
    md_catalogs.catalog_name catalog_name
  FROM md_projects ,
    md_connections,
    md_catalogs
  WHERE md_catalogs.connection_id_fk = md_connections.id
  AND md_connections.project_id_fk   = md_projects.id
WITH READ ONLY ;
CREATE OR REPLACE VIEW MGV_ALL_CONNECTIONS
AS
  SELECT md_projects.id project_id ,
    md_projects.project_name project_name,
    MD_CONNECTIONS.ID CONNECTION_ID ,
    MD_CONNECTIONS.NAME CONNECTION_NAME,
    md_connections.host host ,
    md_connections.port port ,
    md_connections.username username ,
    md_connections.dburl dburl
  FROM md_projects,
    md_connections
  WHERE MD_CONNECTIONS.PROJECT_ID_FK = MD_PROJECTS.ID
WITH READ ONLY ;
CREATE OR REPLACE VIEW MGV_ALL_VIEW_TRIGGERS
AS
  SELECT md_projects.id project_id ,
    md_projects.project_name project_name,
    md_connections.id connection_id ,
    md_connections.host host ,
    md_connections.port port ,
    md_connections.username username ,
    md_catalogs.id catalog_id ,
    md_catalogs.catalog_name catalog_name,
    md_catalogs.dummy_flag dummy_flag ,
    md_schemas.id schema_id ,
    md_schemas.name schema_name ,
    md_views.id view_id ,
    md_views.view_name view_name ,
    md_triggers.id trigger_id ,
    md_triggers.trigger_name trigger_name
  FROM md_projects ,
    md_connections,
    md_catalogs ,
    md_schemas ,
    md_views ,
    md_triggers
  WHERE md_triggers.table_or_view_id_fk = md_views.id
  AND md_views.schema_id_fk             = md_schemas.id
  AND md_schemas.catalog_id_fk          = md_catalogs.id
  AND md_catalogs.connection_id_fk      = md_connections.id
  AND md_connections.project_id_fk      = md_projects.id ;
CREATE OR REPLACE VIEW MGV_ALL_STORED_PROGRAMS
AS
  SELECT md_projects.id project_id ,
    md_projects.project_name project_name ,
    md_connections.id connection_id ,
    md_connections.host host ,
    md_connections.port port ,
    md_connections.username username ,
    md_catalogs.id catalog_id ,
    md_catalogs.catalog_name catalog_name ,
    md_schemas.id schema_id ,
    md_schemas.name schema_name ,
    md_stored_programs.id stored_program_id ,
    md_stored_programs.programtype programtype ,
    md_stored_programs.name stored_program_name,
    md_stored_programs.package_id_fk package_id_fk
  FROM md_projects ,
    md_connections,
    md_catalogs ,
    md_schemas ,
    md_stored_programs
  WHERE md_stored_programs.schema_id_fk = md_schemas.id
  AND md_schemas.catalog_id_fk          = md_catalogs.id
  AND md_catalogs.connection_id_fk      = md_connections.id
  AND md_connections.project_id_fk      = md_projects.id ;
CREATE OR REPLACE VIEW MGV_ALL_VIEWS
AS
  SELECT md_projects.id project_id ,
    md_projects.project_name project_name,
    md_connections.id connection_id ,
    md_connections.host host ,
    md_connections.port port ,
    username username ,
    md_catalogs.id catalog_id ,
    md_catalogs.catalog_name catalog_name,
    md_catalogs.dummy_flag dummy_flag ,
    md_schemas.id schema_id ,
    md_schemas.name schema_name ,
    md_views.id view_id ,
    md_views.view_name view_name
  FROM md_projects ,
    md_connections,
    md_catalogs ,
    md_schemas ,
    md_views
  WHERE md_views.schema_id_fk      = md_schemas.id
  AND md_schemas.catalog_id_fk     = md_catalogs.id
  AND md_catalogs.connection_id_fk = md_connections.id
  AND md_connections.project_id_fk = md_projects.id
WITH READ ONLY ;
COMMENT ON TABLE MGV_ALL_VIEWS
IS
  'View to iterate over all views in the system' ;
CREATE SEQUENCE dbobjectid_sequence START WITH 1 INCREMENT BY 50 MAXVALUE 999999999999999999999999 MINVALUE 1 CACHE 50 ;

  -- Oracle SQL Developer Data Modeler Summary Report:
  --
  -- CREATE TABLE                            36
  -- CREATE INDEX                             0
  -- ALTER TABLE                             41
  -- CREATE VIEW                              8
  -- CREATE PROCEDURE                         0
  -- CREATE TRIGGER                           0
  -- CREATE STRUCTURED TYPE                   0
  -- CREATE COLLECTION TYPE                   0
  -- CREATE CLUSTER                           0
  -- CREATE CONTEXT                           0
  -- CREATE DATABASE                          0
  -- CREATE DIMENSION                         0
  -- CREATE DIRECTORY                         0
  -- CREATE ROLE                              0
  -- CREATE ROLLBACK SEGMENT                  0
  -- CREATE SEQUENCE                          1
  -- CREATE SNAPSHOT                          0
  -- CREATE SYNONYM                           0
  -- CREATE TABLESPACE                        0
  -- CREATE USER                              0
  --
  -- DROP TABLESPACE                          0
  -- DROP DATABASE                            0
  --
  -- ERRORS                                   0
  -- WARNINGS                                 0

-- additional table not in SQL Developer Data Modeler:
  
  CREATE TABLE STAGE_MIGRLOG ( "SVRID_FK" NUMBER, "DBID_GEN_FK" NUMBER,
            ID NUMBER NOT NULL , REF_OBJECT_ID NUMBER ,
            REF_OBJECT_TYPE VARCHAR2 (4000 BYTE), LOG_DATE TIMESTAMP NOT NULL ,
            SEVERITY NUMBER (4) NOT NULL , LOGTEXT VARCHAR2 (4000 BYTE) , PHASE
            VARCHAR2 (20 BYTE) );
  ALTER TABLE STAGE_MIGRLOG ADD CONSTRAINT STAGE_MIGRLOG_PK PRIMARY KEY
  (
    ID
  )
  ;