/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.history.HistoryManager;
import oracle.ide.history.LocalState;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.history.LocalHistoryEntry;

class LocalHistoryProvider
extends HistoryProvider {
    static final HistoryProperty[] PROPERTIES = new HistoryProperty[]{SharedProperties.getDateProperty(), SharedProperties.getRevisionProperty(), SharedProperties.getDescriptionProperty()};
    private static final HistoryFilter _TYPE_FILTER = new HistoryFilter(){

        @Override
        public String getShortLabel() {
            return HistoryArb.getString(10);
        }

        @Override
        public boolean accept(HistoryEntry entry) {
            return entry instanceof LocalHistoryEntry;
        }
    };

    @Override
    public HistoryFilter getTypeFilter() {
        return _TYPE_FILTER;
    }

    @Override
    public HistoryProperty[] getProperties() {
        return PROPERTIES;
    }

    @Override
    public boolean isProviderFor(URL url) {
        try {
            if (url.getProtocol() != null && !url.getProtocol().equals("file")) {
                return false;
            }
            HistoryManager mgr = HistoryManager.getHistoryManager();
            if (mgr != null) {
                if (URLFileSystem.isDirectory((URL)url)) {
                    return false;
                }
                Class cls = Recognizer.recognizeURL((URL)url);
                return cls != null && mgr.getRegisteredHistorian(cls) != null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public HistoryEntry[] getEntries(URL url, HistoryFilter filter) {
        ArrayList<LocalHistoryEntry> entries = new ArrayList<LocalHistoryEntry>();
        try {
            LocalState[] states = null;
            HistoryManager mgr = HistoryManager.getHistoryManager();
            if (mgr != null && !URLFileSystem.isDirectory((URL)url) && (states = mgr.getLocalHistory(url)) != null && states.length > 0) {
                for (int i = 0; i < states.length; ++i) {
                    entries.add(new LocalHistoryEntry(states[i]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HistoryEntry[] result = new HistoryEntry[entries.size()];
        entries.toArray(result);
        return result;
    }
}

