/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ideimpl.history.HistoryOptions;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.history.LocalHistoryProvider;

public final class HistoryManagerImpl
extends HistoryManager
implements ChangeListener {
    private LocalHistoryProvider _localProvider = new LocalHistoryProvider();

    HistoryManagerImpl() {
        try {
            InitialContext ic = new InitialContext();
            try {
                ic.lookup("jdeveloper");
            }
            catch (NamingException ne) {
                ic.createSubcontext("jdeveloper");
            }
            ic.bind("jdeveloper/history-manager", (Object)this);
            HistoryOptions options = HistoryOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            options.addChangeListener((ChangeListener)this);
            this.stateChanged(null);
        }
        catch (NamingException ne) {
            ExceptionDialog.showExceptionDialog((Component)null, (Throwable)ne);
        }
    }

    public HistoryProvider getLocalHistoryProvider() {
        return this._localProvider;
    }

    @Override
    public void showHistory(Context context) {
        EditorManager mgr = EditorManager.getEditorManager();
        if (mgr != null) {
            Editor openEditor;
            HistoryViewer historyViewer = null;
            for (Object editor : mgr.findEditors(context)) {
                if (!(editor instanceof HistoryViewer)) continue;
                historyViewer = (HistoryViewer)editor;
                break;
            }
            if (historyViewer != null) {
                historyViewer.getLeftFilter().setSelectedFilter(this.getAllFilter());
            }
            if ((openEditor = mgr.openEditorInFrame(HistoryViewer.class, context)) != null) {
                openEditor.setContext(context);
            }
            if (historyViewer != null) {
                historyViewer.refreshWithThrobber();
            }
        }
    }

    @Override
    public void showHistory(Node node) {
        EditorManager mgr = EditorManager.getEditorManager();
        if (mgr != null) {
            mgr.openEditorInFrame(HistoryViewer.class, Context.newIdeContext((Node)node));
        }
    }

    @Override
    public void updateHistory(URL url) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        HistoryOptions options = HistoryOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        if (options != null && options.isEnabled()) {
            this.registerProvider(this._localProvider);
        } else {
            this.unregisterProvider(this._localProvider);
        }
    }
}

