/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.compare.CompareContributor;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.resource.CompareArb;

public class CompareURLHelper
extends URLFileSystemHelper {
    private static final String SEPARATOR = "///";
    public static final String PROTOCOL = "ide.compare";

    public static URL newCompareURL(CompareContributor source, CompareContributor target, int sequence) {
        return URLFactory.newURL((String)PROTOCOL, (String)(source.getLongLabel() + SEPARATOR + target.getLongLabel() + SEPARATOR + String.valueOf(sequence)));
    }

    public static int getSequence(URL url) {
        return Integer.parseInt(url.getPath().split(SEPARATOR)[2]);
    }

    public String getFileName(URL url) {
        String path = url.getPath();
        String[] parts = path.split(SEPARATOR);
        return CompareArb.format(13, parts[2]);
    }

    public String getPlatformPathName(URL url) {
        try {
            CompareNode cn = (CompareNode)NodeFactory.find((URL)url);
            if (cn != null) {
                return CompareArb.format(14, new Object[]{cn.getSource().getLongLabel(), cn.getTarget().getLongLabel()});
            }
            return CompareArb.getString(15);
        }
        catch (Exception e) {
            return "";
        }
    }

    public InputStream openInputStream(URL url) {
        return new ByteArrayInputStream(new byte[0]);
    }
}

