/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.DefaultKeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.MenuSpec;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ToolbarView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.compare.view.text.TextCompareView;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.CompareConstants;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.compare.CompareManagerImpl;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.compare.ComparePreferencesPanel;
import oracle.jdevimpl.compare.CompareURLHelper;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.compare.SearchNavigable;
import oracle.jdevimpl.resource.CompareArb;

public class CompareAddin
extends EditorAddin {
    private CompareIdeViewer m_compareIdeViewer;
    private MenuSpec m_menuSpec;
    int m_otherFileAction;
    int m_savedFileAction;
    int m_eachOtherAction;
    private MyController m_controller;
    static final String KEY_CONTEXT = "compareKeyContext";
    public static final String COMPARE_DIRECTORY_FILE_CMD = "compare.compareDirectoryFile";
    public static final int COMPARE_DIRECTORY_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"compare.compareDirectoryFile");
    public static final String GO_FIRST_CMD = "compare.navigateFirst";
    public static final int GO_FIRST_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateFirst");
    public static final String GO_PREVIOUS_CMD = "compare.navigatePrevious";
    public static final int GO_PREVIOUS_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigatePrevious");
    public static final String GO_NEXT_CMD = "compare.navigateNext";
    public static final int GO_NEXT_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateNext");
    public static final String GO_LAST_CMD = "compare.navigateLast";
    public static final int GO_LAST_CMD_ID = Ide.findOrCreateCmdID((String)"compare.navigateLast");
    private Navigable _compareNavigable;
    private List<CompareMethod> _compareMethods = new ArrayList<CompareMethod>();
    private CompareManagerImpl _manager;
    private static String _createPatchCommand;
    private static int _createPatchCommandId;
    private static Controller _patchController;

    public CompareAddin() {
        this.m_compareIdeViewer = new CompareIdeViewer(this);
    }

    CompareIdeViewer getCompareIdeViewer() {
        return this.m_compareIdeViewer;
    }

    public Navigable getCompareNavigable() {
        return this._compareNavigable;
    }

    public void registerCompareMethod(CompareMethod compareMethod) {
        for (int i = 0; i <= this._compareMethods.size(); ++i) {
            if (i >= this._compareMethods.size()) {
                this._compareMethods.add(compareMethod);
                break;
            }
            CompareType[] fallbackTypes = compareMethod.getFallbackCompareTypes();
            if (fallbackTypes == null || !Arrays.asList(fallbackTypes).contains(this._compareMethods.get(i).getCompareType())) continue;
            this._compareMethods.add(i, compareMethod);
            break;
        }
    }

    public Collection<CompareMethod> getCompareMethods() {
        return Collections.unmodifiableCollection(this._compareMethods);
    }

    private void compareOtherFile(Context context) throws Exception {
        int result;
        CompareContributor right = null;
        URL url = null;
        Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
        try {
            if (selection.length == 1) {
                url = this.getSelectionURL(selection[0]);
                if (url != null) {
                    right = this.createContributorFromURL(url);
                }
            } else {
                url = context.getNode().getURL();
                right = this.createContributorFromURL(url);
            }
        }
        catch (IOException ex) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.format(52, URLFileSystem.getName(url)), (String)CompareArb.getString(53), null);
            return;
        }
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(url == null || !URLFileSystem.isDirectoryPath((URL)url) ? 0 : 1);
        if (url != null) {
            chooser.setSelectedURL(url);
        }
        if ((result = chooser.showOpenDialog((Component)Ide.getMainWindow(), CompareArb.getString(26))) == 0) {
            URL otherUrl = chooser.getSelectedURL();
            if (URLFileSystem.isDirectoryPath((URL)url) != URLFileSystem.isDirectoryPath((URL)otherUrl)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString(9), (String)CompareArb.getString(8), null);
            } else if (otherUrl != null && otherUrl.equals(url)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString(7), (String)CompareArb.getString(6), null);
            } else if (!URLFileSystem.exists((URL)otherUrl)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareArb.getString(11), (String)CompareArb.getString(10), null);
            } else {
                CompareContributor left = this.createContributorFromURL(otherUrl);
                this.m_compareIdeViewer.show(left, right);
            }
        }
    }

    private final CompareContributor createContributorFromURL(URL url) throws IOException {
        if (CompareUtil.isContentTypeBinary(url)) {
            return new BinaryCompareContributor(url);
        }
        return URLFileSystem.isDirectoryPath((URL)url) ? this.createDirectoryContributor(url) : new URLContributor(url);
    }

    private void compareSavedFile(Context context) throws Exception {
        URLContributor left = null;
        TextNodeContributor right = null;
        Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
        if (selection.length == 0 && context.getNode() != null) {
            left = new URLContributor(context.getNode().getURL());
            right = new TextNodeContributor((TextNode)context.getNode());
        }
        if (selection.length > 0) {
            if (selection[0] instanceof TextNode) {
                left = new URLContributor(((TextNode)selection[0]).getURL());
                right = new TextNodeContributor((TextNode)selection[0]);
            } else {
                left = new URLContributor(context.getNode().getURL());
                right = new TextNodeContributor((TextNode)context.getNode());
            }
        }
        if (left == null) {
            return;
        }
        this.m_compareIdeViewer.show((CompareContributor)left, (CompareContributor)right);
    }

    private void compareEachOther(Context context) throws Exception {
        Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
        URL url = this.getSelectionURL(selection[0]);
        CompareContributor left = this.createContributorFromURL(url);
        url = this.getSelectionURL(selection[1]);
        CompareContributor right = this.createContributorFromURL(url);
        this.m_compareIdeViewer.show(left, right);
    }

    private CompareContributor createDirectoryContributor(URL directoryUrl) {
        DirectoryCompareContributor contrib = new DirectoryCompareContributor(){};
        contrib.setShortLabel(URLFileSystem.getFileName((URL)directoryUrl));
        contrib.setLongLabel(URLFileSystem.getPlatformPathName((URL)directoryUrl));
        DirectoryList directoryList = new DirectoryList();
        for (final URLFileSystem.FileInfo info : URLFileSystem.ls((URL)directoryUrl)) {
            directoryList.appendFile(new DirectoryFile(info.isDirectory(), URLFileSystem.getFileName((URL)info.getURL()), info.isDirectory() ? "" : Long.toString(this.computeChecksum(info.getURL()))){

                public CompareContributor createCompareContributor() throws Exception {
                    URL url = info.getURL();
                    return CompareAddin.this.createContributorFromURL(url);
                }
            });
        }
        directoryList.clearModified();
        contrib.setDirectoryList(directoryList);
        return contrib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeChecksum(URL url) {
        CheckedInputStream cis = null;
        try {
            cis = new CheckedInputStream(URLFileSystem.openInputStream((URL)url), new Adler32());
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return 0L;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return 0L;
        }
        try {
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            long l = cis.getChecksum().getValue();
            return l;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            try {
                cis.close();
            }
            catch (IOException ioe) {}
        }
    }

    public void initialize() {
        IdeAction selectAllAction;
        this._manager = new CompareManagerImpl();
        CompareViewFactory.registerCompareView((CompareType)CompareType.TEXT, TextCompareView.class);
        CompareManager.getCompareManager().registerCompareMethod(new CompareMethod(){

            @Override
            public boolean canCompare(CompareContributor left, CompareContributor right, StreamType streamType) {
                if (!(left instanceof TextCompareContributor) || !(right instanceof TextCompareContributor)) {
                    return false;
                }
                return streamType != null || this.getStreamType(left) != null && this.getStreamType(right) != null;
            }

            @Override
            public boolean canMerge(CompareContributor left, CompareContributor right, CompareContributor ancestor) {
                if (!(left instanceof TextCompareContributor && right instanceof TextCompareContributor && ancestor instanceof TextCompareContributor)) {
                    return false;
                }
                return this.getStreamType(left) != null && this.getStreamType(right) != null && this.getStreamType(ancestor) != null;
            }

            @Override
            public CompareType getCompareType() {
                return CompareType.TEXT;
            }
        });
        CompareManager.getCompareManager().registerCompareMethod(new CompareMethod(){

            @Override
            public boolean canCompare(CompareContributor left, CompareContributor right, StreamType streamType) {
                return left instanceof DirectoryCompareContributor && right instanceof DirectoryCompareContributor;
            }

            @Override
            public CompareType getCompareType() {
                return CompareType.DIRECTORY;
            }
        });
        URLFileSystem.registerHelper((String)"ide.compare", (URLFileSystemHelper)new CompareURLHelper());
        EditorManager.getEditorManager().register((EditorAddin)this, new Class[]{CompareNode.class});
        Ide.getMenubar().add((Component)this.m_compareIdeViewer.getMainCompareMenu(), MenuManager.getJMenu((String)"File"), MenuConstants.SECTION_FILE_ADDINS);
        this.m_controller = new MyController();
        String name = CompareArb.getString(22);
        Integer mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)name));
        name = StringUtils.stripMnemonic((String)name);
        this.m_savedFileAction = Ide.findOrCreateCmdID((String)"compare.CompareDirty");
        IdeAction compareDirtyAction = IdeAction.get((int)this.m_savedFileAction, null, (String)name, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)mnemonic, null, null, (boolean)true);
        compareDirtyAction.putValue("NoCtxName", (Object)CompareArb.getString(23));
        compareDirtyAction.addController((Controller)this.m_controller);
        name = CompareArb.getString(20);
        mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)name));
        name = StringUtils.stripMnemonic((String)name);
        this.m_otherFileAction = Ide.findOrCreateCmdID((String)"compare.CompareOther");
        IdeAction compareOtherAction = IdeAction.get((int)this.m_otherFileAction, null, (String)name, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)mnemonic, null, null, (boolean)true);
        compareOtherAction.putValue("NoCtxName", (Object)CompareArb.getString(21));
        compareOtherAction.addController((Controller)this.m_controller);
        name = CompareArb.getString(24);
        mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)name));
        name = StringUtils.stripMnemonic((String)name);
        this.m_eachOtherAction = Ide.findOrCreateCmdID((String)"compare.CompareEachOther");
        IdeAction compareEachOtherAction = IdeAction.get((int)this.m_eachOtherAction, null, (String)name, (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)mnemonic, null, null, (boolean)true);
        compareEachOtherAction.putValue("NoCtxName", (Object)CompareArb.getString(25));
        compareEachOtherAction.addController((Controller)this.m_controller);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareDirtyAction, 1.0f), this.m_compareIdeViewer.getMainCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareOtherAction, 2.0f), this.m_compareIdeViewer.getMainCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareEachOtherAction, 1.0f), this.m_compareIdeViewer.getMainCompareMenu(), 2.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareDirtyAction, 1.0f), this.m_compareIdeViewer.getContextCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareOtherAction, 2.0f), this.m_compareIdeViewer.getContextCompareMenu(), 1.0f);
        Ide.getMenubar().add((Component)Ide.getMenubar().createMenuItem((ToggleAction)compareEachOtherAction, 1.0f), this.m_compareIdeViewer.getContextCompareMenu(), 2.0f);
        this._compareNavigable = new SearchNavigable(CompareArb.getString(27), ComparePreferencesPanel.class, new String[]{CompareArb.getString(55), CompareArb.getString(56)});
        IdeSettings.registerUI((Navigable)this._compareNavigable);
        final IdeAction goFirstAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_FIRST_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(41)), (String)CompareArb.getString(40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(41))), (ArrayResourceBundle)CompareArb.getInstance(), (int)42, null, (boolean)false);
        final IdeAction goPreviousAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_PREVIOUS_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(43)), (String)CompareArb.getString(40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(43))), (ArrayResourceBundle)CompareArb.getInstance(), (int)44, null, (boolean)false);
        final IdeAction goNextAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_NEXT_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(45)), (String)CompareArb.getString(40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(45))), (ArrayResourceBundle)CompareArb.getInstance(), (int)46, null, (boolean)false);
        final IdeAction goLastAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)GO_LAST_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(47)), (String)CompareArb.getString(40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(47))), (ArrayResourceBundle)CompareArb.getInstance(), (int)48, null, (boolean)false);
        final IdeAction compareDirectoryAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)COMPARE_DIRECTORY_FILE_CMD), null, (String)StringUtils.stripMnemonic((String)CompareArb.getString(54)), (String)CompareArb.getString(40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(54))), (ArrayResourceBundle)CompareArb.getInstance(), (int)12, null, (boolean)false);
        compareDirectoryAction.addController((Controller)CompareController.getDefaultController());
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void addinsLoaded(IdeEvent idee) {
                Ide.removeIdeListener((IdeListener)this);
                if (CompareAddin.getCreatePatchCommand() == null) {
                    return;
                }
                IdeAction createPatchAction = IdeAction.get((int)CompareAddin.getCreatePatchCommandID(), (String)CompareAddin.getCreatePatchCommand(), (String)StringUtils.stripMnemonic((String)CompareArb.getString(49)), (String)CompareArb.getString(40), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(49))), (ArrayResourceBundle)CompareArb.getInstance(), (int)50, null, (boolean)true);
                createPatchAction.addController(CompareAddin.getPatchController());
            }
        });
        Ide.getKeyStrokeContextRegistry().addContext((KeyStrokeContext)new DefaultKeyStrokeContext(){
            private Set _actions = new HashSet();
            {
                this._actions.add(goFirstAction);
                this._actions.add(goPreviousAction);
                this._actions.add(goNextAction);
                this._actions.add(goLastAction);
                if (IdeAction.find((int)CompareConstants.CREATE_PATCH_CMD_ID) != null) {
                    this._actions.add(IdeAction.find((int)CompareConstants.CREATE_PATCH_CMD_ID));
                }
                this._actions.add(compareDirectoryAction);
            }

            public String getName() {
                return CompareArb.getString(40);
            }

            public Set getAllActions(boolean bGlobal) {
                return this._actions;
            }
        });
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "oracle/jdevimpl/compare/accelerators.xml");
        Ide.getMainWindow().addDynamicMenuListener(new DynamicMenuListener(){

            public JComponent[] gatherDynamicActions(Context context) {
                if (context.getView() instanceof CompareEditor) {
                    return new JComponent[]{Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_FIRST_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_PREVIOUS_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_NEXT_CMD)), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_LAST_CMD)), 0.0f)};
                }
                return new JComponent[0];
            }
        });
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(new ContextMenuListener(){

            public void menuWillShow(ContextMenu menu) {
                if (menu.getContext().getView() instanceof CompareEditor) {
                    Action[] editActions;
                    Object[] selection;
                    CompareView compareView = ((CompareEditor)menu.getContext().getView()).getCompareView();
                    float sectionId = 1.0f;
                    if (compareView instanceof ListCompareView && ((ListCompareView)compareView).getCompareMode() == CompareMode.TWO_WAY_COMPARE && ((ListCompareView)compareView).isSelectionComparable() && (selection = ((ListCompareView)compareView).getSelectionForCompare()) != null && selection[0] instanceof DirectoryFile && selection[1] instanceof DirectoryFile) {
                        try {
                            ((DirectoryFile)selection[0]).getCompareContributor();
                            ((DirectoryFile)selection[1]).getCompareContributor();
                            menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.COMPARE_DIRECTORY_FILE_CMD))), sectionId);
                            sectionId += 0.01f;
                        }
                        catch (UnsupportedOperationException uoe) {
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Action[] actionArray = editActions = compareView instanceof BaseCompareView ? ((BaseCompareView)compareView).getEditActions() : null;
                    if (editActions != null) {
                        for (int i = 0; i < editActions.length; ++i) {
                            if (editActions[i] == null) {
                                sectionId += 0.01f;
                                continue;
                            }
                            menu.add((Component)(editActions[i] instanceof ToggleAction ? menu.createMenuItem((ToggleAction)editActions[i]) : new JMenuItem(editActions[i])), sectionId, false);
                        }
                    }
                    menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_FIRST_CMD))), sectionId += 0.01f);
                    menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_PREVIOUS_CMD))), sectionId);
                    menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_NEXT_CMD))), sectionId);
                    menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)CompareAddin.GO_LAST_CMD))), sectionId);
                    if (compareView instanceof ToolbarView) {
                        sectionId += 0.01f;
                        IdeAction[] toolbarActions = ((ToolbarView)compareView).getToolbarActions();
                        if (toolbarActions != null) {
                            for (IdeAction toolbarAction : toolbarActions) {
                                menu.add((Component)menu.createMenuItem((ToggleAction)toolbarAction), sectionId);
                            }
                        }
                    }
                }
            }

            public void menuWillHide(ContextMenu menu) {
            }

            public boolean handleDefaultAction(Context ctx) {
                return false;
            }
        });
        try {
            InitialContext ic = new InitialContext();
            try {
                ic.lookup("jdeveloper");
            }
            catch (NamingException ne) {
                ic.createSubcontext("jdeveloper");
            }
            ic.bind("jdeveloper/compareviewer", (Object)this.m_compareIdeViewer);
        }
        catch (NamingException ne) {
            ExceptionDialog.showExceptionDialog((Component)null, (Throwable)ne);
        }
        IdeAction copyAction = IdeAction.find((int)18);
        if (copyAction != null) {
            copyAction.addController((Controller)this.m_controller);
        }
        if ((selectAllAction = IdeAction.find((int)22)) != null) {
            selectAllAction.addController((Controller)this.m_controller);
        }
        Preferences prefs = Preferences.getPreferences();
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("compareOptions", (Copyable)CompareOptions.getInstance((PropertyStorage)prefs));
        this.initializeSettings();
    }

    public Class getEditorClass() {
        return CompareEditor.class;
    }

    public boolean isDefault() {
        return true;
    }

    public MenuSpec getMenuSpecification() {
        if (this.m_menuSpec == null) {
            this.m_menuSpec = new MenuSpec(CompareArb.getString(16), null, null, null);
        }
        return this.m_menuSpec;
    }

    public Object getAttribute(Object key) {
        if (key.equals("no-recent-file")) {
            return Boolean.FALSE;
        }
        if (key.equals("restorable-from-url")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public float getEditorWeight(Element element) {
        return Float.NaN;
    }

    public boolean isDuplicable() {
        return false;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    private URL getSelectionURL(Object selection) {
        if (selection instanceof RelativeDirectoryContextFolder) {
            return this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection);
        }
        if (selection instanceof Locatable) {
            return ((Locatable)selection).getURL();
        }
        return null;
    }

    private URL getDirectoryCompareURL(RelativeDirectoryContextFolder selection) {
        RelativeDirectoryContextFolder directoryContextFolder = selection;
        URLPath rootDirectoryPath = directoryContextFolder.getRootDirectories();
        Iterator itr = rootDirectoryPath.iterator();
        if (itr.hasNext()) {
            return URLFactory.newDirURL((URL)((URL)itr.next()), (String)directoryContextFolder.getRelativePath());
        }
        return null;
    }

    private void initializeSettings() {
        Preferences p = Preferences.getPreferences();
        CompareOptions co = CompareOptions.getInstance((PropertyStorage)p);
        CompareHints.setIgnoreWhiteSpace((boolean)co.getIgnoreWhitespace());
        CompareHints.setShowCharDifferences((boolean)co.getShowCharDifferences());
    }

    boolean isValidCompareURL(URL url) {
        if (url == null || !URLFileSystem.isLocal((URL)url) || !URLFileSystem.exists((URL)url)) {
            return false;
        }
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            return true;
        }
        return CompareManager.getCompareManager().isContentComparable(url);
    }

    public static String getCreatePatchCommand() {
        return _createPatchCommand;
    }

    public static void setCreatePatchCommand(String createPatchCommand) {
        _createPatchCommand = createPatchCommand;
    }

    public static int getCreatePatchCommandID() {
        return _createPatchCommandId;
    }

    public static void setCreatePatchCommandID(int createPatchCommandId) {
        _createPatchCommandId = createPatchCommandId;
    }

    public static Controller getPatchController() {
        return _patchController;
    }

    public static void setPatchController(Controller patchController) {
        _patchController = patchController;
    }

    private class MyController
    implements Controller {
        private MyController() {
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == CompareAddin.this.m_eachOtherAction) {
                Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
                if (selection != null && selection.length == 2) {
                    if (selection[0] instanceof Locatable && selection[1] instanceof Locatable) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(selection[0].getURL()) && CompareAddin.this.isValidCompareURL(selection[1].getURL()) && URLFileSystem.isDirectoryPath((URL)selection[0].getURL()) == URLFileSystem.isDirectoryPath((URL)selection[1].getURL()) && DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)selection[0].getURL())) == DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)selection[1].getURL())));
                        return true;
                    }
                    if (selection[0] instanceof RelativeDirectoryContextFolder && selection[1] instanceof RelativeDirectoryContextFolder) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(CompareAddin.this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[0])) && CompareAddin.this.isValidCompareURL(CompareAddin.this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[1])));
                        return true;
                    }
                }
                action.setEnabled(false);
                return true;
            }
            if (cmdId == CompareAddin.this.m_otherFileAction) {
                Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
                if (selection != null) {
                    if (selection.length == 0) {
                        action.setEnabled(context.getNode() != null && CompareAddin.this.isValidCompareURL(context.getNode().getURL()));
                        return true;
                    }
                    if (selection.length != 1) {
                        action.setEnabled(false);
                        return true;
                    }
                    if (selection[0] instanceof Locatable) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(selection[0].getURL()));
                        return true;
                    }
                    if (selection[0] instanceof RelativeDirectoryContextFolder) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(CompareAddin.this.getDirectoryCompareURL((RelativeDirectoryContextFolder)selection[0])));
                        return true;
                    }
                    if (context.getNode() != null) {
                        action.setEnabled(CompareAddin.this.isValidCompareURL(context.getNode().getURL()));
                        return true;
                    }
                }
                action.setEnabled(false);
                return true;
            }
            if (cmdId == CompareAddin.this.m_savedFileAction) {
                Locatable[] selection = VCSManager.getVCSManager().getContextLocatables(context);
                if (selection != null) {
                    if (selection.length == 0) {
                        Node node = context.getNode();
                        action.setEnabled(node instanceof TextNode && (node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp()) && CompareAddin.this.isValidCompareURL(node.getURL()));
                        return true;
                    }
                    if (selection.length == 1 && selection[0] instanceof TextNode && CompareAddin.this.isValidCompareURL(((TextNode)selection[0]).getURL())) {
                        action.setEnabled(this.isDifferent((Node)((TextNode)selection[0])));
                        return true;
                    }
                    action.setEnabled(false);
                    return true;
                }
                action.setEnabled(false);
                return true;
            }
            return false;
        }

        private boolean isDifferent(Node node) {
            if (node == null) {
                return false;
            }
            return node.isDirty() || URLFileSystem.lastModified((URL)node.getURL()) != node.getUnmodifiedTimestamp();
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            try {
                if (cmdId == CompareAddin.this.m_otherFileAction) {
                    CompareAddin.this.compareOtherFile(context);
                    return true;
                }
                if (cmdId == CompareAddin.this.m_savedFileAction) {
                    CompareAddin.this.compareSavedFile(context);
                    return true;
                }
                if (cmdId == CompareAddin.this.m_eachOtherAction) {
                    CompareAddin.this.compareEachOther(context);
                    return true;
                }
            }
            catch (Exception ioe) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ioe);
            }
            return false;
        }
    }
}

