/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.accessibility.Accessible;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.model.Node;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.MnemonicSolver;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.CustomFilterManager;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.resource.HistoryArb;

public abstract class HistoryManager {
    private Collection _providers;
    private static ContextMenu _sharedContextMenu;
    private HistoryFilter _allFilter = null;
    private CustomFilterManager _customFilterManager;
    protected static final String JNDI_NAME = "jdeveloper/history-manager";

    public CustomFilterManager getCustomFilterManager() {
        if (this._customFilterManager == null) {
            this._customFilterManager = new CustomFilterManager();
        }
        return this._customFilterManager;
    }

    public HistoryFilter getAllFilter() {
        if (this._allFilter == null) {
            this._allFilter = new HistoryFilter(){

                @Override
                public String getShortLabel() {
                    return HistoryArb.getString(1);
                }

                @Override
                public boolean accept(HistoryEntry entry) {
                    return true;
                }
            };
        }
        return this._allFilter;
    }

    public static final HistoryManager getHistoryManager() {
        try {
            InitialContext ic = new InitialContext();
            HistoryManager manager = (HistoryManager)ic.lookup(JNDI_NAME);
            return manager;
        }
        catch (NamingException ne) {
            return null;
        }
    }

    public void registerProvider(HistoryProvider provider) {
        if (this._providers == null) {
            this._providers = new HashSet();
        }
        this._providers.add(provider);
    }

    public void unregisterProvider(HistoryProvider provider) {
        if (this._providers != null) {
            this._providers.remove(provider);
            if (this._providers.isEmpty()) {
                this._providers = null;
            }
        }
    }

    public Collection getProviders() {
        if (this._providers == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._providers);
    }

    public final ContextMenu getContextMenu() {
        if (_sharedContextMenu == null) {
            _sharedContextMenu = new ContextMenu(new MnemonicSolver());
        }
        return _sharedContextMenu;
    }

    public final HistoryComponent createHistoryComponent() {
        HistoryComponent component = new HistoryComponent();
        AccessibleUtils.updateAccessibleName((Accessible)component.getTable(), (String)HistoryArb.getString(37), (boolean)false);
        component.getTable().setDefaultRenderer(RevisionIdentifier.class, (TableCellRenderer)new NiceTableCellRenderer(){
            private final Font _defaultFont = this.getFont();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setFont(this._defaultFont);
                RevisionIdentifier revisionIdentifier = (RevisionIdentifier)value;
                this.setToolTipText(null);
                if (value != null) {
                    this.setText(revisionIdentifier.getLabel());
                    if (revisionIdentifier.getIcon() != null) {
                        this.setIcon(revisionIdentifier.getIcon());
                    } else {
                        this.setIcon(null);
                    }
                } else {
                    this.setText(null);
                    this.setIcon(null);
                }
                if (revisionIdentifier != null && revisionIdentifier.isCurrent()) {
                    this.setFont(this._defaultFont.deriveFont(1));
                    this.setToolTipText(HistoryArb.getString(31));
                }
                return c;
            }
        });
        return component;
    }

    public final HistoryComponent createHistoryComponent(HistoryModel model) {
        HistoryComponent component = this.createHistoryComponent();
        component.setModel(model);
        return component;
    }

    public abstract void showHistory(Context var1);

    public abstract void showHistory(Node var1);

    public abstract void updateHistory(URL var1);

    public HistoryModel buildModel(URL url, boolean isAsynchronous, HistoryFilter filter) {
        return this.buildModel(url, isAsynchronous, filter, this.getProviders());
    }

    public HistoryModel buildModel(URL url, boolean isAsynchronous, HistoryFilter filter, Collection providers) {
        DefaultHistoryModel model = new DefaultHistoryModel();
        for (HistoryProvider provider : providers) {
            if (!provider.isProviderFor(url)) continue;
            model.addProperties(provider.getProperties());
            HistoryEntry[] entries = provider.getEntries(url, filter);
            model.addEntries(entries);
        }
        if (filter != null) {
            model.applyFilter(url, filter);
        }
        return model;
    }
}

