/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.io.IOException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.JMenu;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.model.ContentType;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.URLContributor;

public abstract class CompareViewer {
    public static final float COMPARE_WITH_SECTION_MULTI = 2.0f;
    public static final float COMPARE_WITH_SECTION_SINGLE = 1.0f;
    public static final float COMPARE_WITH_WEIGHT_EACH_OTHER = 1.0f;
    public static final float COMPARE_WITH_WEIGHT_FILE_ON_DISK = 1.0f;
    public static final float COMPARE_WITH_WEIGHT_OTHER_FILE = 2.0f;
    public static final String COMPARE_FILE_ON_DISK_COMMAND = "compare.CompareDirty";
    public static final String COMPARE_OTHER_FILE_COMMAND = "compare.CompareOther";
    public static final String COMPARE_EACH_OTHER_COMMAND = "compare.CompareEachOther";

    public static final CompareViewer get() {
        try {
            InitialContext ic = new InitialContext();
            return (CompareViewer)ic.lookup("jdeveloper/compareviewer");
        }
        catch (NamingException ne) {
            return null;
        }
    }

    @Deprecated
    public static final boolean isContentComparable(URL url) {
        return DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)url)) != ContentType.BINARY;
    }

    public abstract JMenu getMainCompareMenu();

    public abstract JMenu getContextCompareMenu();

    public void show(CompareContributor left, CompareContributor right) {
        this.show(left, right, null);
    }

    public void show(CompareContributor left, CompareContributor right, Node contextNode) {
        throw new UnsupportedOperationException();
    }

    public final void show(URL left, URL right) {
        try {
            URLContributor leftContrib = new URLContributor(left);
            URLContributor rightContrib = new URLContributor(right);
            this.show((CompareContributor)leftContrib, (CompareContributor)rightContrib);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

