/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.IdeCompareContributor;

public final class BinaryCompareContributor
extends CompareContributor
implements IdeCompareContributor {
    private Node _contextNode;
    private final InputStream _in;
    private final String _filename;

    public BinaryCompareContributor(URL url) throws IOException {
        this._in = URLFileSystem.openInputStream((URL)(JarUtil.isJarURL((URL)url) ? JarUtil.getJarFileURL((URL)url) : url));
        this._filename = URLFileSystem.getFileName((URL)url);
        this.setShortLabel(URLFileSystem.getFileName((URL)url));
        this.setLongLabel(URLFileSystem.getPlatformPathName((URL)url));
    }

    public BinaryCompareContributor(byte[] data, String filename, String shortLabel, String longLabel) {
        this(new ByteArrayInputStream(data), filename, shortLabel, longLabel);
    }

    public BinaryCompareContributor(InputStream in, String filename, String shortLabel, String longLabel) {
        this._in = in;
        this._filename = filename;
        this.setShortLabel(shortLabel);
        this.setLongLabel(longLabel);
    }

    @Override
    public final void setContextNode(Node contextNode) {
        this._contextNode = contextNode;
    }

    protected final Node getContextNode() {
        if (this._contextNode == null) {
            this._contextNode = Ide.getMainWindow().getLastActiveView().getContext().getNode();
        }
        return this._contextNode;
    }

    @Override
    public final Node getNode() {
        return this.getContextNode();
    }

    public final String getFileName() {
        return this._filename;
    }

    public final InputStream getInputStream() {
        return this._in;
    }
}

