/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import oracle.bali.ewt.event.DeferringPropertyChangeListener;
import oracle.bali.ewt.worker.AbstractWorker;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.MultiWorkerStatusListener;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerStatusAdapter;
import oracle.bali.ewt.worker.WorkerStatusListener;
import oracle.bali.ewt.worker.WorkerUtils;
import oracle.bali.share.util.IntegerUtils;

public final class WorkerUIUtils {
    public static final Object WORKER_CLIENT_PROPERTY = "JEWTWorker";
    public static final Object WORKER_SHORT_DESCRIPTION = "ShortDescription";
    public static final Object WORKER_LONG_DESCRIPTION = "LongDescription";
    public static final Object WORKER_SMALL_ICON = "SmallIcon";
    public static final Object WORKER_ROLLOVER_ICON = "ROIcon";
    public static final Object WORKER_MNEMONIC = "Mnemon";
    public static final Object WORKER_ACCELERATOR = "Accel";
    public static final Object WORKER_INVOKING_COMPONENT = "InvComp";
    private static final String _ACTION_LISTENER = "WorkerUIUtils.actionListener";
    private static final String _WORKER_CHANGE_LISTENER = "WorkerUIUtils.workerChangeListener";
    private static final String _PROPERTY_CHANGE_LISTENER = "WorkerUIUtils.propertyChangeListener";

    public static void setShortDescription(Worker worker, String newShortDescription) {
        worker.putValue(WORKER_SHORT_DESCRIPTION, newShortDescription);
    }

    public static String getShortDescription(Worker worker) {
        return (String)worker.getValue(WORKER_SHORT_DESCRIPTION);
    }

    public static void setLongDescription(Worker worker, String newLongDescription) {
        worker.putValue(WORKER_LONG_DESCRIPTION, newLongDescription);
    }

    public static String getLongDescription(Worker worker) {
        return (String)worker.getValue(WORKER_LONG_DESCRIPTION);
    }

    public static void setSmallIcon(Worker worker, Icon newSmallIcon) {
        worker.putValue(WORKER_SMALL_ICON, newSmallIcon);
    }

    public static Icon getSmallIcon(Worker worker) {
        return (Icon)worker.getValue(WORKER_SMALL_ICON);
    }

    public static void setRolloverIcon(Worker worker, Icon newRolloverIcon) {
        worker.putValue(WORKER_ROLLOVER_ICON, newRolloverIcon);
    }

    public static Icon getRolloverIcon(Worker worker) {
        return (Icon)worker.getValue(WORKER_ROLLOVER_ICON);
    }

    public static void setMnemonic(Worker worker, int newMnemonic) {
        Integer mnemonicValue = newMnemonic != 0 ? IntegerUtils.getInteger((int)newMnemonic) : null;
        worker.putValue(WORKER_MNEMONIC, mnemonicValue);
    }

    public static int getMnemonic(Worker worker) {
        Integer mnemonicValue = (Integer)worker.getValue(WORKER_MNEMONIC);
        if (mnemonicValue != null) {
            return mnemonicValue;
        }
        return 0;
    }

    public static void setAccelerator(Worker worker, KeyStroke newKeyStroke) {
        worker.putValue(WORKER_ACCELERATOR, newKeyStroke);
    }

    public static KeyStroke getAccelerator(Worker worker) {
        return (KeyStroke)worker.getValue(WORKER_ACCELERATOR);
    }

    public JComponent getInvokingComponent(InvocationContext invokeContext) {
        return (JComponent)invokeContext.getValue(WORKER_INVOKING_COMPONENT, null);
    }

    public static Worker getComponentWorker(JComponent component) {
        return (Worker)component.getClientProperty(WORKER_CLIENT_PROPERTY);
    }

    public static JButton createToolBarButton(Worker tbButtonWorker) {
        return WorkerUIUtils.createToolBarButton(tbButtonWorker, InvocationContext.UNDEFINED);
    }

    public static JButton createToolBarButton(Worker tbButtonWorker, Object parameterValue) {
        return WorkerUIUtils.createToolBarButton(tbButtonWorker, parameterValue, null);
    }

    public static JButton createToolBarButton(Worker tbButtonWorker, Object parameterValue, WorkerStatusListener listener) {
        return WorkerUIUtils.createToolBarButton(tbButtonWorker, InvocationContext.PARAMETER_VALUE, parameterValue, listener);
    }

    public static JButton createToolBarButton(Worker tbButtonWorker, Object parameterKey, Object parameterValue, WorkerStatusListener listener) {
        return WorkerUIUtils.createToolBarButton(tbButtonWorker, WorkerUtils.createParameters(parameterKey, parameterValue), listener);
    }

    public static JButton createToolBarButton(Worker tbButtonWorker, Dictionary parameters, WorkerStatusListener listener) {
        JButton newToolBarButton = new JButton();
        newToolBarButton.setRequestFocusEnabled(false);
        WorkerUIUtils._configureWorkerButton(newToolBarButton, tbButtonWorker, parameters, listener, false, true);
        return newToolBarButton;
    }

    public static JMenuItem createMenuItem(Worker menuItemWorker) {
        return WorkerUIUtils.createMenuItem(menuItemWorker, InvocationContext.UNDEFINED);
    }

    public static JMenuItem createMenuItem(Worker menuItemWorker, Object parameterValue) {
        return WorkerUIUtils.createMenuItem(menuItemWorker, parameterValue, null);
    }

    public static JMenuItem createMenuItem(Worker menuItemWorker, Object parameterValue, WorkerStatusListener listener) {
        return WorkerUIUtils.createMenuItem(menuItemWorker, InvocationContext.PARAMETER_VALUE, parameterValue, listener);
    }

    public static JMenuItem createMenuItem(Worker menuItemWorker, Object parameterKey, Object parameterValue, WorkerStatusListener listener) {
        return WorkerUIUtils.createMenuItem(menuItemWorker, WorkerUtils.createParameters(parameterKey, parameterValue), listener);
    }

    public static JMenuItem createMenuItem(Worker menuItemWorker, Dictionary parameters, WorkerStatusListener listener) {
        JMenuItem newMenuItem = new JMenuItem();
        newMenuItem.setAccelerator(WorkerUIUtils.getAccelerator(menuItemWorker));
        WorkerUIUtils._configureWorkerButton(newMenuItem, menuItemWorker, parameters, listener, true, false);
        return newMenuItem;
    }

    public static JButton createPushButton(Worker buttonWorker) {
        return WorkerUIUtils.createPushButton(buttonWorker, InvocationContext.UNDEFINED);
    }

    public static JButton createPushButton(Worker buttonWorker, Object parameterValue) {
        return WorkerUIUtils.createPushButton(buttonWorker, parameterValue, null);
    }

    public static JButton createPushButton(Worker buttonWorker, Object parameterValue, WorkerStatusListener listener) {
        return WorkerUIUtils.createPushButton(buttonWorker, InvocationContext.PARAMETER_VALUE, parameterValue, listener);
    }

    public static JButton createPushButton(Worker buttonWorker, Object parameterKey, Object parameterValue, WorkerStatusListener listener) {
        return WorkerUIUtils.createPushButton(buttonWorker, WorkerUtils.createParameters(parameterKey, parameterValue), listener);
    }

    public static JButton createPushButton(Worker buttonWorker, Dictionary parameters, WorkerStatusListener listener) {
        JButton newPushButton = new JButton();
        WorkerUIUtils._configureWorkerButton(newPushButton, buttonWorker, parameters, listener, true, false);
        return newPushButton;
    }

    public static void dispose(AbstractButton button) {
        Object o = button.getClientProperty(_ACTION_LISTENER);
        if (o instanceof WorkerActionProxy) {
            WorkerActionProxy wap = (WorkerActionProxy)o;
            wap.dispose();
            button.removeActionListener(wap);
        }
        button.putClientProperty(_ACTION_LISTENER, null);
        o = button.getClientProperty(_WORKER_CHANGE_LISTENER);
        if (o instanceof WorkerChangedListener) {
            WorkerChangedListener wcl = (WorkerChangedListener)o;
            wcl.dispose();
        }
        button.putClientProperty(_WORKER_CHANGE_LISTENER, null);
        o = button.getClientProperty(WORKER_CLIENT_PROPERTY);
        Worker w = o instanceof Worker ? (Worker)o : null;
        button.putClientProperty(WORKER_CLIENT_PROPERTY, null);
        o = button.getClientProperty(_PROPERTY_CHANGE_LISTENER);
        if (o instanceof PropertyChangeListener) {
            w.removePropertyChangeListener((PropertyChangeListener)o);
        }
        button.putClientProperty(_PROPERTY_CHANGE_LISTENER, null);
    }

    private static void _configureWorkerButton(AbstractButton button, Worker buttonWorker, Dictionary parameters, WorkerStatusListener listener, boolean setLabel, boolean setIcon) {
        int mnemonic;
        String buttonlabel = setLabel ? AbstractWorker.getName(buttonWorker) : null;
        String buttonCommand = AbstractWorker.getCommand(buttonWorker);
        button.setName(buttonCommand);
        Icon buttonIcon = null;
        Icon rolloverIcon = null;
        if (setIcon) {
            buttonIcon = WorkerUIUtils.getSmallIcon(buttonWorker);
            rolloverIcon = WorkerUIUtils.getRolloverIcon(buttonWorker);
        }
        if ((mnemonic = WorkerUIUtils.getMnemonic(buttonWorker)) != 0) {
            button.setMnemonic(mnemonic);
        }
        String toolTip = setLabel ? WorkerUIUtils.getLongDescription(buttonWorker) : WorkerUIUtils.getShortDescription(buttonWorker);
        button.setText(buttonlabel);
        button.setActionCommand(buttonCommand);
        button.setToolTipText(toolTip);
        WorkerActionProxy actionListener = new WorkerActionProxy(button, buttonWorker, parameters, listener);
        button.addActionListener(actionListener);
        button.putClientProperty(_ACTION_LISTENER, actionListener);
        button.setEnabled(buttonWorker.isEnabled());
        if (buttonIcon != null) {
            button.setIcon(buttonIcon);
        }
        if (rolloverIcon != null) {
            button.setRolloverIcon(rolloverIcon);
        }
        WorkerChangedListener wcl = new WorkerChangedListener(button, setLabel, setIcon);
        DeferringPropertyChangeListener dpcl = new DeferringPropertyChangeListener(wcl);
        button.putClientProperty(_WORKER_CHANGE_LISTENER, wcl);
        button.putClientProperty(_PROPERTY_CHANGE_LISTENER, dpcl);
        buttonWorker.addPropertyChangeListener(dpcl);
        button.putClientProperty(WORKER_CLIENT_PROPERTY, buttonWorker);
    }

    private WorkerUIUtils() {
    }

    private static class WorkerChangedListener
    implements PropertyChangeListener {
        private AbstractButton _button;
        private boolean _trackLabel;
        private boolean _trackIcon;

        public WorkerChangedListener(AbstractButton targetButton, boolean trackLabel, boolean trackIcon) {
            this._button = targetButton;
            this._trackLabel = trackLabel;
            this._trackIcon = trackIcon;
        }

        public void dispose() {
            this._button = null;
        }

        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            Object newValue = event.getNewValue();
            if (propertyName.equals(Worker.WORKER_NAME)) {
                if (this._trackLabel) {
                    this._button.setText((String)newValue);
                }
            } else if (propertyName.equals("enabled")) {
                this._button.setEnabled((Boolean)newValue);
            } else if (propertyName.equals(WORKER_SMALL_ICON)) {
                if (this._trackIcon) {
                    this._button.setIcon((Icon)newValue);
                }
            } else if (propertyName.equals(WORKER_ROLLOVER_ICON)) {
                if (this._trackIcon) {
                    this._button.setRolloverIcon((Icon)newValue);
                }
            } else if (propertyName.equals(WORKER_SHORT_DESCRIPTION)) {
                if (!this._trackLabel) {
                    this._button.setToolTipText((String)newValue);
                }
            } else if (propertyName.equals(WORKER_LONG_DESCRIPTION)) {
                if (this._trackLabel) {
                    this._button.setToolTipText((String)newValue);
                }
            } else if (propertyName.equals(Worker.WORKER_COMMAND)) {
                this._button.setActionCommand((String)newValue);
            }
        }
    }

    private static class WorkerActionProxy
    extends WorkerStatusAdapter
    implements ActionListener {
        private AbstractButton _button;
        private Worker _target;
        private Dictionary _parameters;
        private MultiWorkerStatusListener _multiListener;

        public WorkerActionProxy(AbstractButton button, Worker target, Dictionary parameters, WorkerStatusListener listener) {
            if (target == null) {
                throw new IllegalArgumentException();
            }
            if (parameters == null) {
                parameters = WorkerUtils.createMinimalParameterDictionary();
            }
            parameters.put(WORKER_INVOKING_COMPONENT, button);
            this._button = button;
            this._target = target;
            this._parameters = parameters;
            this._multiListener = new MultiWorkerStatusListener(listener, this);
        }

        public void dispose() {
            this._button = null;
            this._target = null;
            this._parameters = null;
            this._multiListener = null;
        }

        public final void actionPerformed(ActionEvent event) {
            ((AbstractButton)event.getSource()).setEnabled(false);
            WorkerUtils.queueWorker(this._target, this._parameters, (WorkerStatusListener)this._multiListener);
        }

        public void workerSucceeded(InvocationContext invokingContext) {
            this._reenable(invokingContext);
        }

        public void workerFailed(InvocationContext invokingContext) {
            this._reenable(invokingContext);
        }

        private void _reenable(InvocationContext invokingContext) {
            this._button.setEnabled(this._target.isEnabled());
        }
    }
}

