/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.DWizard;
import oracle.bali.share.util.IntegerUtils;

class WizardWindowTitle
extends WizardAdapter
implements PropertyChangeListener {
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_OTHER = "WIZARD.TITLE_OTHER";
    private BaseWizard _wizard;
    private String _baseTitle;
    private Window _wizardWindow;
    private boolean _canUpdate;

    public WizardWindowTitle(Window wizardWindow, BaseWizard wizard) {
        this._wizardWindow = wizardWindow;
        this.setWizard(wizard);
    }

    public void setWizard(BaseWizard wizard) {
        if (wizard != this._wizard) {
            if (this._wizard != null) {
                this._wizard.removeWizardListener(this);
                this._wizard.removePropertyChangeListener(this);
            }
            this._wizard = wizard;
            if (this._wizard != null) {
                this._wizard.addWizardListener(this);
                this._wizard.addPropertyChangeListener(this);
            }
        }
    }

    public void setBaseTitle(String baseTitle) {
        if (baseTitle != this._baseTitle) {
            this._baseTitle = baseTitle;
            this.updateTitle();
        }
    }

    public String getBaseTitle() {
        return this._baseTitle;
    }

    public void setCanUpdate(boolean update) {
        this._canUpdate = update;
    }

    public void updateTitle() {
        if (!this._canUpdate) {
            return;
        }
        if (this._wizard != null && this._baseTitle != null) {
            String title = this._baseTitle;
            WizardPage page = this._wizard.getSelectedPage();
            if (page != null) {
                int pageCount = this._wizard.getPageCount();
                int index = -1;
                int visiblePageCount = 0;
                if (this._wizard instanceof DWizard) {
                    visiblePageCount = pageCount;
                    index = ((DWizard)this._wizard).getCurrentPageIndex();
                } else {
                    for (int i = 0; i < pageCount; ++i) {
                        WizardPage temp = this._wizard.getPageAt(i);
                        if (temp == page) {
                            index = visiblePageCount;
                        }
                        if (!temp.isVisible()) continue;
                        ++visiblePageCount;
                    }
                }
                ResourceBundle b = ResourceBundle.getBundle(_BUNDLE, this._wizardWindow.getLocale());
                MessageFormat format = new MessageFormat(b.getString(_KEY_OTHER));
                Object[] args = new Object[]{this._baseTitle, IntegerUtils.getInteger((int)(++index)), IntegerUtils.getInteger((int)visiblePageCount)};
                title = format.format(args);
            }
            if (this._wizardWindow instanceof Dialog) {
                ((Dialog)this._wizardWindow).setTitle(title);
            } else if (this._wizardWindow instanceof Frame) {
                ((Frame)this._wizardWindow).setTitle(title);
            }
        }
    }

    public void wizardSelectionChanged(WizardEvent event) {
        this.updateTitle();
    }

    public void propertyChange(PropertyChangeEvent pe) {
        String propertyName = pe.getPropertyName();
        if ("pageAdded".equals(propertyName) || "pageRemoved".equals(propertyName) || "pageVisible".equals(propertyName)) {
            this.updateTitle();
        }
    }
}

