/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.View;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.graphics.SpacingIcon;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationManager;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessageModel;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class ValidationMessagePane
extends LWComponent
implements Accessible {
    public static final String PANE_EMPTY = new String("paneEmpty");
    private static final String _LABELED_BY_PROPERTY = "labeledBy";
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _MESSAGE_KEY = "VALIDATION.MESSAGES";
    private static final Icon[] _ICONS = new Icon[6];
    private static final String[] _ICON_NAME = new String[]{"icons/error.png", "icons/warning.png", "icons/success.png", "icons/inprogress.png"};
    private static final Border _MSG_TEXT_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border _MSG_ICON_BORDER = new EmptyBorder(0, 3, 0, 0);
    private static final Color _ERROR_BG = new Color(255, 204, 204);
    private static final Color _WARN_BG = new Color(255, 255, 204);
    private static final String[] _VALIDATION_MESSAGE_ARR = new String[]{"VALIDATION_MESSAGE.ERROR_MNEMONIC", "VALIDATION_MESSAGE.WARNING_MNEMONIC", "VALIDATION_MESSAGE.ERROR", "VALIDATION_MESSAGE.WARNING"};
    private static final String _ACCESS_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private Listener _listener;
    private JList _list;
    private DefaultListModel _listModel;
    private JTree _tree;
    private DefaultMutableTreeNode _root;
    private DefaultTreeModel _treeModel;
    private JLabel _messageLabel;
    private AccessibleJLabel _accessibleLabel;
    private ArrayList _comps;
    private HashMap _indexMap;
    private ValidationManager _manager;
    private Component _selectedComp;
    private Color _originalBg;
    private boolean _isEmpty;
    private JScrollPane _scroll;
    private MessageMode _mode = MessageMode.LIST;
    private JLabel _iconLabel;
    private JTextArea _messageTextArea;
    private int _indentWidth = 0;

    public ValidationMessagePane() {
        this._listener = new Listener();
        this._createUI();
        this._comps = new ArrayList();
        this._indexMap = new HashMap();
        this._manager = new ValidationManager();
        this._isEmpty = true;
    }

    public void addValidationComponent(ValidationComponent vComp) {
        if (!this._comps.contains(vComp)) {
            Component comp = vComp.getComponent();
            this._comps.add(vComp);
            this._putValidationComponent(comp, vComp);
            this._indexMap.put(vComp, IntegerUtils.getInteger((int)this.getMessageCount()));
            this._addValidationMessageModel(vComp, vComp.getValidationMessageModel());
            vComp.addValidationMessageModelListener(this._listener);
            vComp.addPropertyChangeListener(this._listener);
            comp.addFocusListener(this._listener);
        }
    }

    public void removeValidationComponent(ValidationComponent vComp) {
        if (this._comps.remove(vComp)) {
            Component comp = vComp.getComponent();
            this._putValidationComponent(comp, null);
            ValidationMessageModel model = vComp.getValidationMessageModel();
            this._removeValidationMessageModel(vComp, vComp.getValidationMessageModel());
            this._updateIndex(vComp, -model.getMessageCount());
            this._indexMap.remove(vComp);
            vComp.removeValidationMessageModelListener(this._listener);
            vComp.removePropertyChangeListener(this._listener);
            comp.removeFocusListener(this._listener);
        }
    }

    public void removeAllValidationComponents() {
        int count = this._comps.size();
        for (int i = 0; i < count; ++i) {
            ValidationComponent vComp = (ValidationComponent)this._comps.get(i);
            vComp.removeValidationMessageModelListener(this._listener);
            vComp.removePropertyChangeListener(this._listener);
            vComp.getComponent().removeFocusListener(this._listener);
        }
        if (this.getMessageMode() == MessageMode.TREE) {
            int noOfchildren = this._treeModel.getChildCount(this._root);
            for (int i = 0; i < noOfchildren; ++i) {
                this._treeModel.removeNodeFromParent((DefaultMutableTreeNode)this._treeModel.getChild(this._root, 0));
            }
        } else {
            this._listModel.removeAllElements();
        }
        this._comps.clear();
        this._indexMap.clear();
    }

    public int getMessageCount() {
        if (this.getMessageMode() == MessageMode.TREE) {
            return this._treeModel.getChildCount(this._root);
        }
        return this._listModel.getSize();
    }

    public boolean isEmpty() {
        return this._isEmpty;
    }

    public void setMessageLabelVisible(boolean visible) {
        if (visible != this.isMessageLabelVisible()) {
            if (visible) {
                this.add((Component)this._messageLabel, "North");
            } else {
                this.remove(this._messageLabel);
            }
            this.revalidate();
        }
    }

    public boolean isMessageLabelVisible() {
        return this._messageLabel.getParent() == this;
    }

    public void setMessageMode(MessageMode mode) {
        if (this.getMessageMode() != mode) {
            this._mode = mode;
            if (this._mode == MessageMode.TREE) {
                this._disposeList();
            } else {
                this._indentWidth = 0;
                this._disposeTree();
            }
            this._updateUI();
            this._checkPaneIsEmpty();
        }
    }

    public MessageMode getMessageMode() {
        return this._mode;
    }

    public void dispose() {
        this.removeAllValidationComponents();
        this._comps = null;
        this._manager = null;
        this._indexMap = null;
        this._messageLabel = null;
        if (this.getMessageMode() == MessageMode.TREE) {
            this._disposeTree();
        } else {
            this._disposeList();
        }
        this._listener = null;
    }

    public void addNotify() {
        super.addNotify();
        this._updateMessageLabel();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._updateMessageLabel();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJValidatePane();
            StatusBar bar = new StatusBar();
            this._accessibleLabel = new AccessibleJLabel();
            bar.add(this._accessibleLabel);
            bar.setPreferredSize(new Dimension(0, 0));
            this.add((Component)bar, "South");
        }
        return this.accessibleContext;
    }

    protected String getComponentName(ValidationComponent vComp) {
        JComponent jComp;
        JLabel label;
        Component comp = vComp.getComponent();
        if (comp instanceof JComponent && (label = (JLabel)(jComp = (JComponent)comp).getClientProperty(_LABELED_BY_PROPERTY)) != null) {
            return label.getText();
        }
        return comp.getName();
    }

    private void _createUI() {
        this._createList();
        this._messageLabel = new JLabel();
        this._messageLabel.setLabelFor(this._list);
        this._scroll = new JScrollPane(this._list, 20, 31);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this._messageLabel, "North");
        this.add(this._scroll);
    }

    private void _updateUI() {
        if (this.getMessageMode() == MessageMode.TREE) {
            this._createTree();
            this._messageLabel.setLabelFor(this._tree);
            this._scroll.setViewportView(this._tree);
        } else {
            this._createList();
            this._messageLabel.setLabelFor(this._list);
            this._scroll.setViewportView(this._list);
        }
    }

    private void _updateChild(DefaultMutableTreeNode node) {
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this._treeModel.getChild(node, i);
            this._treeModel.nodeChanged(child);
            this._updateChild(child);
        }
    }

    private void _createTree() {
        this._root = new DefaultMutableTreeNode();
        this._treeModel = new DefaultTreeModel(this._root);
        this._tree = new JTree(this._treeModel){

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            public int getRowHeight() {
                return -1;
            }
        };
        Color bg = UIManager.getColor("ValidationMessagePane.background");
        if (bg != null) {
            this._tree.setBackground(bg);
        }
        this._tree.setVisibleRowCount(3);
        this._tree.setRootVisible(false);
        DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
        selModel.setSelectionMode(1);
        this._tree.setSelectionModel(selModel);
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new TreeMessageCellRenderer());
        this._tree.addTreeSelectionListener(this._listener);
        this._tree.addFocusListener(this._listener);
        this._tree.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                ValidationMessagePane.this._updateChild(ValidationMessagePane.this._root);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        this._treeModel.addTreeModelListener(this._listener);
    }

    private void _createList() {
        this._listModel = new DefaultListModel();
        this._list = new JList(this._listModel){

            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        Color bg = UIManager.getColor("ValidationMessagePane.background");
        if (bg != null) {
            this._list.setBackground(bg);
        }
        this._list.setVisibleRowCount(3);
        this._list.setSelectionMode(1);
        this._list.setCellRenderer(new CellRenderer());
        this._list.addListSelectionListener(this._listener);
        this._list.addFocusListener(this._listener);
        this._listModel.addListDataListener(this._listener);
    }

    private void _disposeTree() {
        this._tree.removeTreeSelectionListener(this._listener);
        this._tree.removeFocusListener(this._listener);
        this._treeModel.removeTreeModelListener(this._listener);
        this._treeModel = null;
        this._tree = null;
    }

    private void _disposeList() {
        this._list.removeListSelectionListener(this._listener);
        this._list.removeFocusListener(this._listener);
        this._listModel.removeListDataListener(this._listener);
        this._listModel = null;
        this._list = null;
    }

    private void _updateMessageLabel() {
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle bundle = ResourceBundle.getBundle(_BUNDLE, locale);
        String text = bundle.getString(_MESSAGE_KEY);
        this._messageLabel.setText(StringUtils.stripMnemonic((String)text));
        this._messageLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
    }

    private void _addValidationMessageModel(ValidationComponent comp, ValidationMessageModel model) {
        if (!model.isEmpty()) {
            int index = (Integer)this._indexMap.get(comp);
            ValidationMessage[] messages = model.getValidationMessages();
            for (int i = 0; i < messages.length; ++i) {
                if (this.getMessageMode() == MessageMode.TREE) {
                    TreeNode headerNode = new TreeNode(comp, messages[i], true, messages[i].getMessage());
                    this._treeModel.insertNodeInto(headerNode, this._root, index);
                    final TreePath path = new TreePath(this._treeModel.getPathToRoot(headerNode));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (ValidationMessagePane.this._tree != null) {
                                ValidationMessagePane.this._tree.getSelectionModel().setSelectionPath(path);
                            }
                        }
                    });
                    String[] desc = messages[i].getDescription();
                    if (desc == null) continue;
                    int len = desc.length;
                    for (int j = 0; j < len; ++j) {
                        TreeNode childNode = new TreeNode(comp, messages[i], false, desc[j]);
                        this._treeModel.insertNodeInto(childNode, headerNode, j);
                    }
                    continue;
                }
                this._listModel.add(index, new ListItem(comp, messages[i]));
            }
        }
    }

    private void _removeValidationMessageModel(ValidationComponent comp, ValidationMessageModel model) {
        if (!model.isEmpty()) {
            int index = (Integer)this._indexMap.get(comp);
            if (this.getMessageMode() == MessageMode.TREE) {
                for (int i = model.getMessageCount() - 1; i >= 0; --i) {
                    this._treeModel.removeNodeFromParent((TreeNode)this._root.getChildAt(i));
                }
            } else {
                this._listModel.removeRange(index, index + model.getMessageCount() - 1);
            }
        }
    }

    private void _updateIndex(ValidationComponent vcomp, int count) {
        int size = this._comps.size();
        int index = this._comps.indexOf(vcomp);
        if (index != -1) {
            for (int i = index + 1; i < size; ++i) {
                ValidationComponent currComp = (ValidationComponent)this._comps.get(i);
                int currtIndex = (Integer)this._indexMap.get(currComp);
                this._indexMap.put(currComp, IntegerUtils.getInteger((int)(currtIndex + count)));
            }
        }
    }

    private void _checkPaneIsEmpty() {
        boolean newEmpty;
        boolean bl = newEmpty = this.getMessageCount() == 0;
        if (newEmpty != this._isEmpty) {
            this._isEmpty = newEmpty;
            this.firePropertyChange(PANE_EMPTY, !this._isEmpty, this._isEmpty);
        }
    }

    private void _putValidationComponent(Component comp, ValidationComponent vComp) {
        this._manager.putValidationComponent(comp, vComp);
    }

    private ValidationComponent _getValidationComponent(Component comp) {
        return this._manager.getValidationComponent(comp);
    }

    private String _getAccessibleName(TreeNode node) {
        String labelStr = this._getValidationMessageText(node);
        ValidationComponent validationComp = node.getValidationComponent();
        int severity = node.getMessage().getSeverity();
        if (severity == 1 || severity == 2) {
            return this._getName(labelStr, validationComp, severity);
        }
        return "";
    }

    private String _getAccessibleName(ListItem item) {
        String labelStr = this._getValidationMessageText(item);
        ValidationComponent validationComp = item.getValidationComponent();
        int severity = item.getMessage().getSeverity();
        if (severity == 1 || severity == 2) {
            return this._getName(labelStr, validationComp, severity);
        }
        return "";
    }

    private String _getName(String labelStr, ValidationComponent validationComp, int severity) {
        String[] strargs;
        Component comp = validationComp.getComponent();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle bundle = ResourceBundle.getBundle(_ACCESS_BUNDLE, locale);
        JLabel label = null;
        if (comp instanceof JComponent) {
            label = (JLabel)((JComponent)comp).getClientProperty(_LABELED_BY_PROPERTY);
        }
        int mnemonic = label == null ? 0 : label.getDisplayedMnemonic();
        int index = 0;
        if (mnemonic != 0) {
            strargs = new String[2];
            int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? 2 : 8;
            strargs[0] = labelStr;
            strargs[1] = KeyEvent.getKeyModifiersText(mod) + KeyEvent.getKeyText(mnemonic);
            if (severity == 2) {
                ++index;
            }
        } else {
            strargs = new String[]{labelStr};
            index = 2;
            if (severity == 2) {
                ++index;
            }
        }
        return MessageFormat.format(bundle.getString(_VALIDATION_MESSAGE_ARR[index]), strargs);
    }

    private String _getValidationMessageText(ListItem item) {
        String labelStr = this.getComponentName(item.getValidationComponent());
        ValidationMessage message = item.getMessage();
        String msg = message.getMessage();
        return this._getLabel(labelStr, msg);
    }

    private String _getValidationMessageText(TreeNode node) {
        String labelStr = this.getComponentName(node.getValidationComponent());
        String msg = node.getLabel();
        return this._getLabel(labelStr, msg);
    }

    private String _getLabel(String labelStr, String msg) {
        if (labelStr != null && !"".equals(labelStr)) {
            return labelStr + msg;
        }
        return msg;
    }

    private Icon _getIcon(int severity) {
        int index = severity - 1;
        if (_ICONS[index] == null) {
            ValidationMessagePane._ICONS[index] = index < 5 ? new ImageIcon(ImageUtils.getImageResource(ValidationMessagePane.class, _ICON_NAME[index])) : new SpacingIcon(new ImageIcon(ImageUtils.getImageResource(ValidationMessagePane.class, _ICON_NAME[0])));
        }
        return _ICONS[index];
    }

    private void _initRenderer(JPanel panel) {
        panel.setOpaque(true);
        this._iconLabel = new JLabel();
        this._iconLabel.setOpaque(true);
        this._iconLabel.setBorder(_MSG_ICON_BORDER);
        this._messageTextArea = new JTextArea();
        this._messageTextArea.setLineWrap(true);
        this._messageTextArea.setWrapStyleWord(true);
        this._messageTextArea.setOpaque(true);
        this._messageTextArea.setBorder(_MSG_TEXT_BORDER);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.anchor = 17;
        panel.add((Component)this._iconLabel, constraint);
        constraint.anchor = 18;
        constraint.weightx = 1.0;
        constraint.fill = 2;
        panel.add((Component)this._messageTextArea, constraint);
    }

    private void _updateRenderer(JPanel panel, String label, boolean enabled, Border border, Color areaBg, Color areaFg, Color bg, Font font) {
        this._messageTextArea.setText(label);
        Insets insets = this.getInsets();
        int messageWidth = this.getWidth() - (insets.right + insets.left) - this._iconLabel.getPreferredSize().width - this._indentWidth;
        JScrollBar bar = this._scroll.getVerticalScrollBar();
        if (bar.isVisible()) {
            messageWidth -= bar.getWidth();
        }
        View view = this._messageTextArea.getUI().getRootView(this._messageTextArea);
        view.setSize(messageWidth, Float.MAX_VALUE);
        int height = (int)view.getPreferredSpan(1);
        Insets inset = this._messageTextArea.getInsets();
        height = inset.top + inset.bottom + height;
        this._messageTextArea.setPreferredSize(new Dimension(messageWidth, height));
        this._messageTextArea.setEnabled(enabled);
        this._iconLabel.setEnabled(enabled);
        this._messageTextArea.setFont(font);
        this._messageTextArea.setBorder(border);
        this._messageTextArea.setBackground(areaBg);
        this._messageTextArea.setForeground(areaFg);
        this._iconLabel.setBackground(bg);
        panel.setBackground(bg);
    }

    private class AccessibleJLabel
    extends JLabel {
        private AccessibleJLabel() {
        }

        public void setText(String text) {
            super.setText(text);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", "", text);
            }
        }
    }

    private class AccessibleJValidatePane
    extends JComponent.AccessibleJComponent {
        private AccessibleJValidatePane() {
            super(ValidationMessagePane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class Listener
    implements FocusListener,
    ListDataListener,
    ListSelectionListener,
    TreeSelectionListener,
    TreeModelListener,
    PropertyChangeListener,
    ValidationMessageModelListener {
        private Listener() {
        }

        public void focusLost(FocusEvent event) {
            if (ValidationMessagePane.this.getMessageMode() == MessageMode.TREE) {
                if (event.getComponent() == ValidationMessagePane.this._tree) {
                    DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
                    selModel.setSelectionMode(1);
                    ValidationMessagePane.this._tree.setSelectionModel(selModel);
                    if (ValidationMessagePane.this._selectedComp != null) {
                        this._restoreBackground(ValidationMessagePane.this._selectedComp);
                        ValidationMessagePane.this._selectedComp = null;
                    }
                } else if (FocusUtils.getOppositeComponent(event) != ValidationMessagePane.this._tree) {
                    ValidationMessagePane.this._tree.clearSelection();
                    ValidationMessagePane.this._tree.repaint();
                }
            } else if (event.getComponent() == ValidationMessagePane.this._list) {
                ValidationMessagePane.this._list.setSelectionMode(1);
                if (ValidationMessagePane.this._selectedComp != null) {
                    this._restoreBackground(ValidationMessagePane.this._selectedComp);
                    ValidationMessagePane.this._selectedComp = null;
                }
            } else if (FocusUtils.getOppositeComponent(event) != ValidationMessagePane.this._list) {
                ValidationMessagePane.this._list.clearSelection();
                ValidationMessagePane.this._list.repaint();
            }
        }

        public void focusGained(FocusEvent event) {
            Component comp = event.getComponent();
            if (ValidationMessagePane.this.getMessageMode() == MessageMode.TREE) {
                if (comp == ValidationMessagePane.this._tree) {
                    DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
                    selModel.setSelectionMode(1);
                    ValidationMessagePane.this._tree.setSelectionModel(selModel);
                    TreePath selPath = ValidationMessagePane.this._tree.getSelectionPath();
                    if (selPath == null) {
                        if (ValidationMessagePane.this._root.getChildCount() > 0) {
                            ValidationMessagePane.this._tree.setSelectionPath(new TreePath(((TreeNode)ValidationMessagePane.this._root.getChildAt(0)).getPath()));
                        }
                    } else {
                        TreeNode node = (TreeNode)selPath.getLastPathComponent();
                        ValidationComponent vComp = node.getValidationComponent();
                        ValidationMessagePane.this._selectedComp = vComp.getComponent();
                        ValidationMessagePane.this._originalBg = ValidationMessagePane.this._selectedComp.getBackground();
                        if (vComp.getValidationMessageModel().getMessageCount(1) != 0) {
                            ValidationMessagePane.this._selectedComp.setBackground(_ERROR_BG);
                        } else if (vComp.getValidationMessageModel().getMessageCount(2) != 0) {
                            ValidationMessagePane.this._selectedComp.setBackground(_WARN_BG);
                        }
                    }
                } else {
                    ValidationMessageModel model;
                    int count;
                    ValidationComponent vComp = ValidationMessagePane.this._getValidationComponent(comp);
                    if (vComp != null && (count = (model = vComp.getValidationMessageModel()).getMessageCount()) > 0) {
                        int index = (Integer)ValidationMessagePane.this._indexMap.get(vComp);
                        ValidationMessagePane.this._tree.setSelectionPath(new TreePath(((TreeNode)ValidationMessagePane.this._root.getChildAt(index)).getPath()));
                        ValidationMessagePane.this._tree.repaint();
                    }
                }
            } else if (comp == ValidationMessagePane.this._list) {
                ValidationMessagePane.this._list.setSelectionMode(0);
                ListItem item = (ListItem)ValidationMessagePane.this._list.getSelectedValue();
                if (item == null) {
                    if (ValidationMessagePane.this._list.getModel().getSize() > 0) {
                        ValidationMessagePane.this._list.setSelectedIndex(0);
                    }
                } else {
                    ValidationComponent vComp = item.getValidationComponent();
                    ValidationMessagePane.this._selectedComp = vComp.getComponent();
                    ValidationMessagePane.this._originalBg = ValidationMessagePane.this._selectedComp.getBackground();
                    if (vComp.getValidationMessageModel().getMessageCount(1) != 0) {
                        ValidationMessagePane.this._selectedComp.setBackground(_ERROR_BG);
                    } else if (vComp.getValidationMessageModel().getMessageCount(2) != 0) {
                        ValidationMessagePane.this._selectedComp.setBackground(_WARN_BG);
                    }
                }
            } else {
                ValidationMessageModel model;
                int count;
                ValidationComponent vComp = ValidationMessagePane.this._getValidationComponent(comp);
                if (vComp != null && (count = (model = vComp.getValidationMessageModel()).getMessageCount()) > 0) {
                    int index = (Integer)ValidationMessagePane.this._indexMap.get(vComp);
                    ValidationMessagePane.this._list.setSelectionInterval(index, index + count - 1);
                    ValidationMessagePane.this._list.repaint();
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (ValidationMessagePane.this._list.hasFocus()) {
                ListItem item = (ListItem)ValidationMessagePane.this._list.getSelectedValue();
                if (item != null) {
                    ValidationComponent vComp = item.getValidationComponent();
                    Component comp = vComp.getComponent();
                    if (comp != ValidationMessagePane.this._selectedComp) {
                        if (ValidationMessagePane.this._selectedComp != null) {
                            this._restoreBackground(ValidationMessagePane.this._selectedComp);
                        }
                        ValidationMessagePane.this._selectedComp = comp;
                        ValidationMessagePane.this._originalBg = ValidationMessagePane.this._selectedComp.getBackground();
                    }
                    if (vComp.getValidationMessageModel().getMessageCount(1) != 0) {
                        ValidationMessagePane.this._selectedComp.setBackground(_ERROR_BG);
                    } else if (vComp.getValidationMessageModel().getMessageCount(2) != 0) {
                        ValidationMessagePane.this._selectedComp.setBackground(_WARN_BG);
                    }
                    if (ValidationMessagePane.this._list.getSelectedIndex() == 0) {
                        JViewport viewPort = (JViewport)ValidationMessagePane.this._list.getParent();
                        if (viewPort.getViewPosition().y != 0) {
                            viewPort.setViewPosition(new Point(0, 0));
                        }
                    }
                } else if (ValidationMessagePane.this._selectedComp != null) {
                    this._restoreBackground(ValidationMessagePane.this._selectedComp);
                    ValidationMessagePane.this._selectedComp = null;
                }
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (ValidationMessagePane.this._tree.hasFocus()) {
                TreeNode node;
                TreePath path = ValidationMessagePane.this._tree.getSelectionPath();
                TreeNode treeNode = node = path == null ? null : (TreeNode)path.getLastPathComponent();
                if (node != null) {
                    ValidationComponent vComp = node.getValidationComponent();
                    Component comp = vComp.getComponent();
                    if (comp != ValidationMessagePane.this._selectedComp) {
                        if (ValidationMessagePane.this._selectedComp != null) {
                            this._restoreBackground(ValidationMessagePane.this._selectedComp);
                        }
                        ValidationMessagePane.this._selectedComp = comp;
                        ValidationMessagePane.this._originalBg = ValidationMessagePane.this._selectedComp.getBackground();
                    }
                    if (vComp.getValidationMessageModel().getMessageCount(1) != 0) {
                        ValidationMessagePane.this._selectedComp.setBackground(_ERROR_BG);
                    } else if (vComp.getValidationMessageModel().getMessageCount(2) != 0) {
                        ValidationMessagePane.this._selectedComp.setBackground(_WARN_BG);
                    }
                    if (node.equals(ValidationMessagePane.this._root.getChildAt(0))) {
                        JViewport viewPort = (JViewport)ValidationMessagePane.this._tree.getParent();
                        if (viewPort.getViewPosition().y != 0) {
                            viewPort.setViewPosition(new Point(0, 0));
                        }
                    }
                } else if (ValidationMessagePane.this._selectedComp != null) {
                    this._restoreBackground(ValidationMessagePane.this._selectedComp);
                    ValidationMessagePane.this._selectedComp = null;
                }
            }
        }

        public void propertyChange(PropertyChangeEvent pe) {
            ValidationComponent vComp = (ValidationComponent)pe.getSource();
            if ("validationModel".equals(pe.getPropertyName())) {
                ValidationMessageModel oldM = (ValidationMessageModel)pe.getOldValue();
                ValidationMessagePane.this._removeValidationMessageModel(vComp, oldM);
                ValidationMessageModel newM = (ValidationMessageModel)pe.getNewValue();
                ValidationMessagePane.this._addValidationMessageModel(vComp, newM);
                int diff = newM.getMessageCount() - oldM.getMessageCount();
                ValidationMessagePane.this._updateIndex(vComp, diff);
            }
        }

        public void messageAdded(ValidationMessageModelEvent e) {
            ValidationComponent vComp = (ValidationComponent)e.getSource();
            ValidationMessage message = e.getMessage();
            ValidationMessageModel model = vComp.getValidationMessageModel();
            int index = (Integer)ValidationMessagePane.this._indexMap.get(vComp);
            int errorCount = model.getMessageCount(1);
            int warnCount = model.getMessageCount(2);
            int succCount = model.getMessageCount(3);
            int inProCount = model.getMessageCount(4);
            int pendCount = model.getMessageCount(5);
            if (ValidationMessagePane.this.getMessageMode() == MessageMode.TREE) {
                TreeNode headerNode = new TreeNode(vComp, message, true, message.getMessage());
                index = message.getSeverity() == 1 ? (index += errorCount - 1) : (message.getSeverity() == 2 ? (index += errorCount + warnCount - 1) : (message.getSeverity() == 3 ? (index += errorCount + warnCount + succCount - 1) : (message.getSeverity() == 4 ? (index += errorCount + warnCount + succCount + inProCount - 1) : (message.getSeverity() == 5 ? (index += errorCount + warnCount + succCount + inProCount + pendCount - 1) : (index += model.getMessageCount() - 1)))));
                ValidationMessagePane.this._treeModel.insertNodeInto(headerNode, ValidationMessagePane.this._root, index);
                final TreePath path = new TreePath(ValidationMessagePane.this._treeModel.getPathToRoot(headerNode));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ValidationMessagePane.this._tree != null) {
                            ValidationMessagePane.this._tree.getSelectionModel().setSelectionPath(path);
                        }
                    }
                });
                String[] desc = message.getDescription();
                if (desc != null) {
                    int len = desc.length;
                    for (int j = 0; j < len; ++j) {
                        TreeNode childNode = new TreeNode(vComp, message, false, desc[j]);
                        ValidationMessagePane.this._treeModel.insertNodeInto(childNode, headerNode, j);
                    }
                }
                if (ValidationMessagePane.this._accessibleLabel != null) {
                    ValidationMessagePane.this._accessibleLabel.setText(ValidationMessagePane.this._getAccessibleName(headerNode));
                }
            } else {
                ListItem item = new ListItem(vComp, message);
                if (message.getSeverity() == 1) {
                    ValidationMessagePane.this._listModel.add(index + errorCount - 1, item);
                } else if (message.getSeverity() == 2) {
                    ValidationMessagePane.this._listModel.add(index + errorCount + warnCount - 1, item);
                } else if (message.getSeverity() == 3) {
                    ValidationMessagePane.this._listModel.add(index + errorCount + warnCount + succCount - 1, item);
                } else if (message.getSeverity() == 4) {
                    ValidationMessagePane.this._listModel.add(index + errorCount + warnCount + succCount + inProCount - 1, item);
                } else if (message.getSeverity() == 5) {
                    ValidationMessagePane.this._listModel.add(index + errorCount + warnCount + succCount + inProCount + pendCount - 1, item);
                } else {
                    ValidationMessagePane.this._listModel.add(index + model.getMessageCount() - 1, item);
                }
                if (ValidationMessagePane.this._accessibleLabel != null) {
                    ValidationMessagePane.this._accessibleLabel.setText(ValidationMessagePane.this._getAccessibleName(item));
                }
            }
            ValidationMessagePane.this._updateIndex(vComp, 1);
        }

        public void messageRemoved(ValidationMessageModelEvent e) {
            ValidationComponent vComp = (ValidationComponent)e.getSource();
            ValidationMessageModel model = vComp.getValidationMessageModel();
            ValidationMessage message = e.getMessage();
            if (ValidationMessagePane.this.getMessageMode() == MessageMode.TREE) {
                TreeNode node = new TreeNode(vComp, message, true, message.getMessage());
                node.setParent(ValidationMessagePane.this._root);
                ValidationMessagePane.this._treeModel.removeNodeFromParent(node);
            } else {
                ListItem item = new ListItem(vComp, message);
                ValidationMessagePane.this._listModel.removeElement(item);
            }
            ValidationMessagePane.this._updateIndex(vComp, -1);
        }

        public void intervalAdded(ListDataEvent e) {
            ValidationMessagePane.this._checkPaneIsEmpty();
        }

        public void intervalRemoved(ListDataEvent e) {
            ValidationMessagePane.this._checkPaneIsEmpty();
        }

        public void contentsChanged(ListDataEvent e) {
        }

        private void _restoreBackground(Component comp) {
            comp.setBackground(ValidationMessagePane.this._originalBg);
        }

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
            ValidationMessagePane.this._checkPaneIsEmpty();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            ValidationMessagePane.this._checkPaneIsEmpty();
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    private class TreeMessageCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        public TreeMessageCellRenderer() {
            ValidationMessagePane.this._initRenderer(this);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
            if (!(value instanceof TreeNode)) {
                return new JPanel();
            }
            TreeNode node = (TreeNode)value;
            ValidationMessage message = node.getMessage();
            ValidationMessagePane.this._indentWidth = (Integer)UIManager.get("Tree.leftChildIndent") + (Integer)UIManager.get("Tree.rightChildIndent");
            String label = null;
            if (node.isHeader()) {
                ValidationMessagePane.this._iconLabel.setIcon(ValidationMessagePane.this._getIcon(message.getSeverity()));
                label = ValidationMessagePane.this._getValidationMessageText(node);
            } else {
                ValidationMessagePane.this._indentWidth *= 2;
                ValidationMessagePane.this._iconLabel.setIcon(null);
                label = node.getLabel();
            }
            Color paneBg = UIManager.getColor("ValidationMessagePane.background");
            Color areaBg = null;
            Color areaFg = null;
            if (isSelected) {
                areaBg = UIManager.getColor("Tree.selectionBackground");
                areaFg = UIManager.getColor("Tree.selectionForeground");
            } else {
                areaBg = paneBg == null ? UIManager.getColor("Tree.textBackground") : paneBg;
                areaFg = UIManager.getColor("Tree.textForeground");
            }
            Color bg = paneBg == null ? UIManager.getColor("Tree.textBackground") : paneBg;
            ValidationMessagePane.this._updateRenderer(this, label, tree.isEnabled(), _MSG_TEXT_BORDER, areaBg, areaFg, bg, tree.getFont());
            return this;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        private class Access
        extends JPanel.AccessibleJPanel {
            private Access() {
                super(TreeMessageCellRenderer.this);
            }

            public String getAccessibleName() {
                TreeNode node = (TreeNode)ValidationMessagePane.this._tree.getSelectionPath().getLastPathComponent();
                if (node != null) {
                    return ValidationMessagePane.this._getAccessibleName(node);
                }
                return null;
            }
        }
    }

    private class CellRenderer
    extends JPanel
    implements ListCellRenderer {
        public CellRenderer() {
            ValidationMessagePane.this._initRenderer(this);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListItem item = (ListItem)value;
            ValidationMessage message = item.getMessage();
            ValidationMessagePane.this._iconLabel.setIcon(ValidationMessagePane.this._getIcon(message.getSeverity()));
            String label = ValidationMessagePane.this._getValidationMessageText(item);
            Border border = null;
            if (cellHasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = _MSG_TEXT_BORDER;
            }
            Color paneBg = UIManager.getColor("ValidationMessagePane.background");
            Color areaBg = null;
            Color areaFg = null;
            if (isSelected) {
                areaBg = list.getSelectionBackground();
                areaFg = list.getSelectionForeground();
            } else {
                areaBg = paneBg == null ? list.getBackground() : paneBg;
                areaFg = list.getForeground();
            }
            Color bg = paneBg == null ? list.getBackground() : paneBg;
            ValidationMessagePane.this._updateRenderer(this, label, list.isEnabled(), border, areaBg, areaFg, bg, list.getFont());
            return this;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new Access();
            }
            return this.accessibleContext;
        }

        private class Access
        extends JPanel.AccessibleJPanel {
            private Access() {
                super(CellRenderer.this);
            }

            public String getAccessibleName() {
                ListItem listItem = (ListItem)ValidationMessagePane.this._list.getSelectedValue();
                if (listItem != null) {
                    return ValidationMessagePane.this._getAccessibleName(listItem);
                }
                return null;
            }
        }
    }

    private class ListItem {
        private ValidationComponent _component;
        private ValidationMessage _message;

        public ListItem(ValidationComponent comp, ValidationMessage message) {
            this._component = comp;
            this._message = message;
        }

        public ValidationComponent getValidationComponent() {
            return this._component;
        }

        public ValidationMessage getMessage() {
            return this._message;
        }

        public boolean equals(Object object) {
            if (object instanceof ListItem) {
                ListItem compare = (ListItem)object;
                return this.getValidationComponent().equals(compare.getValidationComponent()) && this.getMessage().equals(compare.getMessage());
            }
            return false;
        }

        public String toString() {
            return ValidationMessagePane.this._getValidationMessageText(this);
        }
    }

    private class TreeNode
    extends DefaultMutableTreeNode {
        private ValidationComponent _component;
        private ValidationMessage _message;
        private String _label;
        private boolean _header;

        public TreeNode(ValidationComponent comp, ValidationMessage message, boolean header, String label) {
            this._component = comp;
            this._message = message;
            this._header = header;
            this._label = label;
        }

        public ValidationComponent getValidationComponent() {
            return this._component;
        }

        public ValidationMessage getMessage() {
            return this._message;
        }

        public String getLabel() {
            return this._label;
        }

        public boolean isHeader() {
            return this._header;
        }

        public boolean equals(Object object) {
            if (object instanceof TreeNode) {
                TreeNode compare = (TreeNode)object;
                return this.getValidationComponent().equals(compare.getValidationComponent()) && this.getMessage().equals(compare.getMessage()) && this.isHeader() == compare.isHeader();
            }
            return false;
        }

        public String toString() {
            return ValidationMessagePane.this._getValidationMessageText(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageMode {
        TREE,
        LIST;

    }
}

