/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.util.Locale;
import oracle.bali.ewt.painter.PaintContext;

public class StringUtils {
    public static final int MNEMONIC_INDEX_NONE = -1;
    private static final char _MNEMONIC_INDICATOR = '&';

    public static int getMnemonicIndex(String string) {
        int index;
        if (string == null) {
            return -1;
        }
        int lengthMinusOne = string.length() - 1;
        int i = 0;
        int count = 0;
        while (i < lengthMinusOne && (index = string.indexOf(38, i)) != -1 && index < lengthMinusOne) {
            if (string.charAt(index + 1) != '&') {
                return index - count;
            }
            i = index + 2;
            ++count;
        }
        return -1;
    }

    public static int getMnemonicKeyCode(String string) {
        int index;
        if (string == null) {
            return 0;
        }
        int lengthMinusOne = string.length() - 1;
        int i = 0;
        while (i < lengthMinusOne && (index = string.indexOf(38, i)) != -1 && index < lengthMinusOne) {
            char ch = string.charAt(index + 1);
            if (ch != '&') {
                return Character.toUpperCase(ch);
            }
            i = index + 2;
        }
        return 0;
    }

    public static String stripMnemonic(String string) {
        if (string == null) {
            return null;
        }
        int length = string.length();
        if (length <= 1) {
            return string;
        }
        StringBuffer buffer = null;
        int i = 0;
        while (i < length) {
            int index = string.indexOf(38, i);
            if (index < 0 || index >= length - 1) {
                if (buffer == null) break;
                buffer.append(string.substring(i));
                break;
            }
            if (buffer == null) {
                if (index == 0 && string.charAt(1) != '&') {
                    string = string.substring(1);
                    --length;
                    continue;
                }
                buffer = new StringBuffer(length - 1);
            }
            buffer.append(string.substring(i, index));
            buffer.append(string.charAt(index + 1));
            i = index + 2;
        }
        if (buffer == null) {
            return string;
        }
        return new String(buffer);
    }

    public static boolean containsRightToLeft(String string) {
        if (string == null) {
            return false;
        }
        int length = string.length();
        int i = 0;
        while (i < length) {
            if (!StringUtils._isRightToLeft(string.charAt(i++))) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayString(String text, PaintContext context) {
        return StringUtils.getDisplayString(text, context.getPaintLocale(), context.getReadingDirection());
    }

    public static String getDisplayString(String text, Locale locale, int direction) {
        return text;
    }

    private static boolean _isArabic(char c) {
        return c >= '\u0600' && c <= '\u06ff';
    }

    private static boolean _isHebrew(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    private static boolean _isRightToLeft(char c) {
        return StringUtils._isArabic(c) || StringUtils._isHebrew(c);
    }

    private StringUtils() {
    }
}

