/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import javax.swing.SwingUtilities;

public final class PaintUtils {
    private static boolean _sJDK15 = false;

    @Deprecated
    public static final void invokeAfterRepaint(Runnable runnable) {
        if (runnable != null) {
            if (_sJDK15) {
                PaintUtils._invokeAfterRepaint(runnable);
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private static void _invokeAfterRepaint(final Runnable runnable) {
        if (PaintUtils._hasPaintEventsPending()) {
            final Toolkit toolkit = Toolkit.getDefaultToolkit();
            AWTEventListener awtEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    int eventId = event.getID();
                    if (!(eventId != 800 && eventId != 801 || PaintUtils._hasPaintEventsPending())) {
                        toolkit.removeAWTEventListener(this);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                runnable.run();
                            }
                        });
                    }
                }
            };
            toolkit.addAWTEventListener(awtEventListener, 8192L);
        } else {
            runnable.run();
        }
    }

    private static boolean _hasPaintEventsPending() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        return eventQueue.peekEvent(800) != null || eventQueue.peekEvent(801) != null;
    }

    static {
        String version = System.getProperty("java.version", "");
        _sJDK15 = version.startsWith("1.5");
    }
}

