/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.GridEditListener;
import oracle.bali.ewt.grid.GridEvent;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableHeaderAdapter;

final class TableGridAdapter
implements GridEditListener,
PropertyChangeListener,
VetoableChangeListener {
    private SpreadTable _table;
    private boolean _originatingSelectionChange;

    public TableGridAdapter(SpreadTable table) {
        this._table = table;
    }

    public void dispose() {
        this._table = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("focusCell".equals(name)) {
            Cell focusCell = this._table.getGrid().getFocusCell();
            if (focusCell != null) {
                if (this._table.getColumnHeader() != null) {
                    this._table.getColumnHeader().setFocusItem(focusCell.column);
                }
                if (this._table.getRowHeader() != null) {
                    this._table.getRowHeader().setFocusItem(focusCell.row);
                }
            }
        } else if ("selection".equals(name)) {
            Header rowHeader = this._table.getRowHeader();
            Header colHeader = this._table.getColumnHeader();
            TwoDSelection gridSel = (TwoDSelection)evt.getNewValue();
            OneDSelection rowsel = gridSel.getRowSelection();
            OneDSelection colsel = gridSel.getColumnSelection();
            try {
                this._originatingSelectionChange = true;
                TableHeaderAdapter rha = this._table.getRowHeaderAdapter();
                TableHeaderAdapter cha = this._table.getColumnHeaderAdapter();
                if (rowHeader != null && !rha.originatingSelectionChange()) {
                    HeaderSelectionManager rsm = rowHeader.getHeaderSelectionManager();
                    rsm.setSelection(rowsel, -1);
                }
                if (colHeader != null && !cha.originatingSelectionChange()) {
                    HeaderSelectionManager csm = colHeader.getHeaderSelectionManager();
                    csm.setSelection(colsel, -1);
                }
            }
            catch (PropertyVetoException pve) {
            }
            finally {
                this._originatingSelectionChange = false;
            }
        }
        this._table.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this._table.fireVetoableChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public void cellEditing(GridEvent e) {
        if (this._table.fireCancelableCellEvent(2005, e.getColumn(), e.getRow())) {
            ((Cancelable)((Object)e)).cancel();
        }
    }

    public void cellEdited(GridEvent e) {
        this._table.fireCellEvent(2006, e.getColumn(), e.getRow());
    }

    boolean originatingSelectionChange() {
        return this._originatingSelectionChange;
    }
}

