/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import oracle.bali.ewt.spinBox.NumberRange;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.share.collection.Range;
import oracle.bali.share.util.IntegerUtils;

public class WrappingNumericSpinBoxModel
extends NumericSpinBoxModel {
    private Number _present;
    private boolean _iteratedOnce = false;

    public WrappingNumericSpinBoxModel(Range range) {
        super(range);
        this._present = range instanceof NumberRange ? (Number)((NumberRange)range).getLower() : (Number)range.getLowerLimit();
    }

    public int getValue() {
        return this._present.intValue();
    }

    public void setValue(int value) {
        Range range = this.getRange();
        if (!range.inRange(value)) {
            throw new IllegalArgumentException();
        }
        this._present = value;
        this._iteratedOnce = false;
    }

    public void setNumber(Number value) {
        Range range = this.getRange();
        if (range instanceof NumberRange ? !((NumberRange)range).inRange(value) : !range.inRange(value.intValue())) {
            throw new IllegalArgumentException();
        }
        this._present = value;
        this._iteratedOnce = false;
    }

    public Number getNumber() {
        return this._present;
    }

    public Object skip(int count) {
        double totalRange;
        Range range = this.getRange();
        Number step = this.__getDecimalStep();
        boolean decimal = this.isDecimal();
        if (count == 0) {
            if (decimal) {
                return this._present;
            }
            return IntegerUtils.getInteger((int)this._present.intValue());
        }
        boolean forward = this.isIteratingForward();
        if (!this._iteratedOnce) {
            this._iteratedOnce = true;
            --count;
        }
        this._present = this.__isIteratingDecimal() ? (forward ? Double.valueOf(this._present.doubleValue() + (double)count * step.doubleValue()) : Double.valueOf(this._present.doubleValue() - (double)count * step.doubleValue())) : (forward ? Double.valueOf(this._present.doubleValue() + (double)count) : Double.valueOf(this._present.doubleValue() - (double)count));
        double upper = 0.0;
        double lower = 0.0;
        double present = this._present.doubleValue();
        if (range instanceof NumberRange) {
            upper = ((NumberRange)range).getUpper().doubleValue();
            lower = ((NumberRange)range).getLower().doubleValue();
        } else {
            upper = range.getUpperLimit();
            lower = range.getLowerLimit();
        }
        if ((present < lower || present > upper) && (present = (present - lower) % (totalRange = upper - lower) + lower) < lower) {
            present += totalRange;
        }
        this._present = present;
        if (range instanceof NumberRange) {
            // empty if block
        }
        if (decimal) {
            return this._present;
        }
        return IntegerUtils.getInteger((int)this._present.intValue());
    }

    public int remainingElements(int desired) {
        return desired;
    }
}

