/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import java.awt.AWTEvent;
import java.awt.Component;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.elaf.EWTSpinButtonUI;
import oracle.bali.ewt.spinBox.SpinAccelerator;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.ewt.spinBox.SpinButtonListener;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;

public class SpinButton
extends LWComponent
implements Accessible {
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _INCREMENT_KEY = "INCREMENT";
    private static final String _DECREMENT_KEY = "DECREMENT";
    private boolean _incrementEnabled = true;
    private boolean _decrementEnabled = true;
    private boolean _standAlone;
    private SpinAccelerator _accelerator;
    private ListenerManager _listeners;

    public SpinButton() {
        this(true);
    }

    public SpinButton(boolean standAlone) {
        this._standAlone = standAlone;
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((EWTSpinButtonUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "EWTSpinButtonUI";
    }

    public void setIncrementEnabled(boolean enabled) {
        if (enabled != this.isIncrementEnabled()) {
            this._incrementEnabled = enabled;
            this.firePropertyChange("incrementEnabled", !enabled, enabled);
        }
    }

    public boolean isIncrementEnabled() {
        return this._incrementEnabled;
    }

    public void setDecrementEnabled(boolean enabled) {
        if (enabled != this.isDecrementEnabled()) {
            this._decrementEnabled = enabled;
            this.firePropertyChange("decrementEnabled", !enabled, enabled);
        }
    }

    public boolean isDecrementEnabled() {
        return this._decrementEnabled;
    }

    public void setIncrementArmed(boolean armed) {
        this.firePropertyChange("incrementArmed", !armed, armed);
    }

    public void setDecrementArmed(boolean armed) {
        this.firePropertyChange("decrementArmed", !armed, armed);
    }

    public SpinAccelerator getAccelerator() {
        return this._accelerator;
    }

    public void setAccelerator(SpinAccelerator accelerator) {
        this._accelerator = accelerator;
    }

    public void addSpinButtonListener(SpinButtonListener listener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)listener);
    }

    public void removeSpinButtonListener(SpinButtonListener listener) {
        this._listeners.removeListener((EventListener)listener);
    }

    public void fireSpinButtonEvent(int type) {
        if (this._listeners != null) {
            this.processEvent(new SpinButtonEvent(this, 2000, type));
        }
    }

    public boolean isStandalone() {
        return this._standAlone;
    }

    protected void processEventImpl(AWTEvent event) {
        if (event instanceof SpinButtonEvent) {
            this.processSpinButtonEvent((SpinButtonEvent)event);
        } else {
            super.processEventImpl(event);
        }
    }

    protected void processSpinButtonEvent(SpinButtonEvent event) {
        Enumeration enumer;
        ListenerManager listeners = this._listeners;
        if (listeners != null && (enumer = listeners.getListeners()) != null) {
            while (enumer.hasMoreElements()) {
                SpinButtonListener listener = (SpinButtonListener)enumer.nextElement();
                switch (event.getID()) {
                    case 2000: {
                        listener.spinButtonSpinning(event);
                        break;
                    }
                }
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSpinButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSpinButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        protected AccessibleSpinButton() {
            super(SpinButton.this);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 2;
        }

        public String getAccessibleActionDescription(int i) {
            Locale l = LocaleUtils.getDefaultableLocale((Component)SpinButton.this);
            ResourceBundle b = ResourceBundle.getBundle(SpinButton._RESOURCE_BUNDLE, l);
            switch (i) {
                case 0: {
                    return b.getString(SpinButton._INCREMENT_KEY);
                }
                case 1: {
                    return b.getString(SpinButton._DECREMENT_KEY);
                }
            }
            return null;
        }

        public boolean doAccessibleAction(int i) {
            int type;
            switch (i) {
                case 0: {
                    if (!SpinButton.this.isIncrementEnabled()) {
                        return false;
                    }
                    type = 1;
                    break;
                }
                case 1: {
                    if (!SpinButton.this.isDecrementEnabled()) {
                        return false;
                    }
                    type = 2;
                    break;
                }
                default: {
                    return false;
                }
            }
            SpinButton.this.fireSpinButtonEvent(type);
            return true;
        }
    }
}

