/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.print;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.imageCanvas.ImageCanvas;
import oracle.bali.ewt.print.DebugPrintGraphics;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.util.IntegerUtils;

public class DebugPrintJob
extends PrintJob {
    private static final double _PAGE_WIDTH_INCHES = 8.5;
    private static final double _PAGE_HEIGHT_INCHES = 11.0;
    private static final double _END_HARDWARE_MARGIN_INCHES = 0.125;
    private static final double _EDGE_HARDWARE_MARGIN_INCHES = 0.125;
    private Frame _parentFrame;
    private String _jobName;
    private Vector _pageVector = new Vector();
    private boolean _isEnded;

    public DebugPrintJob(Frame parentFrame, String printJobName) {
        this._parentFrame = parentFrame;
        this._jobName = printJobName;
    }

    public Graphics getGraphics() {
        if (this._isEnded) {
            throw new IllegalStateException();
        }
        Dimension pageSize = this.getPageDimension();
        DebugPrintGraphics newPageGraphics = new DebugPrintGraphics(pageSize.width, pageSize.height, this);
        this._pageVector.addElement(newPageGraphics);
        int pageResolution = this.getPageResolution();
        int endHardareMargin = (int)((double)pageResolution * 0.125);
        int edgeHardareMargin = (int)((double)pageResolution * 0.125);
        ((Graphics)newPageGraphics).clipRect(endHardareMargin, edgeHardareMargin, pageSize.width - 2 * endHardareMargin, pageSize.height - 2 * edgeHardareMargin);
        return newPageGraphics;
    }

    public Dimension getPageDimension() {
        return new Dimension((int)(8.5 * (double)this.getPageResolution()), (int)(11.0 * (double)this.getPageResolution()));
    }

    public int getPageResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public boolean lastPageFirst() {
        return false;
    }

    public void end() {
        if (!this._isEnded) {
            this._isEnded = true;
            JTabbedPane printPanel = new JTabbedPane();
            Vector pageVector = this._pageVector;
            int numPages = pageVector.size();
            for (int i = 0; i < numPages; ++i) {
                DebugPrintGraphics printGraphics = (DebugPrintGraphics)pageVector.elementAt(i);
                ImageCanvas imagePage = new ImageCanvas(printGraphics.getGraphicsImage());
                printPanel.addTab(IntegerUtils.getString((int)(i + 1)), new EWTScrollPane(imagePage));
            }
            JDialog outputDialog = new JDialog(this._parentFrame, this._jobName);
            outputDialog.getContentPane().add("Center", printPanel);
            outputDialog.pack();
            outputDialog.setDefaultCloseOperation(2);
            WindowUtils.centerWindow(outputDialog, this._parentFrame);
            outputDialog.setVisible(true);
        }
    }
}

