/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.olaf.OracleTreeCellRenderer;

public class OracleTreeUI
extends BasicTreeUI {
    public static ComponentUI createUI(JComponent c) {
        return new OracleTreeUI();
    }

    public TreeCellRenderer createDefaultCellRenderer() {
        return new OracleTreeCellRenderer();
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (key.equals("Tree.expandedIcon")) {
            return new EraseBG(defaults.getIcon("Tree.expandedImage"), new Insets(2, 0, 0, 1));
        }
        if (key.equals("Tree.collapsedIcon")) {
            return new EraseBG(defaults.getIcon("Tree.collapsedImage"), new Insets(1, 0, 1, 0));
        }
        return null;
    }

    protected void installDefaults() {
        FontMetrics fm;
        super.installDefaults();
        Font font = this.tree.getFont();
        if (font != null && (fm = this.tree.getFontMetrics(font)) != null) {
            this.tree.setRowHeight(fm.getHeight() + 2);
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    JTree __getTree() {
        return this.tree;
    }

    void __checkForClickInExpandControl(TreePath path, int mouseX, int mouseY) {
        super.checkForClickInExpandControl(path, mouseX, mouseY);
    }

    boolean __startEditing(TreePath path, MouseEvent event) {
        return super.startEditing(path, event);
    }

    void __selectPathForEvent(TreePath path, MouseEvent event) {
        super.selectPathForEvent(path, event);
    }

    private static class EraseBG
    implements Icon {
        private Icon _icon;
        private Insets _insets;

        public EraseBG(Icon icon, Insets insets) {
            this._icon = icon;
            insets.right += insets.left;
            insets.bottom += insets.top;
            this._insets = insets;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color savedColor = g.getColor();
            g.setColor(c.getBackground());
            Insets i = this._insets;
            g.fillRect(x + i.left, y + i.top, this.getIconWidth() - i.right, this.getIconHeight() - i.bottom);
            g.setColor(savedColor);
            this._icon.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this._icon.getIconWidth();
        }

        public int getIconHeight() {
            return this._icon.getIconHeight();
        }
    }

    private final class MouseHandler
    extends MouseAdapter {
        private TreePath lastSelectedPath = null;

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent event) {
            JTree tree = OracleTreeUI.this.__getTree();
            if (tree != null && tree.isEnabled()) {
                tree.requestFocus();
                TreePath path = OracleTreeUI.this.getClosestPathForLocation(tree, event.getX(), event.getY());
                if (path != null) {
                    int x;
                    Rectangle bounds = OracleTreeUI.this.getPathBounds(tree, path);
                    if (event.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        OracleTreeUI.this.__checkForClickInExpandControl(path, event.getX(), event.getY());
                    }
                    if ((x = event.getX()) > bounds.x && x <= bounds.x + bounds.width && !OracleTreeUI.this.__startEditing(path, event)) {
                        if (tree.isPathSelected(path)) {
                            this.lastSelectedPath = path;
                        } else {
                            this.lastSelectedPath = null;
                            OracleTreeUI.this.__selectPathForEvent(path, event);
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent event) {
            TreePath path;
            JTree tree = OracleTreeUI.this.__getTree();
            if (tree != null && tree.isEnabled() && (path = OracleTreeUI.this.getClosestPathForLocation(tree, event.getX(), event.getY())) != null) {
                Rectangle bounds = OracleTreeUI.this.getPathBounds(tree, path);
                if (event.getY() > bounds.y + bounds.height) {
                    return;
                }
                int x = event.getX();
                if (x > bounds.x && x <= bounds.x + bounds.width && path.equals(this.lastSelectedPath)) {
                    OracleTreeUI.this.__selectPathForEvent(path, event);
                }
            }
            this.lastSelectedPath = null;
        }
    }
}

