/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import java.awt.Point;
import java.awt.Rectangle;
import oracle.bali.ewt.grid.Grid;

public abstract class AbstractBigCell {
    public static AbstractBigCell getBigCell(Grid grid, int column, int row) {
        Object data = grid.getModel().getData(column, row);
        if (data instanceof AbstractBigCell) {
            return (AbstractBigCell)data;
        }
        return null;
    }

    public static Rectangle getCellBounds(Grid grid, int column, int row) {
        AbstractBigCell bigCell = AbstractBigCell.getBigCell(grid, column, row);
        Rectangle rect = new Rectangle();
        if (bigCell == null) {
            rect.x = 0;
            rect.y = 0;
            rect.width = grid.getColumnWidth(column);
            rect.height = grid.getRowHeight(row);
            return rect;
        }
        int realX = 0;
        int realY = 0;
        int realColumn = bigCell.getColumn();
        int realRow = bigCell.getRow();
        realX = -(grid.getColumnPosition(column) - grid.getColumnPosition(realColumn));
        realY = -(grid.getRowPosition(row) - grid.getRowPosition(realRow));
        int realWidth = 0;
        int realHeight = 0;
        int columnCount = bigCell.getColumnCount();
        for (int j = 0; j < columnCount; ++j) {
            realWidth += grid.getColumnWidth(j + realColumn);
        }
        int rowCount = bigCell.getRowCount();
        for (int k = 0; k < rowCount; ++k) {
            realHeight += grid.getRowHeight(k + realRow);
        }
        rect.x = realX;
        rect.y = realY;
        rect.width = realWidth;
        rect.height = realHeight;
        return rect;
    }

    public static Point convertPoint(Grid grid, int column, int row, int x, int y) {
        AbstractBigCell cell = AbstractBigCell.getBigCell(grid, column, row);
        return AbstractBigCell.convertPoint(grid, cell, column, row, x, y);
    }

    public static Point convertPoint(Grid grid, AbstractBigCell cell, int column, int row, int x, int y) {
        boolean l2r;
        if (cell == null) {
            return new Point(x, y);
        }
        boolean bl = l2r = grid.getActualReadingDirection() == 1;
        if (!l2r) {
            x = grid.getColumnWidth(cell.getColumn()) - x;
        }
        for (int cellCol = cell.getColumn(); cellCol < column; ++cellCol) {
            x += grid.getColumnWidth(cellCol);
        }
        for (int cellRow = cell.getRow(); cellRow < row; ++cellRow) {
            y += grid.getRowHeight(cellRow);
        }
        return new Point(x, y);
    }

    public abstract Object getData();

    public abstract void setData(Object var1);

    public abstract int getColumnCount();

    public abstract int getColumn();

    public abstract int getRowCount();

    public abstract int getRow();
}

