/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

class HitTestMask
implements ImageConsumer {
    private ImageProducer _producer;
    private transient boolean _doneGrabbing;
    private transient int _width;
    private transient int _height;
    private transient byte[] _transparentMask;

    public HitTestMask(Image image) {
        this(image.getSource());
    }

    public HitTestMask(ImageProducer producer) {
        this._producer = producer;
    }

    public synchronized boolean contains(int x, int y) {
        if (x >= 0 && y >= 0) {
            if (!this._doneGrabbing) {
                this._producer.startProduction(this);
                while (!this._doneGrabbing) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return true;
                    }
                }
            }
            if (this._transparentMask != null) {
                if (x < this._width && y < this._height) {
                    byte checkByte = this._transparentMask[y * this._getWidthBytes() + x / 8];
                    return (checkByte & 128 >> (x & 7)) != 0;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public void setDimensions(int width, int height) {
        this._width = width;
        this._height = height;
        this._transparentMask = new byte[this._getWidthBytes() * this._height];
    }

    public void setProperties(Hashtable props) {
    }

    public void setColorModel(ColorModel model) {
    }

    public void setHints(int hintflags) {
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, byte[] pixels, int offset, int scanSize) {
        int endY = y + height;
        int endX = x + width;
        int middleStartX = x + 7 & 0xFFFFFFF8;
        int middleEndX = endX & 0xFFFFFFF8;
        int maskByteWidth = this._getWidthBytes();
        int currMaskOffset = maskByteWidth * y + x / 8;
        while (y < endY) {
            int pixel;
            int hitMask;
            int currX = x;
            int lineMaskOffset = 0;
            int linePixelOffset = offset;
            if (x != middleStartX) {
                if (middleStartX > endX) {
                    middleStartX = endX;
                }
                hitMask = 0;
                while (currX < middleStartX) {
                    hitMask = (byte)(hitMask << 1);
                    if (model.getAlpha(pixels[linePixelOffset]) != 0) {
                        hitMask = (byte)(hitMask | 1);
                    }
                    ++linePixelOffset;
                    ++currX;
                }
                int n = currMaskOffset + lineMaskOffset;
                this._transparentMask[n] = (byte)(this._transparentMask[n] | hitMask);
                ++lineMaskOffset;
            }
            while (currX < middleEndX) {
                hitMask = 0;
                for (int i = 0; i < 8; ++i) {
                    hitMask = (byte)(hitMask << 1);
                    pixel = pixels[linePixelOffset];
                    if (pixel < 0) {
                        pixel += 256;
                    }
                    if (model.getAlpha(pixel) != 0) {
                        hitMask = (byte)(hitMask | 1);
                    }
                    ++linePixelOffset;
                }
                currX += 8;
                this._transparentMask[currMaskOffset + lineMaskOffset] = hitMask;
                ++lineMaskOffset;
            }
            if (currX < endX) {
                int endShift = 8 - endX + currX;
                int hitMask2 = 0;
                while (currX < endX) {
                    hitMask2 = (byte)(hitMask2 << 1);
                    pixel = pixels[linePixelOffset];
                    if (pixel < 0) {
                        pixel += 256;
                    }
                    if (model.getAlpha(pixel) != 0) {
                        hitMask2 = (byte)(hitMask2 | 1);
                    }
                    ++linePixelOffset;
                    ++currX;
                }
                hitMask2 = (byte)(hitMask2 << endShift);
                int n = currMaskOffset + lineMaskOffset;
                this._transparentMask[n] = (byte)(this._transparentMask[n] | hitMask2);
            }
            currMaskOffset += maskByteWidth;
            offset += scanSize;
            ++y;
        }
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int offset, int scanSize) {
        int endY = y + height;
        int endX = x + width;
        int middleStartX = x + 7 & 0xFFFFFFF8;
        int middleEndX = endX & 0xFFFFFFF8;
        int maskByteWidth = this._getWidthBytes();
        int currMaskOffset = maskByteWidth * y + x / 8;
        while (y < endY) {
            int hitMask;
            int currX = x;
            int lineMaskOffset = 0;
            int linePixelOffset = offset;
            if (x != middleStartX) {
                if (middleStartX > endX) {
                    middleStartX = endX;
                }
                hitMask = 0;
                while (currX < middleStartX) {
                    hitMask = (byte)(hitMask << 1);
                    if (model.getAlpha(pixels[linePixelOffset]) != 0) {
                        hitMask = (byte)(hitMask | 1);
                    }
                    ++linePixelOffset;
                    ++currX;
                }
                int n = currMaskOffset + lineMaskOffset;
                this._transparentMask[n] = (byte)(this._transparentMask[n] | hitMask);
                ++lineMaskOffset;
            }
            while (currX < middleEndX) {
                hitMask = 0;
                for (int i = 0; i < 8; ++i) {
                    hitMask = (byte)(hitMask << 1);
                    if (model.getAlpha(pixels[linePixelOffset]) != 0) {
                        hitMask = (byte)(hitMask | 1);
                    }
                    ++linePixelOffset;
                }
                currX += 8;
                this._transparentMask[currMaskOffset + lineMaskOffset] = hitMask;
                ++lineMaskOffset;
            }
            if (currX < endX) {
                int endShift = 8 - endX + currX;
                int hitMask2 = 0;
                while (currX < endX) {
                    hitMask2 = (byte)(hitMask2 << 1);
                    if (model.getAlpha(pixels[linePixelOffset]) != 0) {
                        hitMask2 = (byte)(hitMask2 | 1);
                    }
                    ++linePixelOffset;
                    ++currX;
                }
                hitMask2 = (byte)(hitMask2 << endShift);
                int n = currMaskOffset + lineMaskOffset;
                this._transparentMask[n] = (byte)(this._transparentMask[n] | hitMask2);
            }
            currMaskOffset += maskByteWidth;
            offset += scanSize;
            ++y;
        }
    }

    public synchronized void imageComplete(int status) {
        if (status != 3) {
            this._transparentMask = null;
        }
        this._doneGrabbing = true;
        this._producer.removeConsumer(this);
        this.notifyAll();
    }

    private int _getWidthBytes() {
        return (this._width + 7) / 8;
    }
}

