/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class GraphicUtils {
    private static final String SWING_AATEXT_PROPERTY = "swing.aatext";
    private static final boolean useAAText;
    private static final boolean isAtLeastJava16;
    private static Map _sDesktopHints;
    private static PropertyChangeListener _sDesktopHintsListener;
    private static final String AWT_FONT_DESKTOPHINTS = "awt.font.desktophints";

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, int thickness) {
        int height;
        int y;
        int width;
        int x;
        if (x1 != x2 && y1 != y2) {
            return;
        }
        if (thickness == 0 || thickness == 1) {
            g.drawLine(x1, y1, x2, y2);
            return;
        }
        if (x1 == x2) {
            x = x1 - thickness / 2;
            width = thickness;
            if (y1 < y2) {
                y = y1;
                height = y2 - y1 + 1;
            } else {
                y = y2;
                height = y1 - y2 + 1;
            }
        } else {
            y = y1 - thickness / 2;
            height = thickness;
            if (x1 < x2) {
                x = x1;
                width = x2 - x1 + 1;
            } else {
                x = x2;
                width = x1 - x2 + 1;
            }
        }
        g.fillRect(x, y, width, height);
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height, int thickness) {
        int y2;
        if (thickness == 0 || thickness == 1) {
            g.drawRect(x, y, width, height);
            return;
        }
        int thickness2 = thickness / 2;
        int x1 = x - thickness2;
        int x2 = x1 + width + thickness - 1;
        int y1 = y2 = y;
        GraphicUtils.drawLine(g, x1, y1, x2, y2, thickness);
        y1 = y2 = y + height;
        GraphicUtils.drawLine(g, x1, y1, x2, y2, thickness);
        y1 = y + thickness2;
        y2 = y + height - thickness2 - 1;
        x1 = x2 = x;
        GraphicUtils.drawLine(g, x1, y1, x2, y2, thickness);
        x1 = x2 = x + width;
        GraphicUtils.drawLine(g, x1, y1, x2, y2, thickness);
    }

    public static void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            if (y1 > y2) {
                int swap = y2;
                y2 = y1;
                y1 = swap;
            }
            if ((x1 & 1 ^ y1 & 1) != 0) {
                ++y1;
            }
            while (y1 <= y2) {
                g.drawLine(x1, y1, x1, y1);
                y1 += 2;
            }
        } else {
            if (y1 != y2) {
                throw new IllegalArgumentException("Only horizontal and vertical lines");
            }
            if (x1 > x2) {
                int swap = x2;
                x2 = x1;
                x1 = swap;
            }
            if ((x1 & 1 ^ y1 & 1) != 0) {
                ++x1;
            }
            while (x1 <= x2) {
                g.drawLine(x1, y1, x1, y1);
                x1 += 2;
            }
        }
    }

    public static boolean useTextAntialiasing() {
        return useAAText;
    }

    private static boolean drawTextAntialiased(Graphics graphics) {
        return GraphicUtils.useTextAntialiasing() && graphics != null && graphics instanceof Graphics2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawChars(Graphics graphics, char[] data, int offset, int length, int x, int y) {
        if (length <= 0) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2d = (Graphics2D)graphics;
            Object oldAAValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawChars(data, offset, length, x, y);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
            return;
        }
        if (!isAtLeastJava16 || !(graphics instanceof Graphics2D)) {
            graphics.drawChars(data, offset, length, x, y);
            return;
        }
        HashMap<Object, Object> oldHints = new HashMap<Object, Object>(((Graphics2D)graphics).getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics);
            graphics.drawChars(data, offset, length, x, y);
        }
        finally {
            ((Graphics2D)graphics).setRenderingHints(oldHints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawString(Graphics graphics, AttributedCharacterIterator iterator, int x, int y) {
        if (iterator == null) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2d = (Graphics2D)graphics;
            FontRenderContext frContext = new FontRenderContext(null, true, false);
            TextLayout textLayout = new TextLayout(iterator, frContext);
            textLayout.draw(graphics2d, x, y);
            return;
        }
        if (!isAtLeastJava16 || !(graphics instanceof Graphics2D)) {
            graphics.drawString(iterator, x, y);
            return;
        }
        HashMap<Object, Object> oldHints = new HashMap<Object, Object>(((Graphics2D)graphics).getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics);
            graphics.drawString(iterator, x, y);
        }
        finally {
            ((Graphics2D)graphics).setRenderingHints(oldHints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawString(Graphics graphics, String text, int x, int y) {
        if (text == null || text.length() <= 0) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2d = (Graphics2D)graphics;
            Object oldAAValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawString(text, x, y);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
            return;
        }
        if (!isAtLeastJava16 || !(graphics instanceof Graphics2D)) {
            graphics.drawString(text, x, y);
            return;
        }
        HashMap<Object, Object> oldHints = new HashMap<Object, Object>(((Graphics2D)graphics).getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics);
            graphics.drawString(text, x, y);
        }
        finally {
            ((Graphics2D)graphics).setRenderingHints(oldHints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawString(Graphics2D graphics2d, String text, float x, float y) {
        if (text == null || text.length() <= 0) {
            return;
        }
        if (GraphicUtils.useTextAntialiasing()) {
            Object oldAAValue = graphics2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2d.drawString(text, x, y);
            graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
            return;
        }
        if (!isAtLeastJava16) {
            graphics2d.drawString(text, x, y);
            return;
        }
        HashMap<Object, Object> oldHints = new HashMap<Object, Object>(graphics2d.getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics2d);
            graphics2d.drawString(text, x, y);
        }
        finally {
            graphics2d.setRenderingHints(oldHints);
        }
    }

    public static void addDesktopRenderingHints(Graphics graphics) {
        if (!isAtLeastJava16) {
            return;
        }
        if (graphics == null) {
            throw new IllegalArgumentException("graphics parameter is null");
        }
        if (_sDesktopHints == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            _sDesktopHints = (Map)tk.getDesktopProperty(AWT_FONT_DESKTOPHINTS);
            if (_sDesktopHintsListener == null) {
                _sDesktopHintsListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        _sDesktopHints = null;
                    }
                };
                tk.addPropertyChangeListener(AWT_FONT_DESKTOPHINTS, _sDesktopHintsListener);
            }
        }
        if (_sDesktopHints != null) {
            ((Graphics2D)graphics).addRenderingHints(_sDesktopHints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withDesktopRenderingHints(Graphics graphics, Runnable task) {
        if (graphics == null) {
            throw new IllegalArgumentException("graphics parameter is null");
        }
        if (task == null) {
            throw new IllegalArgumentException("task parameter is null");
        }
        if (!isAtLeastJava16) {
            task.run();
            return;
        }
        HashMap<Object, Object> oldHints = new HashMap<Object, Object>(((Graphics2D)graphics).getRenderingHints());
        try {
            GraphicUtils.addDesktopRenderingHints(graphics);
            task.run();
        }
        finally {
            ((Graphics2D)graphics).setRenderingHints(oldHints);
        }
    }

    private GraphicUtils() {
    }

    static {
        String version = null;
        try {
            version = System.getProperty("java.version", "1.0");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            version = "1.0";
        }
        boolean bl = isAtLeastJava16 = !version.startsWith("1.0") && !version.startsWith("1.1") && !version.startsWith("1.2") && !version.startsWith("1.3") && !version.startsWith("1.5");
        if (version.startsWith("1.5")) {
            String property = null;
            try {
                property = System.getProperty(SWING_AATEXT_PROPERTY, "false");
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                property = "false";
            }
            useAAText = Boolean.valueOf(property);
        } else {
            useAAText = false;
        }
    }
}

