/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;

class CMYComponent
extends BaseColorEditor {
    private static final String _KEY_CYAN = "COLORCHOOSER.CYAN_LABEL";
    private static final String _KEY_MAGENTA = "COLORCHOOSER.MAGENTA_LABEL";
    private static final String _KEY_YELLOW = "COLORCHOOSER.YELLOW_LABEL";
    private static final String _KEY_CYAN_DESC = "COLORCHOOSER.CYAN_DESCRIPTION";
    private static final String _KEY_MAGENTA_DESC = "COLORCHOOSER.MAGENTA_DESCRIPTION";
    private static final String _KEY_YELLOW_DESC = "COLORCHOOSER.YELLOW_DESCRIPTION";
    private static final String _CYAN_NAME = "Cyan_Box";
    private static final String _MAGENTA_NAME = "Magenta_Box";
    private static final String _YELLOW_NAME = "Yellow_Box";
    private boolean _ignoreEvents;
    private JLabel _cyanLabel;
    private JLabel _magentaLabel;
    private JLabel _yellowLabel;
    private NumericSpinBox _cyan;
    private NumericSpinBox _magenta;
    private NumericSpinBox _yellow;

    public CMYComponent() {
        Insets inset;
        Listener listener = new Listener();
        this._cyan = new NumericSpinBox(0, 100);
        this._cyan.addChangeListener(listener);
        this._cyan.setName(_CYAN_NAME);
        this._magenta = new NumericSpinBox(0, 100);
        this._magenta.addChangeListener(listener);
        this._magenta.setName(_MAGENTA_NAME);
        this._yellow = new NumericSpinBox(0, 100);
        this._yellow.addChangeListener(listener);
        this._yellow.setName(_YELLOW_NAME);
        this._cyanLabel = new JLabel(" ");
        this._cyanLabel.setLabelFor(this._cyan);
        this._magentaLabel = new JLabel(" ");
        this._magentaLabel.setLabelFor(this._magenta);
        this._yellowLabel = new JLabel(" ");
        this._yellowLabel.setLabelFor(this._yellow);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = inset = new Insets(0, 0, 3, 12);
        this.setLayout(layout);
        gbc.gridwidth = -1;
        layout.setConstraints(this._cyanLabel, gbc);
        this.add(this._cyanLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._cyan, gbc);
        this.add(this._cyan);
        gbc.gridwidth = -1;
        inset.right = 12;
        layout.setConstraints(this._magentaLabel, gbc);
        this.add(this._magentaLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._magenta, gbc);
        this.add(this._magenta);
        gbc.gridwidth = -1;
        inset.bottom = 0;
        inset.right = 12;
        layout.setConstraints(this._yellowLabel, gbc);
        this.add(this._yellowLabel);
        gbc.gridwidth = 0;
        inset.right = 0;
        layout.setConstraints(this._yellow, gbc);
        this.add(this._yellow);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._cyanLabel.setEnabled(enabled);
        this._magentaLabel.setEnabled(enabled);
        this._yellowLabel.setEnabled(enabled);
        this._cyan.setEnabled(enabled);
        this._magenta.setEnabled(enabled);
        this._yellow.setEnabled(enabled);
    }

    protected void updateLabels(Locale newLocale) {
        String translatedText = CMYComponent.__getTranslatedString(newLocale, _KEY_CYAN);
        this._cyanLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._cyanLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = CMYComponent.__getTranslatedString(newLocale, _KEY_MAGENTA);
        this._magentaLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._magentaLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = CMYComponent.__getTranslatedString(newLocale, _KEY_YELLOW);
        this._yellowLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._yellowLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
    }

    protected void updateAccessibleNames() {
        String text = this.__getTranslatedString(_KEY_CYAN_DESC);
        this._cyan.getAccessibleContext().setAccessibleName(text);
        text = this.__getTranslatedString(_KEY_YELLOW_DESC);
        this._yellow.getAccessibleContext().setAccessibleName(text);
        text = this.__getTranslatedString(_KEY_MAGENTA_DESC);
        this._magenta.getAccessibleContext().setAccessibleName(text);
    }

    protected void colorChanged(Color newColor) {
        this._ignoreEvents = true;
        int[] cmy = ColorUtils.colorToCMY(newColor);
        this._cyan.setIntValue(cmy[0]);
        this._magenta.setIntValue(cmy[1]);
        this._yellow.setIntValue(cmy[2]);
        this._ignoreEvents = false;
    }

    private void _updateColor() {
        int c = this._cyan.getIntValue();
        int m = this._magenta.getIntValue();
        int y = this._yellow.getIntValue();
        this.storeColor(ColorUtils.cmyToColor(c, m, y));
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!CMYComponent.this._ignoreEvents) {
                CMYComponent.this._updateColor();
            }
        }
    }
}

