/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;

class ArrowKeyHandler
implements ActionListener {
    private JComponent _component;
    private boolean _forward;

    public static void registerActions(JComponent component) {
        ArrowKeyHandler forward = new ArrowKeyHandler(component, true);
        component.registerKeyboardAction(forward, KeyStroke.getKeyStroke(39, 0), 1);
        component.registerKeyboardAction(forward, KeyStroke.getKeyStroke(40, 0), 1);
        ArrowKeyHandler back = new ArrowKeyHandler(component, false);
        component.registerKeyboardAction(back, KeyStroke.getKeyStroke(37, 0), 1);
        component.registerKeyboardAction(back, KeyStroke.getKeyStroke(38, 0), 1);
    }

    ArrowKeyHandler(JComponent component, boolean forward) {
        this._component = component;
        this._forward = forward;
    }

    public void actionPerformed(ActionEvent e) {
        Object temp;
        int i;
        boolean forward = this._forward;
        if (!this._isLeftToRight()) {
            forward = !forward;
        }
        Object[] components = this._component.getComponents();
        int count = components.length;
        Sort.qSort((Object[])components, (int)count, (Comparator)new Compare());
        for (i = count - 1; !(i < 0 || (temp = components[i]) instanceof JComponent && ((JComponent)temp).hasFocus()); --i) {
        }
        if (i < 0) {
            return;
        }
        Object moveTo = null;
        if (forward) {
            while (++i < count) {
                Object temp2 = components[i];
                if (!this._isAllowed((Component)temp2)) continue;
                moveTo = temp2;
                break;
            }
        } else {
            while (--i >= 0) {
                Object temp3 = components[i];
                if (!this._isAllowed((Component)temp3)) continue;
                moveTo = temp3;
                break;
            }
        }
        if (moveTo != null) {
            ((Component)moveTo).requestFocus();
        }
    }

    private boolean _isAllowed(Component component) {
        return component.isVisible() && component.isEnabled() && component.isFocusTraversable();
    }

    private boolean _isLeftToRight() {
        return true;
    }

    private class Compare
    implements Comparator {
        private Compare() {
        }

        public int compare(Object o1, Object o2) {
            Component c1 = (Component)o1;
            Component c2 = (Component)o2;
            boolean v1 = c1.isShowing();
            boolean v2 = c2.isShowing();
            if (!v1) {
                if (!v2) {
                    return 0;
                }
                return 1;
            }
            if (!v2) {
                return -1;
            }
            Point p1 = c1.getLocationOnScreen();
            Point p2 = c2.getLocationOnScreen();
            if (ArrowKeyHandler.this._isLeftToRight()) {
                if (p1.getX() < p2.getX()) {
                    return -1;
                }
                if (p1.getX() == p2.getX()) {
                    return 0;
                }
                return 1;
            }
            if (p1.getX() > p2.getX()) {
                return -1;
            }
            if (p1.getX() == p2.getX()) {
                return 0;
            }
            return 1;
        }
    }
}

