/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.collection.StringKey;

public abstract class UIBorderFactory {
    private static Border _raisedBevel;
    private static Border _loweredBevel;
    protected static Object RAISED_BEVEL_BORDER;
    protected static Object LOWERED_BEVEL_BORDER;
    static UIBorderFactory _sInstance;

    public static Border getRaisedBevelBorder() {
        if (_raisedBevel == null) {
            _raisedBevel = new BorderProxy(RAISED_BEVEL_BORDER);
        }
        return _raisedBevel;
    }

    public static Border getLoweredBevelBorder() {
        if (_loweredBevel == null) {
            _loweredBevel = new BorderProxy(LOWERED_BEVEL_BORDER);
        }
        return _loweredBevel;
    }

    static UIBorderFactory getDefaultUIBorderFactory(Component component) {
        PaintContext paintContext;
        Object factory = null;
        if (component instanceof JComponent && (paintContext = JPaintContext.getPaintContext((JComponent)component)) != null) {
            factory = paintContext.getPaintUIDefaults().get("UIBorderFactory");
        }
        if (factory == null) {
            factory = UIManager.get("UIBorderFactory");
        }
        if (factory instanceof UIBorderFactory) {
            return (UIBorderFactory)factory;
        }
        return Default.sharedInstance();
    }

    protected abstract Border getBorder(Object var1, Object var2);

    static {
        RAISED_BEVEL_BORDER = new StringKey("Border.raisedBevel");
        LOWERED_BEVEL_BORDER = new StringKey("Border.loweredBevel");
    }

    private static class BorderProxy
    implements Border {
        private Object _key;
        private Object _parameter;

        public BorderProxy(Object key) {
            this(key, null);
        }

        public BorderProxy(Object key, Object parameter) {
            this._key = key;
            this._parameter = parameter;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.getWrappedBorder(c).paintBorder(c, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c) {
            return this.getWrappedBorder(c).getBorderInsets(c);
        }

        public boolean isBorderOpaque() {
            return this.getWrappedBorder(null).isBorderOpaque();
        }

        protected Border getWrappedBorder(Component component) {
            return UIBorderFactory.getDefaultUIBorderFactory(component).getBorder(this._key, this._parameter);
        }
    }

    private static class Default
    extends UIBorderFactory {
        public static UIBorderFactory sharedInstance() {
            if (_sInstance == null) {
                _sInstance = new Default();
            }
            return _sInstance;
        }

        public Border getBorder(Object key, Object parameter) {
            if (RAISED_BEVEL_BORDER.equals(key)) {
                return BorderFactory.createRaisedBevelBorder();
            }
            if (LOWERED_BEVEL_BORDER.equals(key)) {
                return BorderFactory.createLoweredBevelBorder();
            }
            return null;
        }

        private Default() {
        }
    }
}

