/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import sun.awt.AppContext;
import sun.awt.dnd.SunDragSourceContextPeer;

public final class PlasticTreeUI
extends BasicTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;
    private static boolean _sJDK16 = false;
    private static DragRecognitionSupport _sDragSupport;
    private boolean _expansionCheck;

    public static ComponentUI createUI(JComponent b) {
        return new PlasticTreeUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateLineStyle(c.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new LineStyleHandler();
        c.addPropertyChangeListener(this.lineStyleHandler);
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(c);
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.linesEnabled) {
            this.drawDashedVerticalLine(g, x, top, bottom);
        }
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        if (this.linesEnabled) {
            this.drawDashedHorizontalLine(g, y, left, right);
        }
    }

    protected void drawCentered(Component c, Graphics graphics, Icon icon, int x, int y) {
        icon.paintIcon(c, graphics, x - icon.getIconWidth() / 2 - 1, y - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object lineStyle) {
        this.linesEnabled = !"None".equals(lineStyle);
    }

    protected void installListeners() {
        super.installListeners();
        if (_sJDK16) {
            this.tree.addMouseListener(PlasticTreeUI._sGetDragSupportListener());
            this.tree.addMouseMotionListener(PlasticTreeUI._sGetDragSupportListener());
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (_sJDK16) {
            this.tree.removeMouseListener(PlasticTreeUI._sGetDragSupportListener());
            this.tree.removeMouseMotionListener(PlasticTreeUI._sGetDragSupportListener());
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    private static DragRecognitionSupport _sGetDragSupportListener() {
        if (_sDragSupport == null) {
            _sDragSupport = new DragRecognitionSupport();
        }
        return _sDragSupport;
    }

    static {
        String version = System.getProperty("java.version");
        _sJDK16 = version.startsWith("1.6");
    }

    private static class DragRecognitionSupport
    implements MouseListener,
    MouseMotionListener {
        private int motionThreshold;
        private MouseEvent dndArmedEvent;
        private JComponent component;

        private DragRecognitionSupport() {
        }

        public static DragRecognitionSupport getDragRecognitionSupport() {
            DragRecognitionSupport support = (DragRecognitionSupport)AppContext.getAppContext().get(DragRecognitionSupport.class);
            if (support == null) {
                support = new DragRecognitionSupport();
                AppContext.getAppContext().put(DragRecognitionSupport.class, support);
            }
            return support;
        }

        public void mousePressed(MouseEvent e) {
            DragRecognitionSupport.getDragRecognitionSupport().mousePressedImpl(e);
        }

        public void mouseReleased(MouseEvent e) {
            DragRecognitionSupport.getDragRecognitionSupport().mouseReleasedImpl(e);
        }

        public void mouseClicked(MouseEvent p1) {
        }

        public void mouseEntered(MouseEvent p1) {
        }

        public void mouseExited(MouseEvent p1) {
        }

        public void mouseMoved(MouseEvent p1) {
        }

        public void mouseDragged(MouseEvent e) {
            DragRecognitionSupport.getDragRecognitionSupport().mouseDraggedImpl(e);
        }

        public JComponent getComponent(MouseEvent e) {
            Object src = e.getSource();
            if (src instanceof JComponent) {
                JComponent c = (JComponent)src;
                return c;
            }
            return null;
        }

        public void clearState() {
            this.dndArmedEvent = null;
            this.component = null;
        }

        public int mapDragOperationFromModifiers(MouseEvent me, TransferHandler th) {
            if (th == null || !SwingUtilities.isLeftMouseButton(me)) {
                return 0;
            }
            return SunDragSourceContextPeer.convertModifiersToDropAction(me.getModifiersEx(), th.getSourceActions(this.component));
        }

        public boolean isDragPossible(MouseEvent e) {
            TreeUI ui;
            TreePath path;
            JTree tree;
            boolean check;
            JComponent c = this.getComponent(e);
            boolean bl = c == null ? true : (check = c.getTransferHandler() != null);
            return check && (tree = (JTree)this.getComponent(e)).getDragEnabled() && (path = (ui = tree.getUI()).getClosestPathForLocation(tree, e.getX(), e.getY())) != null && tree.isPathSelected(path);
        }

        public void mousePressedImpl(MouseEvent me) {
            this.component = (JComponent)me.getSource();
            if (!this.isDragPossible(me)) {
                return;
            }
            if (this.mapDragOperationFromModifiers(me, this.component.getTransferHandler()) != 0) {
                this.motionThreshold = DragSource.getDragThreshold();
                this.dndArmedEvent = me;
            } else {
                this.clearState();
            }
        }

        public void mouseReleasedImpl(MouseEvent me) {
            if (this.dndArmedEvent != null) {
                this.clearState();
            }
        }

        public void mouseDraggedImpl(MouseEvent me) {
            TransferHandler th;
            int action;
            if (this.dndArmedEvent == null) {
                return;
            }
            if (me.getSource() != this.component) {
                this.clearState();
                return;
            }
            int dx = Math.abs(me.getX() - this.dndArmedEvent.getX());
            int dy = Math.abs(me.getY() - this.dndArmedEvent.getY());
            if ((dx > this.motionThreshold || dy > this.motionThreshold) && (action = this.mapDragOperationFromModifiers(me, th = this.component.getTransferHandler())) != 0) {
                th.exportAsDrag(this.component, this.dndArmedEvent, action);
                this.clearState();
            }
        }
    }

    private final class MouseHandler
    extends MouseAdapter {
        private TreePath lastSelectedPath = null;

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent event) {
            if (PlasticTreeUI.this.tree != null && PlasticTreeUI.this.tree.isEnabled()) {
                PlasticTreeUI.this.tree.requestFocus();
                TreePath path = PlasticTreeUI.this.getClosestPathForLocation(PlasticTreeUI.this.tree, event.getX(), event.getY());
                if (path != null) {
                    Rectangle bounds = PlasticTreeUI.this.getPathBounds(PlasticTreeUI.this.tree, path);
                    if (event.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        PlasticTreeUI.this.checkForClickInExpandControl(path, event.getX(), event.getY());
                    }
                    if (!PlasticTreeUI.this.startEditing(path, event) && !PlasticTreeUI.this.isLocationInExpandControl(path, event.getX(), event.getY())) {
                        if (PlasticTreeUI.this.tree.isPathSelected(path)) {
                            this.lastSelectedPath = path;
                            if (!Boolean.TRUE.equals(PlasticTreeUI.this.tree.getClientProperty("JTree.expandOnMouseRelease")) && SwingUtilities.isLeftMouseButton(event) && PlasticTreeUI.this.isToggleEvent(event)) {
                                PlasticTreeUI.this.toggleExpandState(path);
                                PlasticTreeUI.this._expansionCheck = true;
                            }
                        } else {
                            this.lastSelectedPath = null;
                            PlasticTreeUI.this.selectPathForEvent(path, event);
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent event) {
            TreePath path;
            if (PlasticTreeUI.this.tree != null && PlasticTreeUI.this.tree.isEnabled() && (path = PlasticTreeUI.this.getClosestPathForLocation(PlasticTreeUI.this.tree, event.getX(), event.getY())) != null) {
                Rectangle bounds = PlasticTreeUI.this.getPathBounds(PlasticTreeUI.this.tree, path);
                if (event.getY() > bounds.y + bounds.height) {
                    return;
                }
                if (path.equals(this.lastSelectedPath) && !PlasticTreeUI.this._expansionCheck) {
                    PlasticTreeUI.this.selectPathForEvent(path, event);
                }
            }
            this.lastSelectedPath = null;
            PlasticTreeUI.this._expansionCheck = false;
        }
    }

    private class LineStyleHandler
    implements PropertyChangeListener {
        private LineStyleHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object value = e.getNewValue();
            if (name.equals("JTree.lineStyle")) {
                PlasticTreeUI.this.updateLineStyle(value);
            }
        }
    }
}

