/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.ideimpl.webupdate.wizard.UpdatesPanel;

final class UpdatePage
extends UpdateWizardPage {
    private final UpdatesPanel _updatesPanel = new UpdatesPanel(){

        @Override
        protected void completeValueChanged() {
            if (UpdateWizardPage.updateWizardIsDisposed()) {
                return;
            }
            UpdatePage.this.completeValueChanged();
            UpdatePage.this.updateExpectedTransition();
        }
    };
    private final GridBagLayout _layout = new GridBagLayout();
    private final JMultiLineLabel _hintText = new JMultiLineLabel();

    UpdatePage() {
        this.resControls();
        this.layoutControls();
    }

    private void resControls() {
        this._hintText.setText(UpdateArb.getString(9));
        this._hintText.setPreferredRows(3);
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = INSETS_HINT;
        this.add((Component)this._hintText, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = INSETS_ZERO;
        this.add(this._updatesPanel, gbc);
    }

    @Override
    public Component getInitialFocus() {
        return this._updatesPanel.getInitialFocus();
    }

    private void updateExpectedTransition() {
        WizardCallbacks wc = this.getTraversableContext().getWizardCallbacks();
        wc.wizardUpdateExpectedTransition(this.getExitTransition());
    }

    @Override
    public void pageSelected(TraversableContext context) {
        if (context.getDirection() == 1) {
            this._updatesPanel.populate(this.getModel(context));
        }
    }

    @Override
    protected void pageDeselected(TraversableContext context) {
        this._updatesPanel.cleanUp();
    }

    @Override
    public boolean isComplete() {
        return this._updatesPanel.isComplete();
    }

    @Override
    protected void save(TraversableContext context) {
        this._updatesPanel.save(this.getModel(context));
    }

    @Override
    public boolean canFinish() {
        return this._updatesPanel.isCheckedForUpdates() && !this._updatesPanel.hasUpdates();
    }

    public Object getExitTransition() {
        if (this._updatesPanel.isCheckedForUpdates() && !this._updatesPanel.hasUpdates()) {
            return "updatesToSummary";
        }
        UpdatePageConditions state = new UpdatePageConditions(false, this._updatesPanel.isLicenseRequired(), this._updatesPanel.getSelectedUpdates());
        if (state.isLicense()) {
            return "updatesToLicense";
        }
        if (state.isSingleUser()) {
            return "updatesToDownload";
        }
        return "updatesToDlLocation";
    }
}

