/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webupdate.DeterminateProgressMonitor;
import oracle.ideimpl.webupdate.DownloadUpdatesRunnable;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;
import oracle.javatools.dialogs.ExceptionDialog;

final class DownloadPage
extends UpdateWizardPage {
    private final GridBagLayout _layout = new GridBagLayout();
    private final JMultiLineLabel _hintText = new JMultiLineLabel();
    private final JLabel _lbProgress = new JLabel();
    private final JProgressBar _pbProgress = new JProgressBar();
    private final JLabel _lbStatus = new JLabel();
    private final JButton _btnStop = new JButton();
    private boolean m_canAdvance = false;
    private boolean m_canGoBack = true;
    private transient DeterminateProgressMonitor m_monitor = null;

    DownloadPage() {
        this.resControls();
        this.layoutControls();
        this.installListeners();
    }

    @Override
    public boolean isComplete() {
        return this.m_canAdvance;
    }

    @Override
    public boolean canFinish() {
        return this.m_canAdvance;
    }

    @Override
    protected boolean canGoBack() {
        return this.m_canGoBack;
    }

    private void resControls() {
        this._hintText.setText(UpdateArb.getString(26));
        ResourceUtils.resLabel((JLabel)this._lbProgress, (Component)this._pbProgress, (String)UpdateArb.getString(27));
        ResourceUtils.resButton((AbstractButton)this._btnStop, (String)UpdateArb.getString(30));
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = INSETS_HINT;
        this.add((Component)this._hintText, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.insets = INSETS_GAP_BELOW;
        this.add(this._lbProgress, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        this.add(this._pbProgress, gbc);
        ++gbc.gridy;
        this.add(this._lbStatus, gbc);
        ++gbc.gridy;
        gbc.anchor = 12;
        gbc.insets = INSETS_ZERO;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        this.add(this._btnStop, gbc);
    }

    private void installListeners() {
        this._btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DownloadPage.this.m_monitor.setStopped(true);
            }
        });
    }

    @Override
    public Component getInitialFocus() {
        return this._btnStop;
    }

    private void downloadStopped() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadPage.this._hintText.setText(UpdateArb.getString(31));
                    DownloadPage.this._lbProgress.setVisible(false);
                    DownloadPage.this._pbProgress.setVisible(false);
                    DownloadPage.this._lbStatus.setVisible(false);
                    DownloadPage.this._btnStop.setVisible(false);
                    DownloadPage.this.m_canAdvance = false;
                    DownloadPage.this.m_canGoBack = true;
                    DownloadPage.this.completeValueChanged();
                    DownloadPage.this.validate();
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)DownloadPage.this), (Throwable)re);
                }
            }
        });
    }

    private String getDetailErrorMessage(Throwable exception) {
        return exception.getLocalizedMessage();
    }

    private void downloadError(final Throwable exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String detailMessage = DownloadPage.this.getDetailErrorMessage(exception);
                    DownloadPage.this._hintText.setText(UpdateArb.format(32, detailMessage));
                    DownloadPage.this._lbProgress.setVisible(false);
                    DownloadPage.this._pbProgress.setVisible(false);
                    DownloadPage.this._lbStatus.setVisible(false);
                    DownloadPage.this._btnStop.setVisible(false);
                    DownloadPage.this.m_canAdvance = false;
                    DownloadPage.this.m_canGoBack = true;
                    DownloadPage.this.completeValueChanged();
                    DownloadPage.this.validate();
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)DownloadPage.this), (Throwable)re);
                }
            }
        });
    }

    private void downloadStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadPage.this._hintText.setText(UpdateArb.getString(26));
                    DownloadPage.this._lbProgress.setVisible(true);
                    DownloadPage.this._pbProgress.setVisible(true);
                    DownloadPage.this._lbStatus.setVisible(true);
                    DownloadPage.this._btnStop.setVisible(true);
                    DownloadPage.this._btnStop.setEnabled(true);
                    DownloadPage.this.m_canAdvance = false;
                    DownloadPage.this.m_canGoBack = false;
                    DownloadPage.this.completeValueChanged();
                    DownloadPage.this.validate();
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)DownloadPage.this), (Throwable)re);
                }
            }
        });
    }

    private void downloadComplete(final Map zipFilesByUpdate) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadPage.this._btnStop.setEnabled(false);
                    DownloadPage.this.m_canAdvance = true;
                    if (!DownloadPage.this.getModel(DownloadPage.this.getTraversableContext()).isWizardCancelled()) {
                        DownloadPage.this.getModel(DownloadPage.this.getTraversableContext()).setDownloadedUpdates(zipFilesByUpdate);
                        DownloadPage.this.completeValueChanged();
                        DownloadPage.this.getTraversableContext().getWizardCallbacks().nextPage();
                    }
                }
                catch (Exception re) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)DownloadPage.this), (Throwable)re);
                }
            }
        });
    }

    @Override
    protected void pageSelected(final TraversableContext context) {
        if (context.getDirection() == 1) {
            this.downloadStarted();
            Collection updates = this.getModel(context).getSelectedUpdates();
            this.m_monitor = new DeterminateProgressMonitor(this._pbProgress, this._lbStatus);
            final PropertyChangeListener cancelListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    DownloadPage.this.m_monitor.setStopped((Boolean)pce.getNewValue());
                }
            };
            this.getModel(context).addPropertyChangeListener("wizardCancelled", cancelListener);
            DownloadUpdatesRunnable run = new DownloadUpdatesRunnable(updates){

                private void removeListener() {
                    DownloadPage.this.getModel(context).removePropertyChangeListener("wizardCancelled", cancelListener);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void cancelled() {
                    try {
                        DownloadPage.this.downloadStopped();
                    }
                    finally {
                        this.removeListener();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void failed(Exception e) {
                    try {
                        DownloadPage.this.downloadError(e);
                    }
                    finally {
                        this.removeListener();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void finished(Map zipFilesByUpdate) {
                    try {
                        DownloadPage.this.downloadComplete(zipFilesByUpdate);
                    }
                    finally {
                        this.removeListener();
                    }
                }
            };
            run.setMonitor(this.m_monitor);
            Thread t = new Thread((Runnable)run, "Check for Updates Installer");
            t.setPriority(1);
            t.start();
        }
    }
}

