/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.parser.LocalBundleParser;
import oracle.ideimpl.webupdate.parser.ParserResult;
import org.xml.sax.SAXException;

public final class LocalUpdateBundle {
    private static final String BUNDLE_MANIFEST = "META-INF/bundle.xml";
    private UpdateBundle _bundle;
    private File _bundleFile;

    public LocalUpdateBundle(UpdateBundle bundle) {
        this._bundle = bundle;
    }

    public UpdateBundle getBundle() {
        return this._bundle;
    }

    public void setBundleFile(File file) {
        this._bundleFile = file;
    }

    public File getBundleFile() {
        return this._bundleFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(String entryPath) throws IOException {
        ZipFile zipFile = new ZipFile(this.getBundleFile());
        ZipEntry entry = zipFile.getEntry(entryPath);
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    public static LocalUpdateBundle createInstance(File localFile) throws InvalidLocalBundleException {
        return LocalUpdateBundle.createInstance(localFile, true);
    }

    static LocalUpdateBundle createInstance(File localFile, boolean resolveExt) throws InvalidLocalBundleException {
        if (!localFile.exists()) {
            throw new InvalidLocalBundleException(UpdateArb.format(117, localFile.getName()));
        }
        if (localFile.isDirectory()) {
            throw new InvalidLocalBundleException(UpdateArb.format(118, localFile.getName()));
        }
        if (!localFile.canRead()) {
            throw new InvalidLocalBundleException(UpdateArb.format(119, localFile.getName()));
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(localFile);
            ZipEntry entry = zipFile.getEntry(BUNDLE_MANIFEST);
            if (entry == null) {
                throw new InvalidLocalBundleException(UpdateArb.format(132, localFile.getName(), BUNDLE_MANIFEST));
            }
            InputStream inStream = zipFile.getInputStream(entry);
            ParserResult result = new LocalBundleParser().parse(inStream);
            if (result.problems().hasProblems()) {
                throw new InvalidLocalBundleException(UpdateArb.getString(183), result.problems());
            }
            LocalUpdateBundle lub = new LocalUpdateBundle(result.bundle());
            lub.setBundleFile(localFile);
            if (resolveExt) {
                for (UpdateInfo info : result.bundle().getUpdates()) {
                    Extension oldExtension = ExtensionRegistry.getExtensionRegistry().findExtension(info.getID());
                    info.setNew(oldExtension == null);
                }
            }
            LocalUpdateBundle localUpdateBundle = lub;
            return localUpdateBundle;
        }
        catch (IOException ioe) {
            throw new InvalidLocalBundleException(UpdateArb.format(120, localFile.getName()), ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new InvalidLocalBundleException(UpdateArb.getString(133), pce);
        }
        catch (SAXException saxe) {
            throw new InvalidLocalBundleException(UpdateArb.getString(133), saxe);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }
}

