/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.OTNAuthPanel;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.WOCAuthenticator;
import oracle.ide.webbrowser.internal.Util;
import oracle.ideimpl.webupdate.DeterminateProgressMonitor;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateManager;

public abstract class DownloadUpdatesRunnable
implements Runnable {
    private static final Logger LOG = Logger.getLogger(DownloadUpdatesRunnable.class.getName());
    private static final int BUFFER_SIZE = 4096;
    private static final int AUTH_RETRY = 3;
    private static final NumberFormat TWO_DP_FORMAT = NumberFormat.getInstance();
    private ProxyOptions _savedProxyOptions;
    private static WOCAuthenticator.AuthenticationToken s_wocAuthToken;
    private DeterminateProgressMonitor _monitor;
    private final Collection _remoteUpdates;

    public DownloadUpdatesRunnable(Collection remoteUpdates) {
        this._remoteUpdates = remoteUpdates;
    }

    public final void setMonitor(DeterminateProgressMonitor monitor) {
        this._monitor = monitor;
    }

    protected final DeterminateProgressMonitor getMonitor() {
        return this._monitor;
    }

    @Override
    public void run() {
        File tempDir = new File(UpdateManager.getInstance().getDirectories().getTemp());
        if (!tempDir.exists()) {
            if (!tempDir.mkdirs()) {
                this.failed(new Exception("Unable to create temporary directory " + tempDir));
            }
        } else if (!tempDir.isDirectory()) {
            this.failed(new Exception("File " + tempDir + " is in the way."));
        }
        HashSet<UpdateBundle> bundles = new HashSet<UpdateBundle>();
        for (UpdateInfo update : this._remoteUpdates) {
            bundles.add(update.getBundle());
        }
        HashMap<UpdateBundle, File> zipMap = new HashMap<UpdateBundle, File>();
        this.getMonitor().setMajorStepCount(bundles.size());
        int count = 0;
        for (UpdateBundle bundle : bundles) {
            String centerUrl;
            int lastSlash;
            UpdateCenter center;
            if (this.getMonitor().isStopped()) {
                this.cancelled();
            }
            this.getMonitor().startStep(count);
            this.getMonitor().setMessage(UpdateArb.format(54, bundle.getName()));
            URL url = URLFactory.newURL((String)bundle.getDownloadUrl());
            if (url == null && (center = ((UpdateInfo)bundle.getUpdates().iterator().next()).getSourceCenter()) != null && (lastSlash = (centerUrl = center.getURL()).lastIndexOf(47)) >= 1) {
                url = URLFactory.newURL((String)(centerUrl.substring(0, lastSlash + 1) + bundle.getDownloadUrl()));
            }
            if (url == null) {
                throw new NullPointerException("Null download URL from " + bundle);
            }
            String fileName = URLFileSystem.getFileName((URL)url);
            File destFile = new File(tempDir, fileName);
            int suffix = 0;
            while (destFile.exists()) {
                destFile = new File(tempDir, fileName + "." + String.valueOf(++suffix));
            }
            try {
                this.copy(bundle.getName(), url, destFile);
                zipMap.put(bundle, destFile);
                this.getMonitor().endStep(count++);
                if (!this.getMonitor().isStopped()) continue;
                this.cancelled();
            }
            catch (IOException ioe) {
                if (!this.getMonitor().isStopped()) {
                    this.failed(ioe);
                } else {
                    this.cancelled();
                }
                return;
            }
        }
        this.finished(zipMap);
    }

    protected abstract void failed(Exception var1);

    protected abstract void cancelled();

    protected abstract void finished(Map var1);

    private WOCAuthenticator.AuthenticationToken authenticateOTN(String updateName) throws IOException {
        if (this.getMonitor().isStopped()) {
            throw new IOException("Cancelled Authentication");
        }
        if (s_wocAuthToken == null) {
            WOCAuthenticator woc = new WOCAuthenticator();
            PasswordAuthentication credentials = woc.getRememberedAuthentication();
            OTNAuthPanel authPanel = new OTNAuthPanel();
            HelpUtils.setHelpID((JComponent)authPanel, (String)"f1_idedsignin_html");
            authPanel.setHintText(UpdateArb.format(164, updateName));
            for (int i = 0; i < 3; ++i) {
                Window topWindow = IdeUtil.findActiveModalWindow();
                if (topWindow == null) {
                    topWindow = IdeUtil.getMainWindow();
                }
                if (credentials == null) {
                    credentials = authPanel.runDialog((Component)topWindow, UpdateArb.getString(165));
                }
                if (credentials != null) {
                    WOCAuthenticator.AuthenticationToken token = new WOCAuthenticator().logIn(credentials);
                    if (token != null) {
                        s_wocAuthToken = token;
                        break;
                    }
                } else {
                    throw new IOException(UpdateArb.getString(34));
                }
                credentials = null;
            }
            if (s_wocAuthToken == null) {
                throw new IOException(UpdateArb.getString(33));
            }
        }
        return s_wocAuthToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String updateName, URL src, File dst) throws IOException {
        long sourceLength = -1L;
        InputStream in = null;
        OutputStream out = null;
        boolean fixedProxy = false;
        try {
            block22: {
                if ("http".equals(src.getProtocol())) {
                    HttpURLConnection inConn = (HttpURLConnection)src.openConnection();
                    String hostName = src.getHost();
                    if ("download.oracle.com".equals(hostName)) {
                        fixedProxy = this.fixProxyForDownloadOracleCom();
                    }
                    inConn.setRequestProperty("User-Agent", UpdateManager.getInstance().getUserAgent(src.toString(), false));
                    in = inConn.getInputStream();
                    sourceLength = inConn.getContentLength();
                }
                if (sourceLength == -1L) {
                    sourceLength = URLFileSystem.getLength((URL)src);
                }
                if (in == null) {
                    in = URLFileSystem.openInputStream((URL)src);
                }
                if (in == null) {
                    throw new IOException(UpdateArb.format(83, src));
                }
                out = new FileOutputStream(dst);
                byte[] buffer = new byte[4096];
                long totalRead = 0L;
                String sizeString = DownloadUpdatesRunnable.getDisplaySize(sourceLength);
                do {
                    if (this.getMonitor().isStopped()) {
                        throw new IOException("Stopped during copy");
                    }
                    int bytesRead = in.read(buffer);
                    if (bytesRead < 0) break block22;
                    out.write(buffer, 0, bytesRead);
                    totalRead += (long)bytesRead;
                    if (sourceLength == -1L) {
                        this.getMonitor().setMessage("Downloading " + updateName);
                        continue;
                    }
                    this.getMonitor().setMessage(UpdateArb.format(55, updateName, DownloadUpdatesRunnable.getDisplaySize(totalRead), sizeString));
                    this.getMonitor().setStepProgress((double)totalRead / (double)sourceLength);
                } while (!this.getMonitor().isStopped());
                throw new IOException("Cancelled");
            }
            this.getMonitor().setStepProgress(1.0);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (fixedProxy) {
                this.unfixProxyForDownloadOracleCom();
            }
        }
    }

    private void unfixProxyForDownloadOracleCom() {
        if (this._savedProxyOptions != null) {
            ProxyOptions.setProxyOptions((ProxyOptions)this._savedProxyOptions);
            this._savedProxyOptions = null;
        }
    }

    private boolean fixProxyForDownloadOracleCom() {
        this._savedProxyOptions = null;
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        if (!proxyOptions.getUseProxy().booleanValue() || proxyOptions.getProxyHost() == null || proxyOptions.getProxyHost().trim().length() == 0) {
            if (this.isOracleInternalUser()) {
                LOG.info("Detected internal Oracle user with no proxy. Using emeacache for download.oracle.com.");
                this._savedProxyOptions = proxyOptions;
                ProxyOptions po = new ProxyOptions();
                po.setProxyHost("emeacache.uk.oracle.com");
                po.setProxyPort("80");
                po.setUseProxy(Boolean.TRUE);
                ProxyOptions.setProxyOptions((ProxyOptions)po);
            }
        } else if (proxyOptions.getProxyHost().endsWith(".oracle.com")) {
            ProxyOptions po = new ProxyOptions();
            proxyOptions.copyTo((Object)po);
            if (proxyOptions.getProxyExceptions() != null && proxyOptions.getProxyExceptions().indexOf("oracle.com") != -1) {
                LOG.info("Detected internal Oracle user with proxy exclusion for oracle.com. Removing exception for download.oracle.com");
                this._savedProxyOptions = proxyOptions;
                po.setProxyExceptions("");
            }
            if (proxyOptions.getProxyHost().equalsIgnoreCase("www-proxy.us.oracle.com")) {
                LOG.info("Detected internal Oracle user using www-proxy.us.oracle.com. There are certain download restrictions for internal downloads from download.oracle.com. If you have trouble downloading, try setting the proxy host to emeacache.uk.oracle.com to avoid download those restrictions.");
                this._savedProxyOptions = proxyOptions;
            }
            if (this._savedProxyOptions != null) {
                ProxyOptions.setProxyOptions((ProxyOptions)po);
            }
        }
        return this._savedProxyOptions != null;
    }

    private boolean isOracleInternalUser() {
        return Util.isInsideOracle();
    }

    private static String getDisplaySize(long bytes) {
        StringBuffer buffer = new StringBuffer();
        if (bytes < 1024L) {
            buffer.append(TWO_DP_FORMAT.format(bytes));
            buffer.append(" bytes");
        } else if (bytes >= 1024L && bytes < 0x100000L) {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1024.0));
            buffer.append(" KB");
        } else if (bytes >= 0x100000L && bytes < 0x40000000L) {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1048567.0));
            buffer.append(" MB");
        } else {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1.073741824E9));
            buffer.append(" GB");
        }
        return buffer.toString();
    }

    static {
        TWO_DP_FORMAT.setMaximumFractionDigits(2);
        TWO_DP_FORMAT.setMinimumFractionDigits(2);
        TWO_DP_FORMAT.setParseIntegerOnly(false);
    }
}

