/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.Version;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.view.View;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.CheckMasterListRunnable;
import oracle.ideimpl.webupdate.CheckUpdatesRunnable;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateCenter;
import oracle.ideimpl.webupdate.UpdateHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateLrb;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.WebUpdateAddin;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.balloon.Balloon;
import oracle.javatools.ui.balloon.BalloonConstraint;
import oracle.javatools.ui.balloon.BalloonManager;

public final class AutomaticCheckForUpdates {
    public static final String CONTEXT_KEY_MASTER_LIST = "autoCfuMasterList";
    private static final int HIDE_ACTION_ID = Ide.findOrCreateCmdID((String)"AutoUpdateHide");
    private static final int PREFS_ACTION_ID = Ide.findOrCreateCmdID((String)"AutoUpdatePrefs");
    private Collection _masterList = null;
    private JComponent _notificationIcon = null;
    private JCheckBox _skipCheckbox = null;
    private Controller _controller = null;
    private ContextMenu _contextMenu = null;
    private MouseListener _mouseListener = null;

    AutomaticCheckForUpdates() {
    }

    public void check() {
        if (Boolean.valueOf(System.getProperty("ide.cfu.autoskip")).booleanValue()) {
            return;
        }
        if (Ide.getIdeArgs().hasArg("-nonag")) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("ide.cfu.autoforce")).booleanValue()) {
            this.installBalloon();
        }
        Runnable cfuRunnable = new Runnable(){

            @Override
            public void run() {
                if (WebUpdateAddin.getPreferences().getCheckOnStartup()) {
                    AutomaticCheckForUpdates.this.checkMasterList();
                }
            }
        };
        Thread t = new Thread(cfuRunnable, "Automatic check for updates");
        t.setPriority(1);
        t.start();
    }

    private void checkMasterList() {
        CheckMasterListRunnable masterListCheck = new CheckMasterListRunnable(UpdateManager.getInstance().getMasterServerURL()){

            @Override
            protected void failed(Throwable exception) {
                CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                prefs.setLastErrorType("generic");
                prefs.setLastError(exception.getMessage());
            }

            @Override
            protected void finished(List masterList) {
                ArrayList<UpdateCenter> centers = new ArrayList<UpdateCenter>(masterList);
                UpdateHook updateHook = (UpdateHook)ExtensionRegistry.getExtensionRegistry().getHook(UpdateHook.ELEMENT);
                centers.addAll(updateHook.getUpdateCenters());
                for (UpdateCenter c : centers) {
                    c.setEnabled(c.isSelectedByDefault());
                }
                AutomaticCheckForUpdates.this.checkForUpdates(masterList);
            }
        };
        masterListCheck.setAutomaticUpdateMode(true);
        masterListCheck.run();
    }

    private void checkForUpdates(List masterList) {
        this._masterList = masterList;
        CheckUpdatesRunnable r = new CheckUpdatesRunnable(masterList){

            @Override
            protected void updateCenterError(UpdateCenter center, Throwable exception) {
                CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                prefs.setLastErrorType("generic");
                prefs.setLastError(exception.getMessage());
            }

            @Override
            protected void finished(Collection updates) {
                CheckForUpdatesPreferences prefs = WebUpdateAddin.getPreferences();
                prefs.setLastErrorType("none");
                boolean foundNewUpdates = false;
                HashStructure oldUpdates = prefs.getPreviousUpdates();
                if (oldUpdates == null) {
                    oldUpdates = HashStructure.newInstance();
                }
                HashStructure newUpdates = HashStructure.newInstance();
                for (UpdateInfo update : updates) {
                    String id = update.getID();
                    String oldVersionString = oldUpdates.getString(id);
                    newUpdates.putString(id, update.getVersion().toCanonicalString());
                    if (oldVersionString == null) {
                        foundNewUpdates = true;
                        continue;
                    }
                    Version oldVersion = new Version(oldVersionString);
                    if (update.getVersion().compareTo(oldVersion) <= 0) continue;
                    foundNewUpdates = true;
                }
                boolean havePatches = false;
                for (UpdateInfo update : updates) {
                    if (update.getType() != UpdateInfo.Type.PATCH) continue;
                    havePatches = true;
                    break;
                }
                if (havePatches || foundNewUpdates) {
                    final boolean fHavePatches = havePatches;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutomaticCheckForUpdates.this.installBalloon(fHavePatches);
                        }
                    });
                } else {
                    AutomaticCheckForUpdates.this._masterList = null;
                    UpdateManager.getInstance().clearAutomaticCheckForUpdates();
                }
                prefs.setPreviousUpdates(newUpdates);
            }

            @Override
            protected void stopped() {
            }
        };
        r.setAutomaticUpdatesMode(true);
        r.run();
    }

    private void installBalloon() {
        this.installBalloon(false);
    }

    private String _(String s) {
        return UpdateLrb.getBundle().getString(s);
    }

    private void installBalloon(boolean havePatches) {
        final Balloon b = new Balloon();
        JLabel header = new JLabel();
        header.setFont(header.getFont().deriveFont(1));
        header.setIcon(havePatches ? UpdateArb.getIcon(174) : OracleIcons.getIcon((String)"update2.png"));
        header.setText(havePatches ? this._("SERVICE_UPDATES_AVAILABLE") : this._("UPDATES_AVAILABLE"));
        MultiLineLabel mll = new MultiLineLabel();
        mll.setTextWrapper(WordWrapper.getTextWrapper());
        mll.setPreferredColumns(40);
        mll.setText(havePatches ? this._("CRITICAL_UPDATE") : this._("REGULAR_UPDATE"));
        b.add((Component)header, (Object)BalloonConstraint.HEADER);
        b.add((Component)mll, (Object)BalloonConstraint.TEXT);
        final JCheckBox cbSkipNextTime = new JCheckBox(this._("SKIP_CHECK"));
        cbSkipNextTime.setOpaque(false);
        b.add((Component)cbSkipNextTime, (Object)BalloonConstraint.FOOTER);
        this._skipCheckbox = cbSkipNextTime;
        final ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IdeAction cfuAction = IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID);
                Context context = Context.newIdeContext();
                context.setProperty(AutomaticCheckForUpdates.CONTEXT_KEY_MASTER_LIST, (Object)AutomaticCheckForUpdates.this._masterList);
                try {
                    cfuAction.performAction(context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        b.addActionListener(al);
        b.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent ce) {
                ce.getComponent().removeComponentListener(this);
                b.removeActionListener(al);
                WebUpdateAddin.getPreferences().setCheckOnStartup(!cbSkipNextTime.isSelected());
                if (cbSkipNextTime.isSelected()) {
                    AutomaticCheckForUpdates.this.uninstallNotificationIcon();
                }
                AutomaticCheckForUpdates.this._skipCheckbox = null;
            }
        });
        this.installNotificationIcon();
        BalloonManager.forTarget((JComponent)this._notificationIcon).show(b, 25000);
    }

    private void installNotificationIcon() {
        if (this._notificationIcon == null) {
            JLabel icon = new JLabel();
            icon.setIcon(OracleIcons.getIcon((String)"update2.png"));
            Ide.getStatusBar().getToolbar().add((Component)icon, 0);
            Ide.getStatusBar().getToolbar().revalidate();
            this._mouseListener = new MouseAdapter(){

                private Context createContext(MouseEvent me) {
                    Context context = Context.newIdeContext((View)Ide.getMainWindow().getIdeMainWindowView(), (EventObject)me);
                    context.setProperty(AutomaticCheckForUpdates.CONTEXT_KEY_MASTER_LIST, (Object)AutomaticCheckForUpdates.this._masterList);
                    return context;
                }

                private ContextMenu createContextMenu() {
                    ContextMenu contextMenu = AutomaticCheckForUpdates.this.getOrCreateContextMenu();
                    ContextMenuListener cml = new ContextMenuListener(){

                        public void menuWillShow(ContextMenu contextMenu) {
                            float section = 0.0f;
                            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID)), section);
                            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)HIDE_ACTION_ID)), section += 0.1f);
                            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)PREFS_ACTION_ID)), section);
                        }

                        public void menuWillHide(ContextMenu contextMenu) {
                            contextMenu.removeContextMenuListener((ContextMenuListener)this);
                        }

                        public boolean handleDefaultAction(Context context) {
                            try {
                                IdeAction.find((int)WebUpdateAddin.CFU_ACTION_ID).performAction(context);
                                return true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return false;
                            }
                        }
                    };
                    contextMenu.addContextMenuListener(cml);
                    return contextMenu;
                }

                private void showContextMenu(MouseEvent me) {
                    this.createContextMenu().show(this.createContext(me));
                }

                @Override
                public void mousePressed(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        this.showContextMenu(me);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        this.showContextMenu(me);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() == 2) {
                        this.createContextMenu().fireDefaultAction(this.createContext(me));
                    }
                }
            };
            icon.addMouseListener(this._mouseListener);
            this._notificationIcon = icon;
        }
    }

    public void uninstallNotificationIcon() {
        if (this._notificationIcon != null) {
            Ide.getStatusBar().getToolbar().remove((Component)this._notificationIcon);
            Ide.getStatusBar().getToolbar().invalidate();
            this._notificationIcon.removeMouseListener(this._mouseListener);
            this._notificationIcon = null;
            UpdateManager.getInstance().clearAutomaticCheckForUpdates();
            this.unregisterActions();
            this._contextMenu = null;
        }
    }

    public void updateSkipCheckbox() {
        if (this._skipCheckbox != null) {
            boolean autoCheck = WebUpdateAddin.getPreferences().getCheckOnStartup();
            this._skipCheckbox.setSelected(!autoCheck);
        }
    }

    private ContextMenu getOrCreateContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this.registerActions();
        }
        return this._contextMenu;
    }

    private void registerActions() {
        this._controller = new MyController();
        IdeAction hide = IdeAction.find((int)HIDE_ACTION_ID);
        if (hide == null) {
            hide = IdeAction.get((int)HIDE_ACTION_ID, null, (String)this._("HIDE"));
        }
        hide.addController(this._controller);
        IdeAction prefs = IdeAction.find((int)PREFS_ACTION_ID);
        if (prefs == null) {
            prefs = IdeAction.get((int)PREFS_ACTION_ID, null, (String)this._("PREFERENCES"));
        }
        prefs.addController(this._controller);
    }

    private void unregisterActions() {
        IdeAction prefs;
        IdeAction hide = IdeAction.find((int)HIDE_ACTION_ID);
        if (hide != null) {
            hide.removeController(this._controller);
        }
        if ((prefs = IdeAction.find((int)PREFS_ACTION_ID)) != null) {
            prefs.removeController(this._controller);
        }
        this._controller = null;
    }

    private final class MyController
    implements Controller {
        private MyController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action.getCommandId() == HIDE_ACTION_ID) {
                AutomaticCheckForUpdates.this.uninstallNotificationIcon();
                return true;
            }
            if (action.getCommandId() == PREFS_ACTION_ID) {
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{"Extensions"});
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            return action.getCommandId() == HIDE_ACTION_ID || action.getCommandId() == PREFS_ACTION_ID;
        }
    }
}

