/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import oracle.ojc.interfaces.Storage;

public class StorageJavaFileObject
implements JavaFileObject {
    static final String ENCLOSING_JAR = "javacompiler.enclosing.jar";
    static final String ENCLOSING_JAR_USED = "javacompiler.enclosing.jar.used";
    static boolean checkUnusedJars;
    private JavaFileObject.Kind kind;
    private Storage storage;
    private String encoding;
    private boolean openForWriting;
    private List<Object> bufferUsers;
    private String binaryName;
    private static int interruptCounter;

    public StorageJavaFileObject(String packageName, Storage storage, String encoding) throws IllegalArgumentException {
        if (storage.isDirectory()) {
            throw new IllegalArgumentException("Argument cannot be DirectoryStorage");
        }
        this.storage = storage;
        this.encoding = encoding;
        this.determineKind(storage.getName());
        if (packageName != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(packageName);
            buf.append('.');
            int index = storage.getName().lastIndexOf(46);
            if (index > 0) {
                buf.append(storage.getName().substring(0, index));
            } else {
                buf.append(storage.getName());
            }
            this.binaryName = buf.toString();
        }
    }

    public String toString() {
        return this.storage.getPath();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.storage.getName();
    }

    public boolean matches(String simpleName, JavaFileObject.Kind kind) {
        return this.kind == kind && this.getName().equals(simpleName);
    }

    public String getNameWithoutExtension() {
        String name = this.getName();
        int i = name.lastIndexOf(46);
        return i < 0 ? name : name.substring(0, i);
    }

    public String getPath() {
        return this.storage.getPath();
    }

    public int size() {
        try {
            return this.storage.size();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public synchronized InputStream openInputStream() throws IOException, IllegalStateException {
        ByteBuffer buffer = this.getByteBuffer();
        return new StorageInputStream(buffer);
    }

    @Override
    public synchronized OutputStream openOutputStream() throws FileNotFoundException, IllegalStateException {
        if (this.bufferUsers != null) {
            throw new IllegalStateException("JavaFileObject already open for reading");
        }
        if (this.openForWriting) {
            throw new IllegalStateException("JavaFileObject already open for writing");
        }
        this.openForWriting = true;
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                byte[] oneByte = new byte[]{(byte)b};
                StorageJavaFileObject.this.storage.write(oneByte, 0, 1);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                StorageJavaFileObject.this.storage.write(b, off, len);
            }

            @Override
            public void close() {
                StorageJavaFileObject.this.storage.close();
                StorageJavaFileObject.this.openForWriting = false;
            }
        };
    }

    @Override
    public synchronized Reader openReader(boolean ignoreEncodingErrors) throws IOException, IllegalStateException {
        return new InputStreamReader(this.openInputStream());
    }

    @Override
    public synchronized CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException, IllegalStateException {
        return this.getCharBuffer();
    }

    @Override
    public synchronized Writer openWriter() throws FileNotFoundException, IllegalStateException {
        return new OutputStreamWriter(this.openOutputStream());
    }

    @Override
    public long getLastModified() {
        return this.storage.modDate();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        String name = this.getName();
        if (kind == JavaFileObject.Kind.SOURCE) {
            return name.equals(simpleName + ".java");
        }
        if (kind == JavaFileObject.Kind.CLASS) {
            return name.equals(simpleName + ".class");
        }
        return false;
    }

    @Override
    public URI toUri() {
        return new File(this.storage.getPath()).toURI();
    }

    @Override
    public NestingKind getNestingKind() {
        if (this.getKind() == JavaFileObject.Kind.CLASS) {
            String name = this.getName();
            if (name.indexOf(36) > 0) {
                return NestingKind.MEMBER;
            }
            return NestingKind.TOP_LEVEL;
        }
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public void setBinaryName(String binaryName) {
        this.binaryName = binaryName;
    }

    private void determineKind(String name) {
        this.kind = JavaFileObject.Kind.OTHER;
        if (name != null) {
            for (JavaFileObject.Kind current : JavaFileObject.Kind.values()) {
                if (!name.endsWith(current.extension)) continue;
                this.kind = current;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ByteBuffer getByteBuffer() throws IllegalStateException, IOException {
        ByteBuffer byteBuffer;
        Storage enclosingJar;
        if (++interruptCounter > 20) {
            interruptCounter = 0;
            if (Thread.currentThread().isInterrupted()) {
                return ByteBuffer.allocate(0);
            }
        }
        if (this.openForWriting) {
            throw new IllegalStateException("JavaFileObject already open for writing");
        }
        if (checkUnusedJars && (enclosingJar = (Storage)this.storage.getProperty(ENCLOSING_JAR)) != null) {
            enclosingJar.setProperty(ENCLOSING_JAR_USED, (Object)Boolean.TRUE);
        }
        try {
            this.storage.open();
            byte[] bytes = this.storage.read();
            byteBuffer = ByteBuffer.wrap(bytes);
        }
        finally {
            this.storage.close();
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private synchronized CharBuffer getCharBuffer() throws IllegalStateException, IOException {
        CharBuffer charBuffer;
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (this.encoding != null) {
            Charset charSet = Charset.forName(this.encoding);
            CharsetDecoder decoder = charSet.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            charBuffer = CharBuffer.allocate((int)((float)byteBuffer.limit() * decoder.maxCharsPerByte()));
            decoder.decode(byteBuffer, charBuffer, true);
            charBuffer.limit(charBuffer.position());
        } else {
            charBuffer = CharBuffer.allocate(byteBuffer.limit());
            for (int x = 0; x < byteBuffer.limit(); ++x) {
                charBuffer.put((char)(0xFFFF & byteBuffer.get(x)));
            }
        }
        charBuffer.rewind();
        return charBuffer;
    }

    private synchronized void addBufferUser(Object user) {
        if (this.bufferUsers == null) {
            this.bufferUsers = new ArrayList<Object>(3);
        }
        this.bufferUsers.add(user);
    }

    private synchronized void removeBufferUser(Object user) {
        this.bufferUsers.remove(user);
        if (this.bufferUsers.isEmpty()) {
            this.bufferUsers = null;
        }
    }

    static {
        interruptCounter = 0;
    }

    private class StorageInputStream
    extends InputStream {
        private int pointer = 0;
        private ByteBuffer byteBuffer;

        StorageInputStream(ByteBuffer byteBuffer) {
            StorageJavaFileObject.this.addBufferUser(this);
            this.byteBuffer = byteBuffer;
        }

        @Override
        public int read() throws IOException {
            if (this.pointer >= this.byteBuffer.limit()) {
                return -1;
            }
            return this.byteBuffer.get(this.pointer++);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int length = len;
            int remaining = this.byteBuffer.limit() - this.pointer;
            if (remaining <= 0) {
                return -1;
            }
            if (length > remaining) {
                length = remaining;
            }
            this.byteBuffer.get(b, off, length);
            this.pointer += length;
            return length;
        }

        @Override
        public int available() throws IOException {
            return this.byteBuffer.limit() - this.pointer;
        }

        @Override
        public void close() {
            StorageJavaFileObject.this.removeBufferUser(this);
            this.byteBuffer = null;
        }
    }
}

