/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class JavacTreeScanner
extends TreeScanner<Object, HashSet<JCTree.JCStatement>> {
    private TreeMaker treeMaker;
    private Map<String, String> excludedClassMap;

    public JavacTreeScanner(Context context, TreeMaker treeMaker, java.util.List<String> excludedClasses) {
        this.treeMaker = treeMaker;
        this.excludedClassMap = new HashMap<String, String>();
        for (String excludedClass : excludedClasses) {
            this.excludedClassMap.put(excludedClass, excludedClass);
        }
    }

    @Override
    public Object visitBlock(BlockTree node, HashSet<JCTree.JCStatement> p) {
        HashSet removeTheseStatements = new HashSet(3);
        Object returnValue = super.visitBlock(node, removeTheseStatements);
        if (removeTheseStatements.size() > 0) {
            if (node instanceof JCTree.JCBlock) {
                JCTree.JCBlock block = (JCTree.JCBlock)node;
                ArrayList<JCTree.JCStatement> newStatements = new ArrayList<JCTree.JCStatement>();
                for (JCTree.JCStatement jcStatement : block.stats) {
                    if (!removeTheseStatements.contains(jcStatement)) {
                        newStatements.add(jcStatement);
                        continue;
                    }
                    newStatements.add(this.treeMaker.Skip());
                }
                JCTree.JCStatement[] newStatementArray = newStatements.toArray(new JCTree.JCStatement[newStatements.size()]);
                block.stats = List.from(newStatementArray);
            }
            removeTheseStatements.clear();
        }
        return returnValue;
    }

    @Override
    public Object visitIf(IfTree node, HashSet<JCTree.JCStatement> p) {
        HashSet removeTheseStatements = new HashSet(1);
        Object returnValue = super.visitIf(node, removeTheseStatements);
        if (removeTheseStatements.size() > 0) {
            if (node instanceof JCTree.JCIf) {
                JCTree.JCIf ifStatement = (JCTree.JCIf)node;
                if (removeTheseStatements.contains(ifStatement.getThenStatement())) {
                    ifStatement.thenpart = this.treeMaker.Skip();
                }
                if (removeTheseStatements.contains(ifStatement.getElseStatement())) {
                    ifStatement.elsepart = this.treeMaker.Skip();
                }
            }
            removeTheseStatements.clear();
        }
        return returnValue;
    }

    @Override
    public Object visitExpressionStatement(ExpressionStatementTree node, HashSet<JCTree.JCStatement> p) {
        MethodInvocationTree methodInvoke;
        ExpressionTree exprTree = node.getExpression();
        if (exprTree != null && exprTree.getKind() == Tree.Kind.METHOD_INVOCATION && (exprTree = (methodInvoke = (MethodInvocationTree)exprTree).getMethodSelect()) != null && exprTree.getKind() == Tree.Kind.MEMBER_SELECT) {
            JCTree.JCExpression selected;
            ExecutableType execType;
            TypeMirror returnType;
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)exprTree;
            Type type = fieldAccess.type;
            Symbol sym = fieldAccess.sym;
            if (type != null && type.getKind() == TypeKind.EXECUTABLE && sym != null && sym.isStatic() && (returnType = (execType = (ExecutableType)((Object)type)).getReturnType()) != null && "void".equals(((Object)returnType).toString()) && (selected = fieldAccess.selected) != null && selected.getKind() == Tree.Kind.IDENTIFIER) {
                JCTree.JCIdent ident = (JCTree.JCIdent)selected;
                if (ident.sym != null && ident.sym.flatName() != null && this.excludedClassMap.get(ident.sym.flatName().toString()) != null) {
                    p.add((JCTree.JCStatement)((Object)node));
                    return null;
                }
            }
        }
        return super.visitExpressionStatement(node, p);
    }
}

