/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import oracle.jdevimpl.javacompiler.FileOutputListener;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.JavaCompilerOptions;
import oracle.jdevimpl.javacompiler.ResourceUtils;
import oracle.jdevimpl.javacompiler.StorageJavaFileObject;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public class JDevJavaFileManager
implements JavaFileManager {
    private static final String STORAGE_APPEND_SLASH = "StorageAppendSlash";
    private Storage outputPath;
    private List<? extends Storage> sourcePath;
    private List<? extends Storage> bootClassPath;
    private List<? extends Storage> appendBootClassPath;
    private List<? extends Storage> prependBootClassPath;
    private List<? extends Storage> classPath;
    private Map<JavaFileManager.Location, Iterable<? extends Storage>> locationStorages;
    private String encoding = null;
    private String fileSeparator = System.getProperty("file.separator");
    private char fileSeparatorChar;
    private Map<String, Integer> supportedOptions;
    private List<FileOutputListener> fileOutputListeners;
    private boolean checkUnusedJars;
    private boolean interrupted;
    private int interruptCounter;
    private JavaCompilerLog log;
    private boolean verbosePath;

    public JDevJavaFileManager() {
        if (this.fileSeparator == null) {
            this.fileSeparator = "/";
        }
        this.fileSeparatorChar = this.fileSeparator.charAt(0);
        this.locationStorages = new HashMap<JavaFileManager.Location, Iterable<? extends Storage>>();
        this.supportedOptions = new HashMap<String, Integer>(9);
        this.supportedOptions.put("-d", 1);
        this.supportedOptions.put("-sourcepath", 1);
        this.supportedOptions.put("-classpath", 1);
        this.supportedOptions.put("-cp", 1);
        this.supportedOptions.put("-bootclasspath", 1);
        this.supportedOptions.put("-Xbootclasspath/:", 1);
        this.supportedOptions.put("-Xbootclasspath/a:", 1);
        this.supportedOptions.put("-Xbootclasspath/p:", 1);
        this.supportedOptions.put("-encoding", 1);
        this.fileOutputListeners = new ArrayList<FileOutputListener>();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.getClass().getClassLoader();
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) {
        if (this.interrupted) {
            return Collections.emptyList();
        }
        if (++this.interruptCounter > 20) {
            this.checkInterrupt();
        }
        List<Storage> storages = this.getPackageStorages(location, packageName, false);
        ArrayList<JavaFileObject> fileList = new ArrayList<JavaFileObject>();
        for (Storage storage : storages) {
            if (!storage.isDirectory()) continue;
            this.list(packageName, storage, kinds, fileList, recurse);
        }
        return fileList;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof StorageJavaFileObject) {
            String binaryName = ((StorageJavaFileObject)file).getBinaryName();
            if (binaryName == null) {
                String path = ((StorageJavaFileObject)file).getPath();
                path = path.replace('\\', '/');
                Iterable<? extends Storage> storageIter = this.getLocationStorages(location);
                for (Storage storage : storageIter) {
                    String storagePath = storage.getPath().replace('\\', '/');
                    if (!storagePath.endsWith("/")) {
                        storagePath = storagePath + "/";
                    }
                    if (!path.startsWith(storagePath)) continue;
                    binaryName = path.substring(storagePath.length());
                    int index = binaryName.lastIndexOf(46);
                    if (index > 0) {
                        binaryName = binaryName.substring(0, index);
                    }
                    ((StorageJavaFileObject)file).setBinaryName(binaryName);
                    break;
                }
            }
            return binaryName;
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        if (!(a instanceof StorageJavaFileObject) || !(b instanceof StorageJavaFileObject)) {
            throw new IllegalArgumentException("Arguments of isSameFile have to be StorageJavaFileObjects");
        }
        StorageJavaFileObject one = (StorageJavaFileObject)a;
        StorageJavaFileObject two = (StorageJavaFileObject)b;
        return one.getPath() != null && two.getPath() != null && one.getPath().equals(two.getPath());
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        boolean missingArgument = false;
        if (current.equals("-d")) {
            if (remaining.hasNext()) {
                String path = remaining.next();
                if (!path.endsWith(this.fileSeparator)) {
                    path = path + this.fileSeparator;
                }
                File pathFile = new File(path);
                boolean error = false;
                if (pathFile.exists()) {
                    if (!pathFile.isDirectory()) {
                        error = true;
                    }
                } else if (!pathFile.mkdirs()) {
                    error = true;
                }
                if (error) {
                    String msg = ResourceUtils.format("CANNOT_CREATE_PATH", "Cannot create path {0}", path);
                    throw new IllegalArgumentException(msg);
                }
                this.outputPath = new DirectoryStorage(pathFile);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-sourcepath")) {
            if (remaining.hasNext()) {
                this.sourcePath = JDevJavaFileManager.parsePath(current, "sourcepath", remaining.next(), false, this.verbosePath, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-classpath") || current.equals("-cp")) {
            if (remaining.hasNext()) {
                String argument = remaining.next();
                if (this.classPath == null) {
                    this.classPath = JDevJavaFileManager.parsePath(current, "classpath", argument, this.checkUnusedJars, this.verbosePath, this.log);
                }
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-bootclasspath") || current.equals("-Xbootclasspath/:")) {
            if (remaining.hasNext()) {
                this.bootClassPath = JDevJavaFileManager.parsePath(current, "bootclasspath", remaining.next(), false, this.verbosePath, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-Xbootclasspath/a:")) {
            if (remaining.hasNext()) {
                this.appendBootClassPath = JDevJavaFileManager.parsePath(current, "bootclasspath/a", remaining.next(), false, this.verbosePath, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-Xbootclasspath/p:")) {
            if (remaining.hasNext()) {
                this.prependBootClassPath = JDevJavaFileManager.parsePath(current, "bootclasspath/p", remaining.next(), false, this.verbosePath, this.log);
                return true;
            }
            missingArgument = true;
        } else if (current.equals("-encoding")) {
            if (remaining.hasNext()) {
                this.encoding = JDevJavaFileManager.getEncoding(remaining.next());
                return true;
            }
            missingArgument = true;
        }
        if (missingArgument) {
            String msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", current);
            throw new IllegalArgumentException(msg);
        }
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        Iterable<? extends Storage> storages = this.getLocationStorages(location);
        return storages.iterator().hasNext();
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.CLASS && kind != JavaFileObject.Kind.SOURCE) {
            throw new IllegalArgumentException("Illegal JavaFileObject.Kind: " + kind.name());
        }
        int index = className.lastIndexOf(46);
        String packageName = "";
        String shortClassName = className;
        if (index > 0) {
            packageName = className.substring(0, index);
            shortClassName = className.substring(index + 1);
        }
        shortClassName = shortClassName + kind.extension;
        return (JavaFileObject)this.getFileForInput(location, packageName, shortClassName);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        int index = className.lastIndexOf(46);
        String packageName = index > 0 ? className.substring(0, index) : null;
        String fileName = index > 0 ? className.substring(index + 1) : className;
        fileName = fileName + kind.extension;
        return (JavaFileObject)this.getFileForOutput(location, packageName, fileName, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) {
        Storage fileStorage;
        Storage packageStorage;
        if (this.interrupted) {
            return null;
        }
        if (++this.interruptCounter > 20) {
            this.checkInterrupt();
        }
        if ((packageStorage = this.getPackageStorage(location, packageName)) != null && packageStorage.isDirectory() && (fileStorage = packageStorage.open(relativeName)) != null) {
            return new StorageJavaFileObject(packageName, fileStorage, this.encoding);
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        File parent;
        URI uri;
        if (this.interrupted) {
            return null;
        }
        if (++this.interruptCounter > 20) {
            this.checkInterrupt();
        }
        Iterable<? extends Storage> storages = this.getLocationStorages(location);
        Storage outputStorage = null;
        Iterator<? extends Storage> i$ = storages.iterator();
        if (i$.hasNext()) {
            Storage s;
            outputStorage = s = i$.next();
        }
        if (outputStorage == null && sibling != null && (uri = sibling.toUri()) != null && (parent = new File(uri).getParentFile()) != null) {
            outputStorage = new FileStorage(parent);
        }
        if (outputStorage != null) {
            this.checkDirectory(outputStorage);
            if (packageName != null) {
                String[] packageNamePieces;
                for (String packageNamePiece : packageNamePieces = (packageName = packageName.trim()).length() == 0 ? new String[]{} : packageName.split("\\.")) {
                    if ((outputStorage = outputStorage.createDir(packageNamePiece)) != null && outputStorage.isDirectory()) continue;
                    String outputPath = outputStorage.getPath() + this.fileSeparatorChar + packageNamePiece;
                    String msg = ResourceUtils.format("CANNOT_CREATE_PATH", "Cannot create path {0}", outputPath);
                    throw new IOException(msg);
                }
            }
            outputStorage = outputStorage.create(relativeName);
            this.reportFileOutput(outputStorage.getPath());
            return new StorageJavaFileObject(packageName, outputStorage, this.encoding);
        }
        String msg = ResourceUtils.format("CANNOT_CREATE_PATH", "Cannot create path {0}", packageName + this.fileSeparatorChar + relativeName);
        throw new IOException(msg);
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        PrintWriter writer = null;
        try {
            String unusedZipFileName = System.getProperty("javac.unused.zip.file");
            if (unusedZipFileName != null && unusedZipFileName.trim().length() > 0) {
                File file = new File(unusedZipFileName);
                file.getParentFile().mkdirs();
                try {
                    writer = new PrintWriter(file);
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            for (Iterable<? extends Storage> storageIter : this.locationStorages.values()) {
                for (Storage storage : storageIter) {
                    if (this.checkUnusedJars) {
                        this.closeStorageWithUnusedJarCheck(storage, writer);
                        continue;
                    }
                    storage.close();
                }
            }
            this.locationStorages.clear();
            this.closeStorages(this.sourcePath, writer);
            this.closeStorages(this.bootClassPath, writer);
            this.closeStorages(this.appendBootClassPath, writer);
            this.closeStorages(this.prependBootClassPath, writer);
            this.closeStorages(this.classPath, writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (this.outputPath != null) {
            this.outputPath.close();
            this.outputPath = null;
        }
        this.supportedOptions.clear();
        this.fileOutputListeners.clear();
    }

    private void closeStorages(List<? extends Storage> list, PrintWriter writer) {
        if (list != null) {
            for (Storage storage : list) {
                if (this.checkUnusedJars) {
                    this.closeStorageWithUnusedJarCheck(storage, writer);
                    continue;
                }
                storage.close();
            }
            list.clear();
        }
    }

    private void closeStorageWithUnusedJarCheck(Storage storage, PrintWriter writer) {
        if (storage.getProperty("javacompiler.enclosing.jar") == storage && storage.getProperty("javacompiler.enclosing.jar.used") == Boolean.FALSE) {
            System.out.println("Warning: " + storage.getPath() + " not used.");
            if (writer != null) {
                writer.println(storage.getPath());
            }
        }
        storage.setProperty("javacompiler.enclosing.jar", null);
        storage.close();
    }

    @Override
    public int isSupportedOption(String option) {
        Integer extra = this.supportedOptions.get(option);
        if (extra != null) {
            return extra;
        }
        return -1;
    }

    private Iterable<? extends Storage> getLocationStorages(JavaFileManager.Location location) {
        Iterable<? extends Storage> storages = this.locationStorages.get(location);
        if (storages == null) {
            ArrayList<? extends Storage> storageList = new ArrayList<Storage>();
            if (location instanceof StandardLocation) {
                StandardLocation standardLocation = (StandardLocation)location;
                switch (standardLocation) {
                    case CLASS_OUTPUT: 
                    case SOURCE_OUTPUT: {
                        if (this.outputPath == null) break;
                        storageList.add((Storage)this.outputPath);
                        break;
                    }
                    case CLASS_PATH: {
                        if (this.classPath == null) break;
                        for (Storage storage : this.classPath) {
                            storageList.add((Storage)storage);
                        }
                        break;
                    }
                    case PLATFORM_CLASS_PATH: {
                        if (this.prependBootClassPath != null) {
                            for (Storage storage : this.prependBootClassPath) {
                                storageList.add((Storage)storage);
                            }
                        }
                        if (this.bootClassPath != null) {
                            for (Storage storage : this.bootClassPath) {
                                storageList.add((Storage)storage);
                            }
                        }
                        if (this.appendBootClassPath == null) break;
                        for (Storage storage : this.appendBootClassPath) {
                            storageList.add((Storage)storage);
                        }
                        break;
                    }
                    case SOURCE_PATH: {
                        if (this.sourcePath == null) break;
                        for (Storage storage : this.sourcePath) {
                            storageList.add((Storage)storage);
                        }
                        break;
                    }
                }
            }
            this.locationStorages.put(location, storageList);
            storages = storageList;
        }
        return storages;
    }

    private void list(String packageName, Storage dir, Set<JavaFileObject.Kind> kinds, List<JavaFileObject> fileList, boolean recurse) {
        String[] children = dir.list();
        if (children != null) {
            Object enclosingJar = this.checkUnusedJars ? dir.getProperty("javacompiler.enclosing.jar") : null;
            for (String childName : children) {
                boolean acceptedFile = this.acceptFile(childName, kinds);
                if (!acceptedFile && !recurse) continue;
                Storage childStorage = dir.open(childName);
                if (this.checkUnusedJars) {
                    childStorage.setProperty("javacompiler.enclosing.jar", enclosingJar);
                }
                boolean isDirectory = childStorage.isDirectory();
                if (acceptedFile && !isDirectory) {
                    fileList.add(new StorageJavaFileObject(packageName, childStorage, this.encoding));
                    continue;
                }
                if (!recurse || !isDirectory) continue;
                String childPackageName = packageName + "." + childName;
                this.list(childPackageName, childStorage, kinds, fileList, recurse);
            }
        }
    }

    private boolean acceptFile(String childName, Set<JavaFileObject.Kind> kinds) {
        for (JavaFileObject.Kind kind : kinds) {
            if (kind == JavaFileObject.Kind.OTHER) {
                for (JavaFileObject.Kind otherKind : JavaFileObject.Kind.values()) {
                    if (otherKind == JavaFileObject.Kind.OTHER || !childName.endsWith(otherKind.extension)) continue;
                    return false;
                }
                return true;
            }
            if (!childName.endsWith(kind.extension)) continue;
            return true;
        }
        return false;
    }

    private Storage getPackageStorage(JavaFileManager.Location location, String packageName) {
        List<Storage> storages = this.getPackageStorages(location, packageName, true);
        return storages.size() > 0 ? storages.get(0) : null;
    }

    private List<Storage> getPackageStorages(JavaFileManager.Location location, String packageName, boolean stopAfterFirstOne) {
        ArrayList<Storage> storages = new ArrayList<Storage>();
        Iterable<? extends Storage> storageLocationIter = this.getLocationStorages(location);
        String[] packageNamePieces = (packageName = packageName.trim()).length() == 0 ? new String[]{} : packageName.split("\\.");
        Iterator<? extends Storage> i$ = storageLocationIter.iterator();
        block0: while (i$.hasNext()) {
            Storage storageLocation;
            Storage packageStorage = storageLocation = i$.next();
            Object enclosingJar = this.checkUnusedJars ? packageStorage.getProperty("javacompiler.enclosing.jar") : null;
            boolean appendSlash = packageStorage.getProperty(STORAGE_APPEND_SLASH) != null;
            for (String packageNamePiece : packageNamePieces) {
                if (appendSlash) {
                    packageNamePiece = packageNamePiece + "/";
                }
                if ((packageStorage = packageStorage.open(packageNamePiece)) == null || !packageStorage.isDirectory()) continue block0;
                if (!this.checkUnusedJars) continue;
                packageStorage.setProperty("javacompiler.enclosing.jar", enclosingJar);
            }
            storages.add(packageStorage);
            if (!stopAfterFirstOne) continue;
            return storages;
        }
        return storages;
    }

    public void setClassPath(Storage[] storages) {
        if (storages != null) {
            String pathKind = "classpath";
            String msg = ResourceUtils.format("PARSING_PATH", "Parsing path: {0}", pathKind);
            this.logMessage(msg);
            ArrayList<? extends Storage> storageList = new ArrayList<Storage>(storages.length);
            for (Storage storage : storages) {
                String name = storage.getClass().getName();
                if (name.endsWith(".JarStorage") && name.equals("oracle.jdeveloper.compiler.JarStorage")) {
                    storage.setProperty(STORAGE_APPEND_SLASH, (Object)Boolean.TRUE);
                }
                storageList.add((Storage)storage);
                this.logMessage("   " + storage.getPath());
            }
            this.classPath = storageList;
            msg = ResourceUtils.format("DONE_PARSING_PATH", "Done parsing path: {0}", pathKind);
            this.logMessage(msg);
        }
    }

    private void checkDirectory(Storage storage) throws IOException {
        if (storage.modDate() > 0L) {
            return;
        }
        File file = new File(storage.getPath());
        if (!file.exists() && !file.mkdirs()) {
            String msg = ResourceUtils.format("CANNOT_CREATE_PATH", "Cannot create path {0}", storage.getPath());
            throw new IOException(msg);
        }
    }

    static List<? extends Storage> parsePath(String option, String pathKind, String pathString, boolean checkUnusedJars, boolean verbose, JavaCompilerLog log) throws IllegalArgumentException {
        try {
            JavaCompilerOptions options = new JavaCompilerOptions(checkUnusedJars, verbose, log);
            return options.makeClassPath(pathString, pathKind);
        }
        catch (IllegalArgumentException iae) {
            String msg = ResourceUtils.format("INCORRECT_PATH_FOR_OPTION", "Incorrect path for option {0}: {1}", option, iae.getMessage());
            throw new IllegalArgumentException(msg);
        }
    }

    private synchronized void reportFileOutput(String filePath) {
        for (FileOutputListener listener : this.fileOutputListeners) {
            listener.outputFile(filePath);
        }
    }

    public synchronized void registerFileOutputListener(FileOutputListener listener) {
        this.fileOutputListeners.add(listener);
    }

    public synchronized void unRegisterFileOutputListener(FileOutputListener listener) {
        this.fileOutputListeners.remove(listener);
    }

    private static String getEncoding(String newEncoding) {
        if (newEncoding == null || newEncoding.equals("null")) {
            return null;
        }
        if (newEncoding.equalsIgnoreCase("default")) {
            String encoding = System.getProperty("file.encoding", "8859_1");
            if (encoding != null && encoding.equals("ISO8859_1")) {
                return null;
            }
            return encoding;
        }
        return newEncoding;
    }

    void checkUnusedJars(boolean checkUnusedJars) {
        this.checkUnusedJars = checkUnusedJars;
    }

    public void setLog(JavaCompilerLog log) {
        this.log = log;
    }

    public void setVerbosePath(boolean verbosePath) {
        this.verbosePath = verbosePath;
    }

    private void checkInterrupt() {
        this.interruptCounter = 0;
        if (Thread.currentThread().isInterrupted()) {
            this.interrupted = true;
        }
    }

    private void logMessage(String message) {
        if (this.verbosePath) {
            if (this.log != null) {
                this.log.println(message);
            } else {
                System.out.println(message);
            }
        }
    }
}

