/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import oracle.javatools.util.Log;
import oracle.jdevimpl.javacompiler.JDevJavaFileManager;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.JavaDependencyProvider;
import oracle.jdevimpl.javacompiler.JavacClassLoader;
import oracle.jdevimpl.javacompiler.JavacCompiler;
import oracle.jdevimpl.javacompiler.LogDiagnosticListener;
import oracle.jdevimpl.javacompiler.ResourceUtils;
import oracle.jdevimpl.javacompiler.StorageJavaFileObject;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;
import oracle.ojc.storage.JarStorage;

public class JDevJavaCompiler {
    private static final Log logger = new Log("JavaCompiler");

    public int compile(JavaCompiler compiler, JavaFileManager javaFileManager, Iterable<? extends JavaFileObject> sources, Iterable<String> options, JavaCompilerLog<? extends JavaFileObject> log) throws IllegalArgumentException {
        return this.compileImpl(compiler, null, javaFileManager, sources, options, log);
    }

    public int compile(File toolsJar, JavaFileManager javaFileManager, Iterable<? extends JavaFileObject> sources, Iterable<String> options, JavaCompilerLog<? extends JavaFileObject> log) {
        return this.compileImpl(null, toolsJar, javaFileManager, sources, options, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compileImpl(JavaCompiler compiler, File toolsJar, JavaFileManager javaFileManager, Iterable<? extends JavaFileObject> sources, Iterable<String> options, JavaCompilerLog<? extends JavaFileObject> log) throws IllegalArgumentException {
        File cdiFile;
        String excludeClasses = null;
        ArrayList<String> trimmedOptions = new ArrayList<String>();
        String cdiFileName = null;
        String encoding = null;
        boolean rebuild = false;
        boolean elapsedTime = false;
        String sourceJDK = null;
        if (options != null) {
            Iterator<String> optionsIterator = options.iterator();
            while (optionsIterator.hasNext()) {
                String option = optionsIterator.next();
                if (option.equals("-exclude")) {
                    if (!optionsIterator.hasNext()) continue;
                    if (excludeClasses == null) {
                        excludeClasses = optionsIterator.next();
                        continue;
                    }
                    if (!excludeClasses.endsWith(File.pathSeparator)) {
                        excludeClasses = excludeClasses + File.pathSeparator;
                    }
                    excludeClasses = excludeClasses + optionsIterator.next();
                    continue;
                }
                if (option.equals("-make")) {
                    if (!optionsIterator.hasNext()) continue;
                    cdiFileName = optionsIterator.next();
                    continue;
                }
                if (option.equals("-encoding")) {
                    trimmedOptions.add(option);
                    if (!optionsIterator.hasNext()) continue;
                    encoding = optionsIterator.next();
                    trimmedOptions.add(encoding);
                    continue;
                }
                if (option.equals("-source")) {
                    trimmedOptions.add(option);
                    if (!optionsIterator.hasNext()) continue;
                    sourceJDK = optionsIterator.next();
                    trimmedOptions.add(sourceJDK);
                    continue;
                }
                if (option.equals("-rebuild")) {
                    rebuild = true;
                    continue;
                }
                if (option.equals("-et")) {
                    elapsedTime = true;
                    continue;
                }
                if (option.equals("-version")) continue;
                trimmedOptions.add(option);
            }
        }
        long currentTime = System.currentTimeMillis();
        JavaDependencyProvider dependencyProvider = new JavaDependencyProvider();
        if (sourceJDK != null) {
            dependencyProvider.setSourceJdk(sourceJDK);
        }
        File file = cdiFile = cdiFileName != null ? new File(cdiFileName) : null;
        if (cdiFile != null) {
            sources = JDevJavaCompiler.checkDependencies(dependencyProvider, cdiFile, sources, rebuild, encoding);
        }
        long cdiTime = System.currentTimeMillis() - currentTime;
        if (!sources.iterator().hasNext()) {
            String msg = ResourceUtils.getString("NOTHING_TO_BUILD", "Nothing to build");
            log.println(msg);
            return 0;
        }
        currentTime = System.currentTimeMillis();
        long compileTime = 0L;
        try {
            int result = this.compileImpl(compiler, toolsJar, log, javaFileManager, trimmedOptions, sources, excludeClasses);
            compileTime = System.currentTimeMillis() - currentTime;
            if (result == 0 && cdiFile != null) {
                try {
                    File dir = cdiFile.getParentFile();
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    dependencyProvider.save(cdiFile);
                }
                catch (IOException e) {
                    String msg = ResourceUtils.format("CANNOT_WRITE_CDI_FILE", "Cannot write cdi file: {0}", cdiFile.getPath());
                    log.error(null, 0L, 0L, 0, msg);
                    result = 1;
                }
            }
            int n = result;
            return n;
        }
        finally {
            if (elapsedTime) {
                System.out.println("Compilation time: " + compileTime + " msec, cdi generation time: " + cdiTime + " msec.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compileImpl(JavaCompiler compiler, File toolsJar, JavaCompilerLog<? extends JavaFileObject> log, JavaFileManager javaFileManager, Iterable<String> options, Iterable<? extends JavaFileObject> sources, String excludeClasses) {
        ClassLoader classLoader;
        int n;
        JavaCompiler.CompilationTask task;
        String msg;
        LogDiagnosticListener diagnosticListener;
        JavaFileManager javaFileManagerToUse;
        ClassLoader contextClassLoader;
        JavacClassLoader javacClassLoader;
        block32: {
            int result;
            NullLog logToUse;
            javacClassLoader = null;
            contextClassLoader = null;
            javaFileManagerToUse = null;
            diagnosticListener = null;
            int count = 0;
            Iterator<? extends JavaFileObject> sourceIterator = sources.iterator();
            while (sourceIterator.hasNext()) {
                ++count;
                sourceIterator.next();
            }
            msg = count == 1 ? ResourceUtils.getString("COMPILING_ONE_SOURCE", "Compiling 1 source") : ResourceUtils.format("COMPILING_COUNT_SOURCES", "Compiling {0} sources", count);
            log.println(msg);
            JavaCompiler compilerToUse = compiler;
            if (compilerToUse == null) {
                if (toolsJar != null) {
                    contextClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Object o;
                        Method method;
                        javacClassLoader = new JavacClassLoader(toolsJar, log.getClass().getClassLoader());
                        Thread.currentThread().setContextClassLoader(javacClassLoader);
                        Class<?> javacTool = javacClassLoader.loadClass("com.sun.tools.javac.api.JavacTool");
                        if (javacTool != null && (method = javacTool.getMethod("create", new Class[0])) != null && (o = method.invoke(null, new Object[0])) != null) {
                            compilerToUse = (JavaCompiler)o;
                            Object javacCompiler = this.getJavacCompiler(javacClassLoader);
                            if (javacCompiler == null || javacCompiler.getClass().getClassLoader() != javacClassLoader) {
                                compilerToUse = null;
                            }
                        }
                        if (compilerToUse == null) {
                            logger.trace("Cannot create JavacTool from tools.jar");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (compilerToUse == null) {
                        this.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
                        javacClassLoader = null;
                        msg = ResourceUtils.getString("CANNOT_USE_JSR199_JAVAC_FROM_TOOLS_JAR", "Cannot use jsr199 Javac from tools.jar");
                        log.warning(null, 0L, 0L, 0, msg);
                    }
                }
                if (compilerToUse == null) {
                    compilerToUse = JavacTool.create();
                }
            }
            if ((logToUse = log) == null) {
                logToUse = new NullLog();
            }
            diagnosticListener = new LogDiagnosticListener(logToUse, null);
            javaFileManagerToUse = javaFileManager;
            if (javaFileManagerToUse == null) {
                javaFileManagerToUse = new JDevJavaFileManager();
            }
            if ((result = this.executeCompileTask(task = compilerToUse.getTask(new LogWriter(logToUse), javaFileManagerToUse, diagnosticListener, options, null, sources), javacClassLoader, excludeClasses, log)) < 0) break block32;
            int n2 = result;
            ClassLoader classLoader2 = this.getClass().getClassLoader();
            ResourceBundle.clearCache(classLoader2);
            this.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
            if (javaFileManager == null) {
                try {
                    javaFileManagerToUse.close();
                    logger.trace("Open jar count = " + JarStorage.getOpenJarCount());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (diagnosticListener != null) {
                diagnosticListener.release();
            }
            return n2;
        }
        try {
            msg = ResourceUtils.getString("CANNOT_USE_JSR199_JAVAC", "Cannot use jsr199 Javac");
            log.warning(null, 0L, 0L, 0, msg);
            n = task.call() == Boolean.TRUE ? 0 : 1;
            classLoader = this.getClass().getClassLoader();
        }
        catch (Throwable t) {
            try {
                JDevJavaCompiler.handleThrownException(t, !(t instanceof IllegalArgumentException), true, "EXCEPTION_THROWN_DURING_COMPILATION", "Exception thrown during compilation: {0}", log);
                int n3 = 1;
                return n3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ClassLoader classLoader3 = this.getClass().getClassLoader();
                ResourceBundle.clearCache(classLoader3);
                this.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
                if (javaFileManager == null) {
                    try {
                        javaFileManagerToUse.close();
                        logger.trace("Open jar count = " + JarStorage.getOpenJarCount());
                    }
                    catch (IOException ioe) {}
                }
                if (diagnosticListener != null) {
                    diagnosticListener.release();
                }
            }
        }
        ResourceBundle.clearCache(classLoader);
        this.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
        if (javaFileManager == null) {
            try {
                javaFileManagerToUse.close();
                logger.trace("Open jar count = " + JarStorage.getOpenJarCount());
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (diagnosticListener != null) {
            diagnosticListener.release();
        }
        return n;
    }

    private void releaseJavacClassLoader(JavacClassLoader javacClassLoader, ClassLoader contextClassLoader) {
        if (javacClassLoader != null) {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            ResourceBundle.clearCache(javacClassLoader);
            JDevJavaCompiler.clearLogManager(javacClassLoader);
            javacClassLoader.release();
        }
    }

    private Object getJavacCompiler(ClassLoader javacClassLoader) throws Exception {
        Class<?> javacCompilerClazz = javacClassLoader.loadClass("oracle.jdevimpl.javacompiler.JavacCompiler");
        Object javacCompiler = null;
        Constructor<?>[] constructors = javacCompilerClazz.getDeclaredConstructors();
        if (constructors != null && constructors.length > 0) {
            javacCompiler = constructors[0].newInstance(new Object[0]);
        }
        return javacCompiler;
    }

    private int executeCompileTask(JavaCompiler.CompilationTask task, ClassLoader javacClassLoader, String excludeClasses, JavaCompilerLog<? extends JavaFileObject> log) throws Exception {
        if (task.getClass().getName().equals("com.sun.tools.javac.api.JavacTaskImpl")) {
            if (javacClassLoader == null) {
                try {
                    JavacCompiler javacCompiler = new JavacCompiler();
                    javacCompiler.doJavacTaskImplCompilation((JavacTaskImpl)task, excludeClasses, false);
                }
                catch (Throwable t) {
                    JDevJavaCompiler.handleThrownException(t, false, log.nerrors() <= 0, "EXCEPTION_THROWN_IN_JAVAC", "Exception thrown in Javac: {0}", log);
                }
                return log.nerrors() > 0 ? 1 : 0;
            }
            Object javacCompiler = this.getJavacCompiler(javacClassLoader);
            if (javacCompiler != null) {
                Method[] methods;
                for (Method method : methods = javacCompiler.getClass().getDeclaredMethods()) {
                    if (!method.getName().equals("doJavacTaskImplCompilation")) continue;
                    try {
                        method.invoke(javacCompiler, task, excludeClasses, false);
                    }
                    catch (Throwable t) {
                        JDevJavaCompiler.handleThrownException(t, false, log.nerrors() <= 0, "EXCEPTION_THROWN_IN_JAVAC_INVOCATION", "Exception thrown in Javac invocation: {0}", log);
                    }
                    return log.nerrors() > 0 ? 1 : 0;
                }
                logger.trace("Cannot find doJavacTaskImplCompilation");
            } else {
                logger.trace("Cannot create oracle.jdevimpl.javacompiler.JavacCompiler");
            }
        } else {
            logger.trace("Not a JavacTaskImpl: " + task.getClass().getName());
        }
        return -1;
    }

    private static void handleThrownException(Throwable t, boolean printStacktrace, boolean emitErrorMessage, String resourceKey, String resourceValue, JavaCompilerLog<? extends JavaFileObject> log) {
        String exceptionMessage;
        if (printStacktrace) {
            t.printStackTrace();
        }
        if ((exceptionMessage = t.getMessage()) == null || exceptionMessage.length() == 0) {
            exceptionMessage = ResourceUtils.getString("UNKNOWN_CAUSE", "Unknown cause");
        }
        String msg = ResourceUtils.format(resourceKey, resourceValue, exceptionMessage);
        logger.trace(msg, (Object)t);
        if (emitErrorMessage) {
            log.error(null, 0L, 0L, 0, msg);
        }
    }

    public StorageJavaFileObject getJavaFileObject(String packageName, Storage storage, String encoding) {
        return new StorageJavaFileObject(packageName, storage, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String[] args) {
        int result;
        String msg;
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<JavaFileObject> sources = new ArrayList<JavaFileObject>();
        String toolsJar = null;
        String[] arguments = args;
        String encoding = null;
        String sourcesAsString = null;
        String packagesAsString = null;
        String sourcePathArgument = null;
        List<? extends Storage> sourcePathList = null;
        ArrayList<String> deployableExtensions = null;
        ArrayList deployables = null;
        String outputPathArgument = null;
        boolean elapsedTime = false;
        boolean checkUnusedJars = false;
        boolean verbosePath = false;
        int index = 0;
        while (index < arguments.length) {
            String argument = arguments[index];
            if (argument.equals("-toolsjar")) {
                if (index == arguments.length - 1) {
                    msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-toolsjar");
                    System.err.println(msg);
                    return 1;
                }
                int n = ++index;
                ++index;
                toolsJar = arguments[n];
                continue;
            }
            if (argument.equals("-sources")) {
                if (index == arguments.length - 1) {
                    msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-sources");
                    System.err.println(msg);
                    return 1;
                }
                int n = ++index;
                ++index;
                sourcesAsString = arguments[n];
                continue;
            }
            if (argument.equals("-p")) {
                if (index == arguments.length - 1) {
                    msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-p");
                    System.err.println(msg);
                    return 1;
                }
                int n = ++index;
                ++index;
                packagesAsString = arguments[n];
                continue;
            }
            if (argument.equals("-deploy")) {
                if (index == arguments.length - 1) {
                    msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-deploy");
                    System.err.println(msg);
                    return 1;
                }
                int n = ++index;
                ++index;
                String deployableExtensionsAsString = arguments[n];
                String[] extensions = deployableExtensionsAsString.split(",");
                deployableExtensions = new ArrayList<String>();
                deployables = new ArrayList();
                for (String extension : extensions) {
                    deployableExtensions.add(extension);
                }
                continue;
            }
            if (argument.equals("-encoding")) {
                if (index == arguments.length - 1) {
                    msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-encoding");
                    System.err.println(msg);
                    return 1;
                }
                int n = ++index;
                ++index;
                encoding = arguments[n];
                options.add("-encoding");
                options.add(encoding);
                continue;
            }
            if (argument.equals("-sourcepath")) {
                if (index == arguments.length - 1) {
                    msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-sourcepath");
                    System.err.println(msg);
                    return 1;
                }
                int n = ++index;
                ++index;
                sourcePathArgument = arguments[n];
                options.add("-sourcepath");
                options.add(sourcePathArgument);
                continue;
            }
            if (argument.equals("-d")) {
                if (index == arguments.length - 1) {
                    msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-d");
                    System.err.println(msg);
                    return 1;
                }
                int n = ++index;
                ++index;
                outputPathArgument = arguments[n];
                options.add("-d");
                options.add(outputPathArgument);
                continue;
            }
            if (argument.charAt(0) == '@') {
                if ((arguments = JDevJavaCompiler.expandFile(arguments, index)) != null) continue;
                return 1;
            }
            if (argument.equals("-et")) {
                elapsedTime = true;
                options.add(arguments[index++]);
                continue;
            }
            if (argument.equals("-unusedjars")) {
                checkUnusedJars = true;
                ++index;
                continue;
            }
            if (argument.equals("-verbose")) {
                verbosePath = true;
                options.add(arguments[index++]);
                continue;
            }
            options.add(arguments[index++]);
        }
        NullLog log = new NullLog();
        if (sourcesAsString != null) {
            String[] sourcesAsArray;
            for (String source : sourcesAsArray = sourcesAsString.split(",")) {
                FileStorage storage = new FileStorage(new File(source));
                sources.add(this.getJavaFileObject(null, (Storage)storage, encoding));
            }
        }
        if (sourcePathArgument != null) {
            try {
                sourcePathList = JDevJavaFileManager.parsePath("-sourcepath", "sourcepath", sourcePathArgument, false, false, null);
            }
            catch (IllegalArgumentException iae) {
                System.err.println(iae.getMessage());
                return 1;
            }
        } else {
            msg = ResourceUtils.format("MISSING_OPTION", "Missing option {0}", "-sourcepath");
            System.err.println(msg);
            return 1;
        }
        if (outputPathArgument == null) {
            msg = ResourceUtils.format("MISSING_OPTION", "Missing option {0}", "-d");
            System.err.println(msg);
            return 1;
        }
        if (packagesAsString != null) {
            String[] packages = packagesAsString.split(",");
            this.addSourcesFromSourcePaths(packages, sourcePathList, deployableExtensions, sources, deployables, encoding, outputPathArgument);
        }
        JDevJavaFileManager javaFileManager = new JDevJavaFileManager();
        javaFileManager.checkUnusedJars(checkUnusedJars);
        javaFileManager.setVerbosePath(verbosePath);
        javaFileManager.setLog(log);
        StorageJavaFileObject.checkUnusedJars = checkUnusedJars;
        try {
            File toolsJarFile = toolsJar != null ? new File(toolsJar) : null;
            result = this.compileImpl(null, toolsJarFile, javaFileManager, sources, options, log);
        }
        finally {
            try {
                if (javaFileManager != null) {
                    javaFileManager.close();
                    javaFileManager = null;
                    logger.trace("Open jar count = " + JarStorage.getOpenJarCount());
                }
            }
            catch (IOException ioe) {}
        }
        if (result == 0 && deployables != null) {
            long currentTime = System.currentTimeMillis();
            HashMap<String, Storage> targetDirMap = new HashMap<String, Storage>();
            int deployCount = 0;
            for (String[] deployable : deployables) {
                boolean error = false;
                File sourceFile = new File(deployable[0]);
                Storage targetDirStorage = (Storage)targetDirMap.get(deployable[1]);
                if (targetDirStorage == null) {
                    File targetDir = new File(deployable[1]);
                    if (!targetDir.exists() && !targetDir.mkdirs()) {
                        error = true;
                    } else {
                        targetDirStorage = new DirectoryStorage(targetDir);
                        targetDirMap.put(deployable[1], targetDirStorage);
                    }
                }
                if (!error) {
                    File targetFile = new File(targetDirStorage.getPath(), sourceFile.getName());
                    if (targetFile.isDirectory()) {
                        error = true;
                    } else if (!targetFile.exists() || sourceFile.lastModified() > targetFile.lastModified()) {
                        if (JDevJavaCompiler.copyFile((Storage)new FileStorage(sourceFile), new FileStorage(targetFile))) {
                            error = true;
                        } else {
                            ++deployCount;
                        }
                    }
                }
                if (!error) continue;
                String msg2 = ResourceUtils.format("CANNOT_COPY_RESOURCE", "Cannot copy resource {0} to {1}", deployable[0], deployable[1]);
                System.err.println(msg2);
                result = 1;
            }
            String msg3 = deployCount == 1 ? ResourceUtils.getString("COPIED_ONE_RESOURCE", "Copied 1 resource") : ResourceUtils.format("COPIED_COUNT_RESOURCES", "Copied {0} resources", deployCount);
            System.out.println(msg3);
            if (elapsedTime) {
                System.out.println("Copy time: " + (System.currentTimeMillis() - currentTime) + " msec");
            }
        }
        StringBuilder errorWarningMsg = new StringBuilder();
        if (log.nerrors() == 1) {
            errorWarningMsg.append(ResourceUtils.getString("ONE_ERROR", "1 error"));
        } else {
            errorWarningMsg.append(ResourceUtils.format("NUMBER_OF_ERRORS", "{0} errors", log.nerrors()));
        }
        errorWarningMsg.append(", ");
        if (log.nwarnings() == 1) {
            errorWarningMsg.append(ResourceUtils.getString("ONE_WARNING", "1 warning"));
        } else {
            errorWarningMsg.append(ResourceUtils.format("NUMBER_OF_WARNINGS", "{0} warnings", log.nwarnings()));
        }
        System.out.println(errorWarningMsg.toString());
        return result;
    }

    public static void main(String[] args) {
        JDevJavaCompiler jdevJavaCompiler = new JDevJavaCompiler();
        int result = jdevJavaCompiler.compile(args);
        ClassLoader classLoader = jdevJavaCompiler.getClass().getClassLoader();
        JDevJavaCompiler.clearLogManager(classLoader);
        System.exit(result);
    }

    private static void clearLogManager(ClassLoader classLoader) {
        try {
            LogManager logManager = LogManager.getLogManager();
            Enumeration<String> loggerNames = logManager.getLoggerNames();
            while (loggerNames.hasMoreElements()) {
                Handler[] handlers;
                Logger logger = logManager.getLogger(loggerNames.nextElement());
                Field catalogField = Logger.class.getDeclaredField("catalog");
                catalogField.setAccessible(true);
                ResourceBundle resourceBundle = (ResourceBundle)catalogField.get(logger);
                if (resourceBundle != null && resourceBundle.getClass().getClassLoader() == classLoader) {
                    catalogField.set(logger, null);
                }
                for (Handler handler : handlers = logger.getHandlers()) {
                    if (handler.getClass().getClassLoader() != classLoader) continue;
                    handler.close();
                    logger.removeHandler(handler);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Iterable<? extends JavaFileObject> checkDependencies(JavaDependencyProvider dependencyProvider, File cdiFile, Iterable<? extends JavaFileObject> sources, boolean rebuild, String encoding) {
        if (cdiFile.exists()) {
            try {
                dependencyProvider.load(cdiFile, false);
            }
            catch (IOException e) {
                dependencyProvider.reinit();
            }
        }
        ArrayList fileList = new ArrayList();
        HashMap<File, JavaFileObject> sourceMap = new HashMap<File, JavaFileObject>();
        for (JavaFileObject javaFileObject : sources) {
            File file = new File(javaFileObject.toUri());
            sourceMap.put(file, javaFileObject);
            fileList.add(file);
        }
        try {
            fileList = dependencyProvider.updateData(fileList, rebuild, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return sources;
        }
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        ArrayList c = rebuild ? fileList : dependencyProvider.getDependants(fileList, true);
        for (Object ofile : c) {
            File file = (File)ofile;
            JavaFileObject source = (JavaFileObject)sourceMap.get(file);
            if (source == null) {
                source = new StorageJavaFileObject(null, (Storage)new FileStorage(file), encoding);
            }
            arrayList.add(source);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(Storage sourceFile, FileStorage targetFile) {
        try {
            sourceFile.open();
            byte[] buffer = sourceFile.read();
            targetFile.write(buffer, 0, buffer.length);
            targetFile.close();
            if (System.getProperty("resetClassTimestampToSource") != null) {
                targetFile.setLastModified(sourceFile.modDate());
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = true;
            return bl;
        }
        finally {
            sourceFile.close();
            targetFile.close();
        }
    }

    private void addSourcesFromSourcePaths(String[] packages, List<? extends Storage> sourcePaths, List<String> deployableExtensions, List<JavaFileObject> sources, List<String[]> deployables, String encoding, String outputPath) {
        for (Storage storage : sourcePaths) {
            block1: for (String packageName : packages) {
                Storage packageStorage = storage;
                if (!packageName.equals(".")) {
                    int lastIndex;
                    packageName = packageName.replace('\\', '/');
                    int firstIndex = 0;
                    do {
                        if ((lastIndex = packageName.indexOf(47, firstIndex)) < 0) {
                            lastIndex = packageName.length();
                        }
                        if ((packageStorage = packageStorage.open(packageName.substring(firstIndex, lastIndex))) == null || !packageStorage.isDirectory()) continue block1;
                    } while ((firstIndex = lastIndex + 1) < packageName.length());
                }
                ArrayList files = packageStorage.listStorage();
                block3: for (int x = 0; x < files.size(); ++x) {
                    Storage file = (Storage)files.get(x);
                    if (file.isDirectory()) continue;
                    if (file.getName().endsWith(".java")) {
                        sources.add(this.getJavaFileObject(null, file, encoding));
                        continue;
                    }
                    if (deployableExtensions == null) continue;
                    for (String extension : deployableExtensions) {
                        if (!file.getName().endsWith(extension)) continue;
                        String sourceLocation = file.getPath();
                        String targetLocation = outputPath + '/' + packageName;
                        deployables.add(new String[]{sourceLocation, targetLocation});
                        continue block3;
                    }
                }
            }
        }
    }

    private static String[] expandFile(String[] argv, int curIndex) {
        try {
            int i;
            String fileName = argv[curIndex].substring(1);
            if (!new File(fileName).exists()) {
                String msg = ResourceUtils.format("FILE_DOES_NOT_EXIST", "Error: file {0} does not exist", fileName);
                System.err.println(msg);
                return null;
            }
            FileInputStream f = new FileInputStream(fileName);
            int fileSize = f.available();
            byte[] buf = new byte[fileSize];
            f.read(buf, 0, fileSize);
            f.close();
            boolean firstChar = false;
            boolean inString = false;
            int argCnt = 0;
            block2: for (i = 0; i < fileSize; ++i) {
                if (buf[i] == 96) {
                    if (i + 1 < fileSize && buf[i + 1] == 10) {
                        buf[i++] = 1;
                        buf[i] = 1;
                        continue;
                    }
                    if (i + 2 < fileSize && buf[i + 1] == 13 && buf[i + 2] == 10) {
                        buf[i++] = 1;
                        buf[i++] = 1;
                        buf[i] = 1;
                        continue;
                    }
                }
                if (!inString && Character.isWhitespace((char)buf[i])) {
                    buf[i] = 0;
                    firstChar = false;
                    continue;
                }
                if (!firstChar) {
                    if (buf[i] == 35) {
                        while (i < fileSize) {
                            byte b = buf[i];
                            buf[i] = 0;
                            if (b == 10) continue block2;
                            ++i;
                        }
                        continue;
                    }
                    firstChar = true;
                    ++argCnt;
                }
                if (buf[i] != 34) continue;
                buf[i] = 0;
                inString = !inString;
            }
            if (argCnt == 0) {
                return argv;
            }
            String[] newArgv = new String[argCnt + argv.length - 1];
            if (curIndex > 0) {
                System.arraycopy(argv, 0, newArgv, 0, curIndex);
            }
            if (curIndex + 1 < argv.length) {
                System.arraycopy(argv, curIndex + 1, newArgv, curIndex + argCnt, argv.length - (curIndex + 1));
            }
            for (i = 0; i < fileSize; ++i) {
                if (buf[i] == 0) continue;
                int len = 0;
                int j = i;
                while (j < fileSize && buf[j] != 0) {
                    if (buf[j++] == 1) continue;
                    ++len;
                }
                byte[] tmpbuf = new byte[len];
                len = 0;
                while (i < fileSize && buf[i] != 0) {
                    if (buf[i] != 1) {
                        tmpbuf[len++] = buf[i];
                    }
                    ++i;
                }
                newArgv[curIndex++] = new String(tmpbuf);
            }
            return newArgv;
        }
        catch (Throwable e) {
            String msg = ResourceUtils.format("ERROR_COLON", "Error: {0}", e.getMessage());
            System.err.println(msg);
            return null;
        }
    }

    private static class NullLog
    implements JavaCompilerLog<JavaFileObject> {
        private int nErrors;
        private int nWarnings;

        private NullLog() {
        }

        @Override
        public void println(String line) {
            System.out.println(line);
        }

        @Override
        public void error(JavaFileObject source, long line, long col, int errNumber, String errMsg) {
            ++this.nErrors;
            String msg = ResourceUtils.format("ERROR_COLON", "Error: {0}", errMsg);
            System.err.println(msg);
        }

        @Override
        public void warning(JavaFileObject source, long line, long col, int warnNumber, String warnMsg) {
            ++this.nWarnings;
            String msg = ResourceUtils.format("WARNING_COLON", "Warning: {0}", warnMsg);
            System.out.println(msg);
        }

        @Override
        public void clear(JavaFileObject source) {
        }

        @Override
        public int nerrors() {
            return this.nErrors;
        }

        @Override
        public int nwarnings() {
            return this.nWarnings;
        }
    }

    private static class LogWriter
    extends Writer {
        private StringBuffer buf = new StringBuffer();
        private JavaCompilerLog<? extends JavaFileObject> log;

        LogWriter(JavaCompilerLog<? extends JavaFileObject> log) {
            this.log = log;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.buf.append(cbuf, off, len);
            if (this.buf.length() > 512) {
                this.flushLines(false);
            }
        }

        private void flushLines(boolean flushAll) {
            String str = this.buf.toString();
            StringTokenizer tokenizer = new StringTokenizer(str, "\n\r", true);
            String lastToken = "";
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    this.log.println(lastToken);
                    lastToken = "";
                    continue;
                }
                if (token.equals("\r")) continue;
                lastToken = token;
            }
            if (flushAll) {
                if (lastToken.length() > 0) {
                    this.log.println(lastToken);
                }
                this.buf.setLength(0);
            } else {
                this.buf.replace(0, this.buf.length(), lastToken);
            }
        }

        @Override
        public void flush() {
            this.flushLines(true);
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

