/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;

class FileReadTextBuffer
implements ReadTextBuffer {
    private char[] buffer;
    private int bufLength;

    FileReadTextBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileReadTextBuffer init(File file, String encoding) {
        InputStreamReader reader = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            reader = encoding == null ? new InputStreamReader(inputStream) : new InputStreamReader((InputStream)inputStream, encoding);
            int available = inputStream.available();
            FileReadTextBuffer res = new FileReadTextBuffer();
            res.buffer = new char[available];
            res.bufLength = reader.read(res.buffer, 0, available);
            FileReadTextBuffer fileReadTextBuffer = res;
            return fileReadTextBuffer;
        }
        catch (Exception e) {
            FileReadTextBuffer fileReadTextBuffer = null;
            return fileReadTextBuffer;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public int getLength() {
        return this.bufLength;
    }

    public char getChar(int offset) throws IndexOutOfBoundsException {
        if (offset < 0 || offset >= this.bufLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[offset];
    }

    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        if (offset + length < 0 || offset + length > this.bufLength) {
            throw new IndexOutOfBoundsException();
        }
        char[] res = new char[length];
        System.arraycopy(this.buffer, offset, res, 0, length);
        return res;
    }

    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        if (offset + length < 0 || offset + length > this.bufLength) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.buffer, offset, length);
    }

    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        if (offset + length < 0 || offset + length > this.bufLength) {
            throw new IndexOutOfBoundsException();
        }
        segment.array = this.buffer;
        segment.offset = offset;
        segment.count = length;
    }

    public void readLock() {
    }

    public boolean tryReadLock() {
        return true;
    }

    public int getLockStatus() {
        return -1;
    }

    public void readUnlock() {
    }
}

