/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm;

import java.io.StringWriter;
import java.sql.Connection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.em_cm.ChangePlansModel;
import oracle.dbtools.em_cm.CmAddin;
import oracle.dbtools.em_cm.CmController;
import oracle.dbtools.em_cm.CmPanel;
import oracle.dbtools.em_cm.CmTableModel;
import oracle.dbtools.em_cm.config.CmConfig;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItem;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.ApplyDiffListener;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.ApplyDiffListenerImpl;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorSettings;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public class CmUtil {
    private static String _dbName;
    private static XMLAccessorSettings xacImpl;

    public static String getXMLFromDoc(XMLDocument xMLDocument) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource dOMSource = new DOMSource((Node)xMLDocument);
            transformer.transform(dOMSource, streamResult);
            String string = streamResult.getWriter().toString();
            return string;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public static XMLAccessorSettings getAccessor() {
        if (xacImpl == null) {
            xacImpl = new XMLAccessorSettings();
        }
        xacImpl.setGenerateConstraintIndexes(CmConfig.getInstance().getBoolean("setGenerateConstraintIndexes").booleanValue());
        xacImpl.setGenerateConstraints(CmConfig.getInstance().getBoolean("setGenerateConstraints").booleanValue());
        xacImpl.setGeneratePasswordValue(CmConfig.getInstance().getBoolean("setGeneratePasswordValue").booleanValue());
        xacImpl.setGenerateRefConstraints(CmConfig.getInstance().getBoolean("setGenerateRefConstraints").booleanValue());
        xacImpl.setGenerateSQLTerminator(CmConfig.getInstance().getBoolean("setGenerateSQLTerminator").booleanValue());
        xacImpl.setIgnorePhysicalAttributes(CmConfig.getInstance().getBoolean("setIgnorePhysicalAttributes").booleanValue());
        xacImpl.setIgnoreSegmentAttributes(CmConfig.getInstance().getBoolean("setIgnoreSegmentAttributes").booleanValue());
        xacImpl.setIgnoreStorage(CmConfig.getInstance().getBoolean("setIgnoreStorage").booleanValue());
        xacImpl.setIgnoreTableColumnPosition(CmConfig.getInstance().getBoolean("setIgnoreTableColumnPosition").booleanValue());
        xacImpl.setIgnoreTablespace(CmConfig.getInstance().getBoolean("setIgnoreTablespace").booleanValue());
        xacImpl.setMatchConstraintsByName(CmConfig.getInstance().getBoolean("setMatchConstraintsByName").booleanValue());
        xacImpl.setReportConstraintNameDifferences(CmConfig.getInstance().getBoolean("setReportConstraintNameDifferences").booleanValue());
        xacImpl.setStatistics(CmConfig.getInstance().getBoolean("setStatistics").booleanValue());
        return xacImpl;
    }

    public static XMLDocument getSXml(CMConnection cMConnection, String string, String string2, String string3) throws Exception {
        XMLAccessor xMLAccessor = null;
        xMLAccessor = XMLAccessor.getXMLAccessorForType((int)XMLAccessor.MDAPITypeToIntType((String)CmUtil.getObjectType(string3)), (XMLAccessorClient)CmUtil.getAccessor());
        xMLAccessor.initFromDatabase(cMConnection, string, string2, true);
        return xMLAccessor.getDocument();
    }

    public static OracleConnection getConnection(String string) throws DBException {
        OracleConnection oracleConnection = string.startsWith("IdeConnections%23") ? (OracleConnection)Connections.getInstance().getConnection(string) : (OracleConnection)Connections.getInstance().getConnection("IdeConnections%23" + string);
        if (oracleConnection == null) {
            _dbName = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), (String)_dbName, (boolean)false);
            oracleConnection = (OracleConnection)Connections.getInstance().getConnection(_dbName);
        }
        return oracleConnection;
    }

    public static ChangeItem GetChangeitem(String string, String string2, String string3, String string4, int n, String string5) throws Exception {
        OracleConnection oracleConnection = CmUtil.getConnection(string);
        CMConnection cMConnection = new CMConnection(oracleConnection);
        XMLDocument xMLDocument = CmUtil.getSXml(cMConnection, string4, string2, CmUtil.getObjectType(string3));
        ChangeItem changeItem = null;
        changeItem = new ChangeItem(n, CmUtil.getObjectType(string3), string2, string4, null, xMLDocument, null, (XMLAccessorClient)CmUtil.getAccessor());
        changeItem.setClientSourceDatabase(Connections.getDisplayName((String)Connections.getInstance().getConnectionName((Connection)oracleConnection)));
        changeItem.setDescription(string5);
        String string6 = DBUtil.getInstance((Connection)oracleConnection).executeReturnOneCol("select global_name from global_name");
        changeItem.setGlobalSourceDatabase(string6);
        return changeItem;
    }

    public static CmPanel getPanel() {
        return (CmPanel)CmAddin.getCmWindow().getGUI();
    }

    public static CmTableModel getTableModel() {
        return CmUtil.getPanel().getTableModel();
    }

    public static ChangePlan getPlan() throws Exception {
        ChangePlanInfo changePlanInfo = ((ChangePlansModel)CmUtil.getPanel().getPlanBox().getModel()).getSelectedInfo();
        return CmAddin.getCpAccess().getOneChangePlan(changePlanInfo.getPlanName(), changePlanInfo.getPlanOwner());
    }

    public static ChangePlanInfo getPlanInfo() {
        return ((CmPanel)CmAddin.getCmWindow().getGUI()).getPlanModel().getSelectedInfo();
    }

    public static void addChangeItem(ChangeItem changeItem, ChangePlan changePlan) throws Exception {
        changePlan.addChangeItem(changeItem);
        CmController.getInstance().getConnection().commit();
        CmUtil.getTableModel().addRow((ChangeItemInfo)changeItem);
        CmUtil.getTableModel().fireTableDataChanged();
    }

    public static void updateItem(ChangeItem changeItem, int n, String string) throws Exception {
        OracleConnection oracleConnection = string == null ? CmUtil.getConnection(changeItem.getClientSourceDatabase()) : CmUtil.getConnection(string);
        CMConnection cMConnection = new CMConnection(oracleConnection);
        int n2 = CmUtil.getTableModel().rowExists(changeItem.getObjectName(), CmUtil.getObjectType(changeItem.getObjectType()), changeItem.getObjectSchema());
        changeItem.convertChangeItem(n, CmUtil.getSXml(cMConnection, changeItem.getObjectSchema(), changeItem.getObjectName(), CmUtil.getObjectType(changeItem.getObjectType())), (XMLAccessorClient)CmUtil.getAccessor());
        changeItem.setClientSourceDatabase(Connections.getDisplayName((String)Connections.getInstance().getConnectionName((Connection)oracleConnection)));
        CmUtil.getPlan().updateChangeItem(changeItem);
        CmController.getInstance().getConnection().commit();
        CmUtil.getPanel().getTableModel().updateRow((ChangeItemInfo)changeItem, n2);
    }

    public static void syncItem(ChangeItem changeItem, String string) throws Exception {
        OracleConnection oracleConnection = string == null ? CmUtil.getConnection(changeItem.getClientSourceDatabase()) : CmUtil.getConnection(string);
        CMConnection cMConnection = new CMConnection(oracleConnection);
        int n = CmUtil.getTableModel().rowExists(changeItem.getObjectName(), CmUtil.getObjectType(changeItem.getObjectType()), changeItem.getObjectSchema());
        ApplyDiffListenerImpl applyDiffListenerImpl = new ApplyDiffListenerImpl();
        applyDiffListenerImpl.setAction(3, 0, CmConfig.getInstance().getBoolean("setConflictExistsDifferent").booleanValue());
        applyDiffListenerImpl.setAction(5, 0, CmConfig.getInstance().getBoolean("setConflictModifiedDifferent").booleanValue());
        applyDiffListenerImpl.setAction(6, 0, CmConfig.getInstance().getBoolean("setConflictModifiedPreviously").booleanValue());
        changeItem.updateDefinition(CmUtil.getSXml(cMConnection, changeItem.getObjectSchema(), changeItem.getObjectName(), CmUtil.getObjectType(changeItem.getObjectType())), (XMLAccessorClient)CmUtil.getAccessor(), (ApplyDiffListener)applyDiffListenerImpl);
        changeItem.setClientSourceDatabase(Connections.getDisplayName((String)Connections.getInstance().getConnectionName((Connection)oracleConnection)));
        CmUtil.getPlan().updateChangeItem(changeItem);
        CmController.getInstance().getConnection().commit();
        CmUtil.getPanel().getTableModel().updateRow((ChangeItemInfo)changeItem, n);
    }

    public static void deleteItem(ChangeItemInfo changeItemInfo) throws Exception {
        CmUtil.getPlan().removeChangeItem(changeItemInfo);
        CmController.getInstance().getConnection().commit();
        CmUtil.getPanel().getTableModel().removeRow(changeItemInfo);
        CmUtil.getPanel().getTableModel().fireTableDataChanged();
    }

    private static String getObjectType(String string) {
        if (string.equals("MATERIALIZED VIEW")) {
            return "MATERIALIZED_VIEW";
        }
        if (string.equals("MATERIALIZED VIEW LOG")) {
            return "MATERIALIZED_VIEW_LOG";
        }
        if (string.equals("PACKAGE")) {
            return "PACKAGE_SPEC";
        }
        if (string.equals("PACKAGE BODY")) {
            return "PACKAGE_BODY";
        }
        return string;
    }
}

