/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.em_cm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.em_cm.CmAddin;
import oracle.dbtools.em_cm.CmAddinArb;
import oracle.dbtools.em_cm.CmPopupAction;
import oracle.dbtools.em_cm.CmUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItem;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangeItemInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlan;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanAccessException;
import oracle.sysman.dbTarget.db.changemgr.emo.cpapi.ChangePlanInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;

public class CmController
implements Controller,
ContextMenuListener,
ActionListener {
    private static CmController _instance;
    public static int DISCONNECT_ACTION;
    public static int ADD_PLAN_ACTION;
    public static int REMOVE_PLAN_ACTION;
    public static int REFRESH_PLAN_ACTION;
    public static int REMOVE_ITEM_ACTION;
    public static int REFRESH_ITEM_ACTION;
    public static int PRE_ACTION;
    public static int POST_ACTION;
    private IdeAction cmDisconnect;
    private IdeAction cmPlanAdd;
    private IdeAction cmPlanRemove;
    private IdeAction cmPlanRefresh;
    private IdeAction cmItemRemove;
    private IdeAction cmItemRefresh;
    private IdeAction cmPre;
    private IdeAction cmPost;
    private JLabel lblPlan = new JLabel();
    private JTextField tfdPlan = new JTextField(40);
    private JEWTDialog actionDialog;
    private Connection _conn;
    private BasicEditorPane _sql;

    private CmController() {
        this.createAction();
    }

    public static synchronized CmController getInstance() {
        if (_instance == null) {
            _instance = new CmController();
        }
        return _instance;
    }

    public Connection getConnection() {
        try {
            return CmUtil.getPanel().getConnection();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
            return null;
        }
    }

    public IdeAction getPlanAddAction() {
        return this.cmPlanAdd;
    }

    public IdeAction getPlanRemAction() {
        return this.cmPlanRemove;
    }

    public IdeAction getPlanRefAction() {
        return this.cmPlanRefresh;
    }

    private void createAction() {
        this.cmDisconnect = IdeAction.get((int)DISCONNECT_ACTION, null, (String)CmAddinArb.getString("DISCONNECT"), null, null, (Icon)RaptorImage.getIcon((String)"libteardown.png"), null, (boolean)true);
        this.cmDisconnect.addController((Controller)this);
        this.cmPlanAdd = IdeAction.get((int)ADD_PLAN_ACTION, null, (String)CmAddinArb.getString("ADD_PLAN"), null, null, (Icon)OracleIcons.getIcon((String)"add.png"), null, (boolean)true);
        this.cmPlanAdd.addController((Controller)this);
        this.cmPlanRemove = IdeAction.get((int)REMOVE_PLAN_ACTION, null, (String)CmAddinArb.getString("REMOVE_PLAN"), null, null, (Icon)OracleIcons.getIcon((String)"delete.png"), null, (boolean)true);
        this.cmPlanRemove.addController((Controller)this);
        this.cmPlanRefresh = IdeAction.get((int)REFRESH_PLAN_ACTION, null, (String)CmAddinArb.getString("REFRESH_PLAN"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this.cmPlanRefresh.addController((Controller)this);
        this.cmItemRefresh = IdeAction.get((int)REFRESH_ITEM_ACTION, null, (String)CmAddinArb.getString("REFRESH_ITEM"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this.cmItemRefresh.addController((Controller)this);
        this.cmItemRemove = IdeAction.get((int)REMOVE_ITEM_ACTION, null, (String)CmAddinArb.getString("REMOVE_ITEM"), null, null, (Icon)OracleIcons.getIcon((String)"delete.png"), null, (boolean)true);
        this.cmItemRemove.addController((Controller)this);
        this.cmPre = IdeAction.get((int)PRE_ACTION, null, (String)CmAddinArb.getString("PRE_LABEL"), null, null, (Icon)RaptorImage.getIcon((String)"pastebefore_ena.png"), null, (boolean)true);
        this.cmPre.addController((Controller)this);
        this.cmPost = IdeAction.get((int)POST_ACTION, null, (String)CmAddinArb.getString("POST_LABEL"), null, null, (Icon)RaptorImage.getIcon((String)"pasteafter_ena.png"), null, (boolean)true);
        this.cmPost.addController((Controller)this);
        this.toggleToolar(false);
    }

    public void installTableToolbar(Toolbar toolbar) {
        Action[] actionArray;
        boolean bl = true;
        for (Action action : actionArray = toolbar.getActions()) {
            if (action != this.cmItemRemove) continue;
            bl = false;
            break;
        }
        if (bl) {
            toolbar.add((ToggleAction)this.cmItemRemove);
            toolbar.add((ToggleAction)this.cmItemRefresh);
        }
    }

    public void installToolbar(Toolbar toolbar) {
        Action[] actionArray;
        boolean bl = true;
        for (Action action : actionArray = toolbar.getActions()) {
            if (action != this.cmDisconnect) continue;
            bl = false;
            break;
        }
        if (bl) {
            toolbar.add((ToggleAction)this.cmDisconnect);
            toolbar.addSeparator();
            toolbar.add((ToggleAction)this.cmPre);
            toolbar.add((ToggleAction)this.cmPost);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == DISCONNECT_ACTION) {
            this.Logout(true);
            return true;
        }
        if (ideAction.getCommandId() == ADD_PLAN_ACTION) {
            this.AddPlanDialog();
            return true;
        }
        if (ideAction.getCommandId() == PRE_ACTION) {
            try {
                String string = CmUtil.getPlan().getPreScript();
                this._sql = EditorFactory.createIdeEditorPane();
                this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
                this._sql.setPreferredSize(new Dimension(300, 200));
                this._sql.setText(string);
                this._sql.setEditable(true);
                JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
                jScrollPane.setPreferredSize(this._sql.getPreferredSize());
                jScrollPane.setSize(jScrollPane.getPreferredSize());
                this.actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)CmAddinArb.getString("PRE_SCRIPT"), (int)10);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                            try {
                                CmUtil.getPlan().setPreScript(CmController.this._sql.getText());
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                        CmController.this.actionDialog.setVisible(false);
                        CmController.this.actionDialog.dispose();
                    }
                };
                this.actionDialog.addActionListener(actionListener);
                this.actionDialog.setSize(this._sql.getPreferredSize());
                this.actionDialog.setPreferredSize(this._sql.getPreferredSize());
                IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.actionDialog);
                this.actionDialog.setVisible(true);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == POST_ACTION) {
            try {
                String string = CmUtil.getPlan().getPostScript();
                this._sql = EditorFactory.createIdeEditorPane();
                this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
                this._sql.setPreferredSize(new Dimension(300, 200));
                this._sql.setText(string);
                this._sql.setEditable(true);
                JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
                jScrollPane.setPreferredSize(this._sql.getPreferredSize());
                jScrollPane.setSize(jScrollPane.getPreferredSize());
                this.actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)CmAddinArb.getString("POST_SCRIPT"), (int)10);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                            try {
                                CmUtil.getPlan().setPostScript(CmController.this._sql.getText());
                            }
                            catch (Exception exception) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            }
                        }
                        CmController.this.actionDialog.setVisible(false);
                        CmController.this.actionDialog.dispose();
                    }
                };
                this.actionDialog.addActionListener(actionListener);
                this.actionDialog.setSize(this._sql.getPreferredSize());
                this.actionDialog.setPreferredSize(this._sql.getPreferredSize());
                IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.actionDialog);
                this.actionDialog.setVisible(true);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == REMOVE_PLAN_ACTION) {
            if (CmUtil.getPlanInfo() == null) {
                return true;
            }
            JLabel jLabel = new JLabel(CmAddinArb.getString("DELETE_PLAN") + CmUtil.getPlanInfo().getPlanName());
            this.actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jLabel, null, (String)CmAddinArb.getString("DELETE_PLAN_TITLE"), (int)10);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                        try {
                            ChangePlanInfo changePlanInfo = CmUtil.getPlanInfo();
                            CmAddin.getCpAccess().removeChangePlan(changePlanInfo.getPlanName(), changePlanInfo.getPlanOwner());
                            CmController.this.getConnection().commit();
                            CmUtil.getPanel().getPlanModel().setSelectedItem(null);
                            CmUtil.getPanel().getPlanModel().removeRow(changePlanInfo);
                            CmUtil.getPanel().getPlanModel().fireContentsChanged(this, 0, CmUtil.getPanel().getPlanModel().getSize());
                            CmUtil.getPanel().getTableModel().clear();
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                    }
                    CmController.this.actionDialog.setVisible(false);
                    CmController.this.actionDialog.dispose();
                }
            };
            this.actionDialog.addActionListener(actionListener);
            this.actionDialog.setSize(400, 100);
            this.actionDialog.setPreferredSize(400, 100);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.actionDialog);
            this.actionDialog.setVisible(true);
            return true;
        }
        if (ideAction.getCommandId() == REFRESH_PLAN_ACTION) {
            try {
                ChangePlanInfo changePlanInfo = CmUtil.getPlanInfo();
                ChangePlanInfo[] changePlanInfoArray = CmAddin.getCpAccess().getChangePlans();
                if (changePlanInfoArray != null && changePlanInfoArray.length > 0) {
                    CmUtil.getPanel().getPlanModel().addList(changePlanInfoArray);
                }
                if (changePlanInfo != null) {
                    CmUtil.getPanel().getPlanModel().setSelectedItem(changePlanInfo);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return true;
        }
        if (ideAction.getCommandId() == REFRESH_ITEM_ACTION) {
            CmUtil.getPanel().loadItemTable(CmUtil.getPlanInfo());
            return true;
        }
        if (ideAction.getCommandId() == REMOVE_ITEM_ACTION) {
            try {
                ChangePlan changePlan = CmUtil.getPlan();
                int n = CmUtil.getPanel().getTable().getSelectedRow();
                ChangeItemInfo changeItemInfo = CmUtil.getTableModel().getRow(n);
                changePlan.removeChangeItem(changeItemInfo);
                CmUtil.getTableModel().removeRow(changeItemInfo);
                this.getConnection().commit();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void AddPlanDialog() {
        String string = CmAddinArb.getString("ADD_PLAN_TITLE");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.lblPlan, (Component)this.tfdPlan, (String)CmAddinArb.getString("PLAN_LABEL"));
        jPanel.add((Component)this.lblPlan, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.tfdPlan, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_cmAddPlan_html");
        this.actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    CmController.this.addPlan();
                }
                CmController.this.actionDialog.setVisible(false);
                CmController.this.actionDialog.dispose();
            }
        };
        this.actionDialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 150;
        this.actionDialog.setSize(n2, n);
        this.actionDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.actionDialog);
        this.actionDialog.setVisible(true);
    }

    private void addPlan() {
        try {
            ChangePlanInfo changePlanInfo = new ChangePlanInfo(this.tfdPlan.getText(), this.getConnection().getMetaData().getUserName());
            CmAddin.getCpAccess().createChangePlan(changePlanInfo);
            this.getConnection().commit();
            CmUtil.getPanel().getPlanModel().addRow(changePlanInfo);
            CmUtil.getPanel().getPlanModel().setSelectedItem(changePlanInfo);
            CmUtil.getPanel().loadItemTable(changePlanInfo);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void toggleToolar(boolean bl) {
        this.cmDisconnect.setEnabled(bl);
        this.cmPlanAdd.setEnabled(bl);
        this.cmPlanRemove.setEnabled(bl);
        this.cmPlanRefresh.setEnabled(bl);
        this.cmPre.setEnabled(bl);
        this.cmPost.setEnabled(bl);
        this.cmItemRefresh.setEnabled(bl);
        this.cmItemRemove.setEnabled(bl);
    }

    public void Login() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(CmAddinArb.getString("LOGIN_TASK_NAME"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                try {
                    Connections connections;
                    CmController.this._conn = CmController.this.getConnection();
                    if (CmController.this._conn == null) {
                        return null;
                    }
                    CmAddin.getCpAccess().login(CmController.this.getConnection());
                    if (CmAddin.getCpAccess().isValidConnection()) {
                        CmController.this.toggleToolar(true);
                        connections = CmAddin.getCpAccess().getChangePlans();
                        if (connections != null && ((ChangePlanInfo[])connections).length > 0) {
                            CmUtil.getPanel().getPlanModel().addList((ChangePlanInfo[])connections);
                        }
                    } else {
                        CmController.this.Logout(true);
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)CmAddinArb.getString("BAD_CONNECTION"), (String)CmAddinArb.getString("BAD_CONNECTION_TITLE"), null);
                    }
                    connections = Connections.getInstance();
                    connections.addConnectionDisconnectListener(new ConnectionDisconnectListener(){

                        public void connectionDisconnected(ConnectionDetails connectionDetails) {
                            if (connectionDetails.getConnection().equals(CmController.this._conn)) {
                                CmController.this.Logout(true);
                            }
                        }

                        public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
                        }
                    });
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    this.setMessage(CmAddinArb.format("RUN_FAILED", exception.getLocalizedMessage()));
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    protected void Logout(boolean bl) {
        try {
            if (this._conn != null) {
                CmAddin.getCpAccess().logout();
                this.toggleToolar(false);
                CmUtil.getPanel().getPlanModel().clearList();
                CmUtil.getPanel().getTableModel().clear();
                if (Connections.getInstance().isConnectionOpen(Connections.getInstance().getConnectionName(this._conn))) {
                    Connections.getInstance().closeConnection(Connections.getInstance().getConnectionName(this._conn));
                }
                this._conn = null;
                if (bl) {
                    CmUtil.getPanel().getConnectionBox().getModel().setSelectedItem(null);
                }
            }
        }
        catch (ChangePlanAccessException changePlanAccessException) {
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Action action;
        int n = -666;
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem && (action = ((JMenuItem)object).getAction()) instanceof CmPopupAction) {
            n = ((CmPopupAction)action).getId();
        }
        if (n == -95) {
            this.deleteItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction());
        } else if (n == 2) {
            this.updateItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction(), 2);
        } else if (n == 1) {
            this.updateItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction(), 1);
        } else if (n == 3) {
            this.updateItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction(), 3);
        } else if (n == 4) {
            this.updateItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction(), 4);
        } else if (n == -90) {
            this.showDDL((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction());
        } else if (n == -99) {
            this.syncItem((CmPopupAction)((JMenuItem)actionEvent.getSource()).getAction());
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, actionEvent.getActionCommand(), actionEvent);
        }
    }

    private void showDDL(CmPopupAction cmPopupAction) {
        String string;
        ChangeItem changeItem = (ChangeItem)cmPopupAction.getValue("ChangeItem");
        this._sql = EditorFactory.createIdeEditorPane();
        this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
        this._sql.setPreferredSize(new Dimension(600, 400));
        try {
            string = changeItem.getDDL((XMLAccessorClient)CmUtil.getAccessor());
        }
        catch (Exception exception) {
            string = exception.getLocalizedMessage();
        }
        this._sql.setText(string);
        this._sql.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
        jScrollPane.setPreferredSize(this._sql.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        this.actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)CmAddinArb.getString("SHOW_DDL_TITLE"), (int)16);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CmController.this.actionDialog.setVisible(false);
                CmController.this.actionDialog.dispose();
            }
        };
        this.actionDialog.addActionListener(actionListener);
        this.actionDialog.setSize(this._sql.getPreferredSize());
        this.actionDialog.setPreferredSize(this._sql.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.actionDialog);
        this.actionDialog.setVisible(true);
    }

    private void updateItem(CmPopupAction cmPopupAction, int n) {
        try {
            ChangeItem changeItem = (ChangeItem)cmPopupAction.getValue("ChangeItem");
            CmUtil.updateItem(changeItem, n, null);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void syncItem(CmPopupAction cmPopupAction) {
        try {
            ChangeItem changeItem = (ChangeItem)cmPopupAction.getValue("ChangeItem");
            CmUtil.syncItem(changeItem, null);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void deleteItem(CmPopupAction cmPopupAction) {
        try {
            ChangeItemInfo changeItemInfo = (ChangeItemInfo)cmPopupAction.getValue("ChangeInfo");
            CmUtil.deleteItem(changeItemInfo);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    static {
        DISCONNECT_ACTION = Ide.findOrCreateCmdID((String)"cm_disconnect");
        ADD_PLAN_ACTION = Ide.findOrCreateCmdID((String)"cm_plan_add");
        REMOVE_PLAN_ACTION = Ide.findOrCreateCmdID((String)"cm_plan_remove");
        REFRESH_PLAN_ACTION = Ide.findOrCreateCmdID((String)"cm_plan_refresh");
        REMOVE_ITEM_ACTION = Ide.findOrCreateCmdID((String)"cm_item_remove");
        REFRESH_ITEM_ACTION = Ide.findOrCreateCmdID((String)"cm_item_refresh");
        PRE_ACTION = Ide.findOrCreateCmdID((String)"cm_pre");
        POST_ACTION = Ide.findOrCreateCmdID((String)"cm_post");
    }
}

