/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ide.model.Attributes;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.ideimpl.db.explorer.resource.ExplorerBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.plsql.data.PlsqlError;

final class PlSqlFolder
extends BaseFolder {
    private DBObjectPlSqlNode m_node;

    public PlSqlFolder(DBObjectPlSqlNode node, Context context) {
        this.m_node = node;
        this.setContext(context);
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    private CodeSection init() {
        PlSqlInterrogator plsInt = this.getInterrogator();
        PlSqlFragment rfrag = plsInt.getRoot();
        CodeSection root = new CodeSection("root", this.getIcon());
        if (rfrag != null) {
            this.buildTreeForFragment(plsInt, plsInt.getRoot(), root);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlSqlInterrogator getInterrogator() {
        PlSqlInterrogator plsInt;
        boolean isBody = this.m_node.isBody();
        boolean online = DBObjectNodeUtil.isOnlineNode((Object)this.m_node);
        boolean dirty = this.m_node instanceof Dirtyable && ((Dirtyable)this.m_node).isDirty();
        PlSql obj = (PlSql)this.m_node.getDBObject();
        if (obj != null && !dirty && !online) {
            plsInt = isBody ? ((SpecPlSql)obj).getBodySourceInterrogator() : obj.getSourceInterrogator();
        } else {
            String source = null;
            TextBuffer textBuffer = this.m_node.acquireTextBuffer();
            if (textBuffer != null) {
                try {
                    source = new String(textBuffer.getChars(0, textBuffer.getLength()));
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to get pl/sql source.", e);
                }
                finally {
                    this.m_node.releaseTextBuffer();
                }
            }
            plsInt = PlSqlInterrogator.findOrCreate(source);
        }
        return plsInt;
    }

    private void buildTreeForFragment(PlSqlInterrogator m_plsInt, PlSqlFragment frag, CodeSection folder) {
        PlSqlFragment childFrag2;
        PlSqlFragment[] arr$;
        int len$;
        int i$;
        int mainCount = 0;
        int pseudoCount = 0;
        int pos = 0;
        CodeSection errorFolder = null;
        if (frag.getParent() != null && frag.getFramentType() != PlSqlFragment.Type.TYPE_ALTER_STATEMENT && frag.getParent().getFramentType() == PlSqlFragment.Type.ROOT && m_plsInt.getPlSqlErrors().length > 0) {
            errorFolder = new CodeSection(ExplorerBundle.get("EXPLORER_ERROR_FOLDER"), OracleIcons.getIcon((String)"folder.png"));
            folder.addChild(errorFolder);
            PlsqlError[] errors = m_plsInt.getPlSqlErrors();
            if (errors.length != 0) {
                for (int i = 0; i < errors.length; ++i) {
                    PlsqlError error = errors[i];
                    if (error == null) continue;
                    errorFolder.addChild(new CodeFragment(error.getErrorMessage(), "", OracleIcons.getIcon((String)"error.png"), error.getStartOffset(), -1));
                }
            }
        }
        CodeSection folderToAddto = folder;
        CodeSection pseudoPackageDecls = null;
        if (frag.getFramentType() == PlSqlFragment.Type.PACKAGE_BODY && (i$ = 0) < (len$ = (arr$ = frag.getChildren()).length) && ((childFrag2 = arr$[i$]).getFramentType() == PlSqlFragment.Type.DECLARATION || childFrag2.getFramentType() == PlSqlFragment.Type.PROCEDURE_FD || childFrag2.getFramentType() == PlSqlFragment.Type.FUNCTION_FD || childFrag2.getFramentType() == PlSqlFragment.Type.PRAGMA)) {
            pseudoPackageDecls = new CodeSection(PlSqlFragment.getTypeString((PlSqlFragment.Type)PlSqlFragment.Type.DECLARE), OracleIcons.getIcon((String)"folder.png"));
            folder.addChild(pseudoPackageDecls);
        }
        for (PlSqlFragment childFrag2 : frag.getChildren()) {
            Icon icon = null;
            folderToAddto = folder;
            pos = mainCount++;
            switch (childFrag2.getFramentType()) {
                case PACKAGE_SPEC: 
                case PACKAGE_BODY: {
                    icon = OracleIcons.getIcon((String)"plsql_package.png");
                    break;
                }
                case PROCEDURE: {
                    icon = OracleIcons.getIcon((String)"plsql_proc.png");
                    break;
                }
                case FUNCTION: {
                    icon = OracleIcons.getIcon((String)"function.png");
                    break;
                }
                case PROCEDURE_FD: {
                    icon = OracleIcons.getIcon((String)"plsql_proc.png");
                    if (pseudoPackageDecls == null) break;
                    folderToAddto = pseudoPackageDecls;
                    pos = pseudoCount++;
                    --mainCount;
                    break;
                }
                case FUNCTION_FD: {
                    icon = OracleIcons.getIcon((String)"function.png");
                    if (pseudoPackageDecls == null) break;
                    folderToAddto = pseudoPackageDecls;
                    pos = pseudoCount++;
                    --mainCount;
                    break;
                }
                case TYPE_SPEC: 
                case TYPE_BODY: {
                    icon = OracleIcons.getIcon((String)"domain.png");
                    break;
                }
                case TRIGGER: 
                case TRIGGER_COLUMNS: 
                case TRIGGER_EVENTS: 
                case TRIGGER_REFERENCING: 
                case TRIGGER_ROW_LEVEL: 
                case TRIGGER_TABLE: 
                case TRIGGER_TIMING: 
                case TRIGGER_WHEN: {
                    icon = OracleIcons.getIcon((String)"trigger.png");
                    break;
                }
                case PARAMETER: {
                    icon = OracleIcons.getIcon((String)"field.png");
                    break;
                }
                case DECLARATION: {
                    icon = OracleIcons.getIcon((String)"field.png");
                    if (pseudoPackageDecls == null) break;
                    folderToAddto = pseudoPackageDecls;
                    pos = pseudoCount++;
                    --mainCount;
                    break;
                }
                case PRAGMA: {
                    if (pseudoPackageDecls == null) break;
                    folderToAddto = pseudoPackageDecls;
                    pos = pseudoCount++;
                    --mainCount;
                    break;
                }
                default: {
                    icon = null;
                }
            }
            if (icon != null && childFrag2.getAlterSubType() != null) {
                PlSqlFragment.AlterSubType subType = childFrag2.getAlterSubType();
                switch (subType) {
                    case ADD_ATTRIBUTE: 
                    case ADD_METHOD: {
                        icon = new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"add.png"));
                        break;
                    }
                    case MODIFY_ATTRIBUTE: {
                        icon = new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"edit.png"));
                        break;
                    }
                    case DROP_ATTRIBUTE: 
                    case DROP_METHOD: {
                        icon = new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"delete.png"));
                    }
                }
            }
            if (childFrag2.getChildren().length > 0) {
                if (icon == null) {
                    icon = OracleIcons.getIcon((String)"folder.png");
                }
                CodeSection childFolder = new CodeSection(childFrag2, icon);
                folderToAddto.addChild(childFolder);
                this.buildTreeForFragment(m_plsInt, childFrag2, childFolder);
                continue;
            }
            if (icon == null) {
                icon = OracleIcons.getIcon((String)"method.png");
            }
            CodeFragment element = new CodeFragment(childFrag2, icon);
            folderToAddto.addChild(element);
        }
    }

    public Icon getIcon() {
        return this.m_node.getIcon();
    }

    public String getLongLabel() {
        return this.m_node.getLongLabel();
    }

    public String getShortLabel() {
        return this.m_node.getShortLabel();
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    @Override
    public Object getKey() {
        return this.m_node;
    }

    @Override
    protected List<Element> createChildren(List<Element> existing) {
        return new ArrayList<Element>(this.init().m_children);
    }

    @Override
    protected void fireMessages(List<Element> removed, List<Element> added) {
        UpdateMessage.fireStructureChanged((Subject)this);
    }

    @Override
    protected boolean shouldThread() {
        return DBObjectNodeUtil.isOnlineNode((Object)this.m_node);
    }

    public class CodeSection
    extends CodeFragment {
        private final Collection<CodeFragment> m_children;

        public CodeSection(String label, Icon icon) {
            super(label, null, icon, -1, -1);
            this.m_children = new ArrayList<CodeFragment>();
        }

        public CodeSection(PlSqlFragment frag, Icon icon) {
            super(frag, icon);
            this.m_children = new ArrayList<CodeFragment>();
        }

        @Override
        public boolean mayHaveChildren() {
            return true;
        }

        public Iterator getChildren() {
            return this.m_children.iterator();
        }

        public void addChild(CodeFragment child) {
            this.m_children.add(child);
        }
    }

    public class CodeFragment
    implements PlSqlFragmentElement {
        private String m_label;
        private String m_tooltip;
        private Icon m_icon;
        private int m_start;
        private int m_end;

        public CodeFragment(PlSqlFragment frag, Icon icon) {
            this(frag.getDescriptionString(), frag.getSourceSnippet(100), icon, frag.getStartOffset(), frag.getEndOffset());
        }

        public CodeFragment(String label, String tooltip, Icon icon, int start, int end) {
            this.m_label = label;
            this.m_tooltip = tooltip == null ? label : tooltip;
            this.m_icon = icon;
            this.m_start = start;
            this.m_end = end;
        }

        @Override
        public int getStartOffset() {
            return this.m_start;
        }

        @Override
        public int getEndOffset() {
            return this.m_end + 1;
        }

        public Attributes getAttributes() {
            return PlSqlFolder.this.getAttributes();
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public String getLongLabel() {
            return null;
        }

        public String getShortLabel() {
            return this.m_label;
        }

        public String getToolTipText() {
            return this.m_tooltip;
        }

        public boolean mayHaveChildren() {
            return false;
        }
    }
}

