/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.resource.ExplorerBundle;

abstract class BaseFolder
implements Element,
Subject,
DBExplorerElement {
    private static ThreadPoolExecutor s_pool;
    private final Collection<Observer> m_observers = new ArrayList<Observer>();
    private final List<Element> m_children = new ArrayList<Element>();
    private boolean m_loaded;
    private final Attributes m_attributes = new ElementAttributes();
    private final Comparator<Element> m_childComparator = new Comparator<Element>(){

        @Override
        public int compare(Element o1, Element o2) {
            return BaseFolder.this.compareChildren(o1, o2);
        }
    };
    private ExplorerModelHelper m_helper;

    BaseFolder() {
    }

    public final void setContext(Context context) {
        this.setHelper(new ExplorerModelHelper(context));
    }

    @Override
    public final void setHelper(ExplorerModelHelper helper) {
        if (helper != null) {
            this.m_helper = helper;
        }
    }

    protected final ExplorerModelHelper getHelper() {
        return this.m_helper;
    }

    @Override
    public void reset() {
        if (this.m_loaded) {
            this.m_loaded = false;
            this.initChildren();
        }
    }

    private synchronized void initChildren() {
        if (!this.m_loaded) {
            this.m_loaded = true;
            if (this.shouldThread()) {
                if (this.m_children.size() == 0) {
                    LoadingElement elem = new LoadingElement();
                    this.m_children.add(elem);
                    UpdateMessage.fireChildAdded((Subject)this, (Element)elem);
                }
                BaseFolder.queue(new Runnable(){

                    @Override
                    public void run() {
                        BaseFolder.this.loadChildren();
                    }
                });
            } else {
                this.loadChildren();
            }
        }
    }

    protected boolean shouldThread() {
        return false;
    }

    protected final int compareChildren(Element o1, Element o2) {
        if (o1.mayHaveChildren()) {
            if (!o2.mayHaveChildren()) {
                return -1000;
            }
        } else if (o2.mayHaveChildren()) {
            return 1000;
        }
        return String.valueOf(o1.getShortLabel()).toUpperCase().compareTo(String.valueOf(o2.getShortLabel()).toUpperCase());
    }

    private void loadChildren() {
        List<Element> newList = this.createChildren(this.m_children);
        Collections.sort(newList, this.m_childComparator);
        final ArrayList<Element> added = new ArrayList<Element>();
        final ArrayList<Element> removed = new ArrayList<Element>(this.m_children);
        for (Element elem : newList) {
            if (elem instanceof DBExplorerElement) {
                ((DBExplorerElement)elem).setHelper(this.getHelper());
            }
            if (!this.contains(this.m_children, elem)) {
                added.add(elem);
                continue;
            }
            if (elem instanceof DBExplorerElement) {
                ((DBExplorerElement)elem).reset();
            }
            removed.remove(elem);
        }
        this.m_children.clear();
        this.m_children.addAll(newList);
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireMessages(removed, added);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseFolder.this.fireMessages(removed, added);
                }
            });
        }
    }

    protected void fireMessages(List<Element> removed, List<Element> added) {
        if (removed.size() > 0) {
            UpdateMessage.fireChildrenRemoved((Subject)this, removed);
        }
        if (added.size() > 0) {
            UpdateMessage.fireChildrenAdded((Subject)this, added);
        }
    }

    private <T> boolean contains(List<? extends T> elems, T elem) {
        boolean retval = false;
        for (T test : elems) {
            if (test != elem) continue;
            retval = true;
            break;
        }
        return retval;
    }

    protected abstract List<Element> createChildren(List<Element> var1);

    public boolean mayHaveChildren() {
        return true;
    }

    public final Iterator<Element> getChildren() {
        this.initChildren();
        return Collections.unmodifiableList(this.m_children).iterator();
    }

    public final int size() {
        this.initChildren();
        return this.m_children.size();
    }

    public void notifyObservers(Object subject, UpdateMessage change) {
        for (Observer o : this.m_observers) {
            o.update(subject, change);
        }
    }

    public void detach(Observer observer) {
        this.m_observers.remove(observer);
    }

    public void attach(Observer observer) {
        this.m_observers.add(observer);
    }

    public final Object getData() {
        return this;
    }

    public final Attributes getAttributes() {
        return this.m_attributes;
    }

    private static final void queue(Runnable r) {
        if (s_pool == null) {
            s_pool = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        if (!s_pool.getQueue().contains(r)) {
            s_pool.execute(r);
        }
    }

    private final class LoadingElement
    extends DefaultElement
    implements DBExplorerElement {
        private LoadingElement() {
        }

        @Override
        public Object getKey() {
            return this;
        }

        @Override
        public void reset() {
        }

        @Override
        public void setHelper(ExplorerModelHelper helper) {
        }

        public String getShortLabel() {
            return ExplorerBundle.format("EXPLORER_PROGRESS_MESSAGE", BaseFolder.this.getShortLabel());
        }

        public String getToolTipText() {
            return this.getShortLabel();
        }
    }
}

