/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.explorer.model.DBObjectFolderFactory;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

abstract class BaseDBObjectExplorer
extends BaseTreeExplorer {
    private Node m_node;
    private Element m_root;
    private final L m_listener = new L();
    private Timer m_timer;

    public void setContext(Context context) {
        super.setContext(context);
        if (context != null && context.getNode() instanceof DBObjectNode) {
            Node node = context.getNode();
            String nodeName = node.getShortLabel();
            if (this.tree != null) {
                AccessibleUtils.updateAccessibleName((Accessible)this.tree, (String)nodeName, (boolean)true);
            }
        }
    }

    protected Element annotate(Context context) {
        Node newNode;
        boolean blank = true;
        Node node = newNode = context == null ? null : context.getNode();
        if (newNode instanceof DBObjectNode) {
            if (this.m_node == newNode) {
                blank = false;
            } else {
                Element root = this.createRootElement((DBObjectNode)newNode, context);
                if (root != null) {
                    blank = false;
                    this.stopObserving();
                    this.m_node = newNode;
                    this.m_root = root;
                    this.stopObserving();
                    this.startObserving();
                    this.expandTree();
                }
            }
        }
        if (blank) {
            this.stopObserving();
            this.m_root = new DefaultFolder();
            this.m_node = null;
        }
        return this.m_root;
    }

    protected Element createRootElement(DBObjectNode newNode, Context context) {
        return DBObjectFolderFactory.createRootFolder(newNode, context);
    }

    private void stopObserving() {
        if (this.m_timer != null) {
            this.m_timer.stop();
        }
        if (this.m_node != null) {
            this.m_node.detach((Observer)this.m_listener);
        }
    }

    private void startObserving() {
        if (this.m_node != null) {
            this.m_node.attach((Observer)this.m_listener);
            if (this.m_node instanceof TextNode) {
                ((TextNode)this.m_node).addTextBufferListener((TextBufferListener)this.m_listener);
            }
        }
    }

    protected boolean updateTreeForMessage(UpdateMessage change) {
        int id = change.getMessageID();
        return id == UpdateMessage.OBJECT_OPENED || id == UpdateMessage.OBJECT_RELOADED || id == UpdateMessage.STRUCTURE_CHANGED;
    }

    private final synchronized void scheduleUpdate() {
        if (this.m_timer == null) {
            ActionListener alist = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (BaseDBObjectExplorer.this.m_node != null && BaseDBObjectExplorer.this.m_node.isOpen()) {
                        BaseDBObjectExplorer.this.update();
                    }
                    if (BaseDBObjectExplorer.this.m_timer != null) {
                        BaseDBObjectExplorer.this.m_timer.stop();
                    }
                }
            };
            this.m_timer = new Timer(500, alist);
            this.m_timer.setRepeats(false);
        }
        this.m_timer.restart();
    }

    protected void update() {
        if (this.m_root != null) {
            DBObjectFolderFactory.update(this.m_root);
        }
    }

    protected int getAutoExpandDepth(Node node) {
        return 2;
    }

    private void expandTree() {
        int depth;
        if (this.tree != null && (depth = this.getAutoExpandDepth(this.m_node)) > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.expandTreeToDepth((JTree)BaseDBObjectExplorer.this.tree, (int)depth);
                }
            });
        }
    }

    private class L
    implements TextBufferListener,
    Observer {
        private L() {
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            BaseDBObjectExplorer.this.scheduleUpdate();
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            BaseDBObjectExplorer.this.scheduleUpdate();
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        public void update(Object observed, UpdateMessage change) {
            if (BaseDBObjectExplorer.this.updateTreeForMessage(change)) {
                BaseDBObjectExplorer.this.scheduleUpdate();
            }
        }
    }
}

