/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import oracle.javatools.util.Log;
import oracle.javatools.util.NamedTimer;
import oracle.javatools.util.SynchronizedQueue;
import oracle.jdevimpl.audit.util.Task;

public class SwingExecutor
implements Runnable {
    private Map lastExecutionMap = new HashMap();
    private NamedTimer pendingQueue;
    private SynchronizedQueue readyQueue = new SynchronizedQueue();
    private volatile Thread thread;

    public synchronized void start() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "AuditExecutor-0");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stop() {
        for (Task task : this.lastExecutionMap.keySet()) {
            this.cancel(task);
        }
        this.lastExecutionMap.clear();
        if (this.pendingQueue != null) {
            this.pendingQueue.cancel();
        }
        this.pendingQueue = null;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task, Object input) {
        Task task2 = task;
        synchronized (task2) {
            Execution execution = new Execution(task, input);
            execution.state = 3;
            Execution lastExecution = this.lastExecutionMap.put(task, execution);
            if (lastExecution != null) {
                execution.committingExecution = lastExecution.committingExecution;
                lastExecution.cancel();
            }
            this.readyQueue.add((Object)execution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task, Object input, long delay) {
        Task task2 = task;
        synchronized (task2) {
            Execution execution = new Execution(task, input);
            execution.state = 1;
            Execution lastExecution = this.lastExecutionMap.put(task, execution);
            if (lastExecution != null) {
                execution.committingExecution = lastExecution.committingExecution;
                lastExecution.cancel();
            }
            if (this.pendingQueue == null) {
                this.pendingQueue = new NamedTimer("AuditTimer");
            }
            this.pendingQueue.schedule((TimerTask)execution, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Task task) {
        if (task == null) {
            return;
        }
        Task task2 = task;
        synchronized (task2) {
            Execution execution = (Execution)this.lastExecutionMap.get(task);
            if (execution != null) {
                execution.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelIfExecuting(Task task) {
        if (task == null) {
            return;
        }
        Task task2 = task;
        synchronized (task2) {
            Execution execution = (Execution)this.lastExecutionMap.get(task);
            if (execution != null && execution.state == 4) {
                execution.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Task task) {
        if (task == null) {
            return;
        }
        Task task2 = task;
        synchronized (task2) {
            Execution execution = (Execution)this.lastExecutionMap.remove(task);
            if (execution != null && execution.state == 4) {
                execution.cancel();
            }
            task.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int i = 0;
            while (this.thread == Thread.currentThread()) {
                block31: {
                    Object input;
                    Task task;
                    Execution execution;
                    Thread.currentThread().setName("AuditExecutor-" + i);
                    try {
                        execution = (Execution)this.readyQueue.remove();
                    }
                    catch (InterruptedException e) {
                        break block31;
                    }
                    Task task2 = task = execution.task;
                    synchronized (task2) {
                        switch (execution.state) {
                            case 3: {
                                execution.state = 4;
                                break;
                            }
                            case 6: {
                                assert (execution.committingExecution == null);
                                if (this.lastExecutionMap.get(task) == execution) {
                                    this.lastExecutionMap.remove(task);
                                }
                                break block31;
                            }
                            default: {
                                throw new IllegalStateException("state " + execution.state);
                            }
                        }
                    }
                    try {
                        Thread.currentThread().setName("AuditExecutor-" + i + "-" + task.getName());
                        input = execution.input;
                        execution.input = null;
                        execution.output = task.execute(input);
                    }
                    catch (Throwable e) {
                        execution.output = e;
                    }
                    finally {
                        input = task;
                        synchronized (input) {
                            if (execution.state == 4) {
                                SwingUtilities.invokeLater(execution);
                            } else if (execution.state == 6 && this.lastExecutionMap.get(task) == this) {
                                this.lastExecutionMap.remove(task);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (Throwable e) {
            Log.error((String)"exception unhandled in swing executor {0}: {1}", (Object)this, (Object)e);
        }
    }

    private class Execution
    extends TimerTask
    implements Runnable {
        private Task task;
        private int state = 0;
        private Object input;
        private Object output;
        private Execution committingExecution;
        private static final int IDLE = 0;
        private static final int DELAYING = 1;
        private static final int HOLDING = 2;
        private static final int READY = 3;
        private static final int EXECUTING = 4;
        private static final int COMMITTING = 5;
        private static final int DONE = 6;

        private Execution(Task task, Object input) {
            this.task = task;
            this.input = input;
        }

        @Override
        public boolean cancel() {
            switch (this.state) {
                case 1: {
                    super.cancel();
                    this.state = 6;
                    this.committingExecution = null;
                    return true;
                }
                case 2: {
                    this.state = 6;
                    this.committingExecution = null;
                    if (SwingExecutor.this.lastExecutionMap.get(this.task) == this) {
                        SwingExecutor.this.lastExecutionMap.remove(this.task);
                    }
                    return true;
                }
                case 3: {
                    this.state = 6;
                    assert (this.committingExecution == null);
                    return true;
                }
                case 4: {
                    this.task.cancelExecute();
                    this.state = 6;
                    assert (this.committingExecution == null);
                    return true;
                }
                case 5: {
                    this.task.cancelCommit();
                    this.state = 6;
                    assert (this.committingExecution == this);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Task task = this.task;
            synchronized (task) {
                if (this.state == 1) {
                    if (this.committingExecution == null) {
                        this.state = 3;
                        SwingExecutor.this.readyQueue.add((Object)this);
                    } else if (this.committingExecution.committingExecution == null) {
                        this.committingExecution = null;
                        this.state = 3;
                        SwingExecutor.this.readyQueue.add((Object)this);
                    } else {
                        this.state = 2;
                    }
                    return;
                }
                if (this.state != 4) {
                    if (this.state == 6) {
                        assert (this.committingExecution == null);
                        if (SwingExecutor.this.lastExecutionMap.get(this.task) == this) {
                            SwingExecutor.this.lastExecutionMap.remove(this.task);
                        }
                        return;
                    }
                    return;
                }
                this.state = 5;
                this.committingExecution = this;
            }
            Object output = this.output;
            this.output = null;
            try {
                this.task.commit(output);
            }
            catch (Throwable e) {
                Log.error((String)"caught exception committing {0}: {1}", (Object)this, (Object)e);
            }
            Task task2 = this.task;
            synchronized (task2) {
                this.committingExecution = null;
                Execution lastExecution = (Execution)SwingExecutor.this.lastExecutionMap.get(this.task);
                if (this.state == 6 && lastExecution.state == 2) {
                    lastExecution.committingExecution = null;
                    lastExecution.state = 3;
                    SwingExecutor.this.readyQueue.add((Object)lastExecution);
                }
                this.state = 6;
                if (lastExecution == this) {
                    SwingExecutor.this.lastExecutionMap.remove(this.task);
                }
            }
        }

        public String toString() {
            return "execution " + this.task.getName();
        }
    }
}

