/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Strings {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private Strings() {
    }

    public static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase();
    }

    public static String capitalizeAll(String string) {
        int count = string.length();
        StringBuffer buffer = new StringBuffer(count);
        boolean whitespace = true;
        for (int i = 0; i < count; ++i) {
            char c = string.charAt(i);
            if (whitespace) {
                c = Character.toUpperCase(c);
            }
            buffer.append(c);
            whitespace = Character.isWhitespace(c);
        }
        return buffer.toString();
    }

    public static String capitalizeAndSeparateAll(String string) {
        int count = string.length();
        StringBuffer buffer = new StringBuffer(count << 1);
        boolean wasWhiteSpace = true;
        boolean wasUpperCase = true;
        for (int i = 0; i < count; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!wasUpperCase) {
                    buffer.append(' ');
                }
                wasUpperCase = true;
            } else {
                if (wasWhiteSpace) {
                    c = Character.toUpperCase(c);
                }
                wasUpperCase = false;
            }
            wasWhiteSpace = Character.isWhitespace(c);
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String decapitalize(String string) {
        int i;
        int count = string.length();
        StringBuffer buffer = new StringBuffer(string);
        for (i = 0; i < count && Character.isUpperCase(string.charAt(i)); ++i) {
        }
        if (i <= 1 || i < count) {
            // empty if block
        }
        while (true) {
            int n = --i;
            --i;
            if (n <= 0) break;
            buffer.setCharAt(i, Character.toLowerCase(buffer.charAt(i)));
        }
        return buffer.toString();
    }

    public static String htmlEscaped(String text) {
        StringBuilder buffer = new StringBuilder(text.length() * 10);
        Strings.appendHtmlEscaped(buffer, text);
        return buffer.toString();
    }

    public static void appendHtmlEscaped(StringBuilder buffer, String text) {
        block8: for (int j = 0; j < text.length(); ++j) {
            char c = text.charAt(j);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    buffer.append("&#039;");
                    continue block8;
                }
                case '\\': {
                    buffer.append("&#092;");
                    continue block8;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block8;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
    }

    public static String fill(char c, int length) {
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String firstLine(String string) {
        int index = string.indexOf(10);
        if (index >= 0) {
            return string.substring(0, index);
        }
        return string;
    }

    public static String remove(String string, String substring) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf(substring);
        if (index < 0) {
            return string;
        }
        if (index == 0) {
            return string.substring(substring.length());
        }
        int i = substring.length();
        return string.substring(0, index) + string.substring(index + i);
    }

    public static String removeAll(String string, String substring) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf(substring);
        if (index < 0) {
            return string;
        }
        if (index == 0) {
            return Strings.removeAll(string.substring(substring.length()), substring);
        }
        int i = substring.length();
        return string.substring(0, index) + Strings.removeAll(string.substring(index + i), substring);
    }

    public static String replace(String string, String substring, String replacement) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf(substring);
        if (index < 0) {
            return string;
        }
        if (index == 0) {
            return replacement + string.substring(substring.length());
        }
        int i = substring.length();
        return string.substring(0, index) + replacement + string.substring(index + i);
    }

    public static String replaceAll(String string, String substring, String replacement) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf(substring);
        if (index < 0) {
            return string;
        }
        if (index == 0) {
            return replacement + Strings.replaceAll(string.substring(substring.length()), substring, replacement);
        }
        int i = substring.length();
        return string.substring(0, index) + replacement + Strings.replaceAll(string.substring(index + i), substring, replacement);
    }

    public static String removePrefix(String string, String prefix) {
        return string.startsWith(prefix) ? string.substring(prefix.length()) : string;
    }

    public static String removeSuffix(String string, String suffix) {
        return string.endsWith(suffix) ? string.substring(0, string.length() - suffix.length()) : string;
    }

    public static String trim(String string, char character) {
        int first;
        int length = string.length();
        int last = length;
        for (first = 0; first < last && string.charAt(first) == character; ++first) {
        }
        while (first < last && string.charAt(last - 1) == character) {
            --last;
        }
        return first > 0 || last < length ? string.substring(first, last) : string;
    }

    public String trim(String string, String characters) {
        int first;
        int length = string.length();
        int last = length;
        for (first = 0; first < last && characters.indexOf(string.charAt(first)) >= 0; ++first) {
        }
        while (first < last && characters.indexOf(string.charAt(last - 1)) >= 0) {
            --last;
        }
        return first > 0 || last < length ? string.substring(first, last) : string;
    }

    public static List<String> tokens(String string, char delimiter) {
        int end;
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        while ((end = string.indexOf(delimiter, start)) >= 0) {
            list.add(string.substring(start, end));
            start = end + 1;
        }
        list.add(string.substring(start));
        return list;
    }

    public static String firstToken(String string, char delimiter) {
        int index = string.indexOf(delimiter);
        if (index < 0) {
            return string;
        }
        return string.substring(0, index);
    }

    public static String firstToken(String string, String delimiters) {
        int count = delimiters.length();
        int index = string.indexOf(delimiters.charAt(0));
        int delimiter = 1;
        while (delimiter < count && index < 0) {
            index = string.indexOf(delimiters.charAt(delimiter++));
        }
        while (delimiter < count) {
            int i;
            if ((i = string.indexOf(delimiters.charAt(delimiter++))) < 0) continue;
            index = Math.min(i, index);
        }
        if (index < 0) {
            return string;
        }
        return string.substring(0, index);
    }

    public static String lastToken(String string, char delimiter) {
        return string.substring(string.lastIndexOf(delimiter) + 1);
    }

    public static String lastToken(String string, String delimiters) {
        int count = delimiters.length();
        int index = string.lastIndexOf(delimiters.charAt(0));
        for (int i = 1; i < count; ++i) {
            index = Math.max(string.lastIndexOf(delimiters.charAt(i)), index);
        }
        return string.substring(index + 1);
    }

    public static boolean wildcardMatch(String string, String pattern) {
        int patternLength = pattern.length();
        int stringLength = string.length();
        int si = 0;
        int pi = 0;
        while (pi < patternLength) {
            switch (pattern.charAt(pi)) {
                case '*': {
                    int need = 0;
                    char c = '\uffffffff';
                    block13: while (++pi < patternLength) {
                        char patternCharacter = pattern.charAt(pi);
                        switch (patternCharacter) {
                            case '*': {
                                continue block13;
                            }
                            case '?': {
                                ++need;
                                continue block13;
                            }
                        }
                        c = patternCharacter;
                        break;
                    }
                    if ((si += need) > stringLength) {
                        return false;
                    }
                    if (c < '\u0000') {
                        return true;
                    }
                    while (string.charAt(si) != c) {
                        if (++si < stringLength) continue;
                        return false;
                    }
                    break;
                }
                case '?': {
                    if (si < stringLength) break;
                    return false;
                }
                case '\\': {
                    if (++pi == patternLength) {
                        throw new IllegalArgumentException("incomplete escape at end of pattern");
                    }
                    switch (pattern.charAt(pi)) {
                        case '*': 
                        case '?': 
                        case '\\': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid escape \"\\" + pattern.charAt(pi) + "\" at index " + pi + " in pattern");
                        }
                    }
                }
                default: {
                    if (si >= stringLength) {
                        return false;
                    }
                    if (pattern.charAt(pi) == string.charAt(si)) break;
                    return false;
                }
            }
            ++pi;
            ++si;
        }
        return si == stringLength;
    }

    public static String toString(Object object) {
        return Strings.append(new StringBuffer(), object).toString();
    }

    public static String toString(String message, Object[] arguments) {
        if (arguments == null) {
            return message;
        }
        StringBuffer buffer = new StringBuffer();
        Strings.append(buffer, message, arguments);
        return buffer.toString();
    }

    public static void append(StringBuffer buffer, String message, Object[] arguments) {
        int length = message.length();
        char[] chars = new char[length + 1];
        message.getChars(0, length, chars, 0);
        chars[length] = '\u0000';
        int i = 0;
        while (true) {
            char c;
            int index;
            char c2;
            int i0 = i;
            do {
                if ((c2 = chars[i++]) != '\u0000') continue;
                buffer.append(chars, i0, i - i0 - 1);
                return;
            } while (c2 != '{' || (index = Character.digit(chars[i], 10)) < 0);
            buffer.append(chars, i0, i - i0 - 1);
            Object argument = index < arguments.length ? arguments[index] : "?";
            Strings.append(buffer, argument);
            do {
                int n = ++i;
                ++i;
                c = chars[n];
                if (c != '\u0000') continue;
                buffer.append('?');
                return;
            } while (c != '}');
        }
    }

    public static StringBuffer append(StringBuffer buffer, Object object) {
        block35: {
            boolean nested = false;
            try {
                if (object == null) {
                    buffer.append("null");
                    break block35;
                }
                if (object.getClass().isArray()) {
                    buffer.append(object.getClass().getComponentType().getName());
                    buffer.append("[]{");
                    nested = true;
                    if (object instanceof Object[]) {
                        Object[] array = (Object[])object;
                        if (array.length > 0) {
                            Strings.append(buffer, array[0]);
                        }
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            Strings.append(buffer, array[i]);
                        }
                    } else if (object instanceof int[]) {
                        int[] array = (int[])object;
                        if (array.length > 0) {
                            buffer.append(array[0]);
                        }
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            buffer.append(array[i]);
                        }
                    } else if (object instanceof char[]) {
                        char[] array = (char[])object;
                        if (array.length > 0) {
                            buffer.append(array[0]);
                        }
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            buffer.append(array[i]);
                        }
                    } else if (object instanceof boolean[]) {
                        boolean[] array = (boolean[])object;
                        if (array.length > 0) {
                            buffer.append(array[0]);
                        }
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            buffer.append(array[i]);
                        }
                    } else if (object instanceof short[]) {
                        short[] array = (short[])object;
                        if (array.length > 0) {
                            buffer.append(array[0]);
                        }
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            buffer.append(array[i]);
                        }
                    } else if (object instanceof long[]) {
                        long[] array = (long[])object;
                        if (array.length > 0) {
                            buffer.append(array[0]);
                        }
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            buffer.append(array[i]);
                        }
                    } else if (object instanceof float[]) {
                        float[] array = (float[])object;
                        if (array.length > 0) {
                            buffer.append(array[0]);
                        }
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            buffer.append(array[i]);
                        }
                    } else if (object instanceof double[]) {
                        double[] array = (double[])object;
                        if (array.length > 0) {
                            buffer.append(array[0]);
                        }
                        for (int i = 1; i < array.length; ++i) {
                            buffer.append(", ");
                            buffer.append(array[i]);
                        }
                    }
                    buffer.append('}');
                    break block35;
                }
                buffer.append(object);
            }
            catch (Throwable t) {
                buffer.append('<').append(t.getMessage()).append('>');
                if (!nested) break block35;
                buffer.append('}');
            }
        }
        return buffer;
    }

    public static class TokenIterator
    implements Iterator {
        private String string;
        private char delimiter;
        private int length;
        private int start;
        private int end;
        private final boolean trim;

        public TokenIterator(String string, char delimiter) {
            this.trim = false;
            this.initialize(string, delimiter);
        }

        public TokenIterator(String string, char delimiter, boolean trim) {
            this.trim = trim;
            this.initialize(string, delimiter);
        }

        public void initialize(String string, char delimiter) {
            this.string = string;
            this.delimiter = delimiter;
            this.length = string.length();
            this.start = 0;
            this.end = -1;
            this.advance();
        }

        private void advance() {
            this.start = this.end + 1;
            this.end = this.string.indexOf(this.delimiter, this.start);
            if (this.end < 0) {
                this.end = this.length;
            }
        }

        @Override
        public boolean hasNext() {
            return this.start <= this.length;
        }

        public Object next() {
            return this.nextToken();
        }

        public String nextToken() {
            if (this.start > this.length) {
                throw new NoSuchElementException();
            }
            String result = this.string.substring(this.start, this.end);
            if (this.trim) {
                result = result.trim();
            }
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

