/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import oracle.jdevimpl.audit.swing.CenterLayout;
import oracle.jdevimpl.audit.swing.FocusBorder;

public class NullablePanel
extends JPanel
implements MouseListener {
    JComponent label;
    JComponent content;
    JComponent nullContent;
    MarginBorder labelMargin = new MarginBorder();
    MarginBorder contentMargin = new MarginBorder();

    public NullablePanel(String labelText, String mnemonic, String nullText, JComponent content) {
        this(NullablePanel.createLabel(labelText, content.getName(), mnemonic), nullText, content);
    }

    private static JLabel createLabel(String labelText, String contentName, String mnemonic) {
        JLabel label = new JLabel(labelText);
        label.setName(contentName + ".panel.label");
        if (mnemonic != null && mnemonic.length() > 0) {
            label.setDisplayedMnemonic(mnemonic.charAt(0));
        }
        return label;
    }

    public NullablePanel(JComponent labelComponent, String nullText, JComponent content) {
        super(new BorderLayout(1, 1));
        this.content = content;
        CompoundBorder border = new CompoundBorder(this.contentMargin, content.getBorder());
        content.setBorder(border);
        this.label = labelComponent;
        if (this.label != null) {
            this.label.setBorder(this.labelMargin);
            this.add((Component)this.label, "North");
        }
        if (nullText != null) {
            JLabel label = new JLabel(nullText);
            label.setName(content.getName() + ".panel.null.label");
            label.setForeground(UIManager.getColor("Label.disabledForeground"));
            label.setFocusable(true);
            label.setBorder(new FocusBorder(2, 0));
            label.addMouseListener(this);
            JPanel nullPanel = new JPanel(new CenterLayout());
            nullPanel.add(label);
            this.nullContent = content instanceof JScrollPane ? new JScrollPane(nullPanel, 21, 31) : nullPanel;
            this.nullContent.setBorder(border);
            this.nullContent.setPreferredSize(content.getPreferredSize());
            this.hideContent();
        } else {
            this.showContent();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.labelMargin.setInsets(top, left, 0, right);
        this.contentMargin.setInsets(0, left, bottom, right);
        this.revalidate();
        this.repaint();
    }

    public void setMargin(Insets insets) {
        this.setMargin(insets.top, insets.left, insets.bottom, insets.right);
    }

    public JComponent getContentComponent() {
        if (this.content instanceof JScrollPane) {
            return (JComponent)((JScrollPane)this.content).getViewport().getView();
        }
        return this.content;
    }

    public void showContent() {
        if (this.nullContent != null) {
            this.remove(this.nullContent);
        }
        if (this.label instanceof JLabel) {
            ((JLabel)this.label).setLabelFor(this.getContentComponent());
        }
        this.add((Component)this.content, "Center");
        this.revalidate();
        this.repaint();
    }

    public void hideContent() {
        if (this.nullContent == null) {
            throw new IllegalArgumentException("no null content");
        }
        this.remove(this.content);
        if (this.label instanceof JLabel) {
            ((JLabel)this.label).setLabelFor(this.nullContent);
        }
        this.add((Component)this.nullContent, "Center");
        this.revalidate();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.getComponent().requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static class MarginBorder
    extends AbstractBorder {
        private int top;
        private int left;
        private int bottom;
        private int right;

        public void setInsets(Insets insets) {
            this.setInsets(insets.top, insets.left, insets.bottom, insets.right);
        }

        public void setInsets(int top, int left, int bottom, int right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = this.top;
            insets.left = this.left;
            insets.bottom = this.bottom;
            insets.right = this.right;
            return insets;
        }
    }
}

