/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import oracle.javatools.util.Log;
import oracle.jdevimpl.audit.swing.CheckBoxTreeModel;

public class CheckBoxTreeCellRenderer
extends JCheckBox
implements TreeCellRenderer,
Icon,
ItemListener {
    private static final Log LOG = new Log("checkboxtree");
    private Boolean state = Boolean.FALSE;
    TreeCellRenderer delegate;
    private Dimension iconSize;
    private JCheckBox halfRenderer;
    private JTree tree;
    private Object value;
    private boolean selected;
    private boolean expanded;
    private boolean leaf;
    private int row;
    private boolean focused;
    private Component delegateComponent;

    public CheckBoxTreeCellRenderer(TreeCellRenderer defaultRenderer) {
        this.setHorizontalAlignment(2);
        this.setBorderPaintedFlat(true);
        this.setFocusPainted(false);
        this.setOpaque(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(null);
        this.setText(null);
        this.iconSize = super.getPreferredSize();
        this.addItemListener(this);
        this.delegate = defaultRenderer;
    }

    @Override
    public void setSelected(boolean selected) {
        Boolean state = selected;
        LOG.trace("setting row {0} selected to {1} in {2}", this.row, (Object)this, (Object)state);
        this.setState(state);
    }

    public Boolean getState() {
        return this.state;
    }

    public void setState(Boolean newState) {
        LOG.trace("setting renderer row {0} state to {1}", this.row, (Object)newState);
        Boolean oldState = this.state;
        if (newState == oldState) {
            return;
        }
        this.state = newState;
        if (newState != null) {
            super.setSelected(newState);
        } else {
            super.setSelected(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        LOG.trace("cell renderer handling item changed {0}", (Object)event);
        this.setSelected(event.getStateChange() == 1);
    }

    public int getCheckBoxWidth() {
        return this.iconSize.width;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
        LOG.trace("getting renderer for row {0} value {1}", row, value);
        this.value = value;
        this.tree = tree;
        this.selected = selected;
        this.expanded = expanded;
        this.leaf = leaf;
        this.row = row;
        this.focused = focused;
        this.setEnabled(tree.isEnabled());
        this.setComponentOrientation(tree.getComponentOrientation());
        TreeModel model = tree.getModel();
        if (model instanceof CheckBoxTreeModel) {
            CheckBoxTreeModel checkboxModel = (CheckBoxTreeModel)model;
            this.getAccessibleContext().setAccessibleName(checkboxModel.convertValueToText(value));
        }
        this.delegateComponent = this.getComponent();
        return this;
    }

    void forwardKeyEvent(KeyEvent event) {
        this.processKeyEvent(event);
    }

    private Component getComponent() {
        String text = null;
        if (this.value != null) {
            text = ((CheckBoxTreeModel)this.tree.getModel()).convertValueToText(this.value);
        }
        LOG.trace("getting renderer component for row {0}, value {1}, text {2}", this.row, this.value, (Object)text);
        Component component = this.delegate.getTreeCellRendererComponent(this.tree, text, this.selected, this.expanded, this.leaf, this.row, this.focused);
        component.setEnabled(this.tree.isEnabled());
        if (component instanceof JLabel) {
            ((JLabel)component).setIcon(this);
        }
        return component;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.delegateComponent.getPreferredSize();
        LOG.trace("getting renderer row {0} preferred size {1}", this.row, (Object)size);
        return size;
    }

    @Override
    public void paint(Graphics graphics) {
        Boolean state = ((CheckBoxTreeModel)this.tree.getModel()).getState(this.value);
        LOG.trace("painting renderer row {0},state {1}, text {2}", this.row, (Object)state, this.value);
        this.setState(state);
        if (state == null) {
            JCheckBox renderer = this.getHalfRenderer();
            renderer.setBackground(this.getBackground());
            renderer.setForeground(this.getForeground());
            renderer.setBounds(this.getBounds());
            renderer.setEnabled(this.isEnabled());
            renderer.paint(graphics);
        } else {
            super.paint(graphics);
        }
        this.delegateComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.delegateComponent.paint(graphics);
    }

    private JCheckBox getHalfRenderer() {
        if (this.halfRenderer == null) {
            this.halfRenderer = new JCheckBox();
            this.halfRenderer.setAlignmentX(this.getAlignmentX());
            this.halfRenderer.setAlignmentY(this.getAlignmentY());
            this.halfRenderer.setBorder(this.getBorder());
            this.halfRenderer.setBorderPainted(this.isBorderPainted());
            this.halfRenderer.setBorderPaintedFlat(this.isBorderPaintedFlat());
            this.halfRenderer.setContentAreaFilled(this.isContentAreaFilled());
            this.halfRenderer.setComponentOrientation(this.getComponentOrientation());
            this.halfRenderer.setHorizontalAlignment(2);
            this.halfRenderer.setHorizontalTextPosition(this.getHorizontalTextPosition());
            this.halfRenderer.setIconTextGap(this.getIconTextGap());
            this.halfRenderer.setMargin(this.getMargin());
            this.halfRenderer.setOpaque(this.isOpaque());
            this.halfRenderer.setVerticalAlignment(this.getVerticalAlignment());
            this.halfRenderer.setVerticalTextPosition(this.getVerticalTextPosition());
            ButtonModel model = this.halfRenderer.getModel();
            model.setArmed(true);
            model.setPressed(true);
            model.setSelected(true);
        }
        return this.halfRenderer;
    }

    @Override
    public int getIconHeight() {
        return this.iconSize.height;
    }

    @Override
    public int getIconWidth() {
        return this.iconSize.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public String toString() {
        return "renderer {row " + this.row + ", value " + this.value + ", state " + this.state + ", selected " + this.isSelected() + "}";
    }
}

