/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.report.AuditReporter;
import oracle.jdevimpl.audit.report.StyleSheet;
import oracle.jdevimpl.audit.report.XMLAuditReporter;

public class XSLTAuditReporter
implements AuditReporter {
    protected URL file;
    protected StyleSheet stylesheet;
    protected String title;
    protected String encoding = IdeUtil.getIdeIanaEncoding();
    private static final FormatBundle bundle = new FormatBundle(AuditBundle.class);
    private static final Log log = new Log("report");

    @Override
    public String getName() {
        return "xslt";
    }

    @Override
    public String getDescription() {
        return bundle.get("report.xslt.description");
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFile(URL file) {
        this.file = file;
    }

    public StyleSheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStyleSheet(StyleSheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void report(Profile profile) throws InvocationTargetException {
    }

    @Override
    public void report(AuditModel model) throws InvocationTargetException {
        URL temporary;
        try {
            temporary = URLFileSystem.createTempFile((String)"audit", (String)".tmp", null);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
        XMLAuditReporter reporter = new XMLAuditReporter();
        reporter.setTitle(this.title);
        reporter.setFile(temporary);
        reporter.setEncoding(this.encoding);
        reporter.report(model);
        BufferedInputStream input = null;
        OutputStream output = null;
        InputStream transform = null;
        try {
            input = new BufferedInputStream(URLFileSystem.openInputStream((URL)temporary));
            transform = new BufferedInputStream(URLFileSystem.openInputStream((URL)this.stylesheet.getUrl()));
            output = this.file != null ? new BufferedOutputStream(URLFileSystem.openOutputStream((URL)this.file)) : new BufferedOutputStream(new StandardOutputStream());
            TransformerFactory factory = TransformerFactory.newInstance();
            StreamSource xsl = new StreamSource(transform);
            Transformer transformer = factory.newTransformer(xsl);
            transformer.setErrorListener(new ThrowingErrorListener());
            StreamSource source = new StreamSource(input);
            source.setSystemId(temporary.toString());
            StreamResult result = new StreamResult(output);
            if (this.file != null) {
                result.setSystemId(this.file.toString());
            }
            transformer.setOutputProperty("encoding", this.encoding);
            transformer.setParameter("newline", XSLTAuditReporter.getLineBreakSequence());
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            log.trace("unexpected exception creating report {0}: {1}", (Object)this.file, (Object)e);
            throw new InvocationTargetException(e);
        }
        finally {
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                if (transform != null) {
                    transform.close();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            URLFileSystem.delete((URL)temporary);
            Node node = NodeFactory.find((URL)this.file);
            if (node != null) {
                try {
                    node.revert();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }

    protected static String getLineBreakSequence() {
        return Ide.getEnvironOptions().getLineBreakSequence();
    }

    protected static class ThrowingErrorListener
    implements ErrorListener {
        protected ThrowingErrorListener() {
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            throw e;
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            throw e;
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            throw e;
        }
    }

    protected static class StandardOutputStream
    extends PrintStream {
        public StandardOutputStream() {
            super(System.out, false);
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

