/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.management.Memory;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.model.ProjectModelAdapter;
import oracle.jdevimpl.audit.report.AuditReporter;

public class XMLAuditReporter
implements AuditReporter {
    protected URL file;
    protected int indent = 2;
    protected String title;
    protected String encoding = IdeUtil.getIdeIanaEncoding();
    protected PrintWriter writer;
    protected String lineBreakSequence;
    private AuditModel model;
    private Map<ModelAdapter, String> models = new LinkedHashMap<ModelAdapter, String>();
    private Map<Category, String> categories = new LinkedHashMap<Category, String>();
    private Map<Rule, String> rules = new LinkedHashMap<Rule, String>();
    private Map<Transform, String> transforms = new LinkedHashMap<Transform, String>();
    private int depth = 0;
    private int nextId = 0;
    private static final Log LOG = new Log("report");
    private static final Log MEMORY_LOG = new Log("memory-statistics", "report");
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);
    public static final String NAMESPACE_PREFIX = "oja";
    protected static final String SCHEMA_URI = "http://xmlns.oracle.com/jdeveloper/1013/audit";
    public static final String DOCUMENT_ROOT = "audit";

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    public String getDescription() {
        return BUNDLE.get("report.xml.description");
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        this.encoding = encoding;
    }

    public void setFile(URL destination) {
        LOG.trace("setting destination to {0}", (Object)destination);
        this.file = destination;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void report(Profile profile) throws InvocationTargetException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(AuditModel model) throws InvocationTargetException {
        this.printRunningStatistics("reporting to {0}", this.file);
        this.model = model;
        try {
            LOG.trace("creating output stream {0}", (Object)this.file);
            BufferedOutputStream output = this.file == null ? new BufferedOutputStream(new StandardOutputStream()) : new BufferedOutputStream(URLFileSystem.openOutputStream((URL)this.file));
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)output, this.encoding)));
            this.lineBreakSequence = XMLAuditReporter.getLineBreakSequence();
            this.writeLine("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" standalone=\"yes\"?>");
            this.writeLine("<!DOCTYPE audit [");
            ++this.depth;
            this.writeLine("<!ATTLIST category id ID #REQUIRED>");
            this.writeLine("<!ATTLIST column id ID #REQUIRED>");
            this.writeLine("<!ATTLIST construct id ID #REQUIRED parent IDREF #REQUIRED root (false|true) \"false\">");
            this.writeLine("<!ATTLIST model id ID #REQUIRED>");
            this.writeLine("<!ATTLIST location model IDREF #REQUIRED>");
            this.writeLine("<!ATTLIST rule id ID #REQUIRED category IDREF #REQUIRED>");
            this.writeLine("<!ATTLIST transform id ID #REQUIRED>");
            this.writeLine("<!ATTLIST transform-applied transform IDREF #REQUIRED>");
            this.writeLine("<!ATTLIST value column IDREF #REQUIRED over-threshold (false|true) \"false\">");
            this.writeLine("<!ATTLIST violation rule IDREF #REQUIRED parent IDREF #REQUIRED>");
            --this.depth;
            this.writeLine("]>");
            this.newline();
            this.collect(model.getRoot());
            this.writeBeginTag(DOCUMENT_ROOT, new String[]{"xmlns", SCHEMA_URI}, false, true);
            String title = this.title;
            if (title == null) {
                Object name;
                List<Location> locations = model.getLocations();
                if (locations.size() == 1) {
                    Location location = locations.get(0);
                    ModelAdapter adapter = location.getModel();
                    adapter.beginRead();
                    try {
                        name = adapter.label(location);
                    }
                    finally {
                        adapter.endRead();
                    }
                } else {
                    name = BUNDLE.get("report.multiple.selection.label");
                }
                title = BUNDLE.get("report.audit.default-title", new Object[]{name});
            }
            this.writeTextElement("title", title);
            this.writeStatistics();
            this.writeLocations();
            this.writeProfile();
            this.writeColumns();
            this.writeModels();
            this.writeCategories();
            this.writeRules();
            this.writeTransforms();
            this.writeConstruct(null, this.model.getRoot(), null, false);
            this.writeEndTag(DOCUMENT_ROOT);
        }
        catch (Throwable e) {
            LOG.trace("unexpected exception creating report {0}: {1}", (Object)this.file, (Object)e);
            throw new InvocationTargetException(e);
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        Node node = NodeFactory.find((URL)this.file);
        if (node != null) {
            try {
                node.revert();
            }
            catch (IOException e) {
                LOG.trace("unexpected exception reverting report {0}: {1}", (Object)this.file, (Object)e);
                throw new InvocationTargetException(e);
            }
        }
    }

    private void collect(Object object) {
        Violation violation = this.model.getViolation(object);
        if (violation == null) {
            ModelAdapter model = this.model.getLocation(object).getModel();
            if (!this.models.containsKey(model)) {
                this.models.put(model, "d" + this.models.size());
            }
            for (Object child : this.model.getVisibleChildren(object)) {
                this.collect(child);
            }
        } else {
            Rule rule = violation.getRule();
            Category category = rule.category();
            if (!this.categories.containsKey(category)) {
                this.categories.put(category, "c" + this.categories.size());
            }
            if (!this.rules.containsKey(rule)) {
                this.rules.put(rule, "r" + this.rules.size());
            }
            for (Transform transform : this.model.getTransformsApplied(violation)) {
                if (this.transforms.containsKey(transform)) continue;
                this.transforms.put(transform, "t" + this.transforms.size());
            }
        }
    }

    private void writeStatistics() {
        Object root = this.model.getRoot();
        int fileCount = this.model.getCount(root, AuditModel.Count.VISIBLE_FILES);
        int exceptionCount = this.model.getCount(root, AuditModel.Count.VISIBLE_OUT_OF_BANDS);
        int errorCount = this.model.getCount(root, AuditModel.Count.VISIBLE_ERRORS);
        int warningCount = this.model.getCount(root, AuditModel.Count.VISIBLE_WARNINGS);
        int incompleteCount = this.model.getCount(root, AuditModel.Count.VISIBLE_INCOMPLETES);
        int advisoryCount = this.model.getCount(root, AuditModel.Count.VISIBLE_ADVISORIES);
        this.writeTextElement("model-count", String.valueOf(fileCount));
        this.writeTextElement("violation-count", String.valueOf(errorCount + warningCount + incompleteCount + advisoryCount));
        this.writeTextElement("exception-count", String.valueOf(exceptionCount));
        this.writeTextElement("error-count", String.valueOf(errorCount));
        this.writeTextElement("warning-count", String.valueOf(warningCount));
        this.writeTextElement("incomplete-count", String.valueOf(incompleteCount));
        this.writeTextElement("advisory-count", String.valueOf(advisoryCount));
    }

    private void writeModels() {
        this.writeBeginTag("models");
        for (Map.Entry<ModelAdapter, String> entry : this.models.entrySet()) {
            ModelAdapter model = entry.getKey();
            String id = entry.getValue();
            this.writeBeginTag("model", new String[]{"id", id}, false, true);
            this.writeFile(model.getUrl());
            this.writePackage(model.getDirectory());
            this.writeProject(model.getProject());
            this.writeWorkspace(model.getWorkspace());
            this.writeTextElement("label", model.getShortLabel());
            this.writeEndTag("model");
        }
        this.writeEndTag("models");
    }

    private void writeFile(URL url) {
        if (url != null) {
            this.writeBeginTag("file");
            this.writeTextElement("url", url);
            this.writeTextElement("path", URLFileSystem.getPlatformPathName((URL)url));
            this.writeEndTag("file");
        }
    }

    private void writePackage(ContentDirectory packag) {
        if (packag != null) {
            this.writeTextElement("package", packag.getRelativePath().replace('/', '.'));
        }
    }

    private void writeProject(Project project) {
        if (project != null) {
            this.writeBeginTag("project");
            this.writeTextElement("label", project.getShortLabel());
            this.writeFile(project.getURL());
            this.writeEndTag("project");
        }
    }

    private void writeWorkspace(Workspace workspace) {
        if (workspace != null) {
            this.writeBeginTag("workspace");
            this.writeTextElement("label", workspace.getShortLabel());
            this.writeFile(workspace.getURL());
            this.writeEndTag("workspace");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLocations() {
        this.writeBeginTag("locations");
        for (Location location : this.model.getLocations()) {
            location.getModel().beginRead();
            try {
                this.writeLocation(location);
            }
            finally {
                location.getModel().endRead();
            }
        }
        this.writeEndTag("locations");
    }

    private void writeLocation(Location location) {
        ModelAdapter model = location.getModel();
        String modelId = this.models.get(model);
        this.writeBeginTag("location", new String[]{"model", modelId}, false, true);
        int offset = location.getOffset();
        this.writeTextElement("offset", String.valueOf(offset));
        this.writeTextElement("length", String.valueOf(location.getLength()));
        this.writeTextElement("line-number", String.valueOf(model.getLineOffset(offset) + 1));
        this.writeTextElement("column-offset", String.valueOf(model.getColumnOffset(offset)));
        this.writeEndTag("location");
    }

    private void writeProfile() {
        this.writeBeginTag("profile");
        this.writeTextElement("name", this.model.getProfile().getName());
        this.writeFile(this.model.getProfile().getURL());
        this.writeEndTag("profile");
    }

    private void writeColumns() {
        this.writeBeginTag("columns");
        int size = this.model.getColumnCount();
        for (int i = 1; i < size; ++i) {
            Metric column = this.model.getColumn(i);
            String label = column.labelOrId();
            String description = column.description();
            this.writeBeginTag("column", new String[]{"id", "a" + i}, false, true);
            this.writeTextElement("name", column.id());
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeTextElement("type", column.getType());
            this.writeTextElement("threshold", column.getThreshold());
            this.writeEndTag("column");
        }
        this.writeEndTag("columns");
    }

    private void writeCategories() {
        this.writeBeginTag("categories");
        for (Map.Entry<Category, String> entry : this.categories.entrySet()) {
            Category category = entry.getKey();
            String id = entry.getValue();
            String name = category.id();
            String label = category.labelOrId();
            String description = category.description();
            this.writeBeginTag("category", new String[]{"id", id}, false, true);
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeEndTag("category");
        }
        this.writeEndTag("categories");
    }

    private void writeRules() {
        this.writeBeginTag("rules");
        for (Map.Entry<Rule, String> entry : this.rules.entrySet()) {
            Rule rule = entry.getKey();
            String id = entry.getValue();
            String cid = this.categories.get(rule.category());
            this.writeBeginTag("rule", new String[]{"id", id, "category", cid}, false, true);
            String name = rule.id();
            String label = rule.labelOrId();
            String description = rule.description();
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeTextElement("severity", rule.getSeverity());
            this.writeEndTag("rule");
        }
        this.writeEndTag("rules");
    }

    private void writeTransforms() {
        this.writeBeginTag("transforms");
        for (Map.Entry<Transform, String> entry : this.transforms.entrySet()) {
            Transform transform = entry.getKey();
            String id = entry.getValue();
            String name = transform.id();
            String label = transform.labelOrId();
            String description = transform.description();
            this.writeBeginTag("transform", new String[]{"id", id}, false, true);
            this.writeTextElement("name", name);
            this.writeTextElement("label", label);
            this.writeTextElement("description", description);
            this.writeEndTag("transform");
        }
        this.writeEndTag("transforms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeConstruct(String parentId, Object object, ModelAdapter lockedModel, boolean activeNodeUsageCycle) {
        boolean modelEntered;
        LOG.trace("writing construct {0}", object);
        Location location = this.model.getLocation(object);
        ModelAdapter currentModel = location.getModel();
        boolean bl = modelEntered = currentModel != lockedModel;
        if (modelEntered) {
            if (currentModel instanceof ProjectModelAdapter) {
                this.printRunningStatistics("starting {0}", currentModel);
                Node.beginThreadNodeUsageCycle();
                activeNodeUsageCycle = true;
            }
            currentModel.beginRead();
            lockedModel = currentModel;
        }
        try {
            Violation violation = this.model.getViolation(object);
            if (violation == null) {
                Displayable displayable = this.model.getDisplayable(object);
                String id = "o" + this.nextId++;
                String[] attributes = parentId == null ? new String[]{"id", id, "parent", id, "root", "true"} : new String[]{"id", id, "parent", parentId};
                this.writeBeginTag("construct", attributes, false, true);
                this.writeLocation(location);
                Class<?> type = this.model.getType(object);
                this.writeTextElement("type", type);
                this.writeTextElement("kind", currentModel.getType().label(type));
                this.writeTextElement("name", displayable.getToolTipText());
                this.writeTextElement("label", displayable.getShortLabel());
                this.writeValues(object, this.model);
                this.writeBeginTag("children");
                for (Object child : this.model.getVisibleChildren(object)) {
                    this.writeConstruct(id, child, lockedModel, activeNodeUsageCycle);
                }
                this.writeEndTag("children");
                this.writeEndTag("construct");
            } else {
                this.writeViolation(parentId, object, violation);
            }
            if (!modelEntered) return;
            currentModel.endRead();
            if (!activeNodeUsageCycle) return;
        }
        catch (Throwable throwable) {
            if (!modelEntered) throw throwable;
            currentModel.endRead();
            if (!activeNodeUsageCycle) throw throwable;
            if (currentModel instanceof ProjectModelAdapter) {
                this.printRunningStatistics("ending {0}", currentModel);
                Node.endThreadNodeUsageCycle();
                if (Ide.getIdeArgs().getCreateUI()) throw throwable;
                try {
                    currentModel.getProject().close();
                    throw throwable;
                }
                catch (IOException e) {
                    AuditLogger.error("Unexpected exception closing {0}: {1}", e, currentModel, e);
                }
                throw throwable;
            } else {
                Node.endThreadNodeUsage((Node)currentModel.getNode());
            }
            throw throwable;
        }
        if (currentModel instanceof ProjectModelAdapter) {
            this.printRunningStatistics("ending {0}", currentModel);
            Node.endThreadNodeUsageCycle();
            if (Ide.getIdeArgs().getCreateUI()) return;
            try {
                currentModel.getProject().close();
                return;
            }
            catch (IOException e) {
                AuditLogger.error("Unexpected exception closing {0}: {1}", e, currentModel, e);
            }
            return;
        } else {
            Node.endThreadNodeUsage((Node)currentModel.getNode());
        }
    }

    private void writeViolation(String parentId, Object object, Violation violation) {
        LOG.trace("writing violation {0}", object);
        String rid = this.rules.get(violation.getRule());
        this.writeBeginTag("violation", new String[]{"parent", parentId, "rule", rid}, false, true);
        this.writeLocation(this.model.getLocation(object));
        this.writeTextElement("message", this.model.getDisplayable(object).getShortLabel());
        this.writeValues(object, this.model);
        this.writeTransformsApplied(object, this.model);
        this.writeEndTag("violation");
    }

    protected void writeValues(Object object, AuditModel model) {
        this.writeBeginTag("values");
        int size = model.getColumnCount();
        for (int i = 1; i < size; ++i) {
            String[] attributes = model.isOutOfBand(object, i) ? new String[]{"column", "a" + i, "over-threshold", "true"} : new String[]{"column", "a" + i};
            this.writeTextElement("value", attributes, model.getValue(object, i));
        }
        this.writeEndTag("values");
    }

    protected void writeTransformsApplied(Object object, AuditModel model) {
        this.writeBeginTag("transforms-applied");
        for (Transform transform : model.getTransformsApplied(model.getViolation(object))) {
            String tid = this.transforms.get(transform);
            this.writeBeginTag("transform-applied", new String[]{"transform", tid}, true, true);
        }
        this.writeEndTag("transforms-applied");
    }

    protected void writeTextElement(String name, Object object) {
        this.writeTextElement(name, null, object);
    }

    protected void writeTextElement(String name, String[] attributes, Object object) {
        String text;
        String string = text = object != null ? String.valueOf(object) : "";
        if ("".equals(text)) {
            this.writeBeginTag(name, attributes, true, true);
        } else {
            this.writeBeginTag(name, attributes, false, false);
            this.writeText(text);
            this.writeEndTag(name, false);
        }
    }

    protected void writeText(String text) {
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    this.writer.write("&lt;");
                    continue block4;
                }
                case '&': {
                    this.writer.write("&amp;");
                    continue block4;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
    }

    protected void writeBeginTag(String name) {
        this.writeBeginTag(name, null, false, true);
    }

    protected void writeBeginTag(String name, String[] attributes, boolean empty, boolean wrap) {
        this.writeIndent();
        this.writer.print('<');
        this.writeName(name);
        if (attributes != null) {
            for (int i = 0; i < attributes.length; i += 2) {
                this.writer.print(' ');
                this.writer.print(attributes[i]);
                this.writer.print("=\"");
                this.writer.print(attributes[i + 1]);
                this.writer.print('\"');
            }
        }
        if (empty) {
            this.writer.print('/');
        }
        this.writer.print('>');
        if (wrap) {
            this.newline();
        }
        if (!empty) {
            ++this.depth;
        }
    }

    protected void writeEndTag(String name) {
        this.writeEndTag(name, true);
    }

    protected void writeEndTag(String name, boolean indent) {
        --this.depth;
        if (indent) {
            this.writeIndent();
        }
        this.writer.print("</");
        this.writeName(name);
        this.writer.print('>');
        this.newline();
    }

    protected void writeName(String name) {
        this.writer.print(name);
    }

    protected void writeIndent() {
        int count = this.depth * this.indent;
        while (count-- > 0) {
            this.writer.write(32);
        }
    }

    protected void writeLine(String text) {
        this.writeIndent();
        this.writer.print(text);
        this.newline();
    }

    protected void newline() {
        this.writer.write(this.lineBreakSequence);
    }

    protected static String getLineBreakSequence() {
        return Ide.getEnvironOptions().getLineBreakSequence();
    }

    private void printRunningStatistics(String message, Object ... arguments) {
        if (MEMORY_LOG.isEnabled()) {
            String EOL = System.getProperty("line.separator");
            StringBuilder openNodes = new StringBuilder(EOL);
            Iterator i = NodeFactory.getOpenNodes();
            while (i.hasNext()) {
                openNodes.append("  ");
                openNodes.append(((Node)i.next()).getLongLabel());
                openNodes.append(EOL);
            }
            MEMORY_LOG.trace("{0}: {1} nodes, {2} open nodes:{3}{4}{5}", new Object[]{Log.format((String)message, (Object[])arguments), NodeFactory.getCachedNodeCount(), NodeFactory.getOpenNodeCount(), openNodes, Memory.summary(), EOL});
        }
    }

    class StandardOutputStream
    extends PrintStream {
        public StandardOutputStream() {
            super(System.out, false);
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

