/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Assist;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.swing.AbstractTreeModel;
import oracle.jdevimpl.audit.swing.CheckBoxTreeModel;

public class ProfileTreeModel
extends AbstractTreeModel
implements CheckBoxTreeModel,
PropertyChangeListener {
    private RootNode root;
    private static final Log LOG = new Log("profile", "profile-detail");
    private static final Log LOG_DETAIL = new Log("profile-detail");

    public ProfileTreeModel(ProfileModel model, Class filterType) {
        this.root = new RootNode(this, model);
        boolean rules = Rule.class == filterType;
        boolean assists = Assist.class == filterType;
        boolean metrics = Metric.class == filterType;
        HashMap<String, BranchNode> categories = new HashMap<String, BranchNode>();
        for (ExtensionBean bean : model.getBeans()) {
            Category category;
            boolean assist = bean instanceof Assist;
            if (assists && assist) {
                category = ((Assist)bean).category();
            } else if (rules && !assist && bean instanceof Rule) {
                category = ((Rule)bean).category();
            } else {
                if (!metrics || !(bean instanceof Metric)) continue;
                category = ((Metric)bean).getCategory();
            }
            BranchNode parentNode = this.getParentNode(category, categories);
            parentNode.add(new LeafNode(bean.id(), parentNode));
        }
        model.addPropertyChangeListener(this);
    }

    private BranchNode getParentNode(Category category, Map<String, BranchNode> categories) {
        if (category == null) {
            return this.root;
        }
        String id = category.id();
        BranchNode node = categories.get(id);
        if (node == null) {
            BranchNode parentNode = this.getParentNode(category.getCategory(), categories);
            node = new BranchNode(id, parentNode);
            parentNode.add(node);
            categories.put(id, node);
        }
        return node;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((BeanNode)parent).getChildren().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((BeanNode)parent).getChildren().size();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((BeanNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void stateForPathChanged(TreePath path, Boolean newState) {
        BeanNode node = (BeanNode)path.getLastPathComponent();
        LOG.trace("state for {0} changed to {1}", (Object)node, (Object)newState);
        node.setState(newState);
        TreePath parentPath = path.getParentPath();
        BranchNode parent = node.getParent();
        do {
            this.fireTreeNodesChanged(this, parentPath.getPath(), new int[]{parent.indexOf(node)}, new Object[]{node});
            node = parent;
            parent = parent.getParent();
            parentPath = parentPath.getParentPath();
        } while (parent != null);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((BeanNode)parent).indexOf((BeanNode)child);
    }

    public void addPropertyChangeListener(Object object, PropertyChangeListener listener) {
        ((BeanNode)object).addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(Object object, PropertyChangeListener listener) {
        ((BeanNode)object).removePropertyChangeListener(listener);
    }

    @Override
    public Boolean getState(Object object) {
        return ((BeanNode)object).getState();
    }

    public ExtensionBean getBean(Object object) {
        return ((BeanNode)object).getBean();
    }

    public String getDescription(Object object) {
        return ((BeanNode)object).getDescription();
    }

    @Override
    public String convertValueToText(Object value) {
        BeanNode bean = (BeanNode)value;
        String text = bean.getText();
        if (bean.isModified()) {
            return "<html><i>" + text + "</i></html>";
        }
        return text;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        assert (LOG.trace("handling property '{0}:{1}' in {2} changed", event.getSource(), (Object)event.getPropertyName(), (Object)this));
        ExtensionBean bean = (ExtensionBean)event.getSource();
        if (bean instanceof Rule) {
            this.fireTreeNodeChanged(((Rule)bean).category(), bean);
        } else if (bean instanceof Metric) {
            this.fireTreeNodeChanged(((Metric)bean).getCategory(), bean);
        } else if (bean instanceof Category) {
            this.fireTreeNodeChanged(((Category)bean).getCategory(), bean);
        }
    }

    private TreePath fireTreeNodeChanged(Category category, ExtensionBean bean) {
        TreePath parentPath = category == null ? new TreePath(this.root) : this.fireTreeNodeChanged(category.getCategory(), category);
        if (parentPath == null) {
            return null;
        }
        BeanNode parent = (BeanNode)parentPath.getLastPathComponent();
        BeanNode child = parent.getChild(bean.id());
        if (child == null) {
            return null;
        }
        this.fireTreeNodesChanged(this, parentPath.getPath(), new int[]{parent.indexOf(child)}, new Object[]{child});
        return parentPath.pathByAddingChild(child);
    }

    private static class LeafNode
    extends BeanNode {
        public LeafNode(String name, BranchNode category) {
            super(name, category);
        }

        @Override
        public Boolean getState() {
            ExtensionBean bean = this.getBean();
            boolean enabled = bean instanceof Rule ? ((Rule)bean).isEnabled() : ((Metric)bean).isEnabled();
            Boolean state = enabled;
            LOG_DETAIL.trace("getting state of node {0} as {1}", (Object)this, (Object)state);
            return state;
        }

        @Override
        public void setState(Boolean state) {
            LOG.trace("setting state of node {0} to {1}", (Object)this, (Object)state);
            ExtensionBean bean = this.getBean();
            boolean enabled = state;
            if (bean instanceof Rule) {
                ((Rule)bean).setEnabled(enabled);
            } else {
                ((Metric)bean).setEnabled(enabled);
            }
            BranchNode parent = this.getParent();
            BranchNode grandparent = parent.getParent();
            ProfileTreeModel model = this.getTreeModel();
            model.fireTreeNodesChanged(model, new Object[]{parent}, new int[]{parent.indexOf(this)}, new Object[]{this});
            if (grandparent != null) {
                model.fireTreeNodesChanged(model, new Object[]{grandparent}, new int[]{grandparent.indexOf(parent)}, new Object[]{parent});
            }
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    private static class RootNode
    extends BranchNode {
        private ProfileTreeModel treeModel;
        private ProfileModel model;
        private Collator collator = Collator.getInstance();

        public RootNode(ProfileTreeModel treeModel, ProfileModel model) {
            super(null, null);
            this.treeModel = treeModel;
            this.model = model;
        }

        @Override
        public Collator getCollator() {
            return this.collator;
        }

        @Override
        public ProfileModel getModel() {
            return this.model;
        }

        @Override
        public ProfileTreeModel getTreeModel() {
            return this.treeModel;
        }

        @Override
        public ExtensionBean getBean() {
            return null;
        }

        @Override
        public String getText() {
            return "<root>";
        }

        @Override
        public String getDescription() {
            return "<root>";
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private static class BranchNode
    extends BeanNode {
        private List<BeanNode> list = new ArrayList<BeanNode>();

        protected BranchNode(String name, BranchNode parent) {
            super(name, parent);
        }

        public boolean add(BeanNode child) {
            int index = Collections.binarySearch(this.list, child);
            if (index >= 0) {
                return false;
            }
            this.list.add(-index - 1, child);
            return true;
        }

        public void sort() {
            Collections.sort(this.list);
        }

        @Override
        public List<BeanNode> getChildren() {
            return this.list;
        }
    }

    private static abstract class BeanNode
    implements Comparable<BeanNode> {
        private String id;
        private BranchNode parent;
        private CollationKey key;

        protected BeanNode(String name, BranchNode parent) {
            this.id = name;
            this.parent = parent;
        }

        public String getId() {
            return this.id;
        }

        public BranchNode getParent() {
            return this.parent;
        }

        public CollationKey getCollationKey() {
            if (this.key == null) {
                this.key = this.getCollator().getCollationKey(this.getText());
                assert (this.key != null);
            }
            return this.key;
        }

        public Collator getCollator() {
            return this.parent.getCollator();
        }

        public ProfileModel getModel() {
            return this.getParent().getModel();
        }

        public ProfileTreeModel getTreeModel() {
            return this.getParent().getTreeModel();
        }

        public boolean isModified() {
            if (this.getModel().isModified(this.getId())) {
                return true;
            }
            for (BeanNode child : this.getChildren()) {
                if (!child.isModified()) continue;
                return true;
            }
            return false;
        }

        public Boolean getState() {
            Iterator<BeanNode> i = this.getChildren().iterator();
            if (!i.hasNext()) {
                return Boolean.FALSE;
            }
            Boolean state = i.next().getState();
            if (state == null) {
                return null;
            }
            if (state == Boolean.TRUE) {
                while (i.hasNext()) {
                    if (i.next().getState() == Boolean.TRUE) continue;
                    return null;
                }
                return Boolean.TRUE;
            }
            while (i.hasNext()) {
                if (i.next().getState() == Boolean.FALSE) continue;
                return null;
            }
            return Boolean.FALSE;
        }

        public void setState(Boolean state) {
            for (BeanNode node : this.getChildren()) {
                node.setState(state);
            }
        }

        public boolean isLeaf() {
            return false;
        }

        public List<BeanNode> getChildren() {
            return Collections.emptyList();
        }

        public int indexOf(BeanNode child) {
            return this.getChildren().indexOf(child);
        }

        public ExtensionBean getBean() {
            return this.getModel().getBean(this.getId());
        }

        public BeanNode getChild(String id) {
            for (BeanNode child : this.getChildren()) {
                if (!id.equals(child.getId())) continue;
                return child;
            }
            return null;
        }

        public String getText() {
            String text = this.getBean().labelOrId();
            if (text == null) {
                text = "?";
            }
            return text;
        }

        public String getDescription() {
            return this.getBean().description();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.getBean().addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.getBean().removePropertyChangeListener(listener);
        }

        @Override
        public int compareTo(BeanNode node) {
            return this.getCollationKey().compareTo(node.getCollationKey());
        }

        public String toString() {
            return this.getId();
        }
    }
}

