/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdevimpl.audit.AuditBundle;

public class ProfileMigrator
implements Migrator,
URLFilter {
    private static final int AUDIT_PROFILE = 0;
    private boolean selected = true;
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public boolean canMigrate(int category, File sourceSystemFile) {
        if (category != 0) {
            return false;
        }
        URL sourceSystem = URLFactory.newDirURL((File)sourceSystemFile);
        URL sourceDirectory = ProfileRepository.profileDirectory(sourceSystem);
        return URLFileSystem.exists((URL)sourceDirectory);
    }

    public String getDescription(int category) {
        return "Audit Profiles";
    }

    public boolean isSelected(int category) {
        return category == 0 && this.selected;
    }

    public void setSelected(int category, boolean selected) {
        if (category == 0) {
            this.selected = selected;
        }
    }

    public String[] migrate(File sourceSystemFile, File targetSystemFile) {
        if (!this.selected) {
            return new String[0];
        }
        URL sourceSystem = URLFactory.newDirURL((File)sourceSystemFile);
        URL targetSystem = URLFactory.newDirURL((File)targetSystemFile);
        ArrayList<String> errors = new ArrayList<String>();
        URL sourceDirectory = ProfileRepository.profileDirectory(sourceSystem);
        URL[] sourceProfiles = URLFileSystem.list((URL)sourceDirectory, (URLFilter)this);
        if (sourceProfiles == null || sourceProfiles.length == 0) {
            return new String[0];
        }
        URL targetDirectory = ProfileRepository.profileDirectory(targetSystem);
        boolean created = URLFileSystem.mkdirs((URL)targetDirectory);
        if (!created) {
            return new String[0];
        }
        for (int i = 0; i < sourceProfiles.length; ++i) {
            URL sourceProfile = sourceProfiles[i];
            URL targetProfile = URLFactory.newURL((URL)targetDirectory, (String)URLFileSystem.getFileName((URL)sourceProfile));
            try {
                URLFileSystem.copy((URL)sourceProfile, (URL)targetProfile);
                continue;
            }
            catch (IOException e) {
                String message = BUNDLE.get("profile.migrator.exception.message", new Object[]{URLFileSystem.getPlatformPathName((URL)sourceProfile), URLFileSystem.getPlatformPathName((URL)targetProfile), e.getMessage()});
                errors.add(message);
            }
        }
        return errors.toArray(new String[errors.size()]);
    }

    public boolean accept(URL url) {
        return ".xml".equals(URLFileSystem.getSuffix((URL)url));
    }
}

