/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.profile.AuditProfilePanel;
import oracle.jdevimpl.audit.profile.ProfileComboBox;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.swing.DialogFactory;
import oracle.jdevimpl.audit.util.Cache;

public class AuditDialog
implements ActionListener {
    private final String description;
    private JComponent component;
    private ProfileModel model;
    private JButton editButton;
    private String selectionKey;
    private static final FormatBundle bundle = new FormatBundle(AuditBundle.class);

    public AuditDialog(String description) {
        this.description = description;
        this.selectionKey = "audit.profile.dialog.selection";
    }

    public Profile show() {
        final JComponent component = (JComponent)this.getComponent();
        DialogFactory dialog = new DialogFactory();
        dialog.setTitle(bundle.get("run.audit.title", new Object[]{this.description}));
        dialog.setContent(component);
        dialog.setHelpTopic(bundle.get("run.audit.help"));
        dialog.setResizable(false);
        dialog.addCancelButton(null);
        final JButton ok = dialog.addOkButton(new JButton(bundle.get("run.ok.label")));
        dialog.setDefaultButton(ok);
        ok.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Dimension size = ok.getSize();
                AuditDialog.this.editButton.setPreferredSize(size);
                AuditDialog.this.editButton.setMaximumSize(size);
                AuditDialog.this.editButton.setMinimumSize(size);
                component.revalidate();
            }
        });
        JButton command = dialog.show();
        if (ok == command) {
            Profile profile = this.model.getSelectedItem();
            Cache.put(this.selectionKey, profile.getName());
            return profile;
        }
        return null;
    }

    protected Component createComponent() {
        this.model = new ProfileModel(ProfileRepository.getRepository());
        JLabel label = new JLabel(bundle.get("run.selector.label"));
        label.setDisplayedMnemonic(bundle.get("run.selector.mnemonic").charAt(0));
        ProfileComboBox comboBox = new ProfileComboBox((ComboBoxModel)this.model);
        label.setLabelFor(comboBox);
        this.editButton = new JButton(bundle.get("run.edit.label"));
        this.editButton.setMnemonic(bundle.get("run.edit.mnemonic").charAt(0));
        JPanel component = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.top = 5;
        constraints.insets.bottom = 5;
        component.add((Component)label, constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets.left = 12;
        component.add((Component)comboBox, constraints);
        constraints.fill = 0;
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        constraints.insets.left = 12;
        component.add((Component)this.editButton, constraints);
        this.editButton.addActionListener(this);
        String selectionName = (String)Cache.get(this.selectionKey);
        Profile selection = this.model.getProfile(selectionName, "audit-rules");
        assert (selection != null);
        this.model.setSelectedItem(selection);
        return component;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = (JComponent)this.createComponent();
        }
        return this.component;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Window window = SwingUtilities.getWindowAncestor(this.component);
        new AuditProfilePanel(this.model).show(window);
    }
}

